/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class FieldInfos {
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 4;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 8;
    static final byte OMIT_NORMS = 16;
    private ArrayList byNumber = new ArrayList();
    private HashMap byName = new HashMap();

    FieldInfos() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        IndexInput input = d.openInput(name);
        try {
            this.read(input);
        }
        finally {
            input.close();
        }
    }

    public void add(Document doc) {
        List fields = doc.getFields();
        Iterator fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            Fieldable field = (Fieldable)fieldIterator.next();
            this.add(field.name(), field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms());
        }
    }

    public void addIndexed(Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector);
        }
    }

    public void add(Collection names, boolean isIndexed) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.add((String)i.next(), isIndexed);
        }
    }

    public void add(String name, boolean isIndexed) {
        this.add(name, isIndexed, false, false, false, false);
    }

    public void add(String name, boolean isIndexed, boolean storeTermVector) {
        this.add(name, isIndexed, storeTermVector, false, false, false);
    }

    public void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, false);
    }

    public void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            this.addInternal(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms);
        } else {
            if (fi.isIndexed != isIndexed) {
                fi.isIndexed = true;
            }
            if (fi.storeTermVector != storeTermVector) {
                fi.storeTermVector = true;
            }
            if (fi.storePositionWithTermVector != storePositionWithTermVector) {
                fi.storePositionWithTermVector = true;
            }
            if (fi.storeOffsetWithTermVector != storeOffsetWithTermVector) {
                fi.storeOffsetWithTermVector = true;
            }
            if (fi.omitNorms != omitNorms) {
                fi.omitNorms = false;
            }
        }
    }

    private void addInternal(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms) {
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size(), storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms);
        this.byNumber.add(fi);
        this.byName.put(name, fi);
    }

    public int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        if (fi != null) {
            return fi.number;
        }
        return -1;
    }

    public FieldInfo fieldInfo(String fieldName) {
        return (FieldInfo)this.byName.get(fieldName);
    }

    public String fieldName(int fieldNumber) {
        FieldInfo fi = this.fieldInfo(fieldNumber);
        if (fi != null) {
            return fi.name;
        }
        return "";
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        try {
            return (FieldInfo)this.byNumber.get(fieldNumber);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean hasVectors = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            hasVectors = true;
            break;
        }
        return hasVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory d, String name) throws IOException {
        IndexOutput output = d.createOutput(name);
        try {
            this.write(output);
        }
        finally {
            output.close();
        }
    }

    public void write(IndexOutput output) throws IOException {
        output.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fi = this.fieldInfo(i);
            byte bits = 0;
            if (fi.isIndexed) {
                bits = (byte)(bits | 1);
            }
            if (fi.storeTermVector) {
                bits = (byte)(bits | 2);
            }
            if (fi.storePositionWithTermVector) {
                bits = (byte)(bits | 4);
            }
            if (fi.storeOffsetWithTermVector) {
                bits = (byte)(bits | 8);
            }
            if (fi.omitNorms) {
                bits = (byte)(bits | 0x10);
            }
            output.writeString(fi.name);
            output.writeByte(bits);
        }
    }

    private void read(IndexInput input) throws IOException {
        int size = input.readVInt();
        for (int i = 0; i < size; ++i) {
            String name = input.readString().intern();
            byte bits = input.readByte();
            boolean isIndexed = (bits & 1) != 0;
            boolean storeTermVector = (bits & 2) != 0;
            boolean storePositionsWithTermVector = (bits & 4) != 0;
            boolean storeOffsetWithTermVector = (bits & 8) != 0;
            boolean omitNorms = (bits & 0x10) != 0;
            this.addInternal(name, isIndexed, storeTermVector, storePositionsWithTermVector, storeOffsetWithTermVector, omitNorms);
        }
    }
}

