/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.Deflater;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class FieldsWriter {
    static final byte FIELD_IS_TOKENIZED = 1;
    static final byte FIELD_IS_BINARY = 2;
    static final byte FIELD_IS_COMPRESSED = 4;
    private FieldInfos fieldInfos;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;

    FieldsWriter(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.createOutput(segment + ".fdt");
        this.indexStream = d.createOutput(segment + ".fdx");
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final void addDocument(Document doc) throws IOException {
        Fieldable field;
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            field = (Fieldable)fields.nextElement();
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        fields = doc.fields();
        while (fields.hasMoreElements()) {
            int len;
            byte[] data;
            field = (Fieldable)fields.nextElement();
            boolean disableCompression = field instanceof FieldsReader.FieldForMerge;
            if (!field.isStored()) continue;
            this.fieldsStream.writeVInt(this.fieldInfos.fieldNumber(field.name()));
            byte bits = 0;
            if (field.isTokenized()) {
                bits = (byte)(bits | 1);
            }
            if (field.isBinary()) {
                bits = (byte)(bits | 2);
            }
            if (field.isCompressed()) {
                bits = (byte)(bits | 4);
            }
            this.fieldsStream.writeByte(bits);
            if (field.isCompressed()) {
                data = null;
                data = disableCompression ? field.binaryValue() : (field.isBinary() ? this.compress(field.binaryValue()) : this.compress(field.stringValue().getBytes("UTF-8")));
                len = data.length;
                this.fieldsStream.writeVInt(len);
                this.fieldsStream.writeBytes(data, len);
                continue;
            }
            if (field.isBinary()) {
                data = field.binaryValue();
                len = data.length;
                this.fieldsStream.writeVInt(len);
                this.fieldsStream.writeBytes(data, len);
                continue;
            }
            this.fieldsStream.writeString(field.stringValue());
        }
    }

    private final byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        compressor.end();
        return bos.toByteArray();
    }
}

