/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;

public class IndexFileDeleter {
    private Vector deletable;
    private Vector pending;
    private Directory directory;
    private SegmentInfos segmentInfos;
    private PrintStream infoStream;

    public IndexFileDeleter(SegmentInfos segmentInfos, Directory directory) throws IOException {
        this.segmentInfos = segmentInfos;
        this.directory = directory;
    }

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public void findDeletableFiles() throws IOException {
        HashMap<String, SegmentInfo> current = new HashMap<String, SegmentInfo>();
        for (int j = 0; j < this.segmentInfos.size(); ++j) {
            SegmentInfo segmentInfo = (SegmentInfo)this.segmentInfos.elementAt(j);
            current.put(segmentInfo.name, segmentInfo);
        }
        String segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        String[] files = this.directory.list();
        for (int i = 0; i < files.length; ++i) {
            String segmentName;
            String extension;
            if (!filter.accept(null, files[i]) || files[i].equals(segmentsInfosFileName) || files[i].equals("segments.gen")) continue;
            int loc = files[i].indexOf(46);
            if (loc != -1) {
                extension = files[i].substring(1 + loc);
                segmentName = files[i].substring(0, loc);
            } else {
                extension = null;
                segmentName = files[i];
            }
            loc = segmentName.indexOf(95, 1);
            if (loc != -1) {
                segmentName = segmentName.substring(0, loc);
            }
            boolean doDelete = false;
            if (!current.containsKey(segmentName)) {
                doDelete = true;
            } else {
                int field;
                SegmentInfo info = (SegmentInfo)current.get(segmentName);
                if (filter.isCFSFile(files[i]) && info.getUseCompoundFile()) {
                    doDelete = true;
                } else if ("del".equals(extension)) {
                    if (!files[i].equals(info.getDelFileName())) {
                        doDelete = true;
                    }
                } else if (extension != null && extension.startsWith("s") && extension.matches("s\\d+") && !files[i].equals(info.getNormFileName(field = Integer.parseInt(extension.substring(1))))) {
                    doDelete = true;
                }
            }
            if (!doDelete) continue;
            this.addDeletableFile(files[i]);
            if (this.infoStream == null) continue;
            this.infoStream.println("IndexFileDeleter: file \"" + files[i] + "\" is unreferenced in index and will be deleted on next commit");
        }
    }

    public final void deleteSegments(Vector segments) throws IOException {
        this.deleteFiles();
        for (int i = 0; i < segments.size(); ++i) {
            SegmentReader reader = (SegmentReader)segments.elementAt(i);
            if (reader.directory() == this.directory) {
                this.deleteFiles(reader.files());
                continue;
            }
            this.deleteFiles(reader.files(), reader.directory());
        }
    }

    public final void deleteFiles(Vector files, Directory directory) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            directory.deleteFile((String)files.elementAt(i));
        }
    }

    public final void deleteFiles(Vector files) throws IOException {
        this.deleteFiles();
        for (int i = 0; i < files.size(); ++i) {
            this.deleteFile((String)files.elementAt(i));
        }
    }

    public final void deleteFile(String file) throws IOException {
        block3: {
            try {
                this.directory.deleteFile(file);
            }
            catch (IOException e) {
                if (!this.directory.fileExists(file)) break block3;
                if (this.infoStream != null) {
                    this.infoStream.println("IndexFileDeleter: unable to remove file \"" + file + "\": " + e.toString() + "; Will re-try later.");
                }
                this.addDeletableFile(file);
            }
        }
    }

    final void clearPendingFiles() {
        this.pending = null;
    }

    final void addPendingFile(String fileName) {
        if (this.pending == null) {
            this.pending = new Vector();
        }
        this.pending.addElement(fileName);
    }

    final void commitPendingFiles() {
        if (this.pending != null) {
            if (this.deletable == null) {
                this.deletable = this.pending;
                this.pending = null;
            } else {
                this.deletable.addAll(this.pending);
                this.pending = null;
            }
        }
    }

    public final void addDeletableFile(String fileName) {
        if (this.deletable == null) {
            this.deletable = new Vector();
        }
        this.deletable.addElement(fileName);
    }

    public final void deleteFiles() throws IOException {
        if (this.deletable != null) {
            Vector oldDeletable = this.deletable;
            this.deletable = null;
            this.deleteFiles(oldDeletable);
        }
    }
}

