/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import org.apache.lucene.index.IndexFileNames;

public class IndexFileNameFilter
implements FilenameFilter {
    static IndexFileNameFilter singleton = new IndexFileNameFilter();
    private HashSet extensions = new HashSet();

    public IndexFileNameFilter() {
        for (int i = 0; i < IndexFileNames.INDEX_EXTENSIONS.length; ++i) {
            this.extensions.add(IndexFileNames.INDEX_EXTENSIONS[i]);
        }
    }

    public boolean accept(File dir, String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensions.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && this.matches("f\\d+", extension)) {
                return true;
            }
            if (extension.startsWith("s") && this.matches("s\\d+", extension)) {
                return true;
            }
        } else {
            if (name.equals("deletable")) {
                return true;
            }
            if (name.startsWith("segments")) {
                return true;
            }
        }
        return false;
    }

    public boolean isCFSFile(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensions.contains(extension) && !extension.equals("del") && !extension.equals("gen") && !extension.equals("cfs")) {
                return true;
            }
            if (extension.startsWith("f") && this.matches("f\\d+", extension)) {
                return true;
            }
        }
        return false;
    }

    public static IndexFileNameFilter getFilter() {
        return singleton;
    }

    public native boolean matches(String var1, String var2);
}

