/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    public static long DEFAULT_WRITE_LOCK_TIMEOUT = 1000L;
    private long writeLockTimeout = DEFAULT_WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private SegmentInfos segmentInfos = new SegmentInfos();
    private SegmentInfos ramSegmentInfos = new SegmentInfos();
    private final RAMDirectory ramDirectory = new RAMDirectory();
    private IndexFileDeleter deleter;
    private Lock writeLock;
    private int termIndexInterval = 128;
    private boolean useCompoundFile = true;
    private boolean closeDir;
    private int maxFieldLength = 10000;
    private int mergeFactor = 10;
    private int minMergeDocs = 10;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private PrintStream infoStream = null;

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean value) {
        this.useCompoundFile = value;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create, true);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws IOException {
        this(FSDirectory.getDirectory(path, create), a, create, true);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws IOException {
        this(d, a, create, false);
    }

    private IndexWriter(Directory d, Analyzer a, boolean create, boolean closeDir) throws IOException {
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        Lock writeLock = this.directory.makeLock(WRITE_LOCK_NAME);
        if (!writeLock.obtain(this.writeLockTimeout)) {
            throw new IOException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.segmentInfos.write(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
            }
            this.deleter = new IndexFileDeleter(this.segmentInfos, this.directory);
            this.deleter.setInfoStream(this.infoStream);
            this.deleter.findDeletableFiles();
            this.deleter.deleteFiles();
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        if (maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2");
        }
        this.minMergeDocs = maxBufferedDocs;
    }

    public int getMaxBufferedDocs() {
        return this.minMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        DEFAULT_WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return DEFAULT_WRITE_LOCK_TIMEOUT;
    }

    public synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
        if (this.closeDir) {
            this.directory.close();
        }
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized int docCount() {
        int count = this.ramSegmentInfos.size();
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
        }
        return count;
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, analyzer, this);
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newRAMSegmentName();
        dw.addDocument(segmentName, doc);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ramSegmentInfos.addElement(new SegmentInfo(segmentName, 1, this.ramDirectory, false));
            this.maybeFlushRamSegments();
        }
    }

    final synchronized int getRAMSegmentCount() {
        return this.ramSegmentInfos.size();
    }

    private final synchronized String newRAMSegmentName() {
        return "_ram_" + Integer.toString(this.ramSegmentInfos.counter++, 36);
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory || this.useCompoundFile && (!SegmentReader.usesCompoundFile(this.segmentInfos.info(0)) || SegmentReader.hasSeparateNorms(this.segmentInfos.info(0))))) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(this.segmentInfos, minSegment < 0 ? 0 : minSegment, this.segmentInfos.size());
        }
    }

    public synchronized void addIndexes(Directory[] dirs) throws IOException {
        this.optimize();
        int start = this.segmentInfos.size();
        for (int i = 0; i < dirs.length; ++i) {
            SegmentInfos sis = new SegmentInfos();
            sis.read(dirs[i]);
            for (int j = 0; j < sis.size(); ++j) {
                this.segmentInfos.addElement(sis.info(j));
            }
        }
        while (this.segmentInfos.size() > start + this.mergeFactor) {
            for (int base = start; base < this.segmentInfos.size(); ++base) {
                int end = Math.min(this.segmentInfos.size(), base + this.mergeFactor);
                if (end - base <= 1) continue;
                this.mergeSegments(this.segmentInfos, base, end);
            }
        }
        this.optimize();
    }

    public synchronized void addIndexesNoOptimize(Directory[] dirs) throws IOException {
        int numTailSegments;
        this.flushRamSegments();
        int start = this.segmentInfos.size();
        int startUpperBound = this.minMergeDocs;
        try {
            for (int i = 0; i < dirs.length; ++i) {
                if (this.directory == dirs[i]) {
                    throw new IllegalArgumentException("Cannot add this index to itself");
                }
                SegmentInfos sis = new SegmentInfos();
                sis.read(dirs[i]);
                for (int j = 0; j < sis.size(); ++j) {
                    SegmentInfo info = sis.info(j);
                    this.segmentInfos.addElement(info);
                    while (startUpperBound < info.docCount) {
                        if ((startUpperBound *= this.mergeFactor) <= this.maxMergeDocs) continue;
                        throw new IllegalArgumentException("Upper bound cannot exceed maxMergeDocs");
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            for (int i = this.segmentInfos.size() - 1; i >= start; --i) {
                this.segmentInfos.remove(i);
            }
            throw e;
        }
        this.maybeMergeSegments(startUpperBound);
        int segmentCount = this.segmentInfos.size();
        for (numTailSegments = 0; numTailSegments < segmentCount && startUpperBound >= this.segmentInfos.info((int)(segmentCount - 1 - numTailSegments)).docCount; ++numTailSegments) {
        }
        if (numTailSegments == 0) {
            return;
        }
        if (this.checkNonDecreasingLevels(segmentCount - numTailSegments)) {
            int numSegmentsToCopy;
            for (numSegmentsToCopy = 0; numSegmentsToCopy < segmentCount && this.directory != this.segmentInfos.info((int)(segmentCount - 1 - numSegmentsToCopy)).dir; ++numSegmentsToCopy) {
            }
            if (numSegmentsToCopy == 0) {
                return;
            }
            for (int i = segmentCount - numSegmentsToCopy; i < segmentCount; ++i) {
                this.mergeSegments(this.segmentInfos, i, i + 1);
            }
            if (this.checkNonDecreasingLevels(segmentCount - numSegmentsToCopy)) {
                return;
            }
        }
        this.mergeSegments(this.segmentInfos, segmentCount - numTailSegments, segmentCount);
        if (this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).docCount > startUpperBound) {
            this.maybeMergeSegments(startUpperBound * this.mergeFactor);
        }
    }

    public synchronized void addIndexes(IndexReader[] readers) throws IOException {
        this.optimize();
        String mergedName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        SegmentReader sReader = null;
        if (this.segmentInfos.size() == 1) {
            sReader = SegmentReader.get(this.segmentInfos.info(0));
            merger.add(sReader);
            segmentsToDelete.addElement(sReader);
        }
        for (int i = 0; i < readers.length; ++i) {
            merger.add(readers[i]);
        }
        int docCount = merger.merge();
        this.segmentInfos.setSize(0);
        SegmentInfo info = new SegmentInfo(mergedName, docCount, this.directory, false);
        this.segmentInfos.addElement(info);
        if (sReader != null) {
            sReader.close();
        }
        String segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
        this.segmentInfos.write(this.directory);
        this.deleter.deleteFile(segmentsInfosFileName);
        this.deleter.deleteSegments(segmentsToDelete);
        if (this.useCompoundFile) {
            Vector filesToDelete = merger.createCompoundFile(mergedName + ".cfs");
            segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
            info.setUseCompoundFile(true);
            this.segmentInfos.write(this.directory);
            this.deleter.deleteFile(segmentsInfosFileName);
            this.deleter.deleteFiles(filesToDelete);
        }
    }

    private final void maybeFlushRamSegments() throws IOException {
        if (this.ramSegmentInfos.size() >= this.minMergeDocs) {
            this.flushRamSegments();
        }
    }

    public final synchronized void flushRamSegments() throws IOException {
        if (this.ramSegmentInfos.size() > 0) {
            this.mergeSegments(this.ramSegmentInfos, 0, this.ramSegmentInfos.size());
            this.maybeMergeSegments(this.minMergeDocs);
        }
    }

    public final long ramSizeInBytes() {
        return this.ramDirectory.sizeInBytes();
    }

    public final synchronized int numRamDocs() {
        return this.ramSegmentInfos.size();
    }

    private final void maybeMergeSegments(int startUpperBound) throws IOException {
        long lowerBound = -1L;
        for (long upperBound = (long)startUpperBound; upperBound < (long)this.maxMergeDocs; upperBound *= (long)this.mergeFactor) {
            int numSegments;
            int minSegment = this.segmentInfos.size();
            int maxSegment = -1;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if (maxSegment == -1 && (long)si.docCount > lowerBound && (long)si.docCount <= upperBound) {
                    maxSegment = minSegment;
                    continue;
                }
                if ((long)si.docCount <= upperBound) continue;
                break;
            }
            if ((numSegments = ++maxSegment - ++minSegment) < this.mergeFactor) break;
            boolean exceedsUpperLimit = false;
            while (numSegments >= this.mergeFactor) {
                int docCount = this.mergeSegments(this.segmentInfos, minSegment, minSegment + this.mergeFactor);
                numSegments -= this.mergeFactor;
                if ((long)docCount > upperBound) {
                    ++minSegment;
                    exceedsUpperLimit = true;
                    continue;
                }
                ++numSegments;
            }
            if (!exceedsUpperLimit) break;
            lowerBound = upperBound;
        }
    }

    private final int mergeSegments(SegmentInfos sourceSegments, int minSegment, int end) throws IOException {
        String mergedName = this.newSegmentName();
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        Vector<SegmentReader> segmentsToDelete = new Vector<SegmentReader>();
        for (int i = minSegment; i < end; ++i) {
            SegmentInfo si = sourceSegments.info(i);
            if (this.infoStream != null) {
                this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
            }
            SegmentReader reader = SegmentReader.get(si);
            merger.add(reader);
            if (reader.directory() != this.directory && reader.directory() != this.ramDirectory) continue;
            segmentsToDelete.addElement(reader);
        }
        int mergedDocCount = merger.merge();
        if (this.infoStream != null) {
            this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
        }
        SegmentInfo newSegment = new SegmentInfo(mergedName, mergedDocCount, this.directory, false);
        if (sourceSegments == this.ramSegmentInfos) {
            sourceSegments.removeAllElements();
            this.segmentInfos.addElement(newSegment);
        } else {
            for (int i = end - 1; i > minSegment; --i) {
                sourceSegments.remove(i);
            }
            this.segmentInfos.set(minSegment, newSegment);
        }
        merger.closeReaders();
        String segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
        this.segmentInfos.write(this.directory);
        this.deleter.deleteFile(segmentsInfosFileName);
        this.deleter.deleteSegments(segmentsToDelete);
        if (this.useCompoundFile) {
            Vector filesToDelete = merger.createCompoundFile(mergedName + ".cfs");
            segmentsInfosFileName = this.segmentInfos.getCurrentSegmentFileName();
            newSegment.setUseCompoundFile(true);
            this.segmentInfos.write(this.directory);
            this.deleter.deleteFile(segmentsInfosFileName);
            this.deleter.deleteFiles(filesToDelete);
        }
        return mergedDocCount;
    }

    private final boolean checkNonDecreasingLevels(int start) {
        int lowerBound = -1;
        int upperBound = this.minMergeDocs;
        for (int i = this.segmentInfos.size() - 1; i >= start; --i) {
            int docCount = this.segmentInfos.info((int)i).docCount;
            if (docCount <= lowerBound) {
                return false;
            }
            while (docCount > upperBound) {
                lowerBound = upperBound;
                upperBound *= this.mergeFactor;
            }
        }
        return true;
    }
}

