/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentInfo {
    public String name;
    public int docCount;
    public Directory dir;
    private boolean preLockless;
    private long delGen;
    private long[] normGen;
    private byte isCompoundFile;

    public SegmentInfo(String name, int docCount, Directory dir) {
        this.name = name;
        this.docCount = docCount;
        this.dir = dir;
        this.delGen = -1L;
        this.isCompoundFile = 0;
        this.preLockless = true;
    }

    public SegmentInfo(String name, int docCount, Directory dir, boolean isCompoundFile) {
        this(name, docCount, dir);
        this.isCompoundFile = isCompoundFile ? (byte)1 : (byte)-1;
        this.preLockless = false;
    }

    public SegmentInfo(Directory dir, int format, IndexInput input) throws IOException {
        this.dir = dir;
        this.name = input.readString();
        this.docCount = input.readInt();
        if (format <= -2) {
            this.delGen = input.readLong();
            int numNormGen = input.readInt();
            if (numNormGen == -1) {
                this.normGen = null;
            } else {
                this.normGen = new long[numNormGen];
                for (int j = 0; j < numNormGen; ++j) {
                    this.normGen[j] = input.readLong();
                }
            }
            this.isCompoundFile = input.readByte();
            this.preLockless = this.isCompoundFile == 0;
        } else {
            this.delGen = 0L;
            this.normGen = null;
            this.isCompoundFile = 0;
            this.preLockless = true;
        }
    }

    void setNumField(int numField) {
        if (this.normGen == null) {
            this.normGen = new long[numField];
            if (!this.preLockless) {
                for (int i = 0; i < numField; ++i) {
                    this.normGen[i] = -1L;
                }
            }
        }
    }

    boolean hasDeletions() throws IOException {
        if (this.delGen == -1L) {
            return false;
        }
        if (this.delGen > 0L) {
            return true;
        }
        return this.dir.fileExists(this.getDelFileName());
    }

    void advanceDelGen() {
        this.delGen = this.delGen == -1L ? 1L : ++this.delGen;
    }

    void clearDelGen() {
        this.delGen = -1L;
    }

    String getDelFileName() {
        if (this.delGen == -1L) {
            return null;
        }
        return IndexFileNames.fileNameFromGeneration(this.name, ".del", this.delGen);
    }

    boolean hasSeparateNorms(int fieldNumber) throws IOException {
        if (this.normGen == null && this.preLockless || this.normGen != null && this.normGen[fieldNumber] == 0L) {
            String fileName = this.name + ".s" + fieldNumber;
            return this.dir.fileExists(fileName);
        }
        return this.normGen != null && this.normGen[fieldNumber] != -1L;
    }

    boolean hasSeparateNorms() throws IOException {
        int i;
        if (this.normGen == null) {
            if (!this.preLockless) {
                return false;
            }
            String[] result = this.dir.list();
            String pattern = this.name + ".s";
            int patternLength = pattern.length();
            for (int i2 = 0; i2 < result.length; ++i2) {
                if (!result[i2].startsWith(pattern) || !Character.isDigit(result[i2].charAt(patternLength))) continue;
                return true;
            }
            return false;
        }
        for (i = 0; i < this.normGen.length; ++i) {
            if (this.normGen[i] <= 0L) continue;
            return true;
        }
        for (i = 0; i < this.normGen.length; ++i) {
            if (this.normGen[i] != 0L || !this.dir.fileExists(this.getNormFileName(i))) continue;
            return true;
        }
        return false;
    }

    void advanceNormGen(int fieldIndex) {
        if (this.normGen[fieldIndex] == -1L) {
            this.normGen[fieldIndex] = 1L;
        } else {
            int n = fieldIndex;
            this.normGen[n] = this.normGen[n] + 1L;
        }
    }

    String getNormFileName(int number) throws IOException {
        long gen = this.normGen == null ? 0L : this.normGen[number];
        if (this.hasSeparateNorms(number)) {
            String prefix = ".s";
            return IndexFileNames.fileNameFromGeneration(this.name, prefix + number, gen);
        }
        String prefix = ".f";
        return IndexFileNames.fileNameFromGeneration(this.name, prefix + number, 0L);
    }

    void setUseCompoundFile(boolean isCompoundFile) {
        this.isCompoundFile = isCompoundFile ? (byte)1 : (byte)-1;
    }

    boolean getUseCompoundFile() throws IOException {
        if (this.isCompoundFile == -1) {
            return false;
        }
        if (this.isCompoundFile == 1) {
            return true;
        }
        return this.dir.fileExists(this.name + ".cfs");
    }

    void write(IndexOutput output) throws IOException {
        output.writeString(this.name);
        output.writeInt(this.docCount);
        output.writeLong(this.delGen);
        if (this.normGen == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(this.normGen.length);
            for (int j = 0; j < this.normGen.length; ++j) {
                output.writeLong(this.normGen[j]);
            }
        }
        output.writeByte(this.isCompoundFile);
    }
}

