/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public abstract class Directory {
    protected LockFactory lockFactory;

    public abstract String[] list() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract void renameFile(String var1, String var2) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    public abstract IndexInput openInput(String var1) throws IOException;

    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }
}

