/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLock;

public class NativeFSLockFactory
extends LockFactory {
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private File lockDir;

    private void acquireTestLock() throws IOException {
        String randomLockName = "lucene-" + Long.toString(new Random().nextInt(), 36) + "-test.lock";
        Lock l = this.makeLock(randomLockName);
        try {
            l.obtain();
        }
        catch (IOException e) {
            IOException e2 = new IOException("Failed to acquire random test lock; please verify filesystem for lock directory '" + this.lockDir + "' supports locking");
            e2.initCause(e);
            throw e2;
        }
        l.release();
    }

    public NativeFSLockFactory() throws IOException {
        this(new File(LOCK_DIR));
    }

    public NativeFSLockFactory(String lockDirName) throws IOException {
        this(new File(lockDirName));
    }

    public NativeFSLockFactory(File lockDir) throws IOException {
        this.lockDir = lockDir;
        if (!lockDir.exists()) {
            if (!lockDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + lockDir.getAbsolutePath());
            }
        } else if (!lockDir.isDirectory()) {
            throw new IOException("Found regular file where directory expected: " + lockDir.getAbsolutePath());
        }
        this.acquireTestLock();
    }

    public synchronized Lock makeLock(String lockName) {
        String fullName = this.lockPrefix.equals("") ? lockName : this.lockPrefix + "-n-" + lockName;
        return new NativeFSLock(this.lockDir, fullName);
    }

    public void clearAllLocks() throws IOException {
        if (this.lockDir.exists()) {
            String[] files = this.lockDir.list();
            if (files == null) {
                throw new IOException("Cannot read lock directory " + this.lockDir.getAbsolutePath());
            }
            String prefix = this.lockPrefix + "-n-";
            for (int i = 0; i < files.length; ++i) {
                File lockFile;
                if (!files[i].startsWith(prefix) || (lockFile = new File(this.lockDir, files[i])).delete()) continue;
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

