/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;

public final class RAMDirectory
extends Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap fileMap = new HashMap();
    private Set fileNames = this.fileMap.keySet();
    private Collection files = this.fileMap.values();
    long sizeInBytes = 0L;

    public RAMDirectory() {
        this.setLockFactory(new SingleInstanceLockFactory());
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        this();
        String[] files = dir.list();
        byte[] buf = new byte[1024];
        for (int i = 0; i < files.length; ++i) {
            int toRead;
            IndexOutput os = this.createOutput(files[i]);
            IndexInput is = dir.openInput(files[i]);
            long len = is.length();
            for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                toRead = readCount + 1024L > len ? (int)(len - readCount) : 1024;
                is.readBytes(buf, 0, toRead);
                os.writeBytes(buf, toRead);
            }
            is.close();
            os.close();
        }
        if (closeDir) {
            dir.close();
        }
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public final synchronized String[] list() {
        String[] result = new String[this.fileNames.size()];
        int i = 0;
        Iterator it = this.fileNames.iterator();
        while (it.hasNext()) {
            result[i++] = (String)it.next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean fileExists(String name) {
        RAMFile file;
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        return file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long fileModified(String name) throws IOException {
        RAMFile file;
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchFile(String name) throws IOException {
        long ts2;
        RAMFile file;
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long fileLength(String name) throws IOException {
        RAMFile file;
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public final synchronized long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final synchronized long getRecomputedSizeInBytes() {
        long size = 0L;
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            size += ((RAMFile)it.next()).getSizeInBytes();
        }
        return size;
    }

    public final synchronized void deleteFile(String name) throws IOException {
        RAMFile file = (RAMFile)this.fileMap.get(name);
        if (file != null) {
            this.fileMap.remove(name);
            file.directory = null;
            this.sizeInBytes -= file.sizeInBytes;
        } else {
            throw new FileNotFoundException(name);
        }
    }

    public final synchronized void renameFile(String from, String to) throws IOException {
        RAMFile fromFile = (RAMFile)this.fileMap.get(from);
        if (fromFile == null) {
            throw new FileNotFoundException(from);
        }
        RAMFile toFile = (RAMFile)this.fileMap.get(to);
        if (toFile != null) {
            this.sizeInBytes -= toFile.sizeInBytes;
            toFile.directory = null;
        }
        this.fileMap.remove(from);
        this.fileMap.put(to, fromFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IndexOutput createOutput(String name) {
        RAMFile file = new RAMFile(this);
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            RAMFile existing = (RAMFile)this.fileMap.get(name);
            if (existing != null) {
                this.sizeInBytes -= existing.sizeInBytes;
                existing.directory = null;
            }
            this.fileMap.put(name, file);
        }
        return new RAMOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IndexInput openInput(String name) throws IOException {
        RAMFile file;
        RAMDirectory rAMDirectory = this;
        synchronized (rAMDirectory) {
            file = (RAMFile)this.fileMap.get(name);
        }
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new RAMInputStream(file);
    }

    public final void close() {
        this.fileMap = null;
        this.fileNames = null;
        this.files = null;
    }
}

