/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMOutputStream
extends BufferedIndexOutput {
    private RAMFile file;
    private long pointer = 0L;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    RAMOutputStream(RAMFile f) {
        this.file = f;
    }

    public void writeTo(IndexOutput out) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            out.writeBytes((byte[])this.file.buffers.get(buffer++), length);
            pos = nextPos;
        }
    }

    public void reset() {
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        this.file.setLength(0L);
    }

    public void flushBuffer(byte[] src, int len) {
        int bufferPos = 0;
        while (bufferPos != len) {
            int bufferNumber = (int)(this.pointer / 1024L);
            int bufferOffset = (int)(this.pointer % 1024L);
            int bytesInBuffer = 1024 - bufferOffset;
            int remainInSrcBuffer = len - bufferPos;
            int bytesToCopy = bytesInBuffer >= remainInSrcBuffer ? remainInSrcBuffer : bytesInBuffer;
            byte[] buffer = bufferNumber == this.file.buffers.size() ? this.file.addBuffer(1024) : (byte[])this.file.buffers.get(bufferNumber);
            System.arraycopy(src, bufferPos, buffer, bufferOffset, bytesToCopy);
            bufferPos += bytesToCopy;
            this.pointer += (long)bytesToCopy;
        }
        if (this.pointer > this.file.length) {
            this.file.setLength(this.pointer);
        }
        this.file.setLastModified(System.currentTimeMillis());
    }

    public void close() throws IOException {
        super.close();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.pointer = pos;
    }

    public long length() {
        return this.file.length;
    }
}

