/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSLock;

public class SimpleFSLockFactory
extends LockFactory {
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private File lockDir;

    public SimpleFSLockFactory() throws IOException {
        this.lockDir = new File(LOCK_DIR);
        this.init(this.lockDir);
    }

    public SimpleFSLockFactory(File lockDir) throws IOException {
        this.init(lockDir);
    }

    public SimpleFSLockFactory(String lockDirName) throws IOException {
        this.lockDir = new File(lockDirName);
        this.init(this.lockDir);
    }

    protected void init(File lockDir) throws IOException {
        this.lockDir = lockDir;
    }

    public Lock makeLock(String lockName) {
        return new SimpleFSLock(this.lockDir, this.lockPrefix + "-" + lockName);
    }

    public void clearAllLocks() throws IOException {
        if (this.lockDir.exists()) {
            String[] files = this.lockDir.list();
            if (files == null) {
                throw new IOException("Cannot read lock directory " + this.lockDir.getAbsolutePath());
            }
            String prefix = this.lockPrefix + "-";
            for (int i = 0; i < files.length; ++i) {
                File lockFile;
                if (!files[i].startsWith(prefix) || (lockFile = new File(this.lockDir, files[i])).delete()) continue;
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

