/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredEntrySet;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredSortedEntrySet;
import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedValueSet;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.db.Database;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredMap
extends StoredContainer
implements Map {
    private StoredKeySet keySet;
    private StoredEntrySet entrySet;
    private StoredValueSet valueSet;

    public StoredMap(Database database, EntryBinding entryBinding, EntryBinding entryBinding2, boolean bl) {
        super(new DataView(database, entryBinding, entryBinding2, null, bl, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding entryBinding, EntryBinding entryBinding2, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, entryBinding2, null, true, primaryKeyAssigner));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding entryBinding, EntityBinding entityBinding, boolean bl) {
        super(new DataView(database, entryBinding, null, entityBinding, bl, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding entryBinding, EntityBinding entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, null, entityBinding, true, primaryKeyAssigner));
        this.initView();
    }

    StoredMap(DataView dataView) {
        super(dataView);
        this.initView();
    }

    void initAfterClone() {
        this.initView();
    }

    private void initView() {
        this.entrySet = this.isOrdered() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
        DataView dataView = this.view.keySetView();
        this.keySet = this.isOrdered() ? new StoredSortedKeySet(dataView) : new StoredKeySet(dataView);
        dataView = this.view.valueSetView();
        this.valueSet = this.isOrdered() && dataView.canDeriveKeyFromValue() ? new StoredSortedValueSet(dataView) : new StoredValueSet(dataView);
    }

    public Object get(Object object) {
        return super.get(object);
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object append(Object object) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(object, objectArray, null);
            this.commitAutoCommit(bl);
            return objectArray[0];
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public Object remove(Object object) {
        Object[] objectArray = new Object[1];
        this.removeKey(object, objectArray);
        return objectArray[0];
    }

    public boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    public void putAll(Map map) {
        boolean bl = this.beginAutoCommit();
        Iterator iterator = null;
        try {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public Set keySet() {
        return this.keySet;
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Collection values() {
        return this.valueSet;
    }

    public Collection duplicates(Object object) {
        try {
            DataView dataView = this.view.valueSetView(object);
            return new StoredValueSet(dataView, true);
        }
        catch (KeyRangeException keyRangeException) {
            return Collections.EMPTY_SET;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            return ((Object)this.entrySet()).equals(((Map)object).entrySet());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

