/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class CacheFilePriority {
    public static final CacheFilePriority DEFAULT = new CacheFilePriority("DEFAULT", 3);
    public static final CacheFilePriority HIGH = new CacheFilePriority("HIGH", 4);
    public static final CacheFilePriority LOW = new CacheFilePriority("LOW", 2);
    public static final CacheFilePriority VERY_HIGH = new CacheFilePriority("VERY_HIGH", 5);
    public static final CacheFilePriority VERY_LOW = new CacheFilePriority("VERY_LOW", 1);
    private final String priorityName;
    private final int flag;

    static CacheFilePriority fromFlag(int n) {
        switch (n) {
            case 3: {
                return DEFAULT;
            }
            case 4: {
                return HIGH;
            }
            case 2: {
                return LOW;
            }
            case 5: {
                return VERY_HIGH;
            }
            case 1: {
                return VERY_LOW;
            }
        }
        throw new IllegalArgumentException("Unknown cache priority: " + n);
    }

    private CacheFilePriority(String string, int n) {
        this.priorityName = string;
        this.flag = n;
    }

    public String toString() {
        return "CacheFilePriority." + this.priorityName;
    }

    int getFlag() {
        return this.flag;
    }
}

