/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockRequest;
import com.sleepycat.db.LockRequestMode;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogCursor;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.PreparedTransaction;
import com.sleepycat.db.ReplicationConfig;
import com.sleepycat.db.ReplicationStats;
import com.sleepycat.db.ReplicationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.internal.DbEnv;
import java.io.File;
import java.io.FileNotFoundException;

public class Environment {
    private DbEnv dbenv;
    private int autoCommitFlag;

    Environment(DbEnv dbEnv) throws DatabaseException {
        this.dbenv = dbEnv;
        dbEnv.wrapper = this;
    }

    public Environment(File file, EnvironmentConfig environmentConfig) throws DatabaseException, FileNotFoundException {
        this(EnvironmentConfig.checkNull(environmentConfig).openEnvironment(file));
        this.autoCommitFlag = (this.dbenv.get_open_flags() & 0x40000) == 0 ? 0 : 0x1000000;
    }

    public void close() throws DatabaseException {
        this.dbenv.close(0);
    }

    DbEnv unwrap() {
        return this.dbenv;
    }

    public static void remove(File file, boolean bl, EnvironmentConfig environmentConfig) throws DatabaseException, FileNotFoundException {
        environmentConfig = EnvironmentConfig.checkNull(environmentConfig);
        int n = bl ? 4 : 0;
        n |= environmentConfig.getUseEnvironment() ? 2048 : 0;
        DbEnv dbEnv = environmentConfig.createEnvironment();
        dbEnv.remove(file == null ? null : file.toString(), n |= environmentConfig.getUseEnvironmentRoot() ? 4096 : 0);
    }

    public void setConfig(EnvironmentConfig environmentConfig) throws DatabaseException {
        environmentConfig.configureEnvironment(this.dbenv, new EnvironmentConfig(this.dbenv));
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        return new EnvironmentConfig(this.dbenv);
    }

    public Database openDatabase(Transaction transaction, String string, String string2, DatabaseConfig databaseConfig) throws DatabaseException, FileNotFoundException {
        return new Database(DatabaseConfig.checkNull(databaseConfig).openDatabase(this.dbenv, transaction == null ? null : transaction.txn, string, string2));
    }

    public SecondaryDatabase openSecondaryDatabase(Transaction transaction, String string, String string2, Database database, SecondaryConfig secondaryConfig) throws DatabaseException, FileNotFoundException {
        return new SecondaryDatabase(SecondaryConfig.checkNull(secondaryConfig).openSecondaryDatabase(this.dbenv, transaction == null ? null : transaction.txn, string, string2, database.db), database);
    }

    public void removeDatabase(Transaction transaction, String string, String string2) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbremove(transaction == null ? null : transaction.txn, string, string2, transaction == null ? this.autoCommitFlag : 0);
    }

    public void renameDatabase(Transaction transaction, String string, String string2, String string3) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbrename(transaction == null ? null : transaction.txn, string, string2, string3, transaction == null ? this.autoCommitFlag : 0);
    }

    public File getHome() throws DatabaseException {
        String string = this.dbenv.get_home();
        return string == null ? null : new File(string);
    }

    public int trickleCacheWrite(int n) throws DatabaseException {
        return this.dbenv.memp_trickle(n);
    }

    public int detectDeadlocks(LockDetectMode lockDetectMode) throws DatabaseException {
        return this.dbenv.lock_detect(0, lockDetectMode.getFlag());
    }

    public Lock getLock(int n, boolean bl, DatabaseEntry databaseEntry, LockRequestMode lockRequestMode) throws DatabaseException {
        return Lock.wrap(this.dbenv.lock_get(n, bl ? 2 : 0, databaseEntry, lockRequestMode.getFlag()));
    }

    public void putLock(Lock lock) throws DatabaseException {
        this.dbenv.lock_put(lock.unwrap());
    }

    public int createLockerID() throws DatabaseException {
        return this.dbenv.lock_id();
    }

    public void freeLockerID(int n) throws DatabaseException {
        this.dbenv.lock_id_free(n);
    }

    public void lockVector(int n, boolean bl, LockRequest[] lockRequestArray) throws DatabaseException {
        this.dbenv.lock_vec(n, bl ? 2 : 0, lockRequestArray, 0, lockRequestArray.length);
    }

    public LogCursor openLogCursor() throws DatabaseException {
        return LogCursor.wrap(this.dbenv.log_cursor(0));
    }

    public String getLogFileName(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        return this.dbenv.log_file(logSequenceNumber);
    }

    public void startReplication(DatabaseEntry databaseEntry, boolean bl) throws DatabaseException {
        this.dbenv.rep_start(databaseEntry, bl ? 2 : 1);
    }

    public int electReplicationMaster(int n, int n2, int n3, int n4) throws DatabaseException {
        return this.dbenv.rep_elect(n, n2, n3, n4, 0);
    }

    public void flushReplication() throws DatabaseException {
        this.dbenv.rep_flush();
    }

    public ReplicationStatus processReplicationMessage(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        DbEnv.RepProcessMessage repProcessMessage = new DbEnv.RepProcessMessage();
        repProcessMessage.envid = n;
        DatabaseEntry databaseEntry3 = new DatabaseEntry(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        LogSequenceNumber logSequenceNumber = new LogSequenceNumber();
        int n2 = this.dbenv.rep_process_message(databaseEntry, databaseEntry3, repProcessMessage, logSequenceNumber);
        return ReplicationStatus.getStatus(n2, databaseEntry3, repProcessMessage.envid, logSequenceNumber);
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig, boolean bl) throws DatabaseException {
        this.dbenv.rep_set_config(replicationConfig.getFlag(), bl);
    }

    public boolean getReplicationConfig(ReplicationConfig replicationConfig) throws DatabaseException {
        return this.dbenv.rep_get_config(replicationConfig.getFlag());
    }

    public void syncReplication() throws DatabaseException {
        this.dbenv.rep_sync(0);
    }

    public CacheStats getCacheStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.memp_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public CacheFileStats[] getCacheFileStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.memp_fstat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public LogStats getLogStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.log_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public ReplicationStats getReplicationStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.rep_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public LockStats getLockStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.lock_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public MutexStats getMutexStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.mutex_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public TransactionStats getTransactionStats(StatsConfig statsConfig) throws DatabaseException {
        return this.dbenv.txn_stat(StatsConfig.checkNull(statsConfig).getFlags());
    }

    public Transaction beginTransaction(Transaction transaction, TransactionConfig transactionConfig) throws DatabaseException {
        return new Transaction(TransactionConfig.checkNull(transactionConfig).beginTransaction(this.dbenv, transaction == null ? null : transaction.txn));
    }

    public void checkpoint(CheckpointConfig checkpointConfig) throws DatabaseException {
        CheckpointConfig.checkNull(checkpointConfig).runCheckpoint(this.dbenv);
    }

    public void logFlush(LogSequenceNumber logSequenceNumber) throws DatabaseException {
        this.dbenv.log_flush(logSequenceNumber);
    }

    public LogSequenceNumber logPut(DatabaseEntry databaseEntry, boolean bl) throws DatabaseException {
        LogSequenceNumber logSequenceNumber = new LogSequenceNumber();
        this.dbenv.log_put(logSequenceNumber, databaseEntry, bl ? 1 : 0);
        return logSequenceNumber;
    }

    public void logPrint(Transaction transaction, String string) throws DatabaseException {
        this.dbenv.log_print(transaction == null ? null : transaction.txn, string);
    }

    public File[] getArchiveLogFiles(boolean bl) throws DatabaseException {
        String[] stringArray = this.dbenv.log_archive(1 | (bl ? 4 : 0));
        int n = stringArray == null ? 0 : stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    public File[] getArchiveDatabases() throws DatabaseException {
        String string = this.dbenv.get_home();
        String[] stringArray = this.dbenv.log_archive(2);
        int n = stringArray == null ? 0 : stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(string, stringArray[i]);
        }
        return fileArray;
    }

    public void removeOldLogFiles() throws DatabaseException {
        this.dbenv.log_archive(8);
    }

    public PreparedTransaction[] recover(int n, boolean bl) throws DatabaseException {
        return this.dbenv.txn_recover(n, bl ? 18 : 9);
    }

    public void panic(boolean bl) throws DatabaseException {
        this.dbenv.set_flags(0x800000, bl);
    }

    public static String getVersionString() {
        return DbEnv.get_version_string();
    }

    public static int getVersionMajor() {
        return DbEnv.get_version_major();
    }

    public static int getVersionMinor() {
        return DbEnv.get_version_minor();
    }

    public static int getVersionPatch() {
        return DbEnv.get_version_patch();
    }
}

