/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.internal.DbEnv;

public final class ReplicationStatus {
    static final ReplicationStatus SUCCESS = new ReplicationStatus("SUCCESS", 0);
    private int errCode;
    private DatabaseEntry cdata;
    private int envid;
    private LogSequenceNumber lsn;
    private String statusName;
    private static final ReplicationStatus IGNORE = new ReplicationStatus("IGNORE", -30976);
    private static final ReplicationStatus STARTUPDONE = new ReplicationStatus("STARTUPDONE", -30976);

    private ReplicationStatus(String string, int n, DatabaseEntry databaseEntry, int n2, LogSequenceNumber logSequenceNumber) {
        this.statusName = string;
        this.errCode = n;
        this.cdata = databaseEntry;
        this.envid = n2;
        this.lsn = logSequenceNumber;
    }

    private ReplicationStatus(String string, int n) {
        this(string, n, null, 0, null);
    }

    public boolean isSuccess() {
        return this.errCode == 0;
    }

    public boolean isIgnore() {
        return this.errCode == -30983;
    }

    public boolean isPermanent() {
        return this.errCode == -30982;
    }

    public boolean isNewMaster() {
        return this.errCode == -30979;
    }

    public boolean isNewSite() {
        return this.errCode == -30978;
    }

    public boolean isNotPermanent() {
        return this.errCode == -30977;
    }

    public boolean isStartupDone() {
        return this.errCode == -30976;
    }

    public DatabaseEntry getCData() {
        return this.cdata;
    }

    public int getEnvID() {
        return this.envid;
    }

    public LogSequenceNumber getLSN() {
        return this.lsn;
    }

    public String toString() {
        return "ReplicationStatus." + this.statusName;
    }

    static ReplicationStatus getStatus(int n, DatabaseEntry databaseEntry, int n2, LogSequenceNumber logSequenceNumber) {
        switch (n) {
            case 0: {
                return SUCCESS;
            }
            case -30983: {
                return IGNORE;
            }
            case -30982: {
                return new ReplicationStatus("ISPERM", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30979: {
                return new ReplicationStatus("NEWMASTER", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30978: {
                return new ReplicationStatus("NEWSITE", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30977: {
                return new ReplicationStatus("NOTPERM", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30976: {
                return STARTUPDONE;
            }
        }
        throw new IllegalArgumentException("Unknown error code: " + DbEnv.strerror(n));
    }
}

