/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import java.io.FileNotFoundException;

public class SecondaryConfig
extends DatabaseConfig
implements Cloneable {
    public static final SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private boolean immutableSecondaryKey;
    private SecondaryKeyCreator keyCreator;

    static SecondaryConfig checkNull(SecondaryConfig secondaryConfig) {
        return secondaryConfig == null ? DEFAULT : secondaryConfig;
    }

    public SecondaryConfig() {
    }

    public void setKeyCreator(SecondaryKeyCreator secondaryKeyCreator) {
        this.keyCreator = secondaryKeyCreator;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public void setAllowPopulate(boolean bl) {
        this.allowPopulate = bl;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public void setImmutableSecondaryKey(boolean bl) {
        this.immutableSecondaryKey = bl;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openSecondaryDatabase(DbEnv dbEnv, DbTxn dbTxn, String string, String string2, Db db) throws DatabaseException, FileNotFoundException {
        int n = 0;
        n |= this.allowPopulate ? 1 : 0;
        if (this.getTransactional() && dbTxn == null) {
            n |= 0x1000000;
        }
        if (this.immutableSecondaryKey) {
            n |= 0x2000;
        }
        Db db2 = super.openDatabase(dbEnv, dbTxn, string, string2);
        boolean bl = false;
        try {
            db.associate(dbTxn, db2, this.keyCreator, n);
            bl = true;
            Db db3 = db2;
            return db3;
        }
        finally {
            if (!bl) {
                try {
                    db2.close(0);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    SecondaryConfig(Db db) throws DatabaseException {
        super(db);
        this.allowPopulate = false;
        this.keyCreator = db.get_seckey_create();
    }
}

