/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.BtreePrefixCalculator;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.Hasher;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.RecordNumberAppender;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbMpoolFile;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;
import com.sleepycat.db.internal.db_java;
import com.sleepycat.db.internal.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Comparator;

public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    static final int GIGABYTE = 0x40000000;
    private long db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    public Database wrapper;
    private RecordNumberAppender append_recno_handler;
    private Comparator bt_compare_handler;
    private BtreePrefixCalculator bt_prefix_handler;
    private Comparator dup_compare_handler;
    private FeedbackHandler db_feedback_handler;
    private Hasher h_hash_handler;
    private SecondaryKeyCreator seckey_create_handler;

    protected Db(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Db db) {
        return db == null ? 0L : db.swigCPtr;
    }

    void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    private void initialize(DbEnv dbEnv) {
        if (dbEnv == null) {
            this.private_dbenv = true;
            dbEnv = db_java.getDbEnv0(this);
            dbEnv.initialize();
        }
        this.dbenv = dbEnv;
        this.db_ref = db_java.initDbRef0(this, this);
    }

    private void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.db_ref);
        this.db_ref = 0L;
        if (this.private_dbenv) {
            this.dbenv.cleanup();
        }
        this.dbenv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.cleanup();
        }
    }

    public DbEnv get_env() throws DatabaseException {
        return this.dbenv;
    }

    private final void handle_append_recno(DatabaseEntry databaseEntry, int n) throws DatabaseException {
        this.append_recno_handler.appendRecordNumber(this.wrapper, databaseEntry, n);
    }

    public RecordNumberAppender get_append_recno() throws DatabaseException {
        return this.append_recno_handler;
    }

    private final int handle_bt_compare(byte[] byArray, byte[] byArray2) {
        return this.bt_compare_handler.compare(byArray, byArray2);
    }

    public Comparator get_bt_compare() throws DatabaseException {
        return this.bt_compare_handler;
    }

    private final int handle_bt_prefix(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        return this.bt_prefix_handler.prefix(this.wrapper, databaseEntry, databaseEntry2);
    }

    public BtreePrefixCalculator get_bt_prefix() throws DatabaseException {
        return this.bt_prefix_handler;
    }

    private final void handle_db_feedback(int n, int n2) {
        if (n == 1) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, n2);
        } else if (n == 2) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, n2);
        }
    }

    public FeedbackHandler get_feedback() throws DatabaseException {
        return this.db_feedback_handler;
    }

    private final int handle_dup_compare(byte[] byArray, byte[] byArray2) {
        return this.dup_compare_handler.compare(byArray, byArray2);
    }

    public Comparator get_dup_compare() throws DatabaseException {
        return this.dup_compare_handler;
    }

    private final int handle_h_hash(byte[] byArray, int n) {
        return this.h_hash_handler.hash(this.wrapper, byArray, n);
    }

    public Hasher get_h_hash() throws DatabaseException {
        return this.h_hash_handler;
    }

    private final int handle_seckey_create(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws DatabaseException {
        return this.seckey_create_handler.createSecondaryKey((SecondaryDatabase)this.wrapper, databaseEntry, databaseEntry2, databaseEntry3) ? 0 : -30998;
    }

    public SecondaryKeyCreator get_seckey_create() throws DatabaseException {
        return this.seckey_create_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String string, String string2, int n) throws DatabaseException, FileNotFoundException {
        try {
            this.remove0(string, string2, n);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(String string, String string2, String string3, int n) throws DatabaseException, FileNotFoundException {
        try {
            this.rename0(string, string2, string3, n);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verify(String string, String string2, OutputStream outputStream, int n) throws DatabaseException, FileNotFoundException {
        try {
            boolean bl = this.verify0(string, string2, outputStream, n);
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public ErrorHandler get_errcall() {
        return this.dbenv.get_errcall();
    }

    public void set_errcall(ErrorHandler errorHandler) {
        this.dbenv.set_errcall(errorHandler);
    }

    public OutputStream get_error_stream() {
        return this.dbenv.get_error_stream();
    }

    public void set_error_stream(OutputStream outputStream) {
        this.dbenv.set_error_stream(outputStream);
    }

    public void set_errpfx(String string) {
        this.dbenv.set_errpfx(string);
    }

    public String get_errpfx() {
        return this.dbenv.get_errpfx();
    }

    public OutputStream get_message_stream() {
        return this.dbenv.get_message_stream();
    }

    public void set_message_stream(OutputStream outputStream) {
        this.dbenv.set_message_stream(outputStream);
    }

    public MessageHandler get_msgcall() {
        return this.dbenv.get_msgcall();
    }

    public void set_msgcall(MessageHandler messageHandler) {
        this.dbenv.set_msgcall(messageHandler);
    }

    public void set_paniccall(PanicHandler panicHandler) throws DatabaseException {
        this.dbenv.set_paniccall(panicHandler);
    }

    public PanicHandler get_paniccall() throws DatabaseException {
        return this.dbenv.get_paniccall();
    }

    public Db(DbEnv dbEnv, int n) throws DatabaseException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbEnv), n), true);
        this.initialize(dbEnv);
    }

    public void associate(DbTxn dbTxn, Db db, SecondaryKeyCreator secondaryKeyCreator, int n) throws DatabaseException {
        db.seckey_create_handler = secondaryKeyCreator;
        db_javaJNI.Db_associate(this.swigCPtr, DbTxn.getCPtr(dbTxn), Db.getCPtr(db), db.seckey_create_handler, n);
    }

    public void compact(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, CompactStats compactStats, int n, DatabaseEntry databaseEntry3) throws DatabaseException {
        db_javaJNI.Db_compact(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, databaseEntry2, compactStats, n, databaseEntry3);
    }

    int close0(int n) {
        return db_javaJNI.Db_close0(this.swigCPtr, n);
    }

    public Dbc cursor(DbTxn dbTxn, int n) throws DatabaseException {
        long l = db_javaJNI.Db_cursor(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
        return l == 0L ? null : new Dbc(l, false);
    }

    public int del(DbTxn dbTxn, DatabaseEntry databaseEntry, int n) throws DatabaseException {
        return db_javaJNI.Db_del(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, n);
    }

    public void err(int n, String string) {
        db_javaJNI.Db_err(this.swigCPtr, n, string);
    }

    public void errx(String string) {
        db_javaJNI.Db_errx(this.swigCPtr, string);
    }

    public boolean get_transactional() throws DatabaseException {
        return db_javaJNI.Db_get_transactional(this.swigCPtr);
    }

    public int get(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        return db_javaJNI.Db_get(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, databaseEntry2, n);
    }

    public boolean get_byteswapped() throws DatabaseException {
        return db_javaJNI.Db_get_byteswapped(this.swigCPtr);
    }

    public long get_cachesize() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize_ncache(this.swigCPtr);
    }

    public String get_filename() throws DatabaseException {
        return db_javaJNI.Db_get_filename(this.swigCPtr);
    }

    public String get_dbname() throws DatabaseException {
        return db_javaJNI.Db_get_dbname(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DatabaseException {
        return db_javaJNI.Db_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.Db_get_flags(this.swigCPtr);
    }

    public int get_lorder() throws DatabaseException {
        return db_javaJNI.Db_get_lorder(this.swigCPtr);
    }

    public DbMpoolFile get_mpf() throws DatabaseException {
        long l = db_javaJNI.Db_get_mpf(this.swigCPtr);
        return l == 0L ? null : new DbMpoolFile(l, false);
    }

    public int get_open_flags() throws DatabaseException {
        return db_javaJNI.Db_get_open_flags(this.swigCPtr);
    }

    public int get_pagesize() throws DatabaseException {
        return db_javaJNI.Db_get_pagesize(this.swigCPtr);
    }

    public int get_bt_minkey() throws DatabaseException {
        return db_javaJNI.Db_get_bt_minkey(this.swigCPtr);
    }

    public int get_h_ffactor() throws DatabaseException {
        return db_javaJNI.Db_get_h_ffactor(this.swigCPtr);
    }

    public int get_h_nelem() throws DatabaseException {
        return db_javaJNI.Db_get_h_nelem(this.swigCPtr);
    }

    public int get_re_delim() throws DatabaseException {
        return db_javaJNI.Db_get_re_delim(this.swigCPtr);
    }

    public int get_re_len() throws DatabaseException {
        return db_javaJNI.Db_get_re_len(this.swigCPtr);
    }

    public int get_re_pad() throws DatabaseException {
        return db_javaJNI.Db_get_re_pad(this.swigCPtr);
    }

    public String get_re_source() throws DatabaseException {
        return db_javaJNI.Db_get_re_source(this.swigCPtr);
    }

    public int get_q_extentsize() throws DatabaseException {
        return db_javaJNI.Db_get_q_extentsize(this.swigCPtr);
    }

    public int get_type() throws DatabaseException {
        return db_javaJNI.Db_get_type(this.swigCPtr);
    }

    public Dbc join(Dbc[] dbcArray, int n) throws DatabaseException {
        long l = db_javaJNI.Db_join(this.swigCPtr, dbcArray, n);
        return l == 0L ? null : new Dbc(l, true);
    }

    public void key_range(DbTxn dbTxn, DatabaseEntry databaseEntry, KeyRange keyRange, int n) throws DatabaseException {
        db_javaJNI.Db_key_range(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, keyRange, n);
    }

    public void open(DbTxn dbTxn, String string, String string2, int n, int n2, int n3) throws DatabaseException, FileNotFoundException {
        db_javaJNI.Db_open(this.swigCPtr, DbTxn.getCPtr(dbTxn), string, string2, n, n2, n3);
    }

    public int pget(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, int n) throws DatabaseException {
        return db_javaJNI.Db_pget(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, databaseEntry2, databaseEntry3, n);
    }

    public int put(DbTxn dbTxn, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, int n) throws DatabaseException {
        return db_javaJNI.Db_put(this.swigCPtr, DbTxn.getCPtr(dbTxn), databaseEntry, databaseEntry2, n);
    }

    void remove0(String string, String string2, int n) {
        db_javaJNI.Db_remove0(this.swigCPtr, string, string2, n);
    }

    void rename0(String string, String string2, String string3, int n) {
        db_javaJNI.Db_rename0(this.swigCPtr, string, string2, string3, n);
    }

    public void set_append_recno(RecordNumberAppender recordNumberAppender) throws DatabaseException {
        this.append_recno_handler = recordNumberAppender;
        db_javaJNI.Db_set_append_recno(this.swigCPtr, this.append_recno_handler);
    }

    public void set_bt_compare(Comparator comparator) throws DatabaseException {
        this.bt_compare_handler = comparator;
        db_javaJNI.Db_set_bt_compare(this.swigCPtr, this.bt_compare_handler);
    }

    public void set_bt_minkey(int n) throws DatabaseException {
        db_javaJNI.Db_set_bt_minkey(this.swigCPtr, n);
    }

    public void set_bt_prefix(BtreePrefixCalculator btreePrefixCalculator) throws DatabaseException {
        this.bt_prefix_handler = btreePrefixCalculator;
        db_javaJNI.Db_set_bt_prefix(this.swigCPtr, this.bt_prefix_handler);
    }

    public void set_cachesize(long l, int n) throws DatabaseException {
        db_javaJNI.Db_set_cachesize(this.swigCPtr, l, n);
    }

    public void set_dup_compare(Comparator comparator) throws DatabaseException {
        this.dup_compare_handler = comparator;
        db_javaJNI.Db_set_dup_compare(this.swigCPtr, this.dup_compare_handler);
    }

    public void set_encrypt(String string, int n) throws DatabaseException {
        db_javaJNI.Db_set_encrypt(this.swigCPtr, string, n);
    }

    public void set_feedback(FeedbackHandler feedbackHandler) throws DatabaseException {
        this.db_feedback_handler = feedbackHandler;
        db_javaJNI.Db_set_feedback(this.swigCPtr, this.db_feedback_handler);
    }

    public void set_flags(int n) throws DatabaseException {
        db_javaJNI.Db_set_flags(this.swigCPtr, n);
    }

    public void set_h_ffactor(int n) throws DatabaseException {
        db_javaJNI.Db_set_h_ffactor(this.swigCPtr, n);
    }

    public void set_h_hash(Hasher hasher) throws DatabaseException {
        this.h_hash_handler = hasher;
        db_javaJNI.Db_set_h_hash(this.swigCPtr, this.h_hash_handler);
    }

    public void set_h_nelem(int n) throws DatabaseException {
        db_javaJNI.Db_set_h_nelem(this.swigCPtr, n);
    }

    public void set_lorder(int n) throws DatabaseException {
        db_javaJNI.Db_set_lorder(this.swigCPtr, n);
    }

    public void set_pagesize(long l) throws DatabaseException {
        db_javaJNI.Db_set_pagesize(this.swigCPtr, l);
    }

    public void set_re_delim(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_delim(this.swigCPtr, n);
    }

    public void set_re_len(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_len(this.swigCPtr, n);
    }

    public void set_re_pad(int n) throws DatabaseException {
        db_javaJNI.Db_set_re_pad(this.swigCPtr, n);
    }

    public void set_re_source(String string) throws DatabaseException {
        db_javaJNI.Db_set_re_source(this.swigCPtr, string);
    }

    public void set_q_extentsize(int n) throws DatabaseException {
        db_javaJNI.Db_set_q_extentsize(this.swigCPtr, n);
    }

    public Object stat(DbTxn dbTxn, int n) throws DatabaseException {
        return db_javaJNI.Db_stat(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
    }

    public void sync(int n) throws DatabaseException {
        db_javaJNI.Db_sync(this.swigCPtr, n);
    }

    public int truncate(DbTxn dbTxn, int n) throws DatabaseException {
        return db_javaJNI.Db_truncate(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
    }

    public void upgrade(String string, int n) throws DatabaseException {
        db_javaJNI.Db_upgrade(this.swigCPtr, string, n);
    }

    boolean verify0(String string, String string2, OutputStream outputStream, int n) {
        return db_javaJNI.Db_verify0(this.swigCPtr, string, string2, outputStream, n);
    }
}

