/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.regex;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.regex.PythonRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexQueryCapable;
import org.apache.lucene.search.regex.RegexTermEnum;

public class RegexQuery
extends MultiTermQuery
implements RegexQueryCapable {
    private RegexCapabilities regexImpl = new PythonRegexCapabilities();

    public RegexQuery(Term term) {
        super(term);
    }

    public void setRegexImplementation(RegexCapabilities impl) {
        this.regexImpl = impl;
    }

    public RegexCapabilities getRegexImplementation() {
        return this.regexImpl;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        Term term = new Term(this.getTerm().field(), this.getTerm().text());
        return new RegexTermEnum(reader, term, this.regexImpl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexQuery that = (RegexQuery)o;
        return this.regexImpl.equals(that.regexImpl);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.regexImpl.hashCode();
        return result;
    }
}

