/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.store.db.DbDirectory;

public class File {
    protected static Random random = new Random();
    protected DatabaseEntry key;
    protected DatabaseEntry data;
    protected long length;
    protected long timeModified;
    protected String name;
    protected byte[] uuid;

    protected File(String name) throws IOException {
        this.setName(name);
        this.data = new DatabaseEntry(new byte[32]);
        this.data.setUserBuffer(this.data.getSize(), true);
    }

    protected File(DbDirectory directory, String name, boolean create) throws IOException {
        this(name);
        if (!this.exists(directory)) {
            if (!create) {
                throw new IOException("File does not exist: " + name);
            }
            DatabaseEntry key = new DatabaseEntry(new byte[24]);
            DatabaseEntry data = new DatabaseEntry(null);
            Db blocks = directory.blocks;
            DbTxn txn = directory.txn;
            int flags = directory.flags;
            key.setUserBuffer(24, true);
            data.setPartial(true);
            this.uuid = new byte[16];
            try {
                do {
                    random.nextBytes(this.uuid);
                    this.uuid[6] = (byte)(0x40 | this.uuid[6] & 0xF);
                    this.uuid[8] = (byte)(0xFFFFFF80 | this.uuid[8] & 0x3F);
                    System.arraycopy(this.uuid, 0, key.getData(), 0, 16);
                } while (blocks.get(txn, key, data, flags) != -30989);
            }
            catch (DatabaseException e) {
                throw new IOException(e.getMessage());
            }
        } else if (create) {
            this.length = 0L;
        }
    }

    protected String getName() {
        return this.name;
    }

    private void setName(String name) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeUTF(name);
        out.close();
        this.key = new DatabaseEntry(buffer.toByteArray());
        this.key.setUserBuffer(this.key.getSize(), true);
        this.name = name;
    }

    protected byte[] getKey() throws IOException {
        if (this.uuid == null) {
            throw new IOException("Uninitialized file");
        }
        return this.uuid;
    }

    protected long getLength() {
        return this.length;
    }

    protected long getTimeModified() {
        return this.timeModified;
    }

    protected boolean exists(DbDirectory directory) throws IOException {
        Db files = directory.files;
        DbTxn txn = directory.txn;
        int flags = directory.flags;
        try {
            if (files.get(txn, this.key, this.data, flags) == -30989) {
                return false;
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
        byte[] bytes = this.data.getData();
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(buffer);
        this.length = in.readLong();
        this.timeModified = in.readLong();
        in.close();
        this.uuid = new byte[16];
        System.arraycopy(bytes, 16, this.uuid, 0, 16);
        return true;
    }

    protected void modify(DbDirectory directory, long length, long timeModified) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(32);
        DataOutputStream out = new DataOutputStream(buffer);
        Db files = directory.files;
        DbTxn txn = directory.txn;
        out.writeLong(length);
        out.writeLong(timeModified);
        out.write(this.getKey());
        out.close();
        System.arraycopy(buffer.toByteArray(), 0, this.data.getData(), 0, 32);
        try {
            files.put(txn, this.key, this.data, 0);
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
        this.length = length;
        this.timeModified = timeModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(DbDirectory directory) throws IOException {
        if (!this.exists(directory)) {
            throw new IOException("File does not exist: " + this.getName());
        }
        Dbc cursor = null;
        try {
            try {
                byte[] bytes = this.getKey();
                int ulen = bytes.length + 8;
                byte[] cursorBytes = new byte[ulen];
                DatabaseEntry cursorKey = new DatabaseEntry(cursorBytes);
                DatabaseEntry cursorData = new DatabaseEntry(null);
                Db files = directory.files;
                Db blocks = directory.blocks;
                DbTxn txn = directory.txn;
                int flags = directory.flags;
                System.arraycopy(bytes, 0, cursorBytes, 0, bytes.length);
                cursorKey.setUserBuffer(ulen, true);
                cursorData.setPartial(true);
                cursor = blocks.cursor(txn, flags);
                if (cursor.get(cursorKey, cursorData, 0x1E | flags) != -30989) {
                    cursor.del(0);
                    block5: while (cursor.get(cursorKey, cursorData, 0x12 | flags) != -30989) {
                        for (int i = 0; i < bytes.length; ++i) {
                            if (bytes[i] != cursorBytes[i]) break block5;
                        }
                        cursor.del(0);
                    }
                }
                files.del(txn, this.key, 0);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void rename(DbDirectory directory, String name) throws IOException {
        if (!this.exists(directory)) {
            throw new IOException("File does not exist: " + this.getName());
        }
        File newFile = new File(name);
        if (newFile.exists(directory)) {
            newFile.delete(directory);
        }
        try {
            Db files = directory.files;
            DbTxn txn = directory.txn;
            files.del(txn, this.key, 0);
            this.setName(name);
            files.put(txn, this.key, this.data, 0);
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
    }
}

