/* ====================================================================
 * Copyright (c) 2004-2005 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#include "PyLucene.h"

#include "org/osafoundation/util/PythonException.h"
#include "org/osafoundation/search/highlight/PythonFormatter.h"
#include "org/osafoundation/search/highlight/PythonFragmenter.h"
#include "org/apache/lucene/search/highlight/TokenGroup.h"
#include "org/apache/lucene/analysis/Token.h"


/**
 * The native functions declared in: 
 *     org.osafoundation.search.highlight.PythonFormatter
 *     org.osafoundation.search.highlight.PythonFragmenter
 * 
 * @author Andi Vajda
 */

namespace org {
    namespace osafoundation {
        namespace search {
            namespace highlight {

                // org.osafoundation.search.highlight.PythonFormatter

                void PythonFormatter::incRef(void)
                {
                    PythonGIL gil;
                    Py_INCREF(*(PyObject **) &pythonFormatter);
                }

                void PythonFormatter::decRef(void)
                {
                    finalizeObject(pythonFormatter);
                }

                jstring PythonFormatter::highlightTerm(jstring originalText, ::org::apache::lucene::search::highlight::TokenGroup *tokenGroup)
                {
                    PythonGIL gil;
                    PyObject *pyOriginalText = j2p(originalText);
                    PyObject *pyTokenGroup = wrap_TokenGroup(tokenGroup);
                    PyObject *pys = callPython(*(PyObject **) &pythonFormatter, "highlightTerm", pyOriginalText, pyTokenGroup, NULL);

                    Py_DECREF(pyOriginalText);
                    Py_DECREF(pyTokenGroup);

                    if (!pys)
                        throw new org::osafoundation::util::PythonException();

                    jstring js = p2j(pys);
                    Py_DECREF(pys);

                    return js;
                }


                // org.osafoundation.search.highlight.PythonFragmenter

                void PythonFragmenter::incRef(void)
                {
                    PythonGIL gil;
                    Py_INCREF(*(PyObject **) &pythonFragmenter);
                }

                void PythonFragmenter::decRef(void)
                {
                    finalizeObject(pythonFragmenter);
                }

                jboolean PythonFragmenter::isNewFragment(::org::apache::lucene::analysis::Token *token)
                {
                    PythonGIL gil;
                    PyObject *pyToken = wrap_Token(token);
                    PyObject *pyb = callPython(*(PyObject **) &pythonFragmenter, "isNewFragment", pyToken, NULL);

                    Py_DECREF(pyToken);

                    if (!pyb)
                        throw new org::osafoundation::util::PythonException();

                    jboolean b = (jboolean) PyObject_IsTrue(pyb);
                    Py_DECREF(pyb);

                    return b;
                }

                void PythonFragmenter::start(jstring text)
                {
                    PythonGIL gil;
                    PyObject *pys = j2p(text);
                    PyObject *result = callPython(*(PyObject **) &pythonFragmenter, "start", pys, NULL);

                    Py_DECREF(pys);

                    if (!result)
                        throw new org::osafoundation::util::PythonException();

                    Py_DECREF(result);
                }
            }
        }
    }
}

