/* ====================================================================
 * Copyright (c) 2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#include "PyLucene.h"

#include "org/osafoundation/util/PythonException.h"
#include "org/apache/lucene/search/regex/PythonRegexCapabilities.h"
#include "org/apache/lucene/index/IndexFileNameFilter.h"


/**
 * The native functions declared in: 
 *     org.apache.lucene.search.regex.PythonRegexCapabilities
 *     org.apache.lucene.index.IndexFileNameFilter
 * 
 * @author Andi Vajda
 */


static PyObject *re_module = NULL;

namespace org {
    namespace apache {
        namespace lucene {
            namespace search {
                namespace regex {
                    
                    // org.apache.lucene.search.regex.PythonRegexCapabilities

                    void PythonRegexCapabilities::finalize()
                    {
                        if (*(PyObject **) &pythonRE)
                        {
                            PythonGIL gil;
                            
                            Py_DECREF(*(PyObject **) &pythonRE);
                            *(PyObject **) &pythonRE = NULL;
                        }
                    }

                    void PythonRegexCapabilities::compile(jstring pattern)
                    {
                        PythonGIL gil;

                        if (!re_module)
                            re_module = PyImport_ImportModule("re");

                        PyObject *pyPattern = j2p(pattern);
                        PyObject *fn = PyObject_GetAttrString(re_module, "compile");

                        Py_XDECREF(*(PyObject **) &pythonRE);
                        *(PyObject **) &pythonRE = PyObject_CallFunctionObjArgs(fn, pyPattern, NULL);

                        Py_DECREF(pyPattern);
                        Py_DECREF(fn);

                        if (!*(PyObject **) &pythonRE)
                            throw new org::osafoundation::util::PythonException();
                    }

                    jboolean PythonRegexCapabilities::match(jstring text)
                    {
                        PythonGIL gil;

                        if (!re_module)
                            re_module = PyImport_ImportModule("re");

                        PyObject *pyText = j2p(text);
                        PyObject *fn = PyObject_GetAttrString(re_module, "match");
                        PyObject *result = PyObject_CallFunctionObjArgs(fn, *(PyObject **) &pythonRE, pyText, NULL);

                        Py_DECREF(pyText);
                        Py_DECREF(fn);

                        if (!result)
                            throw new org::osafoundation::util::PythonException();

                        jboolean isTrue = PyObject_IsTrue(result);

                        Py_DECREF(result);

                        return isTrue;
                    }
                }
            }

            namespace index {

                // org.apache.lucene.index.IndexFileNameFilter

                jboolean IndexFileNameFilter::matches(jstring pattern,
                                                      jstring text)
                {
                    PythonGIL gil;

                    if (!re_module)
                        re_module = PyImport_ImportModule("re");

                    PyObject *pyPattern = j2p(pattern);
                    PyObject *pyText = j2p(text);
                    PyObject *fn = PyObject_GetAttrString(re_module, "match");
                    PyObject *result = PyObject_CallFunctionObjArgs(fn, pyPattern, pyText, NULL);

                    Py_DECREF(pyPattern);
                    Py_DECREF(pyText);
                    Py_DECREF(fn);

                    if (!result)
                        throw new org::osafoundation::util::PythonException();

                    jboolean isTrue = PyObject_IsTrue(result);

                    Py_DECREF(result);

                    return isTrue;
                }
            }
        }
    }
}
