/* ====================================================================
 * Copyright (c) 2004-2005 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#include "PyLucene.h"

#include "org/apache/lucene/document/Field.h"
#include "org/apache/lucene/document/Document.h"
#include "org/osafoundation/util/PythonComparable.h"
#include "org/osafoundation/util/PythonRunnable.h"
#include "org/osafoundation/util/PythonException.h"


/**
 * The native functions declared in:
 *     org.osafoundation.util.PythonComparable
 *     org.osafoundation.util.PythonRunnable
 * 
 * @author Andi Vajda
 */

namespace org {
    namespace osafoundation {
        namespace util {

            // org.osafoundation.util.PythonComparable

            void PythonComparable::incRef(void)
            {
                PythonGIL gil;
                Py_INCREF(*(PyObject **) &pythonComparable);
            }

            void PythonComparable::decRef(void)
            {
                finalizeObject(pythonComparable);
            }

            jint PythonComparable::compareTo(jobject jo)
            {
                PythonGIL gil;
                PyObject *po = jc2pc((::java::lang::Comparable *) jo);
                PyObject *pyn = callPython(*(PyObject **) &pythonComparable, "compareTo", po, NULL);

                Py_DECREF(po);

                if (!pyn)
                    throw new org::osafoundation::util::PythonException();

                long n = PyInt_AsLong(pyn);
                Py_DECREF(pyn);

                return (jint) n;
            }

            // org.osafoundation.util.PythonRunnable

            void PythonRunnable::incRef(void)
            {
                PythonGIL gil;
                Py_INCREF(*(PyObject **) &pythonRunnable);
            }

            void PythonRunnable::decRef(void)
            {
                finalizeObject(pythonRunnable);
            }

            void PythonRunnable::run(void)
            {
                PythonGIL gil;
		PyObject *runnable = *(PyObject **) &pythonRunnable;
                PyObject *pyv = callPython(runnable, "run", NULL);

                if (pyv)
                    Py_DECREF(pyv);
            }
        }
    }
}
