/* ====================================================================
 * Copyright (c) 2004-2005 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

package org.osafoundation.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;


public class IndexReaderEnumeration implements Enumeration {

    protected IndexReader indexReader;
    protected int current = 0;

    public IndexReaderEnumeration(IndexReader indexReader)
    {
        this.indexReader = indexReader;
    }

    public boolean hasMoreElements()
    {
        return current < indexReader.maxDoc();
    }

    public Object nextElement()
    {
        while (current < indexReader.maxDoc())
        {
            try {
                if (!indexReader.isDeleted(current++))
                    return indexReader.document(current - 1);
            } catch (IOException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        throw new NoSuchElementException();
    }
}
