/* ====================================================================
 * Copyright (c) 2004-2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#include <gcj/cni.h>
#include <java/lang/StringBuffer.h>
#include <java/io/File.h>
#include <java/util/Arrays.h>
#include <java/util/List.h>
#include <java/util/Vector.h>

#include "org/apache/lucene/LucenePackage.h"
#include "org/apache/lucene/analysis/Token.h"
#include "org/apache/lucene/analysis/TokenStream.h"
#include "org/apache/lucene/analysis/TokenFilter.h"
#include "org/apache/lucene/analysis/Tokenizer.h"
#include "org/apache/lucene/analysis/CharTokenizer.h"
#include "org/apache/lucene/analysis/LetterTokenizer.h"
#include "org/apache/lucene/analysis/LowerCaseTokenizer.h"
#include "org/apache/lucene/analysis/LowerCaseFilter.h"
#include "org/apache/lucene/analysis/ISOLatin1AccentFilter.h"
#include "org/apache/lucene/analysis/KeywordAnalyzer.h"
#include "org/apache/lucene/analysis/KeywordTokenizer.h"
#include "org/apache/lucene/analysis/LengthFilter.h"
#include "org/apache/lucene/analysis/PorterStemFilter.h"
#include "org/apache/lucene/analysis/StopFilter.h"
#include "org/apache/lucene/analysis/Analyzer.h"
#include "org/apache/lucene/analysis/SimpleAnalyzer.h"
#include "org/apache/lucene/analysis/StopAnalyzer.h"
#include "org/apache/lucene/analysis/WhitespaceAnalyzer.h"
#include "org/apache/lucene/analysis/WhitespaceTokenizer.h"
#include "org/apache/lucene/analysis/PerFieldAnalyzerWrapper.h"
#include "org/apache/lucene/analysis/standard/StandardAnalyzer.h"
#include "org/apache/lucene/analysis/standard/StandardFilter.h"
#include "org/apache/lucene/analysis/standard/StandardTokenizer.h"
#include "org/apache/lucene/analysis/standard/StandardTokenizerTokenManager.h"
#include "org/apache/lucene/analysis/standard/StandardTokenizerConstants.h"
#include "org/apache/lucene/analysis/br/BrazilianAnalyzer.h"
#include "org/apache/lucene/analysis/br/BrazilianStemmer.h"
#include "org/apache/lucene/analysis/br/BrazilianStemFilter.h"
#include "org/apache/lucene/analysis/cjk/CJKAnalyzer.h"
#include "org/apache/lucene/analysis/cjk/CJKTokenizer.h"
#include "org/apache/lucene/analysis/cn/ChineseAnalyzer.h"
#include "org/apache/lucene/analysis/cn/ChineseFilter.h"
#include "org/apache/lucene/analysis/cn/ChineseTokenizer.h"
#include "org/apache/lucene/analysis/cz/CzechAnalyzer.h"
#include "org/apache/lucene/analysis/de/GermanAnalyzer.h"
#include "org/apache/lucene/analysis/de/GermanStemmer.h"
#include "org/apache/lucene/analysis/de/GermanStemFilter.h"
#include "org/apache/lucene/analysis/el/GreekAnalyzer.h"
#include "org/apache/lucene/analysis/el/GreekLowerCaseFilter.h"
#include "org/apache/lucene/analysis/el/GreekCharsets.h"
#include "org/apache/lucene/analysis/fr/FrenchAnalyzer.h"
#include "org/apache/lucene/analysis/fr/FrenchStemmer.h"
#include "org/apache/lucene/analysis/fr/FrenchStemFilter.h"
#include "org/apache/lucene/analysis/nl/DutchAnalyzer.h"
#include "org/apache/lucene/analysis/nl/DutchStemmer.h"
#include "org/apache/lucene/analysis/nl/DutchStemFilter.h"
#include "org/apache/lucene/analysis/ru/RussianAnalyzer.h"
#include "org/apache/lucene/analysis/ru/RussianStemmer.h"
#include "org/apache/lucene/analysis/ru/RussianStemFilter.h"
#include "org/apache/lucene/analysis/ru/RussianLowerCaseFilter.h"
#include "org/apache/lucene/analysis/ru/RussianCharsets.h"
#include "org/apache/lucene/analysis/snowball/SnowballAnalyzer.h"
#include "org/apache/lucene/analysis/snowball/SnowballFilter.h"
#include "org/apache/lucene/document/Fieldable.h"
#include "org/apache/lucene/document/Field.h"
#include "org/apache/lucene/document/Field$Store.h"
#include "org/apache/lucene/document/Field$Index.h"
#include "org/apache/lucene/document/Field$TermVector.h"
#include "org/apache/lucene/document/DateField.h"
#include "org/apache/lucene/document/DateTools$Resolution.h"
#include "org/apache/lucene/document/DateTools.h"
#include "org/apache/lucene/document/NumberTools.h"
#include "org/apache/lucene/document/FieldSelectorResult.h"
#include "org/apache/lucene/document/Document.h"
#include "org/apache/lucene/index/IndexWriter.h"
#include "org/apache/lucene/index/IndexReader.h"
#include "org/apache/lucene/index/IndexReader$FieldOption.h"
#include "org/apache/lucene/index/IndexModifier.h"
#include "org/apache/lucene/index/FilterIndexReader.h"
#include "org/apache/lucene/index/ParallelReader.h"
#include "org/apache/lucene/index/MultiReader.h"
#include "org/apache/lucene/index/Term.h"
#include "org/apache/lucene/index/TermDocs.h"
#include "org/apache/lucene/index/TermVectorOffsetInfo.h"
#include "org/apache/lucene/index/TermEnum.h"
#include "org/apache/lucene/index/TermFreqVector.h"
#include "org/apache/lucene/index/TermPositionVector.h"
#include "org/apache/lucene/index/TermPositions.h"
#include "org/apache/lucene/index/MultipleTermPositions.h"
#include "org/apache/lucene/index/IndexFileNames.h"
#include "org/apache/lucene/queryParser/QueryParser.h"
#include "org/apache/lucene/queryParser/QueryParser$Operator.h"
#include "org/apache/lucene/queryParser/QueryParserConstants.h"
#include "org/apache/lucene/queryParser/QueryParserTokenManager.h"
#include "org/apache/lucene/queryParser/MultiFieldQueryParser.h"
#include "org/apache/lucene/queryParser/Token.h"
#include "org/apache/lucene/search/BooleanClause.h"
#include "org/apache/lucene/search/BooleanClause$Occur.h"
#include "org/apache/lucene/search/BooleanQuery.h"
#include "org/apache/lucene/search/TermQuery.h"
#include "org/apache/lucene/search/PhraseQuery.h"
#include "org/apache/lucene/search/MultiPhraseQuery.h"
#include "org/apache/lucene/search/PrefixQuery.h"
#include "org/apache/lucene/search/Searchable.h"
#include "org/apache/lucene/search/Searcher.h"
#include "org/apache/lucene/search/Query.h"
#include "org/apache/lucene/search/MatchAllDocsQuery.h"
#include "org/apache/lucene/search/Weight.h"
#include "org/apache/lucene/search/Scorer.h"
#include "org/apache/lucene/search/Hits.h"
#include "org/apache/lucene/search/Hit.h"
#include "org/apache/lucene/search/HitCollector.h"
#include "org/apache/lucene/search/TopDocCollector.h"
#include "org/apache/lucene/search/TopFieldDocCollector.h"
#include "org/apache/lucene/search/IndexSearcher.h"
#include "org/apache/lucene/search/MultiSearcher.h"
#include "org/apache/lucene/search/ParallelMultiSearcher.h"
#include "org/apache/lucene/search/ScoreDoc.h"
#include "org/apache/lucene/search/ScoreDocComparator.h"
#include "org/apache/lucene/search/TopDocs.h"
#include "org/apache/lucene/search/TopFieldDocs.h"
#include "org/apache/lucene/search/FieldDoc.h"
#include "org/apache/lucene/search/SortComparator.h"
#include "org/apache/lucene/search/SortField.h"
#include "org/apache/lucene/search/Sort.h"
#include "org/apache/lucene/search/SortComparatorSource.h"
#include "org/apache/lucene/search/Explanation.h"
#include "org/apache/lucene/search/Similarity.h"
#include "org/apache/lucene/search/DefaultSimilarity.h"
#include "org/apache/lucene/search/Filter.h"
#include "org/apache/lucene/search/FilteredTermEnum.h"
#include "org/apache/lucene/search/FuzzyTermEnum.h"
#include "org/apache/lucene/search/WildcardTermEnum.h"
#include "org/apache/lucene/search/CachingWrapperFilter.h"
#include "org/apache/lucene/search/QueryFilter.h"
#include "org/apache/lucene/search/RangeFilter.h"
#include "org/apache/lucene/search/PrefixFilter.h"
#include "org/apache/lucene/search/FilteredQuery.h"
#include "org/apache/lucene/search/RangeQuery.h"
#include "org/apache/lucene/search/ConstantScoreQuery.h"
#include "org/apache/lucene/search/ConstantScoreRangeQuery.h"
#include "org/apache/lucene/search/DisjunctionMaxQuery.h"
#include "org/apache/lucene/search/MultiTermQuery.h"
#include "org/apache/lucene/search/FuzzyQuery.h"
#include "org/apache/lucene/search/WildcardQuery.h"
#include "org/apache/lucene/search/spans/SpanQuery.h"
#include "org/apache/lucene/search/spans/Spans.h"
#include "org/apache/lucene/search/spans/SpanFirstQuery.h"
#include "org/apache/lucene/search/spans/SpanNearQuery.h"
#include "org/apache/lucene/search/spans/SpanNotQuery.h"
#include "org/apache/lucene/search/spans/SpanOrQuery.h"
#include "org/apache/lucene/search/spans/SpanTermQuery.h"
#include "org/apache/lucene/search/regex/RegexQuery.h"
#include "org/apache/lucene/search/regex/SpanRegexQuery.h"
#include "org/apache/lucene/search/regex/RegexTermEnum.h"
#include "org/apache/lucene/search/regex/RegexCapabilities.h"
#include "org/apache/lucene/search/regex/PythonRegexCapabilities.h"
#include "org/apache/lucene/search/similar/MoreLikeThis.h"
#include "org/apache/lucene/search/similar/MoreLikeThisQuery.h"
#include "org/apache/lucene/search/FuzzyLikeThisQuery.h"
#include "org/apache/lucene/search/BooleanFilter.h"
#include "org/apache/lucene/search/FilterClause.h"
#include "org/apache/lucene/search/TermsFilter.h"
#include "org/apache/lucene/search/BoostingQuery.h"
#include "org/apache/lucene/search/highlight/TokenGroup.h"
#include "org/apache/lucene/search/highlight/TextFragment.h"
#include "org/apache/lucene/search/highlight/WeightedTerm.h"
#include "org/apache/lucene/search/highlight/Formatter.h"
#include "org/apache/lucene/search/highlight/SimpleHTMLFormatter.h"
#include "org/apache/lucene/search/highlight/GradientFormatter.h"
#include "org/apache/lucene/search/highlight/SpanGradientFormatter.h"
#include "org/apache/lucene/search/highlight/Fragmenter.h"
#include "org/apache/lucene/search/highlight/SimpleFragmenter.h"
#include "org/apache/lucene/search/highlight/NullFragmenter.h"
#include "org/apache/lucene/search/highlight/Scorer.h"
#include "org/apache/lucene/search/highlight/QueryScorer.h"
#include "org/apache/lucene/search/highlight/QueryTermExtractor.h"
#include "org/apache/lucene/search/highlight/Highlighter.h"
#include "org/apache/lucene/store/IndexInput.h"
#include "org/apache/lucene/store/BufferedIndexInput.h"
#include "org/apache/lucene/store/IndexOutput.h"
#include "org/apache/lucene/store/BufferedIndexOutput.h"
#include "org/apache/lucene/store/RAMOutputStream.h"
#include "org/apache/lucene/store/Lock.h"
#include "org/apache/lucene/store/Directory.h"
#include "org/apache/lucene/store/FSDirectory.h"
#include "org/apache/lucene/store/RAMDirectory.h"
#include "org/apache/lucene/store/MMapDirectory.h"
#include "org/osafoundation/util/PythonComparable.h"
#include "org/osafoundation/util/PythonRunnable.h"
#include "org/osafoundation/util/PythonException.h"
#include "org/osafoundation/util/IndexReaderEnumeration.h"
#include "org/osafoundation/util/TokenEnumeration.h"
#include "org/osafoundation/io/PythonReader.h"
#include "org/osafoundation/search/PythonSortComparatorSource.h"
#include "org/osafoundation/search/PythonSortComparator.h"
#include "org/osafoundation/search/PythonFilter.h"
#include "org/osafoundation/search/PythonHitCollector.h"
#include "org/osafoundation/search/PythonSimilarity.h"
#include "org/osafoundation/search/PythonFilteredTermEnum.h"
#include "org/osafoundation/search/PythonSearcher.h"
#include "org/osafoundation/search/highlight/PythonFormatter.h"
#include "org/osafoundation/search/highlight/PythonFragmenter.h"
#include "org/osafoundation/analysis/PythonAnalyzer.h"
#include "org/osafoundation/analysis/PythonTokenStream.h"
#include "org/osafoundation/analysis/PythonTokenFilter.h"
#include "org/osafoundation/analysis/PythonCharTokenizer.h"
#include "org/osafoundation/queryParser/PythonQueryParser.h"
#include "org/osafoundation/queryParser/PythonMultiFieldQueryParser.h"
#include "org/osafoundation/store/PythonDirectory.h"
#include "org/osafoundation/store/PythonIndexInput.h"
#include "org/osafoundation/store/PythonIndexOutput.h"
#include "org/osafoundation/store/PythonLock.h"

#include <Python.h>
#include "structmember.h"

#ifdef _WITH_DB_DIRECTORY

#include "com/sleepycat/db/internal/DbEnv.h"
#include "com/sleepycat/db/internal/Db.h"
#include "com/sleepycat/db/internal/DbTxn.h"

#include "org/apache/lucene/store/db/DbDirectory.h"

#include <db.h>

/* from Python's _bsddb.c */
typedef struct {
    PyObject_HEAD
    DB_ENV *db_env;
} DBEnvObject;

typedef struct {
    PyObject_HEAD
    DB *db;
} DBObject;

typedef struct {
    PyObject_HEAD
    DB_TXN *txn;
} DBTxnObject;

#endif

#include "cpp/PyLucene.h"
#include "macros.h"
#include "functions.h"
#include "converters.h"

#include "java.h"
#include "lucene.h"


/* LucenePackage */

class j_lucenepackage {
public:
    PyObject_HEAD
    org::apache::lucene::LucenePackage *object;
};

static PyObject *j_lucenepackage_get(PyTypeObject *type);

static PyMethodDef j_lucenepackage_methods[] = {
    DECLARE_METHOD(j_lucenepackage, get, METH_NOARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(LucenePackage, j_lucenepackage, Package,
             org::apache::lucene::LucenePackage, abstract_init);

/* IndexInput */

class j_indexinput {
public:
    PyObject_HEAD
    org::apache::lucene::store::IndexInput *object;
};

static int j_indexinput_init(j_indexinput *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_indexinput_close(j_indexinput *self);
static PyObject *j_indexinput_getFilePointer(j_indexinput *self);
static PyObject *j_indexinput_length(j_indexinput *self);
static PyObject *j_indexinput_readByte(j_indexinput *self);
static PyObject *j_indexinput_readInt(j_indexinput *self);
static PyObject *j_indexinput_readLong(j_indexinput *self);
static PyObject *j_indexinput_readString(j_indexinput *self);
static PyObject *j_indexinput_readVInt(j_indexinput *self);
static PyObject *j_indexinput_readVLong(j_indexinput *self);
static PyObject *j_indexinput_seek(j_indexinput *self, PyObject *arg);

static PyMethodDef j_indexinput_methods[] = {
    DECLARE_METHOD(j_indexinput, close, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, getFilePointer, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, length, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readByte, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readInt, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readLong, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readString, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readVInt, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, readVLong, METH_NOARGS),
    DECLARE_METHOD(j_indexinput, seek, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexInput, j_indexinput, Object,
             org::apache::lucene::store::IndexInput, j_indexinput_init);

static int check_IndexInput(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "readByte");
}

static org::apache::lucene::store::IndexInput *make_IndexInput(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::store::IndexInput *)
        new org::osafoundation::store::PythonIndexInput(ptr);
}

/* BufferedIndexInput */

class j_bufferedindexinput {
public:
    PyObject_HEAD
    org::apache::lucene::store::BufferedIndexInput *object;
};

static PyMethodDef j_bufferedindexinput_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BufferedIndexInput, j_bufferedindexinput, IndexInput,
             org::apache::lucene::store::BufferedIndexInput, abstract_init);

/* IndexOutput */

class j_indexoutput {
public:
    PyObject_HEAD
    org::apache::lucene::store::IndexOutput *object;
};

static int j_indexoutput_init(j_indexoutput *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_indexoutput_close(j_indexoutput *self);
static PyObject *j_indexoutput_flush(j_indexoutput *self);
static PyObject *j_indexoutput_getFilePointer(j_indexoutput *self);
static PyObject *j_indexoutput_length(j_indexoutput *self);
static PyObject *j_indexoutput_seek(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeByte(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeBytes(j_indexoutput *self, PyObject *args);
static PyObject *j_indexoutput_writeChars(j_indexoutput *self, PyObject *args);
static PyObject *j_indexoutput_writeInt(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeLong(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeString(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeVInt(j_indexoutput *self, PyObject *arg);
static PyObject *j_indexoutput_writeVLong(j_indexoutput *self, PyObject *arg);

static PyMethodDef j_indexoutput_methods[] = {
    DECLARE_METHOD(j_indexoutput, close, METH_NOARGS),
    DECLARE_METHOD(j_indexoutput, flush, METH_NOARGS),
    DECLARE_METHOD(j_indexoutput, getFilePointer, METH_NOARGS),
    DECLARE_METHOD(j_indexoutput, length, METH_NOARGS),
    DECLARE_METHOD(j_indexoutput, seek, METH_O),
    DECLARE_METHOD(j_indexoutput, writeByte, METH_O),
    DECLARE_METHOD(j_indexoutput, writeBytes, METH_VARARGS),
    DECLARE_METHOD(j_indexoutput, writeChars, METH_VARARGS),
    DECLARE_METHOD(j_indexoutput, writeInt, METH_O),
    DECLARE_METHOD(j_indexoutput, writeLong, METH_O),
    DECLARE_METHOD(j_indexoutput, writeString, METH_O),
    DECLARE_METHOD(j_indexoutput, writeVInt, METH_O),
    DECLARE_METHOD(j_indexoutput, writeVLong, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexOutput, j_indexoutput, Object,
             org::apache::lucene::store::IndexOutput, j_indexoutput_init);

static int check_IndexOutput(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "flushBuffer");
}

static org::apache::lucene::store::IndexOutput *make_IndexOutput(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::store::IndexOutput *)
        new org::osafoundation::store::PythonIndexOutput(ptr);
}


/* BufferedIndexOutput */

class j_bufferedindexoutput {
public:
    PyObject_HEAD
    org::apache::lucene::store::BufferedIndexOutput *object;
};

static PyMethodDef j_bufferedindexoutput_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BufferedIndexOutput, j_bufferedindexoutput, IndexOutput,
             org::apache::lucene::store::BufferedIndexOutput, abstract_init);


/* Lock */

class j_lock {
public:
    PyObject_HEAD
    org::apache::lucene::store::Lock *object;
};

static int j_lock_init(j_lock *self, PyObject *args, PyObject *kwds);
static PyObject *j_lock_isLocked(j_lock *self);
static PyObject *j_lock_obtain(j_lock *self, PyObject *args);
static PyObject *j_lock_release(j_lock *self);

static PyMethodDef j_lock_methods[] = {
    DECLARE_METHOD(j_lock, isLocked, METH_NOARGS),
    DECLARE_METHOD(j_lock, obtain, METH_VARARGS),
    DECLARE_METHOD(j_lock, release, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Lock, j_lock, Object, org::apache::lucene::store::Lock,
             j_lock_init);

static int check_Lock(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "isLocked");
}

static org::apache::lucene::store::Lock *make_Lock(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::store::Lock *)
        new org::osafoundation::store::PythonLock(ptr);
}

/* Directory */

class j_directory {
public:
    PyObject_HEAD
    org::apache::lucene::store::Directory *object;
};

static int j_directory_init(j_directory *self, PyObject *args, PyObject *kwds);
static PyObject *j_directory_close(j_directory *self);
static PyObject *j_directory_createOutput(j_directory *self, PyObject *arg);
static PyObject *j_directory_openInput(j_directory *self, PyObject *arg);
static PyObject *j_directory_deleteFile(j_directory *self, PyObject *arg);
static PyObject *j_directory_renameFile(j_directory *self, PyObject *args);
static PyObject *j_directory_touchFile(j_directory *self, PyObject *arg);
static PyObject *j_directory_fileExists(j_directory *self, PyObject *arg);
static PyObject *j_directory_fileLength(j_directory *self, PyObject *arg);
static PyObject *j_directory_fileModified(j_directory *self, PyObject *arg);
static PyObject *j_directory_list(j_directory *self);
static PyObject *j_directory_makeLock(j_directory *self, PyObject *arg);

static PyMethodDef j_directory_methods[] = {
    DECLARE_METHOD(j_directory, close, METH_NOARGS),
    DECLARE_METHOD(j_directory, createOutput, METH_O),
    DECLARE_METHOD(j_directory, openInput, METH_O),
    DECLARE_METHOD(j_directory, deleteFile, METH_O),
    DECLARE_METHOD(j_directory, renameFile, METH_VARARGS),
    DECLARE_METHOD(j_directory, fileExists, METH_O),
    DECLARE_METHOD(j_directory, fileLength, METH_O),
    DECLARE_METHOD(j_directory, fileModified, METH_O),
    DECLARE_METHOD(j_directory, list, METH_NOARGS),
    DECLARE_METHOD(j_directory, makeLock, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Directory, j_directory, Object,
             org::apache::lucene::store::Directory, j_directory_init);

static int check_Directory(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "deleteFile");
}

static org::apache::lucene::store::Directory *make_Directory(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::store::Directory *)
        new org::osafoundation::store::PythonDirectory(ptr);
}

/* FSDirectory */

class j_fsdirectory {
public:
    PyObject_HEAD
    org::apache::lucene::store::FSDirectory *object;
};

static PyObject *j_fsdirectory_getDirectory(PyTypeObject *type, PyObject *args);
static PyObject *j_fsdirectory_getDisableLocks(PyTypeObject *type);
static PyObject *j_fsdirectory_setDisableLocks(PyTypeObject *type,
                                               PyObject *arg);
static PyObject *j_fsdirectory_getFile(j_fsdirectory *self);

static PyMethodDef j_fsdirectory_methods[] = {
    DECLARE_METHOD(j_fsdirectory, getDirectory, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_fsdirectory, getDisableLocks, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_fsdirectory, setDisableLocks, METH_O | METH_CLASS),
    DECLARE_METHOD(j_fsdirectory, getFile, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FSDirectory, j_fsdirectory, Directory,
             org::apache::lucene::store::FSDirectory, abstract_init);

/* MMapDirectory */

class j_mmapdirectory {
public:
    PyObject_HEAD
    org::apache::lucene::store::MMapDirectory *object;
};

static PyObject *j_mmapdirectory_getDirectory(PyTypeObject *type,
                                              PyObject *args);

static PyMethodDef j_mmapdirectory_methods[] = {
    DECLARE_METHOD(j_mmapdirectory, getDirectory, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MMapDirectory, j_mmapdirectory, FSDirectory,
             org::apache::lucene::store::MMapDirectory, abstract_init);

#ifdef _WITH_DB_DIRECTORY

/* DbDirectory */

class j_dbdirectory {
public:
    PyObject_HEAD
    org::apache::lucene::store::db::DbDirectory *object;
};

static int j_dbdirectory_init(j_dbdirectory *self,
                              PyObject *args, PyObject *kwds);

static PyMethodDef j_dbdirectory_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DbDirectory, j_dbdirectory, Directory,
             org::apache::lucene::store::db::DbDirectory, j_dbdirectory_init);

#endif

/* RAMDirectory */

class j_ramdirectory {
public:
    PyObject_HEAD
    org::apache::lucene::store::RAMDirectory *object;
};

static int j_ramdirectory_init(j_ramdirectory *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_ramdirectory_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RAMDirectory, j_ramdirectory, Directory,
             org::apache::lucene::store::RAMDirectory, j_ramdirectory_init);

/* RAMOutputStream */

class j_ramoutputstream {
public:
    PyObject_HEAD
    org::apache::lucene::store::RAMOutputStream *object;
};

static int j_ramoutputstream_init(j_ramoutputstream *self,
                                  PyObject *args, PyObject *kwds);
static PyObject *j_ramoutputstream_reset(j_ramoutputstream *self);
static PyObject *j_ramoutputstream_writeTo(j_ramoutputstream *self,
                                           PyObject *arg);

static PyMethodDef j_ramoutputstream_methods[] = {
    DECLARE_METHOD(j_ramoutputstream, reset, METH_NOARGS),
    DECLARE_METHOD(j_ramoutputstream, writeTo, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RAMOutputStream, j_ramoutputstream, BufferedIndexOutput,
             org::apache::lucene::store::RAMOutputStream,
             j_ramoutputstream_init);

/* Token */

class j_token {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::Token *object;
};

static int j_token_init(j_token *self, PyObject *args, PyObject *kwds);
static PyObject *j_token_startOffset(j_token *self);
static PyObject *j_token_endOffset(j_token *self);
static PyObject *j_token_getPositionIncrement(j_token *self);
static PyObject *j_token_setPositionIncrement(j_token *self, PyObject *arg);
static PyObject *j_token_termText(j_token *self);
static PyObject *j_token_type(j_token *self);

static PyMethodDef j_token_methods[] = {
    DECLARE_METHOD(j_token, startOffset, METH_NOARGS),
    DECLARE_METHOD(j_token, endOffset, METH_NOARGS),
    DECLARE_METHOD(j_token, getPositionIncrement, METH_NOARGS),
    DECLARE_METHOD(j_token, setPositionIncrement, METH_O),
    DECLARE_METHOD(j_token, termText, METH_NOARGS),
    DECLARE_METHOD(j_token, type, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Token, j_token, Object, org::apache::lucene::analysis::Token,
             j_token_init);

/* TokenStream */

class j_tokenstream {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::TokenStream *object;
};

static int j_tokenstream_init(j_tokenstream *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_tokenstream_close(j_tokenstream *self);
static PyObject *j_tokenstream_next(j_tokenstream *self);
static PyObject *j_tokenstream_charTokenizer(j_tokenstream *self,
                                             PyObject *args);
static PyObject *j_tokenstream_tokenFilter(j_tokenstream *self,
                                           PyObject *arg);

static PyMethodDef j_tokenstream_methods[] = {
    DECLARE_METHOD(j_tokenstream, close, METH_NOARGS),
    DECLARE_METHOD(j_tokenstream, next, METH_NOARGS),
    DECLARE_METHOD(j_tokenstream, next, METH_NOARGS),
    DECLARE_METHOD(j_tokenstream, charTokenizer, METH_VARARGS),
    DECLARE_METHOD(j_tokenstream, tokenFilter, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TokenStream, j_tokenstream, Object,
             org::apache::lucene::analysis::TokenStream, j_tokenstream_init);

static int check_TokenStream(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "next");
}

static org::apache::lucene::analysis::TokenStream *make_TokenStream(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::analysis::TokenStream *)
        new org::osafoundation::analysis::PythonTokenStream(ptr);
}

static PyObject *j_tokenstream_iter(j_tokenstream *self);

/* TokenEnumeration */

class j_tokenenumeration {
public:
    PyObject_HEAD
    org::osafoundation::util::TokenEnumeration *object;
};

static PyObject *j_tokenenumeration_nextElement(j_tokenenumeration *self);
#define j_tokenenumeration_next j_tokenenumeration_nextElement

static PyMethodDef j_tokenenumeration_methods[] = {
    DECLARE_METHOD(j_tokenenumeration, nextElement, METH_NOARGS),
    DECLARE_METHOD(j_tokenenumeration, next, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TokenEnumeration, j_tokenenumeration, Enumeration,
             org::osafoundation::util::TokenEnumeration, abstract_init);

/* TokenFilter */

class j_tokenfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::TokenFilter *object;
};

static int j_tokenfilter_init(j_tokenfilter *self,
                              PyObject *args, PyObject *kwds);

static PyMethodDef j_tokenfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TokenFilter, j_tokenfilter, TokenStream,
             org::apache::lucene::analysis::TokenFilter, abstract_init);

static int check_TokenFilter(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "next");
}

/* Tokenizer */

class j_tokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::Tokenizer *object;
};

static PyMethodDef j_tokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Tokenizer, j_tokenizer, TokenStream,
             org::apache::lucene::analysis::Tokenizer, abstract_init);

/* CharTokenizer */

class j_chartokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::CharTokenizer *object;
};

static PyMethodDef j_chartokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(CharTokenizer, j_chartokenizer, Tokenizer,
             org::apache::lucene::analysis::CharTokenizer, abstract_init);

static int check_CharTokenizer(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "isTokenChar");
}

/* Analyzer */

class j_analyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::Analyzer *object;
};

static int j_analyzer_init(j_analyzer *self, PyObject *args, PyObject *kwds);
static PyObject *j_analyzer_tokenStream(j_analyzer *self, PyObject *args);
static PyObject *j_analyzer_getPositionIncrementGap(j_analyzer *self,
                                                    PyObject *arg);
DECLARE_DOWNCAST(j_analyzer, GermanAnalyzer);
DECLARE_DOWNCAST(j_analyzer, PerFieldAnalyzerWrapper);
DECLARE_DOWNCAST(j_analyzer, RussianAnalyzer);
DECLARE_DOWNCAST(j_analyzer, SimpleAnalyzer);
DECLARE_DOWNCAST(j_analyzer, StandardAnalyzer);
DECLARE_DOWNCAST(j_analyzer, StopAnalyzer);
DECLARE_DOWNCAST(j_analyzer, WhitespaceAnalyzer);
static PyObject *j_analyzer_queryParser(j_analyzer *self, PyObject *args);
static PyObject *j_analyzer_multiFieldQueryParser(j_analyzer *self,
                                                  PyObject *args);

static PyMethodDef j_analyzer_methods[] = {
    DECLARE_METHOD(j_analyzer, tokenStream, METH_VARARGS),
    DECLARE_METHOD(j_analyzer, getPositionIncrementGap, METH_O),
    DECLARE_DOWNCAST_METHODS(j_analyzer, GermanAnalyzer),
    DECLARE_DOWNCAST_METHODS(j_analyzer, PerFieldAnalyzerWrapper),
    DECLARE_DOWNCAST_METHODS(j_analyzer, RussianAnalyzer),
    DECLARE_DOWNCAST_METHODS(j_analyzer, SimpleAnalyzer),
    DECLARE_DOWNCAST_METHODS(j_analyzer, StandardAnalyzer),
    DECLARE_DOWNCAST_METHODS(j_analyzer, StopAnalyzer),
    DECLARE_DOWNCAST_METHODS(j_analyzer, WhitespaceAnalyzer),
    DECLARE_METHOD(j_analyzer, queryParser, METH_VARARGS),
    DECLARE_METHOD(j_analyzer, multiFieldQueryParser, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Analyzer, j_analyzer, Object,
             org::apache::lucene::analysis::Analyzer, j_analyzer_init);

static int check_Analyzer(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "tokenStream");
}

static org::apache::lucene::analysis::Analyzer *make_Analyzer(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::analysis::Analyzer *)
        new org::osafoundation::analysis::PythonAnalyzer(ptr);
}

/* LetterTokenizer */

class j_lettertokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::LetterTokenizer *object;
};

static int j_lettertokenizer_init(j_lettertokenizer *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_lettertokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(LetterTokenizer, j_lettertokenizer, CharTokenizer,
             org::apache::lucene::analysis::LetterTokenizer,
             j_lettertokenizer_init);

/* LowerCaseTokenizer */

class j_lowercasetokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::LowerCaseTokenizer *object;
};

static int j_lowercasetokenizer_init(j_lowercasetokenizer *self,
                                     PyObject *args, PyObject *kwds);

static PyMethodDef j_lowercasetokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(LowerCaseTokenizer, j_lowercasetokenizer, LetterTokenizer,
             org::apache::lucene::analysis::LowerCaseTokenizer,
             j_lowercasetokenizer_init);

/* LowerCaseFilter */

class j_lowercasefilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::LowerCaseFilter *object;
};

static int j_lowercasefilter_init(j_lowercasefilter *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_lowercasefilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(LowerCaseFilter, j_lowercasefilter, TokenFilter,
             org::apache::lucene::analysis::LowerCaseFilter,
             j_lowercasefilter_init);

/* ISOLatin1AccentFilter */

class j_isolatin1accentfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ISOLatin1AccentFilter *object;
};

static int j_isolatin1accentfilter_init(j_isolatin1accentfilter *self,
                                        PyObject *args, PyObject *kwds);
static PyObject *j_isolatin1accentfilter_removeAccents(PyTypeObject *type,
                                                       PyObject *arg);

static PyMethodDef j_isolatin1accentfilter_methods[] = {
    DECLARE_METHOD(j_isolatin1accentfilter, removeAccents, METH_O | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ISOLatin1AccentFilter, j_isolatin1accentfilter, TokenFilter,
             org::apache::lucene::analysis::ISOLatin1AccentFilter,
             j_isolatin1accentfilter_init);

/* KeywordAnalyzer */

class j_keywordanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::KeywordAnalyzer *object;
};

static int j_keywordanalyzer_init(j_keywordanalyzer *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_keywordanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(KeywordAnalyzer, j_keywordanalyzer, Analyzer,
             org::apache::lucene::analysis::KeywordAnalyzer,
             j_keywordanalyzer_init);

/* KeywordTokenizer */

class j_keywordtokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::KeywordTokenizer *object;
};

static int j_keywordtokenizer_init(j_keywordtokenizer *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_keywordtokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(KeywordTokenizer, j_keywordtokenizer, Tokenizer,
             org::apache::lucene::analysis::KeywordTokenizer,
             j_keywordtokenizer_init);

/* LengthFilter */

class j_lengthfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::LengthFilter *object;
};

static int j_lengthfilter_init(j_lengthfilter *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_lengthfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(LengthFilter, j_lengthfilter, TokenFilter,
             org::apache::lucene::analysis::LengthFilter,
             j_lengthfilter_init);

/* PorterStemFilter */

class j_porterstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::PorterStemFilter *object;
};

static int j_porterstemfilter_init(j_porterstemfilter *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_porterstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PorterStemFilter, j_porterstemfilter, TokenFilter,
             org::apache::lucene::analysis::PorterStemFilter,
             j_porterstemfilter_init);

/* StopFilter */

class j_stopfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::StopFilter *object;
};

static int j_stopfilter_init(j_stopfilter *self,
                             PyObject *args, PyObject *kwds);

static PyMethodDef j_stopfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(StopFilter, j_stopfilter, TokenFilter,
             org::apache::lucene::analysis::StopFilter,
             j_stopfilter_init);

/* SimpleAnalyzer */

class j_simpleanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::SimpleAnalyzer *object;
};

static int j_simpleanalyzer_init(j_simpleanalyzer *self,
                                 PyObject *args, PyObject *kwds);

static PyMethodDef j_simpleanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SimpleAnalyzer, j_simpleanalyzer, Analyzer,
             org::apache::lucene::analysis::SimpleAnalyzer,
             j_simpleanalyzer_init);

/* StopAnalyzer */

class j_stopanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::StopAnalyzer *object;
};

static int j_stopanalyzer_init(j_stopanalyzer *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_stopanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(StopAnalyzer, j_stopanalyzer, Analyzer,
             org::apache::lucene::analysis::StopAnalyzer,
             j_stopanalyzer_init);

/* WhitespaceAnalyzer */

class j_whitespaceanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::WhitespaceAnalyzer *object;
};

static int j_whitespaceanalyzer_init(j_whitespaceanalyzer *self,
                                     PyObject *args, PyObject *kwds);

static PyMethodDef j_whitespaceanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(WhitespaceAnalyzer, j_whitespaceanalyzer, Analyzer,
             org::apache::lucene::analysis::WhitespaceAnalyzer,
             j_whitespaceanalyzer_init);

/* WhitespaceTokenizer */

class j_whitespacetokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::WhitespaceTokenizer *object;
};

static int j_whitespacetokenizer_init(j_whitespacetokenizer *self,
                                      PyObject *args, PyObject *kwds);

static PyMethodDef j_whitespacetokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(WhitespaceTokenizer, j_whitespacetokenizer, Tokenizer,
             org::apache::lucene::analysis::WhitespaceTokenizer,
             j_whitespacetokenizer_init);

/* PerFieldAnalyzerWrapper */

class j_perfieldanalyzerwrapper {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::PerFieldAnalyzerWrapper *object;
};

static int j_perfieldanalyzerwrapper_init(j_perfieldanalyzerwrapper *self,
                                          PyObject *args, PyObject *kwds);
static PyObject *j_perfieldanalyzerwrapper_addAnalyzer(j_perfieldanalyzerwrapper *self, PyObject *args);

static PyMethodDef j_perfieldanalyzerwrapper_methods[] = {
    DECLARE_METHOD(j_perfieldanalyzerwrapper, addAnalyzer, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PerFieldAnalyzerWrapper, j_perfieldanalyzerwrapper, Analyzer,
             org::apache::lucene::analysis::PerFieldAnalyzerWrapper,
             j_perfieldanalyzerwrapper_init);

/* StandardAnalyzer */

class j_standardanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::standard::StandardAnalyzer *object;
};

static int j_standardanalyzer_init(j_standardanalyzer *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_standardanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(StandardAnalyzer, j_standardanalyzer, Analyzer,
             org::apache::lucene::analysis::standard::StandardAnalyzer,
             j_standardanalyzer_init);

/* StandardFilter */

class j_standardfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::standard::StandardFilter *object;
};

static int j_standardfilter_init(j_standardfilter *self,
                                 PyObject *args, PyObject *kwds);

static PyMethodDef j_standardfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(StandardFilter, j_standardfilter, TokenFilter,
             org::apache::lucene::analysis::standard::StandardFilter,
             j_standardfilter_init);

/* StandardTokenizer */

class j_standardtokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::standard::StandardTokenizer *object;
};

static int j_standardtokenizer_init(j_standardtokenizer *self,
                                    PyObject *args, PyObject *kwds);

static PyMethodDef j_standardtokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(StandardTokenizer, j_standardtokenizer, Tokenizer,
             org::apache::lucene::analysis::standard::StandardTokenizer,
             j_standardtokenizer_init);

/* BrazilianAnalyzer */

class j_braziliananalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::br::BrazilianAnalyzer *object;
};

static int j_braziliananalyzer_init(j_braziliananalyzer *self,
                                    PyObject *args, PyObject *kwds);
static PyObject *j_braziliananalyzer_setStemExclusionTable(j_braziliananalyzer *self, PyObject *arg);

static PyMethodDef j_braziliananalyzer_methods[] = {
    DECLARE_METHOD(j_braziliananalyzer, setStemExclusionTable, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BrazilianAnalyzer, j_braziliananalyzer, Analyzer,
             org::apache::lucene::analysis::br::BrazilianAnalyzer,
             j_braziliananalyzer_init);

/* BrazilianStemmer */

class j_brazilianstemmer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::br::BrazilianStemmer *object;
};

static int j_brazilianstemmer_init(j_brazilianstemmer *self,
                                   PyObject *args, PyObject *kwds);
static PyObject *j_brazilianstemmer_stem(j_brazilianstemmer *self,
                                         PyObject *arg);

static PyMethodDef j_brazilianstemmer_methods[] = {
    DECLARE_METHOD(j_brazilianstemmer, stem, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BrazilianStemmer, j_brazilianstemmer, Object,
             org::apache::lucene::analysis::br::BrazilianStemmer,
             j_brazilianstemmer_init);

/* BrazilianStemFilter */

class j_brazilianstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::br::BrazilianStemFilter *object;
};

static int j_brazilianstemfilter_init(j_brazilianstemfilter *self,
                                      PyObject *args, PyObject *kwds);

static PyMethodDef j_brazilianstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BrazilianStemFilter, j_brazilianstemfilter, TokenFilter,
             org::apache::lucene::analysis::br::BrazilianStemFilter,
             j_brazilianstemfilter_init);

/* CJKAnalyzer */

class j_cjkanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cjk::CJKAnalyzer *object;
};

static int j_cjkanalyzer_init(j_cjkanalyzer *self,
                              PyObject *args, PyObject *kwds);

static PyMethodDef j_cjkanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(CJKAnalyzer, j_cjkanalyzer, Analyzer,
             org::apache::lucene::analysis::cjk::CJKAnalyzer,
             j_cjkanalyzer_init);

/* CJKTokenizer */

class j_cjktokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cjk::CJKTokenizer *object;
};

static int j_cjktokenizer_init(j_cjktokenizer *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_cjktokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(CJKTokenizer, j_cjktokenizer, Tokenizer,
             org::apache::lucene::analysis::cjk::CJKTokenizer,
             j_cjktokenizer_init);

/* ChineseAnalyzer */

class j_chineseanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cn::ChineseAnalyzer *object;
};

static int j_chineseanalyzer_init(j_chineseanalyzer *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_chineseanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ChineseAnalyzer, j_chineseanalyzer, Analyzer,
             org::apache::lucene::analysis::cn::ChineseAnalyzer,
             j_chineseanalyzer_init);

/* ChineseFilter */

class j_chinesefilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cn::ChineseFilter *object;
};

static int j_chinesefilter_init(j_chinesefilter *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_chinesefilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ChineseFilter, j_chinesefilter, TokenFilter,
             org::apache::lucene::analysis::cn::ChineseFilter,
             j_chinesefilter_init);

/* ChineseTokenizer */

class j_chinesetokenizer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cn::ChineseTokenizer *object;
};

static int j_chinesetokenizer_init(j_chinesetokenizer *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_chinesetokenizer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ChineseTokenizer, j_chinesetokenizer, Tokenizer,
             org::apache::lucene::analysis::cn::ChineseTokenizer,
             j_chinesetokenizer_init);

/* CzechAnalyzer */

class j_czechanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::cz::CzechAnalyzer *object;
};

static int j_czechanalyzer_init(j_czechanalyzer *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_czechanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(CzechAnalyzer, j_czechanalyzer, Analyzer,
             org::apache::lucene::analysis::cz::CzechAnalyzer,
             j_czechanalyzer_init);

/* GermanAnalyzer */

class j_germananalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::de::GermanAnalyzer *object;
};

static int j_germananalyzer_init(j_germananalyzer *self,
                                 PyObject *args, PyObject *kwds);
static PyObject *j_germananalyzer_setStemExclusionTable(j_germananalyzer *self, PyObject *arg);

static PyMethodDef j_germananalyzer_methods[] = {
    DECLARE_METHOD(j_germananalyzer, setStemExclusionTable, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GermanAnalyzer, j_germananalyzer, Analyzer,
             org::apache::lucene::analysis::de::GermanAnalyzer,
             j_germananalyzer_init);

/* GermanStemmer */

class j_germanstemmer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::de::GermanStemmer *object;
};

static int j_germanstemmer_init(j_germanstemmer *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_germanstemmer_stem(j_germanstemmer *self, PyObject *arg);

static PyMethodDef j_germanstemmer_methods[] = {
    DECLARE_METHOD(j_germanstemmer, stem, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GermanStemmer, j_germanstemmer, Object,
             org::apache::lucene::analysis::de::GermanStemmer,
             j_germanstemmer_init);

/* GermanStemFilter */

class j_germanstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::de::GermanStemFilter *object;
};

static int j_germanstemfilter_init(j_germanstemfilter *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_germanstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GermanStemFilter, j_germanstemfilter, TokenFilter,
             org::apache::lucene::analysis::de::GermanStemFilter,
             j_germanstemfilter_init);

/* GreekAnalyzer */

class j_greekanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::el::GreekAnalyzer *object;
};

static int j_greekanalyzer_init(j_greekanalyzer *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_greekanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GreekAnalyzer, j_greekanalyzer, Analyzer,
             org::apache::lucene::analysis::el::GreekAnalyzer,
             j_greekanalyzer_init);

/* GreekLowerCaseFilter */

class j_greeklowercasefilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::el::GreekLowerCaseFilter *object;
};

static int j_greeklowercasefilter_init(j_greeklowercasefilter *self,
                                       PyObject *args, PyObject *kwds);

static PyMethodDef j_greeklowercasefilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GreekLowerCaseFilter, j_greeklowercasefilter, TokenFilter,
             org::apache::lucene::analysis::el::GreekLowerCaseFilter,
             j_greeklowercasefilter_init);

/* GreekCharsets */

class j_greekcharsets {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::el::GreekCharsets *object;
};

static PyObject *j_greekcharsets_toLowerCase(PyTypeObject *type,
                                             PyObject *args);

static PyMethodDef j_greekcharsets_methods[] = {
    DECLARE_METHOD(j_greekcharsets, toLowerCase, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GreekCharsets, j_greekcharsets, Object,
             org::apache::lucene::analysis::el::GreekCharsets, abstract_init);

/* FrenchAnalyzer */

class j_frenchanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::fr::FrenchAnalyzer *object;
};

static int j_frenchanalyzer_init(j_frenchanalyzer *self,
                                 PyObject *args, PyObject *kwds);
static PyObject *j_frenchanalyzer_setStemExclusionTable(j_frenchanalyzer *self, PyObject *arg);

static PyMethodDef j_frenchanalyzer_methods[] = {
    DECLARE_METHOD(j_frenchanalyzer, setStemExclusionTable, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FrenchAnalyzer, j_frenchanalyzer, Analyzer,
             org::apache::lucene::analysis::fr::FrenchAnalyzer,
             j_frenchanalyzer_init);

/* FrenchStemmer */

class j_frenchstemmer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::fr::FrenchStemmer *object;
};

static int j_frenchstemmer_init(j_frenchstemmer *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_frenchstemmer_stem(j_frenchstemmer *self, PyObject *arg);

static PyMethodDef j_frenchstemmer_methods[] = {
    DECLARE_METHOD(j_frenchstemmer, stem, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FrenchStemmer, j_frenchstemmer, Object,
             org::apache::lucene::analysis::fr::FrenchStemmer,
             j_frenchstemmer_init);

/* FrenchStemFilter */

class j_frenchstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::fr::FrenchStemFilter *object;
};

static int j_frenchstemfilter_init(j_frenchstemfilter *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_frenchstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FrenchStemFilter, j_frenchstemfilter, TokenFilter,
             org::apache::lucene::analysis::fr::FrenchStemFilter,
             j_frenchstemfilter_init);

/* DutchAnalyzer */

class j_dutchanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::nl::DutchAnalyzer *object;
};

static int j_dutchanalyzer_init(j_dutchanalyzer *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_dutchanalyzer_setStemExclusionTable(j_dutchanalyzer *self, PyObject *arg);

static PyMethodDef j_dutchanalyzer_methods[] = {
    DECLARE_METHOD(j_dutchanalyzer, setStemExclusionTable, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DutchAnalyzer, j_dutchanalyzer, Analyzer,
             org::apache::lucene::analysis::nl::DutchAnalyzer,
             j_dutchanalyzer_init);

/* DutchStemmer */

class j_dutchstemmer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::nl::DutchStemmer *object;
};

static int j_dutchstemmer_init(j_dutchstemmer *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_dutchstemmer_stem(j_dutchstemmer *self, PyObject *arg);

static PyMethodDef j_dutchstemmer_methods[] = {
    DECLARE_METHOD(j_dutchstemmer, stem, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DutchStemmer, j_dutchstemmer, Object,
             org::apache::lucene::analysis::nl::DutchStemmer,
             j_dutchstemmer_init);

/* DutchStemFilter */

class j_dutchstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::nl::DutchStemFilter *object;
};

static int j_dutchstemfilter_init(j_dutchstemfilter *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_dutchstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DutchStemFilter, j_dutchstemfilter, TokenFilter,
             org::apache::lucene::analysis::nl::DutchStemFilter,
             j_dutchstemfilter_init);

/* RussianAnalyzer */

class j_russiananalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ru::RussianAnalyzer *object;
};

static int j_russiananalyzer_init(j_russiananalyzer *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_russiananalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RussianAnalyzer, j_russiananalyzer, Analyzer,
             org::apache::lucene::analysis::ru::RussianAnalyzer,
             j_russiananalyzer_init);

/* RussianStemmer */

class j_russianstemmer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ru::RussianStemmer *object;
};

static int j_russianstemmer_init(j_russianstemmer *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_russianstemmer_stem(j_russianstemmer *self, PyObject *arg);

static PyMethodDef j_russianstemmer_methods[] = {
    DECLARE_METHOD(j_russianstemmer, stem, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RussianStemmer, j_russianstemmer, Object,
             org::apache::lucene::analysis::ru::RussianStemmer,
             j_russianstemmer_init);

/* RussianStemFilter */

class j_russianstemfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ru::RussianStemFilter *object;
};

static int j_russianstemfilter_init(j_russianstemfilter *self,
                                  PyObject *args, PyObject *kwds);

static PyMethodDef j_russianstemfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RussianStemFilter, j_russianstemfilter, TokenFilter,
             org::apache::lucene::analysis::ru::RussianStemFilter,
             j_russianstemfilter_init);

/* RussianLowerCaseFilter */

class j_russianlowercasefilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ru::RussianLowerCaseFilter *object;
};

static int j_russianlowercasefilter_init(j_russianlowercasefilter *self,
                                         PyObject *args, PyObject *kwds);

static PyMethodDef j_russianlowercasefilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RussianLowerCaseFilter, j_russianlowercasefilter, TokenFilter,
             org::apache::lucene::analysis::ru::RussianLowerCaseFilter,
             j_russianlowercasefilter_init);

/* RussianCharsets */

class j_russiancharsets {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::ru::RussianCharsets *object;
};

static PyObject *j_russiancharsets_toLowerCase(PyTypeObject *type,
                                               PyObject *args);

static PyMethodDef j_russiancharsets_methods[] = {
    DECLARE_METHOD(j_russiancharsets, toLowerCase, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RussianCharsets, j_russiancharsets, Object,
             org::apache::lucene::analysis::ru::RussianCharsets, abstract_init);

/* SnowballAnalyzer */

class j_snowballanalyzer {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::snowball::SnowballAnalyzer *object;
};

static int j_snowballanalyzer_init(j_snowballanalyzer *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_snowballanalyzer_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SnowballAnalyzer, j_snowballanalyzer, Analyzer,
             org::apache::lucene::analysis::snowball::SnowballAnalyzer,
             j_snowballanalyzer_init);

/* SnowballFilter */

class j_snowballfilter {
public:
    PyObject_HEAD
    org::apache::lucene::analysis::snowball::SnowballFilter *object;
};

static int j_snowballfilter_init(j_snowballfilter *self,
                                 PyObject *args, PyObject *kwds);

static PyMethodDef j_snowballfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SnowballFilter, j_snowballfilter, TokenFilter,
             org::apache::lucene::analysis::snowball::SnowballFilter,
             j_snowballfilter_init);

/* Parameter */

class j_parameter {
public:
    PyObject_HEAD
    org::apache::lucene::util::Parameter *object;
};

static PyMethodDef j_parameter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Parameter, j_parameter, Object,
             org::apache::lucene::util::Parameter, abstract_init);

/* Field.Store */

class j_field_store {
public:
    PyObject_HEAD
    org::apache::lucene::document::Field$Store *object;
};

static PyMethodDef j_field_store_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Field_Store, j_field_store, Parameter,
             org::apache::lucene::document::Field$Store, abstract_init);

/* Field.Index */

class j_field_index {
public:
    PyObject_HEAD
    org::apache::lucene::document::Field$Index *object;
};

static PyMethodDef j_field_index_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Field_Index, j_field_index, Parameter,
             org::apache::lucene::document::Field$Index, abstract_init);

/* Field.TermVector */

class j_field_termvector {
public:
    PyObject_HEAD
    org::apache::lucene::document::Field$TermVector *object;
};

static PyMethodDef j_field_termvector_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Field_TermVector, j_field_termvector, Parameter,
             org::apache::lucene::document::Field$TermVector, abstract_init);

/* Field */

class j_field {
public:
    PyObject_HEAD
    org::apache::lucene::document::Field *object;
};

static int j_field_init(j_field *self, PyObject *args, PyObject *kwds);
static PyObject *j_field_isIndexed(j_field *self);
static PyObject *j_field_isStored(j_field *self);
static PyObject *j_field_isTokenized(j_field *self);
static PyObject *j_field_isCompressed(j_field *self);
static PyObject *j_field_isBinary(j_field *self);
static PyObject *j_field_isTermVectorStored(j_field *self);
static PyObject *j_field_isStoreOffsetWithTermVector(j_field *self);
static PyObject *j_field_isStorePositionWithTermVector(j_field *self);
static PyObject *j_field_name(j_field *self);
static PyObject *j_field_stringValue(j_field *self);
static PyObject *j_field_readerValue(j_field *self);
static PyObject *j_field_binaryValue(j_field *self);
static PyObject *j_field_getBoost(j_field *self);
static PyObject *j_field_setBoost(j_field *self, PyObject *arg);
static PyObject *j_field_getOmitNorms(j_field *self);
static PyObject *j_field_setOmitNorms(j_field *self, PyObject *arg);

static PyMethodDef j_field_methods[] = {
    DECLARE_METHOD(j_field, isIndexed, METH_NOARGS),
    DECLARE_METHOD(j_field, isStored, METH_NOARGS),
    DECLARE_METHOD(j_field, isTokenized, METH_NOARGS),
    DECLARE_METHOD(j_field, isCompressed, METH_NOARGS),
    DECLARE_METHOD(j_field, isBinary, METH_NOARGS),
    DECLARE_METHOD(j_field, isTermVectorStored, METH_NOARGS),
    DECLARE_METHOD(j_field, isStoreOffsetWithTermVector, METH_NOARGS),
    DECLARE_METHOD(j_field, isStorePositionWithTermVector, METH_NOARGS),
    DECLARE_METHOD(j_field, name, METH_NOARGS),
    DECLARE_METHOD(j_field, stringValue, METH_NOARGS),
    DECLARE_METHOD(j_field, readerValue, METH_NOARGS),
    DECLARE_METHOD(j_field, binaryValue, METH_NOARGS),
    DECLARE_METHOD(j_field, getBoost, METH_NOARGS),
    DECLARE_METHOD(j_field, setBoost, METH_O),
    DECLARE_METHOD(j_field, getOmitNorms, METH_NOARGS),
    DECLARE_METHOD(j_field, setOmitNorms, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Field, j_field, Object,
             org::apache::lucene::document::Field, j_field_init);

/* DateField */

class j_datefield {
public:
    PyObject_HEAD
    org::apache::lucene::document::DateField *object;
};

static PyObject *j_datefield_dateToString(PyTypeObject *type, PyObject *arg);
static PyObject *j_datefield_stringToDate(PyTypeObject *type, PyObject *arg);
static PyObject *j_datefield_MAX_DATE_STRING(PyTypeObject *type);
static PyObject *j_datefield_MIN_DATE_STRING(PyTypeObject *type);
static PyObject *j_datefield_timeToString(PyTypeObject *type, PyObject *arg);
static PyObject *j_datefield_stringToTime(PyTypeObject *type, PyObject *arg);

static PyMethodDef j_datefield_methods[] = {
    DECLARE_METHOD(j_datefield, dateToString, METH_O | METH_CLASS),
    DECLARE_METHOD(j_datefield, stringToDate, METH_O | METH_CLASS),
    DECLARE_METHOD(j_datefield, MAX_DATE_STRING, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_datefield, MIN_DATE_STRING, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_datefield, stringToTime, METH_O | METH_CLASS),
    DECLARE_METHOD(j_datefield, timeToString, METH_O | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DateField, j_datefield, Object,
             org::apache::lucene::document::DateField, abstract_init);

/* DateTools_Resolution */

class j_datetools_resolution {
public:
    PyObject_HEAD
    org::apache::lucene::document::DateTools$Resolution *object;
};

static PyMethodDef j_datetools_resolution_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DateTools_Resolution, j_datetools_resolution, Parameter,
             org::apache::lucene::document::DateTools$Resolution,
             abstract_init);

/* DateTools */

class j_datetools {
public:
    PyObject_HEAD
    org::apache::lucene::document::DateTools *object;
};

static PyObject *j_datetools_dateToString(PyTypeObject *type, PyObject *args);
static PyObject *j_datetools_stringToDate(PyTypeObject *type, PyObject *arg);
static PyObject *j_datetools_timeToString(PyTypeObject *type, PyObject *args);
static PyObject *j_datetools_stringToTime(PyTypeObject *type, PyObject *arg);
static PyObject *j_datetools_round(PyTypeObject *type, PyObject *args);

static PyMethodDef j_datetools_methods[] = {
    DECLARE_METHOD(j_datetools, dateToString, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_datetools, stringToDate, METH_O | METH_CLASS),
    DECLARE_METHOD(j_datetools, stringToTime, METH_O | METH_CLASS),
    DECLARE_METHOD(j_datetools, timeToString, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_datetools, round, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DateTools, j_datetools, Object,
             org::apache::lucene::document::DateTools, abstract_init);

/* NumberTools */

class j_numbertools {
public:
    PyObject_HEAD
    org::apache::lucene::document::NumberTools *object;
};

static PyObject *j_numbertools_longToString(PyTypeObject *type, PyObject *arg);
static PyObject *j_numbertools_stringToLong(PyTypeObject *type, PyObject *arg);

static PyMethodDef j_numbertools_methods[] = {
    DECLARE_METHOD(j_numbertools, longToString, METH_O | METH_CLASS),
    DECLARE_METHOD(j_numbertools, stringToLong, METH_O | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(NumberTools, j_numbertools, Object,
             org::apache::lucene::document::NumberTools, abstract_init);

/* FieldEnumeration */

class j_fieldenumeration {
public:
    PyObject_HEAD
    java::util::Enumeration *object;
};

static PyObject *j_fieldenumeration_nextElement(j_fieldenumeration *self);
#define j_fieldenumeration_next j_fieldenumeration_nextElement

static PyMethodDef j_fieldenumeration_methods[] = {
    DECLARE_METHOD(j_fieldenumeration, nextElement, METH_NOARGS),
    DECLARE_METHOD(j_fieldenumeration, next, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FieldEnumeration, j_fieldenumeration, Enumeration,
             java::util::Enumeration, abstract_init);

/* Document */

class j_document {
public:
    PyObject_HEAD
    org::apache::lucene::document::Document *object;
};

static int j_document_init(j_document *self, PyObject *args, PyObject *kwds);
static PyObject *j_document_add(j_document *self, PyObject *arg);
static PyObject *j_document_get(j_document *self, PyObject *arg);
static PyObject *j_document_getField(j_document *self, PyObject *arg);
static PyObject *j_document_getFields(j_document *self, PyObject *arg);
static PyObject *j_document_getValues(j_document *self, PyObject *arg);
static PyObject *j_document_getBinaryValue(j_document *self, PyObject *arg);
static PyObject *j_document_getBinaryValues(j_document *self, PyObject *arg);
static PyObject *j_document_fields(j_document *self);
static PyObject *j_document_getBoost(j_document *self);
static PyObject *j_document_setBoost(j_document *self, PyObject *arg);
static PyObject *j_document_removeField(j_document *self, PyObject *arg);
static PyObject *j_document_removeFields(j_document *self, PyObject *arg);
static PyObject *j_document___getattr__(j_document *self, PyObject *arg);
static PyObject *j_document___delattr__(j_document *self, PyObject *arg);

static PyMethodDef j_document_methods[] = {
    DECLARE_METHOD(j_document, add, METH_O),
    DECLARE_METHOD(j_document, get, METH_O),
    DECLARE_METHOD(j_document, getField, METH_O),
    DECLARE_METHOD(j_document, getFields, METH_O),
    DECLARE_METHOD(j_document, getValues, METH_O),
    DECLARE_METHOD(j_document, getBinaryValue, METH_O),
    DECLARE_METHOD(j_document, getBinaryValues, METH_O),
    DECLARE_METHOD(j_document, fields, METH_NOARGS),
    DECLARE_METHOD(j_document, getBoost, METH_NOARGS),
    DECLARE_METHOD(j_document, setBoost, METH_O),
    DECLARE_METHOD(j_document, removeField, METH_O),
    DECLARE_METHOD(j_document, removeFields, METH_O),
    DECLARE_METHOD(j_document, __getattr__, METH_O),
    DECLARE_METHOD(j_document, __delattr__, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Document, j_document, Object,
             org::apache::lucene::document::Document, j_document_init);

static int j_document_dict_length(j_document *self);
static PyObject *j_document_dict_get(j_document *self, PyObject *key);

static PyMappingMethods j_document_as_mapping = {
    (inquiry) j_document_dict_length,
    (binaryfunc) j_document_dict_get,
    (objobjargproc) NULL
};

/* IndexWriter */

class j_indexwriter {
public:
    PyObject_HEAD
    org::apache::lucene::index::IndexWriter *object;
};

static int j_indexwriter_init(j_indexwriter *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_indexwriter_close(j_indexwriter *self);
static PyObject *j_indexwriter_docCount(j_indexwriter *self);
static PyObject *j_indexwriter_getAnalyzer(j_indexwriter *self);
static PyObject *j_indexwriter_getDirectory(j_indexwriter *self);
static PyObject *j_indexwriter_getUseCompoundFile(j_indexwriter *self);
static PyObject *j_indexwriter_setUseCompoundFile(j_indexwriter *self,
                                                  PyObject *arg);
static PyObject *j_indexwriter_getMaxFieldLength(j_indexwriter *self);
static PyObject *j_indexwriter_setMaxFieldLength(j_indexwriter *self,
                                                 PyObject *arg);
static PyObject *j_indexwriter_getMaxMergeDocs(j_indexwriter *self);
static PyObject *j_indexwriter_setMaxMergeDocs(j_indexwriter *self,
                                               PyObject *arg);
static PyObject *j_indexwriter_getMaxBufferedDocs(j_indexwriter *self);
static PyObject *j_indexwriter_setMaxBufferedDocs(j_indexwriter *self,
                                                  PyObject *arg);
static PyObject *j_indexwriter_getMergeFactor(j_indexwriter *self);
static PyObject *j_indexwriter_setMergeFactor(j_indexwriter *self,
                                              PyObject *arg);
static PyObject *j_indexwriter_getInfoStream(j_indexwriter *self);
static PyObject *j_indexwriter_setInfoStream(j_indexwriter *self,
                                             PyObject *arg);
static PyObject *j_indexwriter_getSimilarity(j_indexwriter *self);
static PyObject *j_indexwriter_setSimilarity(j_indexwriter *self,
                                             PyObject *arg);
static PyObject *j_indexwriter_getTermIndexInterval(j_indexwriter *self);
static PyObject *j_indexwriter_setTermIndexInterval(j_indexwriter *self,
                                                    PyObject *arg);
static PyObject *j_indexwriter_getWriteLockTimeout(j_indexwriter *self);
static PyObject *j_indexwriter_setWriteLockTimeout(j_indexwriter *self,
                                                   PyObject *arg);
static PyObject *j_indexwriter_optimize(j_indexwriter *self);
static PyObject *j_indexwriter_addIndexes(j_indexwriter *self, PyObject *arg);
static PyObject *j_indexwriter_addDocument(j_indexwriter *self, PyObject *args);

static PyMethodDef j_indexwriter_methods[] = {
    DECLARE_METHOD(j_indexwriter, close, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, docCount, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, getAnalyzer, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, getDirectory, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, getUseCompoundFile, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setUseCompoundFile, METH_O),
    DECLARE_METHOD(j_indexwriter, getMaxFieldLength, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setMaxFieldLength, METH_O),
    DECLARE_METHOD(j_indexwriter, getMaxMergeDocs, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setMaxMergeDocs, METH_O),
    DECLARE_METHOD(j_indexwriter, getMaxBufferedDocs, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setMaxBufferedDocs, METH_O),
    DECLARE_METHOD(j_indexwriter, getMergeFactor, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setMergeFactor, METH_O),
    DECLARE_METHOD(j_indexwriter, getInfoStream, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setInfoStream, METH_O),
    DECLARE_METHOD(j_indexwriter, getSimilarity, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setSimilarity, METH_O),
    DECLARE_METHOD(j_indexwriter, getTermIndexInterval, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setTermIndexInterval, METH_O),
    DECLARE_METHOD(j_indexwriter, getWriteLockTimeout, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, setWriteLockTimeout, METH_O),
    DECLARE_METHOD(j_indexwriter, optimize, METH_NOARGS),
    DECLARE_METHOD(j_indexwriter, addIndexes, METH_O),
    DECLARE_METHOD(j_indexwriter, addDocument, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexWriter, j_indexwriter, Object,
             org::apache::lucene::index::IndexWriter, j_indexwriter_init);

/* Term */

class j_term {
public:
    PyObject_HEAD
    org::apache::lucene::index::Term *object;
};

static int j_term_init(j_term *self, PyObject *args, PyObject *kwds);
static PyObject *j_term_field(j_term *self);
static PyObject *j_term_text(j_term *self);
static PyObject *j_term_createTerm(j_term *self, PyObject *arg);

static PyMethodDef j_term_methods[] = {
    DECLARE_METHOD(j_term, field, METH_NOARGS),
    DECLARE_METHOD(j_term, text, METH_NOARGS),
    DECLARE_METHOD(j_term, createTerm, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Term, j_term, Object,
             org::apache::lucene::index::Term, j_term_init);

/* TermEnum */

class j_termenum {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermEnum *object;
};

static PyObject *j_termenum_next(j_termenum *self);
static PyObject *j_termenum_term(j_termenum *self);
static PyObject *j_termenum_docFreq(j_termenum *self);
static PyObject *j_termenum_close(j_termenum *self);
static PyObject *j_termenum_skipTo(j_termenum *self, PyObject *arg);

static PyMethodDef j_termenum_methods[] = {
    DECLARE_METHOD(j_termenum, next, METH_NOARGS),
    DECLARE_METHOD(j_termenum, term, METH_NOARGS),
    DECLARE_METHOD(j_termenum, docFreq, METH_NOARGS),
    DECLARE_METHOD(j_termenum, close, METH_NOARGS),
    DECLARE_METHOD(j_termenum, skipTo, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermEnum, j_termenum, Object,
             org::apache::lucene::index::TermEnum, abstract_init);

/* TermVectorOffsetInfo */

class j_termvectoroffsetinfo {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermVectorOffsetInfo *object;
};

static int j_termvectoroffsetinfo_init(j_termvectoroffsetinfo *self, PyObject *args, PyObject *kwds);
static PyObject *j_termvectoroffsetinfo_getStartOffset(j_termvectoroffsetinfo *self);
static PyObject *j_termvectoroffsetinfo_setStartOffset(j_termvectoroffsetinfo *self, PyObject *arg);
static PyObject *j_termvectoroffsetinfo_getEndOffset(j_termvectoroffsetinfo *self);
static PyObject *j_termvectoroffsetinfo_setEndOffset(j_termvectoroffsetinfo *self, PyObject *arg);

static PyMethodDef j_termvectoroffsetinfo_methods[] = {
    DECLARE_METHOD(j_termvectoroffsetinfo, getStartOffset, METH_NOARGS),
    DECLARE_METHOD(j_termvectoroffsetinfo, setStartOffset, METH_O),
    DECLARE_METHOD(j_termvectoroffsetinfo, getEndOffset, METH_NOARGS),
    DECLARE_METHOD(j_termvectoroffsetinfo, setEndOffset, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermVectorOffsetInfo, j_termvectoroffsetinfo, Object,
             org::apache::lucene::index::TermVectorOffsetInfo, abstract_init);

/* TermDocs */

class j_termdocs {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermDocs *object;
};

static PyObject *j_termdocs_seek(j_termdocs *self, PyObject *arg);
static PyObject *j_termdocs_doc(j_termdocs *self);
static PyObject *j_termdocs_freq(j_termdocs *self);
static PyObject *j_termdocs_next(j_termdocs *self);
static PyObject *j_termdocs_skipTo(j_termdocs *self, PyObject *arg);
static PyObject *j_termdocs_close(j_termdocs *self);
static PyObject *j_termdocs_read(j_termdocs *self, PyObject *arg);

static PyMethodDef j_termdocs_methods[] = {
    DECLARE_METHOD(j_termdocs, seek, METH_O),
    DECLARE_METHOD(j_termdocs, doc, METH_NOARGS),
    DECLARE_METHOD(j_termdocs, freq, METH_NOARGS),
    DECLARE_METHOD(j_termdocs, next, METH_NOARGS),
    DECLARE_METHOD(j_termdocs, skipTo, METH_O),
    DECLARE_METHOD(j_termdocs, close, METH_NOARGS),
    DECLARE_METHOD(j_termdocs, read, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermDocs, j_termdocs, Object,
             org::apache::lucene::index::TermDocs, abstract_init);

/* TermPositions */

class j_termpositions {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermPositions *object;
};

static PyObject *j_termpositions_nextPosition(j_termpositions *self);

static PyMethodDef j_termpositions_methods[] = {
    DECLARE_METHOD(j_termpositions, nextPosition, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermPositions, j_termpositions, TermDocs,
             org::apache::lucene::index::TermPositions, abstract_init);

/* MultipleTermPositions */

class j_multipletermpositions {
public:
    PyObject_HEAD
    org::apache::lucene::index::MultipleTermPositions *object;
};

static int j_multipletermpositions_init(j_multipletermpositions *self,
                                        PyObject *args, PyObject *kwds);

static PyMethodDef j_multipletermpositions_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultipleTermPositions, j_multipletermpositions, TermPositions,
             org::apache::lucene::index::MultipleTermPositions,
             j_multipletermpositions_init);

/* TermFreqVector */

class j_termfreqvector {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermFreqVector *object;
};

static PyObject *j_termfreqvector_getField(j_termfreqvector *self);
static PyObject *j_termfreqvector_size(j_termfreqvector *self);
static PyObject *j_termfreqvector_getTerms(j_termfreqvector *self);
static PyObject *j_termfreqvector_getTermFrequencies(j_termfreqvector *self);
static PyObject *j_termfreqvector_indexOf(j_termfreqvector *self,
                                          PyObject *arg);
static PyObject *j_termfreqvector_indexesOf(j_termfreqvector *self,
                                            PyObject *args);

static PyMethodDef j_termfreqvector_methods[] = {
    DECLARE_METHOD(j_termfreqvector, getField, METH_NOARGS),
    DECLARE_METHOD(j_termfreqvector, size, METH_NOARGS),
    DECLARE_METHOD(j_termfreqvector, getTerms, METH_NOARGS),
    DECLARE_METHOD(j_termfreqvector, getTermFrequencies, METH_NOARGS),
    DECLARE_METHOD(j_termfreqvector, indexOf, METH_O),
    DECLARE_METHOD(j_termfreqvector, indexesOf, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermFreqVector, j_termfreqvector, Object,
             org::apache::lucene::index::TermFreqVector, abstract_init);

/* TermPositionVector */

class j_termpositionvector {
public:
    PyObject_HEAD
    org::apache::lucene::index::TermPositionVector *object;
};

static PyObject *j_termpositionvector_getTermPositions(j_termpositionvector *self, PyObject *arg);
static PyObject *j_termpositionvector_getOffsets(j_termpositionvector *self, PyObject *arg);

static PyMethodDef j_termpositionvector_methods[] = {
    DECLARE_METHOD(j_termpositionvector, getTermPositions, METH_O),
    DECLARE_METHOD(j_termpositionvector, getOffsets, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermPositionVector, j_termpositionvector, TermFreqVector,
             org::apache::lucene::index::TermPositionVector, abstract_init);

/* IndexReader */

class j_indexreader {
public:
    PyObject_HEAD
    org::apache::lucene::index::IndexReader *object;
};

static PyObject *j_indexreader_open(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_main(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_lastModified(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_getCurrentVersion(PyTypeObject *type,
                                                 PyObject *arg);
static PyObject *j_indexreader_isLocked(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_unlock(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_indexExists(PyTypeObject *type, PyObject *arg);
static PyObject *j_indexreader_getTermFreqVector(j_indexreader *self,
                                                 PyObject *args);
static PyObject *j_indexreader_getTermFreqVectors(j_indexreader *self,
                                                  PyObject *arg);
static PyObject *j_indexreader_numDocs(j_indexreader *self);
static PyObject *j_indexreader_maxDoc(j_indexreader *self);
static PyObject *j_indexreader_document(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_isDeleted(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_hasDeletions(j_indexreader *self);
static PyObject *j_indexreader_setNorm(j_indexreader *self, PyObject *args);
static PyObject *j_indexreader_hasNorms(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_norms(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_terms(j_indexreader *self, PyObject *args);
static PyObject *j_indexreader_termDocs(j_indexreader *self, PyObject *args);
static PyObject *j_indexreader_termPositions(j_indexreader *self, PyObject *args);
static PyObject *j_indexreader_docFreq(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_directory(j_indexreader *self);
static PyObject *j_indexreader_getVersion(j_indexreader *self);
static PyObject *j_indexreader_isCurrent(j_indexreader *self);
static PyObject *j_indexreader_deleteDocument(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_deleteDocuments(j_indexreader *self, PyObject *arg);
static PyObject *j_indexreader_undeleteAll(j_indexreader *self);
static PyObject *j_indexreader_close(j_indexreader *self);
static PyObject *j_indexreader_getFieldNames(j_indexreader *self, PyObject *arg);

static PyMethodDef j_indexreader_methods[] = {
    DECLARE_METHOD(j_indexreader, open, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, main, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, lastModified, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, getCurrentVersion, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, isLocked, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, unlock, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, indexExists, METH_O | METH_CLASS),
    DECLARE_METHOD(j_indexreader, getTermFreqVector, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, getTermFreqVectors, METH_O),
    DECLARE_METHOD(j_indexreader, numDocs, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, maxDoc, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, document, METH_O),
    DECLARE_METHOD(j_indexreader, isDeleted, METH_O),
    DECLARE_METHOD(j_indexreader, hasDeletions, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, setNorm, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, hasNorms, METH_O),
    DECLARE_METHOD(j_indexreader, norms, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, terms, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, termDocs, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, termPositions, METH_VARARGS),
    DECLARE_METHOD(j_indexreader, docFreq, METH_O),
    DECLARE_METHOD(j_indexreader, directory, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, getVersion, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, isCurrent, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, deleteDocument, METH_O),
    DECLARE_METHOD(j_indexreader, deleteDocuments, METH_O),
    DECLARE_METHOD(j_indexreader, undeleteAll, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, close, METH_NOARGS),
    DECLARE_METHOD(j_indexreader, getFieldNames, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexReader, j_indexreader, Object,
             org::apache::lucene::index::IndexReader, abstract_init);

static PyObject *j_indexreader_iter(j_indexreader *self);

/* IndexReader.FieldOption */

class j_indexreader_fieldoption {
public:
    PyObject_HEAD
    org::apache::lucene::index::IndexReader$FieldOption *object;
};

static PyMethodDef j_indexreader_fieldoption_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexReader_FieldOption, j_indexreader_fieldoption, Parameter,
             org::apache::lucene::index::IndexReader$FieldOption,
             abstract_init);

/* IndexReaderEnumeration */

class j_indexreaderenumeration {
public:
    PyObject_HEAD
    org::osafoundation::util::IndexReaderEnumeration *object;
};

static PyObject *j_indexreaderenumeration_nextElement(j_indexreaderenumeration *self);
static PyObject *j_indexreaderenumeration_next(j_indexreaderenumeration *self);

static PyMethodDef j_indexreaderenumeration_methods[] = {
    DECLARE_METHOD(j_indexreaderenumeration, nextElement, METH_NOARGS),
    DECLARE_METHOD(j_indexreaderenumeration, next, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexReaderEnumeration, j_indexreaderenumeration, Enumeration,
             org::osafoundation::util::IndexReaderEnumeration, abstract_init);

/* FilterIndexReader */

class j_filterindexreader {
public:
    PyObject_HEAD
    org::apache::lucene::index::FilterIndexReader *object;
};

static int j_filterindexreader_init(j_filterindexreader *self, PyObject *args, PyObject *kwds);

static PyMethodDef j_filterindexreader_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FilterIndexReader, j_filterindexreader, IndexReader,
             org::apache::lucene::index::FilterIndexReader,
             j_filterindexreader_init);

/* ParallelReader */

class j_parallelreader {
public:
    PyObject_HEAD
    org::apache::lucene::index::ParallelReader *object;
};

static int j_parallelreader_init(j_parallelreader *self,
                                 PyObject *args, PyObject *kwds);
static PyObject *j_parallelreader_add(j_parallelreader *self, PyObject *args);

static PyMethodDef j_parallelreader_methods[] = {
    DECLARE_METHOD(j_parallelreader, add, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ParallelReader, j_parallelreader, IndexReader,
             org::apache::lucene::index::ParallelReader,
             j_parallelreader_init);

/* IndexModifier */

class j_indexmodifier {
public:
    PyObject_HEAD
    org::apache::lucene::index::IndexModifier *object;
};

static int j_indexmodifier_init(j_indexmodifier *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_indexmodifier_optimize(j_indexmodifier *self);
static PyObject *j_indexmodifier_flush(j_indexmodifier *self);
static PyObject *j_indexmodifier_close(j_indexmodifier *self);
static PyObject *j_indexmodifier_addDocument(j_indexmodifier *self,
                                             PyObject *args);
static PyObject *j_indexmodifier_deleteDocument(j_indexmodifier *self,
                                                PyObject *arg);
static PyObject *j_indexmodifier_deleteDocuments(j_indexmodifier *self,
                                                 PyObject *arg);
static PyObject *j_indexmodifier_docCount(j_indexmodifier *self);
static PyObject *j_indexmodifier_getInfoStream(j_indexmodifier *self);
static PyObject *j_indexmodifier_setInfoStream(j_indexmodifier *self,
                                               PyObject *arg);
static PyObject *j_indexmodifier_getUseCompoundFile(j_indexmodifier *self);
static PyObject *j_indexmodifier_setUseCompoundFile(j_indexmodifier *self,
                                                    PyObject *arg);
static PyObject *j_indexmodifier_getMaxFieldLength(j_indexmodifier *self);
static PyObject *j_indexmodifier_setMaxFieldLength(j_indexmodifier *self,
                                                    PyObject *arg);
static PyObject *j_indexmodifier_getMaxBufferedDocs(j_indexmodifier *self);
static PyObject *j_indexmodifier_setMaxBufferedDocs(j_indexmodifier *self,
                                                    PyObject *arg);
static PyObject *j_indexmodifier_getMergeFactor(j_indexmodifier *self);
static PyObject *j_indexmodifier_setMergeFactor(j_indexmodifier *self,
                                                PyObject *arg);

static PyMethodDef j_indexmodifier_methods[] = {
    DECLARE_METHOD(j_indexmodifier, optimize, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, flush, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, close, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, addDocument, METH_VARARGS),
    DECLARE_METHOD(j_indexmodifier, deleteDocument, METH_O),
    DECLARE_METHOD(j_indexmodifier, deleteDocuments, METH_O),
    DECLARE_METHOD(j_indexmodifier, docCount, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, getInfoStream, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, setInfoStream, METH_O),
    DECLARE_METHOD(j_indexmodifier, getUseCompoundFile, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, setUseCompoundFile, METH_O),
    DECLARE_METHOD(j_indexmodifier, getMaxFieldLength, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, setMaxFieldLength, METH_O),
    DECLARE_METHOD(j_indexmodifier, getMaxBufferedDocs, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, setMaxBufferedDocs, METH_O),
    DECLARE_METHOD(j_indexmodifier, getMergeFactor, METH_NOARGS),
    DECLARE_METHOD(j_indexmodifier, setMergeFactor, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexModifier, j_indexmodifier, Object,
             org::apache::lucene::index::IndexModifier, j_indexmodifier_init);

/* MultiReader */

class j_multireader {
public:
    PyObject_HEAD
    org::apache::lucene::index::MultiReader *object;
};

static int j_multireader_init(j_multireader *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_multireader_add(j_multireader *self, PyObject *args);

static PyMethodDef j_multireader_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultiReader, j_multireader, IndexReader,
             org::apache::lucene::index::MultiReader,
             j_multireader_init);


/* Query */

class j_query {
public:
    PyObject_HEAD
    org::apache::lucene::search::Query *object;
};

static PyObject *j_query_mergeBooleanQueries(PyTypeObject *type, PyObject *arg);
static PyObject *j_query_getBoost(j_query *self);
static PyObject *j_query_setBoost(j_query *self, PyObject *arg);
static PyObject *j_query_rewrite(j_query *self, PyObject *arg);
static PyObject *j_query_combine(j_query *self, PyObject *arg);
static PyObject *j_query_weight(j_query *self, PyObject *arg);
static PyObject *j_query_getSimilarity(j_query *self, PyObject *arg);
static PyObject *j_query_toString(j_query *self, PyObject *args);
DECLARE_DOWNCAST(j_query, BooleanQuery);
DECLARE_DOWNCAST(j_query, PrefixQuery);
DECLARE_DOWNCAST(j_query, TermQuery);
DECLARE_DOWNCAST(j_query, PhraseQuery);
DECLARE_DOWNCAST(j_query, MultiPhraseQuery);
DECLARE_DOWNCAST(j_query, FilteredQuery);
DECLARE_DOWNCAST(j_query, RangeQuery);
DECLARE_DOWNCAST(j_query, MultiTermQuery);
DECLARE_DOWNCAST(j_query, FuzzyQuery);
DECLARE_DOWNCAST(j_query, WildcardQuery);
DECLARE_DOWNCAST(j_query, SpanQuery);
DECLARE_DOWNCAST(j_query, SpanFirstQuery);
DECLARE_DOWNCAST(j_query, SpanNearQuery);
DECLARE_DOWNCAST(j_query, SpanNotQuery);
DECLARE_DOWNCAST(j_query, SpanOrQuery);
DECLARE_DOWNCAST(j_query, SpanTermQuery);
DECLARE_DOWNCAST(j_query, MatchAllDocsQuery);
DECLARE_DOWNCAST(j_query, ConstantScoreQuery);
DECLARE_DOWNCAST(j_query, ConstantScoreRangeQuery);
DECLARE_DOWNCAST(j_query, DisjunctionMaxQuery);
DECLARE_DOWNCAST(j_query, RegexQuery);
DECLARE_DOWNCAST(j_query, SpanRegexQuery);

static PyMethodDef j_query_methods[] = {
    DECLARE_METHOD(j_query, mergeBooleanQueries, METH_O | METH_CLASS),
    DECLARE_METHOD(j_query, getBoost, METH_NOARGS),
    DECLARE_METHOD(j_query, setBoost, METH_O),
    DECLARE_METHOD(j_query, rewrite, METH_O),
    DECLARE_METHOD(j_query, combine, METH_O),
    DECLARE_METHOD(j_query, weight, METH_O),
    DECLARE_METHOD(j_query, getSimilarity, METH_O),
    DECLARE_METHOD(j_query, toString, METH_VARARGS),
    DECLARE_DOWNCAST_METHODS(j_query, BooleanQuery),
    DECLARE_DOWNCAST_METHODS(j_query, PrefixQuery),
    DECLARE_DOWNCAST_METHODS(j_query, TermQuery),
    DECLARE_DOWNCAST_METHODS(j_query, PhraseQuery),
    DECLARE_DOWNCAST_METHODS(j_query, MultiPhraseQuery),
    DECLARE_DOWNCAST_METHODS(j_query, FilteredQuery),
    DECLARE_DOWNCAST_METHODS(j_query, RangeQuery),
    DECLARE_DOWNCAST_METHODS(j_query, MultiTermQuery),
    DECLARE_DOWNCAST_METHODS(j_query, FuzzyQuery),
    DECLARE_DOWNCAST_METHODS(j_query, WildcardQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanFirstQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanNearQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanNotQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanOrQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanTermQuery),
    DECLARE_DOWNCAST_METHODS(j_query, MatchAllDocsQuery),
    DECLARE_DOWNCAST_METHODS(j_query, ConstantScoreQuery),
    DECLARE_DOWNCAST_METHODS(j_query, ConstantScoreRangeQuery),
    DECLARE_DOWNCAST_METHODS(j_query, DisjunctionMaxQuery),
    DECLARE_DOWNCAST_METHODS(j_query, RegexQuery),
    DECLARE_DOWNCAST_METHODS(j_query, SpanRegexQuery),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Query, j_query, Object, org::apache::lucene::search::Query,
             abstract_init);

/* MultiTermQuery */

class j_multitermquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::MultiTermQuery *object;
};

static PyObject *j_multitermquery_getTerm(j_multitermquery *self);

static PyMethodDef j_multitermquery_methods[] = {
    DECLARE_METHOD(j_multitermquery, getTerm, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultiTermQuery, j_multitermquery, Query,
             org::apache::lucene::search::MultiTermQuery, abstract_init);

/* Hits */

class j_hits {
public:
    PyObject_HEAD
    org::apache::lucene::search::Hits *object;
};

static PyObject *j_hits_length(j_hits *self);
static PyObject *j_hits_doc(j_hits *self, PyObject *arg);
static PyObject *j_hits_score(j_hits *self, PyObject *arg);
static PyObject *j_hits_id(j_hits *self, PyObject *arg);

static PyMethodDef j_hits_methods[] = {
    DECLARE_METHOD(j_hits, length, METH_NOARGS),
    DECLARE_METHOD(j_hits, doc, METH_O),
    DECLARE_METHOD(j_hits, score, METH_O),
    DECLARE_METHOD(j_hits, id, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Hits, j_hits, Object, org::apache::lucene::search::Hits,
             abstract_init);

static PyObject *j_hits_iter(j_hits *self);
static int j_hits_getlength(j_hits *self);
static PyObject *j_hits_getitem(j_hits *self, int n);

static PySequenceMethods j_hits_as_sequence = {
    (inquiry)j_hits_getlength,              /* sq_length */
    (binaryfunc)NULL,                       /* sq_concat */
    (intargfunc)NULL,                       /* sq_repeat */
    (intargfunc)j_hits_getitem,             /* sq_item   */
    (intintargfunc)NULL,                    /* sq_slice  */
    (intobjargproc)NULL,                    /* sq_ass_item */
    (intintobjargproc)NULL,                 /* sq_ass_slice */
    (objobjproc)NULL,                       /* sq_contains */
    (binaryfunc)NULL,                       /* sq_inplace_concat */
    (intargfunc)NULL,                       /* sq_inplace_repeat */
};

/* HitIterator */

class j_hititerator {
public:
    PyObject_HEAD
    org::apache::lucene::search::Hits *object;
    jint i, len;
};

static int j_hititerator_init(j_hititerator *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_hititerator_iter(j_hititerator *self);
static PyObject *j_hititerator_next(j_hititerator *self);

static PyMethodDef j_hititerator_methods[] = {
    DECLARE_METHOD(j_hititerator, next, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(HitIterator, j_hititerator, Object,
             org::apache::lucene::search::Hits, j_hititerator_init);

/* Hit */

class j_hit {
public:
    PyObject_HEAD
    org::apache::lucene::search::Hit *object;
    jint hitNumber;
};

static PyObject *j_hit_getDocument(j_hit *self);
static PyObject *j_hit_getScore(j_hit *self);
static PyObject *j_hit_getId(j_hit *self);
static PyObject *j_hit_getBoost(j_hit *self);
static PyObject *j_hit_get(j_hit *self, PyObject *arg);

static PyMethodDef j_hit_methods[] = {
    DECLARE_METHOD(j_hit, getDocument, METH_NOARGS),
    DECLARE_METHOD(j_hit, getScore, METH_NOARGS),
    DECLARE_METHOD(j_hit, getId, METH_NOARGS),
    DECLARE_METHOD(j_hit, getBoost, METH_NOARGS),
    DECLARE_METHOD(j_hit, get, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Hit, j_hit, Object,
             org::apache::lucene::search::Hit, abstract_init);

static int j_hit_getlength(j_hit *self);
static PyObject *j_hit_getitem(j_hit *self, int n);

static PySequenceMethods j_hit_as_sequence = {
    (inquiry)j_hit_getlength,              /* sq_length */
    (binaryfunc)NULL,                      /* sq_concat */
    (intargfunc)NULL,                      /* sq_repeat */
    (intargfunc)j_hit_getitem,             /* sq_item   */
    (intintargfunc)NULL,                   /* sq_slice  */
    (intobjargproc)NULL,                   /* sq_ass_item */
    (intintobjargproc)NULL,                /* sq_ass_slice */
    (objobjproc)NULL,                      /* sq_contains */
    (binaryfunc)NULL,                      /* sq_inplace_concat */
    (intargfunc)NULL,                      /* sq_inplace_repeat */
};

/* HitCollector */

class j_hitcollector {
public:
    PyObject_HEAD
    org::apache::lucene::search::HitCollector *object;
};

static int j_hitcollector_init(j_hitcollector *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_hitcollector_collect(j_hitcollector *self, PyObject *args);

static PyMethodDef j_hitcollector_methods[] = {
    DECLARE_METHOD(j_hitcollector, collect, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(HitCollector, j_hitcollector, Object,
             org::apache::lucene::search::HitCollector, j_hitcollector_init);

static int check_HitCollector(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "collect");
}

static org::apache::lucene::search::HitCollector *make_HitCollector(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::HitCollector *)
        new org::osafoundation::search::PythonHitCollector(ptr);
}

/* Scorer */

class j_scorer {
public:
    PyObject_HEAD
    org::apache::lucene::search::Scorer *object;
};

static PyObject *j_scorer_getSimilarity(j_scorer *self);
static PyObject *j_scorer_score(j_scorer *self, PyObject *args);
static PyObject *j_scorer_next(j_scorer *self);
static PyObject *j_scorer_doc(j_scorer *self);
static PyObject *j_scorer_skipTo(j_scorer *self, PyObject *arg);
static PyObject *j_scorer_explain(j_scorer *self, PyObject *arg);

static PyMethodDef j_scorer_methods[] = {
    DECLARE_METHOD(j_scorer, getSimilarity, METH_NOARGS),
    DECLARE_METHOD(j_scorer, score, METH_VARARGS),
    DECLARE_METHOD(j_scorer, next, METH_NOARGS),
    DECLARE_METHOD(j_scorer, doc, METH_NOARGS),
    DECLARE_METHOD(j_scorer, skipTo, METH_O),
    DECLARE_METHOD(j_scorer, explain, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Scorer, j_scorer, Object,
             org::apache::lucene::search::Scorer, abstract_init);

/* Weight */

class j_weight {
public:
    PyObject_HEAD
    org::apache::lucene::search::Weight *object;
};

static PyObject *j_weight_getQuery(j_weight *self);
static PyObject *j_weight_getValue(j_weight *self);
static PyObject *j_weight_sumOfSquaredWeights(j_weight *self);
static PyObject *j_weight_normalize(j_weight *self, PyObject *arg);
static PyObject *j_weight_scorer(j_weight *self, PyObject *arg);
static PyObject *j_weight_explain(j_weight *self, PyObject *args);

static PyMethodDef j_weight_methods[] = {
    DECLARE_METHOD(j_weight, getQuery, METH_NOARGS),
    DECLARE_METHOD(j_weight, getValue, METH_NOARGS),
    DECLARE_METHOD(j_weight, sumOfSquaredWeights, METH_NOARGS),
    DECLARE_METHOD(j_weight, normalize, METH_O),
    DECLARE_METHOD(j_weight, scorer, METH_O),
    DECLARE_METHOD(j_weight, explain, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Weight, j_weight, Object,
             org::apache::lucene::search::Weight, abstract_init);

/* Similarity */

class j_similarity {
public:
    PyObject_HEAD
    org::apache::lucene::search::Similarity *object;
};

static PyObject *j_similarity_getDefault(PyTypeObject *type);
static PyObject *j_similarity_setDefault(PyTypeObject *type, PyObject *arg);
static PyObject *j_similarity_encodeNorm(PyTypeObject *type, PyObject *arg);
static PyObject *j_similarity_decodeNorm(PyTypeObject *type, PyObject *arg);
static PyObject *j_similarity_lengthNorm(j_similarity *self, PyObject *args);
static PyObject *j_similarity_queryNorm(j_similarity *self, PyObject *arg);
static PyObject *j_similarity_tf(j_similarity *self, PyObject *arg);
static PyObject *j_similarity_idf(j_similarity *self, PyObject *args);
static PyObject *j_similarity_coord(j_similarity *self, PyObject *args);
static PyObject *j_similarity_sloppyFreq(j_similarity *self, PyObject *arg);

static PyMethodDef j_similarity_methods[] = {
    DECLARE_METHOD(j_similarity, getDefault, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_similarity, setDefault, METH_O | METH_CLASS),
    DECLARE_METHOD(j_similarity, encodeNorm, METH_O | METH_CLASS),
    DECLARE_METHOD(j_similarity, decodeNorm, METH_O | METH_CLASS),
    DECLARE_METHOD(j_similarity, lengthNorm, METH_VARARGS),
    DECLARE_METHOD(j_similarity, queryNorm, METH_O),
    DECLARE_METHOD(j_similarity, tf, METH_O),
    DECLARE_METHOD(j_similarity, idf, METH_VARARGS),
    DECLARE_METHOD(j_similarity, coord, METH_VARARGS),
    DECLARE_METHOD(j_similarity, sloppyFreq, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Similarity, j_similarity, Object,
             org::apache::lucene::search::Similarity, abstract_init);

static int check_Similarity(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "idf");
}

static org::apache::lucene::search::Similarity *make_Similarity(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::Similarity *)
        new org::osafoundation::search::PythonSimilarity(ptr);
}

/* ScoreDoc */

class j_scoredoc {
public:
    PyObject_HEAD
    org::apache::lucene::search::ScoreDoc *object;
};

static int j_scoredoc_init(j_scoredoc *self, PyObject *args, PyObject *kwds);
DECLARE_DOWNCAST(j_scoredoc, FieldDoc);

static PyMethodDef j_scoredoc_methods[] = {
    DECLARE_DOWNCAST_METHODS(j_scoredoc, FieldDoc),
    { NULL, NULL, 0, NULL }
};

static PyObject *j_scoredoc_get_score(j_scoredoc *self, void *data);
static int j_scoredoc_set_score(j_scoredoc *self, PyObject *arg, void *data);
static PyObject *j_scoredoc_get_doc(j_scoredoc *self, void *data);
static int j_scoredoc_set_doc(j_scoredoc *self, PyObject *arg, void *data);

static PyGetSetDef j_scoredoc_properties[] = {
    { "score", (getter) j_scoredoc_get_score, (setter) j_scoredoc_set_score,
      NULL, NULL },
    { "doc", (getter) j_scoredoc_get_doc, (setter) j_scoredoc_set_doc,
      NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL }
};

DECLARE_TYPE(ScoreDoc, j_scoredoc, Object,
             org::apache::lucene::search::ScoreDoc, j_scoredoc_init);

/* FieldDoc */

class j_fielddoc {
public:
    PyObject_HEAD
    org::apache::lucene::search::FieldDoc *object;
};

static int j_fielddoc_init(j_fielddoc *self, PyObject *args, PyObject *kwds);

static PyMethodDef j_fielddoc_methods[] = {
    { NULL, NULL, 0, NULL }
};

static PyObject *j_fielddoc_get_fields(j_fielddoc *self, void *data);
static int j_fielddoc_set_fields(j_fielddoc *self, PyObject *arg, void *data);

static PyGetSetDef j_fielddoc_properties[] = {
    { "fields", (getter) j_fielddoc_get_fields, (setter) j_fielddoc_set_fields,
      NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL }
};

DECLARE_TYPE(FieldDoc, j_fielddoc, ScoreDoc,
             org::apache::lucene::search::FieldDoc, j_fielddoc_init);

/* TopDocs */

class j_topdocs {
public:
    PyObject_HEAD
    org::apache::lucene::search::TopDocs *object;
};

static int j_topdocs_init(j_topdocs *self, PyObject *args, PyObject *kwds);
static PyObject *j_topdocs_getMaxScore(j_topdocs *self);
static PyObject *j_topdocs_setMaxScore(j_topdocs *self, PyObject *arg);

static PyMethodDef j_topdocs_methods[] = {
    DECLARE_METHOD(j_topdocs, getMaxScore, METH_NOARGS),
    DECLARE_METHOD(j_topdocs, setMaxScore, METH_O),
    { NULL, NULL, 0, NULL }
};

static PyObject *j_topdocs_get_scoreDocs(j_topdocs *self, void *data);
static int j_topdocs_set_scoreDocs(j_topdocs *self, PyObject *arg, void *data);
static PyObject *j_topdocs_get_totalHits(j_topdocs *self, void *data);
static int j_topdocs_set_totalHits(j_topdocs *self, PyObject *arg, void *data);

static PyGetSetDef j_topdocs_properties[] = {
    { "scoreDocs",
      (getter) j_topdocs_get_scoreDocs,
      (setter) j_topdocs_set_scoreDocs,
      NULL, NULL },
    { "totalHits",
      (getter) j_topdocs_get_totalHits,
      (setter) j_topdocs_set_totalHits,
      NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL }
};

DECLARE_TYPE(TopDocs, j_topdocs, Object,
             org::apache::lucene::search::TopDocs, j_topdocs_init);

/* TopFieldDocs */

class j_topfielddocs {
public:
    PyObject_HEAD
    org::apache::lucene::search::TopFieldDocs *object;
};

static int j_topfielddocs_init(j_topfielddocs *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_topfielddocs_methods[] = {
    { NULL, NULL, 0, NULL }
};

static PyObject *j_topfielddocs_get_fields(j_topfielddocs *self, void *data);
static int j_topfielddocs_set_fields(j_topfielddocs *self,
                                     PyObject *arg, void *data);

static PyGetSetDef j_topfielddocs_properties[] = {
    { "fields",
      (getter) j_topfielddocs_get_fields,
      (setter) j_topfielddocs_set_fields,
      NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL }
};

DECLARE_TYPE(TopFieldDocs, j_topfielddocs, TopDocs,
             org::apache::lucene::search::TopFieldDocs, j_topfielddocs_init);

/* ScoreDocComparator */

class j_scoredoccomparator {
public:
    PyObject_HEAD
    org::apache::lucene::search::ScoreDocComparator *object;
};

static PyObject *j_scoredoccomparator_compare(j_scoredoccomparator *self,
                                              PyObject *args);
static PyObject *j_scoredoccomparator_sortValue(j_scoredoccomparator *self,
                                                PyObject *arg);
static PyObject *j_scoredoccomparator_sortType(j_scoredoccomparator *self);

static PyMethodDef j_scoredoccomparator_methods[] = {
    DECLARE_METHOD(j_scoredoccomparator, compare, METH_VARARGS),
    DECLARE_METHOD(j_scoredoccomparator, sortValue, METH_O),
    DECLARE_METHOD(j_scoredoccomparator, sortType, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ScoreDocComparator, j_scoredoccomparator, Object,
             org::apache::lucene::search::ScoreDocComparator, abstract_init);

/* SortComparatorSource */

class j_sortcomparatorsource {
public:
    PyObject_HEAD
    org::apache::lucene::search::SortComparatorSource *object;
};

static int j_sortcomparatorsource_init(j_sortcomparatorsource *self,
                                       PyObject *args, PyObject *kwds);
static PyObject *j_sortcomparatorsource_newComparator(j_sortcomparatorsource *self, PyObject *args);

static PyMethodDef j_sortcomparatorsource_methods[] = {
    DECLARE_METHOD(j_sortcomparatorsource, newComparator, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SortComparatorSource, j_sortcomparatorsource, Object,
             org::apache::lucene::search::SortComparatorSource,
             j_sortcomparatorsource_init);

static int check_SortComparatorSource(PyObject *arg)
{
    return (PyObject_HasAttrString(arg, "getComparable") ||
            PyObject_HasAttrString(arg, "newComparator"));
}

static org::apache::lucene::search::SortComparatorSource *make_SortComparatorSource(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    if (PyObject_HasAttrString(arg, "getComparable"))
        return (org::apache::lucene::search::SortComparatorSource *)
            new org::osafoundation::search::PythonSortComparator(ptr);

    return (org::apache::lucene::search::SortComparatorSource *)
        new org::osafoundation::search::PythonSortComparatorSource(ptr);
}

/* SortComparator */

class j_sortcomparator {
public:
    PyObject_HEAD
    org::apache::lucene::search::SortComparator *object;
};

static PyMethodDef j_sortcomparator_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SortComparator, j_sortcomparator, SortComparatorSource,
             org::apache::lucene::search::SortComparator, abstract_init);

static int check_SortComparator(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "getComparable");
}

static org::apache::lucene::search::SortComparator *make_SortComparator(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::SortComparator *)
        new org::osafoundation::search::PythonSortComparator(ptr);
}

/* SortField */

class j_sortfield {
public:
    PyObject_HEAD
    org::apache::lucene::search::SortField *object;
};

static int j_sortfield_init(j_sortfield *self,
                            PyObject *args, PyObject *kwds);
static PyObject *j_sortfield_getFactory(j_sortfield *self);
static PyObject *j_sortfield_getField(j_sortfield *self);
static PyObject *j_sortfield_getType(j_sortfield *self);
static PyObject *j_sortfield_getLocale(j_sortfield *self);
static PyObject *j_sortfield_getReverse(j_sortfield *self);

static PyMethodDef j_sortfield_methods[] = {
    DECLARE_METHOD(j_sortfield, getFactory, METH_NOARGS),
    DECLARE_METHOD(j_sortfield, getField, METH_NOARGS),
    DECLARE_METHOD(j_sortfield, getField, METH_NOARGS),
    DECLARE_METHOD(j_sortfield, getType, METH_NOARGS),
    DECLARE_METHOD(j_sortfield, getLocale, METH_NOARGS),
    DECLARE_METHOD(j_sortfield, getReverse, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SortField, j_sortfield, Object,
             org::apache::lucene::search::SortField, j_sortfield_init);

/* Sort */

class j_sort {
public:
    PyObject_HEAD
    org::apache::lucene::search::Sort *object;
};

static int j_sort_init(j_sort *self, PyObject *args, PyObject *kwds);
static PyObject *j_sort_setSort(j_sort *self, PyObject *args);

static PyMethodDef j_sort_methods[] = {
    DECLARE_METHOD(j_sort, setSort, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Sort, j_sort, Object,
             org::apache::lucene::search::Sort, j_sort_init);

/* TopDocCollector */

class j_topdoccollector {
public:
    PyObject_HEAD
    org::apache::lucene::search::TopDocCollector *object;
};

static int j_topdoccollector_init(j_topdoccollector *self,
                                  PyObject *args, PyObject *kwds);
static PyObject *j_topdoccollector_getTotalHits(j_topdoccollector *self);
static PyObject *j_topdoccollector_topDocs(j_topdoccollector *self);

static PyMethodDef j_topdoccollector_methods[] = {
    DECLARE_METHOD(j_topdoccollector, getTotalHits, METH_NOARGS),
    DECLARE_METHOD(j_topdoccollector, topDocs, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TopDocCollector, j_topdoccollector, HitCollector,
             org::apache::lucene::search::TopDocCollector,
             j_topdoccollector_init);

/* TopFieldDocCollector */

class j_topfielddoccollector {
public:
    PyObject_HEAD
    org::apache::lucene::search::TopFieldDocCollector *object;
};

static int j_topfielddoccollector_init(j_topfielddoccollector *self,
                                       PyObject *args, PyObject *kwds);

static PyMethodDef j_topfielddoccollector_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TopFieldDocCollector, j_topfielddoccollector, TopDocCollector,
             org::apache::lucene::search::TopFieldDocCollector,
             j_topfielddoccollector_init);

/* Filter */

class j_filter {
public:
    PyObject_HEAD
    org::apache::lucene::search::Filter *object;
};

static int j_filter_init(j_filter *self, PyObject *args, PyObject *kwds);
static PyObject *j_filter_bits(j_filter *self, PyObject *arg);

static PyMethodDef j_filter_methods[] = {
    DECLARE_METHOD(j_filter, bits, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Filter, j_filter, Object, org::apache::lucene::search::Filter,
             j_filter_init);

static int check_Filter(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "bits");
}

static org::apache::lucene::search::Filter *make_Filter(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::Filter *)
        new org::osafoundation::search::PythonFilter(ptr);
}

/* Searchable */

class j_searchable {
public:
    PyObject_HEAD
    org::apache::lucene::search::Searchable *object;
};

static int j_searchable_init(j_searchable *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_searchable_close(j_searchable *self);
static PyObject *j_searchable_doc(j_searchable *self, PyObject *arg);
static PyObject *j_searchable_docFreq(j_searchable *self, PyObject *arg);
static PyObject *j_searchable_docFreqs(j_searchable *self, PyObject *arg);
static PyObject *j_searchable_explain(j_searchable *self, PyObject *args);
static PyObject *j_searchable_maxDoc(j_searchable *self);
static PyObject *j_searchable_rewrite(j_searchable *self, PyObject *arg);
static PyObject *j_searchable_search(j_searchable *self, PyObject *args);
DECLARE_DOWNCAST(j_searchable, Searcher);

static PyMethodDef j_searchable_methods[] = {
    DECLARE_METHOD(j_searchable, close, METH_NOARGS),
    DECLARE_METHOD(j_searchable, doc, METH_O),
    DECLARE_METHOD(j_searchable, docFreq, METH_O),
    DECLARE_METHOD(j_searchable, docFreqs, METH_O),
    DECLARE_METHOD(j_searchable, explain, METH_VARARGS),
    DECLARE_METHOD(j_searchable, maxDoc, METH_NOARGS),
    DECLARE_METHOD(j_searchable, rewrite, METH_O),
    DECLARE_METHOD(j_searchable, search, METH_VARARGS),
    DECLARE_DOWNCAST_METHODS(j_searchable, Searcher),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Searchable, j_searchable, Object,
             org::apache::lucene::search::Searchable, j_searchable_init);

static int check_Searchable(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "explain");
}

static org::apache::lucene::search::Searchable *make_Searchable(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::Searchable *)
        new org::osafoundation::search::PythonSearcher(ptr);
}

/* Searcher */

class j_searcher {
public:
    PyObject_HEAD
    org::apache::lucene::search::Searcher *object;
};

static PyObject *j_searcher_search(j_searcher *self, PyObject *args);
static PyObject *j_searcher_explain(j_searcher *self, PyObject *args);
static PyObject *j_searcher_getSimilarity(j_searcher *self);
static PyObject *j_searcher_setSimilarity(j_searcher *self, PyObject *arg);
DECLARE_DOWNCAST(j_searcher, IndexSearcher);
DECLARE_DOWNCAST(j_searcher, MultiSearcher);
DECLARE_DOWNCAST(j_searcher, ParallelMultiSearcher);

static PyMethodDef j_searcher_methods[] = {
    DECLARE_METHOD(j_searcher, search, METH_VARARGS),
    DECLARE_METHOD(j_searcher, explain, METH_VARARGS),
    DECLARE_METHOD(j_searcher, getSimilarity, METH_NOARGS),
    DECLARE_METHOD(j_searcher, setSimilarity, METH_O),
    DECLARE_DOWNCAST_METHODS(j_searcher, IndexSearcher),
    DECLARE_DOWNCAST_METHODS(j_searcher, MultiSearcher),
    DECLARE_DOWNCAST_METHODS(j_searcher, ParallelMultiSearcher),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Searcher, j_searcher, Searchable,
             org::apache::lucene::search::Searcher, abstract_init);

/* IndexSearcher */

class j_indexsearcher {
public:
    PyObject_HEAD
    org::apache::lucene::search::IndexSearcher *object;
};

static int j_indexsearcher_init(j_indexsearcher *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_indexsearcher_getIndexReader(j_indexsearcher *self);

static PyMethodDef j_indexsearcher_methods[] = {
    DECLARE_METHOD(j_indexsearcher, getIndexReader, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(IndexSearcher, j_indexsearcher, Searcher,
             org::apache::lucene::search::IndexSearcher, j_indexsearcher_init);

/* MultiSearcher */

class j_multisearcher {
public:
    PyObject_HEAD
    org::apache::lucene::search::MultiSearcher *object;
};

static int j_multisearcher_init(j_multisearcher *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_multisearcher_subDoc(j_multisearcher *self, PyObject *arg);
static PyObject *j_multisearcher_subSearcher(j_multisearcher *self,
                                             PyObject *arg);
static PyObject *j_multisearcher_getSearchables(j_multisearcher *self);

static PyMethodDef j_multisearcher_methods[] = {
    DECLARE_METHOD(j_multisearcher, subDoc, METH_O),
    DECLARE_METHOD(j_multisearcher, subSearcher, METH_O),
    DECLARE_METHOD(j_multisearcher, getSearchables, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultiSearcher, j_multisearcher, Searcher,
             org::apache::lucene::search::MultiSearcher, j_multisearcher_init);

/* ParallelMultiSearcher */

class j_parallelmultisearcher {
public:
    PyObject_HEAD
    org::apache::lucene::search::ParallelMultiSearcher *object;
};

static int j_parallelmultisearcher_init(j_parallelmultisearcher *self,
                                        PyObject *args, PyObject *kwds);

static PyMethodDef j_parallelmultisearcher_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ParallelMultiSearcher, j_parallelmultisearcher, MultiSearcher,
             org::apache::lucene::search::ParallelMultiSearcher,
             j_parallelmultisearcher_init);

/* Explanation */

class j_explanation {
public:
    PyObject_HEAD
    org::apache::lucene::search::Explanation *object;
};

static int j_explanation_init(j_explanation *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_explanation_addDetail(j_explanation *self, PyObject *arg);
static PyObject *j_explanation_getDetails(j_explanation *self);
static PyObject *j_explanation_getDescription(j_explanation *self);
static PyObject *j_explanation_setDescription(j_explanation *self,
                                              PyObject *arg);
static PyObject *j_explanation_getValue(j_explanation *self);
static PyObject *j_explanation_setValue(j_explanation *self, PyObject *arg);
static PyObject *j_explanation_toHtml(j_explanation *self);

static PyMethodDef j_explanation_methods[] = {
    DECLARE_METHOD(j_explanation, addDetail, METH_O),
    DECLARE_METHOD(j_explanation, getDetails, METH_NOARGS),
    DECLARE_METHOD(j_explanation, getDescription, METH_NOARGS),
    DECLARE_METHOD(j_explanation, setDescription, METH_O),
    DECLARE_METHOD(j_explanation, getValue, METH_NOARGS),
    DECLARE_METHOD(j_explanation, setValue, METH_O),
    DECLARE_METHOD(j_explanation, toHtml, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Explanation, j_explanation, Object,
             org::apache::lucene::search::Explanation, abstract_init);

/* MatchAllDocsQuery */

class j_matchalldocsquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::MatchAllDocsQuery *object;
};

static int j_matchalldocsquery_init(j_matchalldocsquery *self,
                                    PyObject *args, PyObject *kwds);

static PyMethodDef j_matchalldocsquery_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MatchAllDocsQuery, j_matchalldocsquery, Query,
             org::apache::lucene::search::MatchAllDocsQuery,
             j_matchalldocsquery_init);

/* BooleanClause.Occur */

class j_booleanclause_occur {
public:
    PyObject_HEAD
    org::apache::lucene::search::BooleanClause$Occur *object;
};

static PyMethodDef j_booleanclause_occur_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BooleanClause_Occur, j_booleanclause_occur, Parameter,
             org::apache::lucene::search::BooleanClause$Occur, abstract_init);

/* BooleanClause */

class j_booleanclause {
public:
    PyObject_HEAD
    org::apache::lucene::search::BooleanClause *object;
};

static int j_booleanclause_init(j_booleanclause *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_booleanclause_getQuery(j_booleanclause *self);
static PyObject *j_booleanclause_setQuery(j_booleanclause *self, PyObject *arg);
static PyObject *j_booleanclause_getOccur(j_booleanclause *self);
static PyObject *j_booleanclause_setOccur(j_booleanclause *self, PyObject *arg);
static PyObject *j_booleanclause_isProhibited(j_booleanclause *self);
static PyObject *j_booleanclause_isRequired(j_booleanclause *self);

static PyMethodDef j_booleanclause_methods[] = {
    DECLARE_METHOD(j_booleanclause, getQuery, METH_NOARGS),
    DECLARE_METHOD(j_booleanclause, setQuery, METH_O),
    DECLARE_METHOD(j_booleanclause, getOccur, METH_NOARGS),
    DECLARE_METHOD(j_booleanclause, setOccur, METH_O),
    DECLARE_METHOD(j_booleanclause, isProhibited, METH_NOARGS),
    DECLARE_METHOD(j_booleanclause, isRequired, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BooleanClause, j_booleanclause, Object,
             org::apache::lucene::search::BooleanClause, j_booleanclause_init);

/* BooleanQuery */

class j_booleanquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::BooleanQuery *object;
};

static int j_booleanquery_init(j_booleanquery *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_booleanquery_getUseScorer14(PyTypeObject *type);
static PyObject *j_booleanquery_setUseScorer14(PyTypeObject *type,
                                               PyObject *arg);
static PyObject *j_booleanquery_getMaxClauseCount(PyTypeObject *type);
static PyObject *j_booleanquery_setMaxClauseCount(PyTypeObject *type,
                                                  PyObject *arg);
static PyObject *j_booleanquery_isCoordDisabled(j_booleanquery *self);
static PyObject *j_booleanquery_getClauses(j_booleanquery *self);
static PyObject *j_booleanquery_add(j_booleanquery *self, PyObject *args);
static PyObject *j_booleanquery_getMinimumNumberShouldMatch(j_booleanquery *self);
static PyObject *j_booleanquery_setMinimumNumberShouldMatch(j_booleanquery *self, PyObject *arg);

static PyMethodDef j_booleanquery_methods[] = {
    DECLARE_METHOD(j_booleanquery, getUseScorer14, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_booleanquery, setUseScorer14, METH_O | METH_CLASS),
    DECLARE_METHOD(j_booleanquery, getMaxClauseCount, METH_NOARGS | METH_CLASS),
    DECLARE_METHOD(j_booleanquery, setMaxClauseCount, METH_O | METH_CLASS),
    DECLARE_METHOD(j_booleanquery, isCoordDisabled, METH_NOARGS),
    DECLARE_METHOD(j_booleanquery, getClauses, METH_NOARGS),
    DECLARE_METHOD(j_booleanquery, add, METH_VARARGS),
    DECLARE_METHOD(j_booleanquery, getMinimumNumberShouldMatch, METH_NOARGS),
    DECLARE_METHOD(j_booleanquery, setMinimumNumberShouldMatch, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BooleanQuery, j_booleanquery, Query,
             org::apache::lucene::search::BooleanQuery, j_booleanquery_init);

/* TermQuery */

class j_termquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::TermQuery *object;
};

static int j_termquery_init(j_termquery *self,
                            PyObject *args, PyObject *kwds);
static PyObject *j_termquery_getTerm(j_termquery *self);

static PyMethodDef j_termquery_methods[] = {
    DECLARE_METHOD(j_termquery, getTerm, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermQuery, j_termquery, Query,
             org::apache::lucene::search::TermQuery, j_termquery_init);

/* PrefixQuery */

class j_prefixquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::PrefixQuery *object;
};

static int j_prefixquery_init(j_prefixquery *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_prefixquery_getPrefix(j_prefixquery *self);

static PyMethodDef j_prefixquery_methods[] = {
    DECLARE_METHOD(j_prefixquery, getPrefix, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PrefixQuery, j_prefixquery, Query,
             org::apache::lucene::search::PrefixQuery, j_prefixquery_init);

/* PhraseQuery */

class j_phrasequery {
public:
    PyObject_HEAD
    org::apache::lucene::search::PhraseQuery *object;
};

static int j_phrasequery_init(j_phrasequery *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_phrasequery_getSlop(j_phrasequery *self);
static PyObject *j_phrasequery_setSlop(j_phrasequery *self, PyObject *arg);
static PyObject *j_phrasequery_add(j_phrasequery *self, PyObject *args);
static PyObject *j_phrasequery_getTerms(j_phrasequery *self);
static PyObject *j_phrasequery_getPositions(j_phrasequery *self);

static PyMethodDef j_phrasequery_methods[] = {
    DECLARE_METHOD(j_phrasequery, getSlop, METH_NOARGS),
    DECLARE_METHOD(j_phrasequery, setSlop, METH_O),
    DECLARE_METHOD(j_phrasequery, add, METH_VARARGS),
    DECLARE_METHOD(j_phrasequery, getTerms, METH_NOARGS),
    DECLARE_METHOD(j_phrasequery, getPositions, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PhraseQuery, j_phrasequery, Query,
             org::apache::lucene::search::PhraseQuery, j_phrasequery_init);

/* MultiPhraseQuery */

class j_multiphrasequery {
public:
    PyObject_HEAD
    org::apache::lucene::search::MultiPhraseQuery *object;
};

static int j_multiphrasequery_init(j_multiphrasequery *self,
                                   PyObject *args, PyObject *kwds);
static PyObject *j_multiphrasequery_getSlop(j_multiphrasequery *self);
static PyObject *j_multiphrasequery_setSlop(j_multiphrasequery *self,
                                            PyObject *arg);
static PyObject *j_multiphrasequery_add(j_multiphrasequery *self,
                                        PyObject *args);
static PyObject *j_multiphrasequery_getPositions(j_multiphrasequery *self);

static PyMethodDef j_multiphrasequery_methods[] = {
    DECLARE_METHOD(j_multiphrasequery, getSlop, METH_NOARGS),
    DECLARE_METHOD(j_multiphrasequery, setSlop, METH_O),
    DECLARE_METHOD(j_multiphrasequery, add, METH_VARARGS),
    DECLARE_METHOD(j_multiphrasequery, getPositions, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultiPhraseQuery, j_multiphrasequery, Query,
             org::apache::lucene::search::MultiPhraseQuery,
             j_multiphrasequery_init);

/* FilteredTermEnum */

class j_filteredtermenum {
public:
    PyObject_HEAD
    org::apache::lucene::search::FilteredTermEnum *object;
};

static PyObject *j_filteredtermenum_difference(j_filteredtermenum *self);

static PyMethodDef j_filteredtermenum_methods[] = {
    DECLARE_METHOD(j_filteredtermenum, difference, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FilteredTermEnum, j_filteredtermenum, TermEnum,
             org::apache::lucene::search::FilteredTermEnum, abstract_init);

/* DefaultSimilarity */

class j_defaultsimilarity {
public:
    PyObject_HEAD
    org::apache::lucene::search::DefaultSimilarity *object;
};

static int j_defaultsimilarity_init(j_defaultsimilarity *self,
                                    PyObject *args, PyObject *kwds);

static PyMethodDef j_defaultsimilarity_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DefaultSimilarity, j_defaultsimilarity, Similarity,
             org::apache::lucene::search::DefaultSimilarity,
             j_defaultsimilarity_init);

/* CachingWrapperFilter */

class j_cachingwrapperfilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::CachingWrapperFilter *object;
};

static int j_cachingwrapperfilter_init(j_cachingwrapperfilter *self,
                                       PyObject *args, PyObject *kwds);

static PyMethodDef j_cachingwrapperfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(CachingWrapperFilter, j_cachingwrapperfilter, Filter,
             org::apache::lucene::search::CachingWrapperFilter,
             j_cachingwrapperfilter_init);

/* QueryFilter */

class j_queryfilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::QueryFilter *object;
};

static int j_queryfilter_init(j_queryfilter *self,
                              PyObject *args, PyObject *kwds);

static PyMethodDef j_queryfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryFilter, j_queryfilter, Filter,
             org::apache::lucene::search::QueryFilter,
             j_queryfilter_init);

/* RangeFilter */

class j_rangefilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::RangeFilter *object;
};

static int j_rangefilter_init(j_rangefilter *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_rangefilter_Less(PyTypeObject *type, PyObject *args);
static PyObject *j_rangefilter_More(PyTypeObject *type, PyObject *args);

static PyMethodDef j_rangefilter_methods[] = {
    DECLARE_METHOD(j_rangefilter, Less, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_rangefilter, More, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RangeFilter, j_rangefilter, Filter,
             org::apache::lucene::search::RangeFilter, j_rangefilter_init);

/* PrefixFilter */

class j_prefixfilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::PrefixFilter *object;
};

static int j_prefixfilter_init(j_prefixfilter *self,
                               PyObject *args, PyObject *kwds);

static PyMethodDef j_prefixfilter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PrefixFilter, j_prefixfilter, Filter,
             org::apache::lucene::search::PrefixFilter, j_prefixfilter_init);

/* FuzzyTermEnum */

class j_fuzzytermenum {
public:
    PyObject_HEAD
    org::apache::lucene::search::FuzzyTermEnum *object;
};

static int j_fuzzytermenum_init(j_fuzzytermenum *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_fuzzytermenum_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FuzzyTermEnum, j_fuzzytermenum, FilteredTermEnum,
             org::apache::lucene::search::FuzzyTermEnum, j_fuzzytermenum_init);

/* WildcardTermEnum */

class j_wildcardtermenum {
public:
    PyObject_HEAD
    org::apache::lucene::search::WildcardTermEnum *object;
};

static int j_wildcardtermenum_init(j_wildcardtermenum *self,
                                   PyObject *args, PyObject *kwds);

static PyMethodDef j_wildcardtermenum_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(WildcardTermEnum, j_wildcardtermenum, FilteredTermEnum,
             org::apache::lucene::search::WildcardTermEnum,
             j_wildcardtermenum_init);

/* FilteredQuery */

class j_filteredquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::FilteredQuery *object;
};

static int j_filteredquery_init(j_filteredquery *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_filteredquery_getQuery(j_filteredquery *self);

static PyMethodDef j_filteredquery_methods[] = {
    DECLARE_METHOD(j_filteredquery, getQuery, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FilteredQuery, j_filteredquery, Query,
             org::apache::lucene::search::FilteredQuery, j_filteredquery_init);

/* RangeQuery */

class j_rangequery {
public:
    PyObject_HEAD
    org::apache::lucene::search::RangeQuery *object;
};

static int j_rangequery_init(j_rangequery *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_rangequery_getField(j_rangequery *self);
static PyObject *j_rangequery_getLowerTerm(j_rangequery *self);
static PyObject *j_rangequery_getUpperTerm(j_rangequery *self);
static PyObject *j_rangequery_isInclusive(j_rangequery *self);

static PyMethodDef j_rangequery_methods[] = {
    DECLARE_METHOD(j_rangequery, getField, METH_NOARGS),
    DECLARE_METHOD(j_rangequery, getLowerTerm, METH_NOARGS),
    DECLARE_METHOD(j_rangequery, getUpperTerm, METH_NOARGS),
    DECLARE_METHOD(j_rangequery, isInclusive, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RangeQuery, j_rangequery, Query,
             org::apache::lucene::search::RangeQuery, j_rangequery_init);

/* ConstantScoreQuery */

class j_constantscorequery {
public:
    PyObject_HEAD
    org::apache::lucene::search::ConstantScoreQuery *object;
};

static int j_constantscorequery_init(j_constantscorequery *self,
                                     PyObject *args, PyObject *kwds);

static PyMethodDef j_constantscorequery_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ConstantScoreQuery, j_constantscorequery, Query,
             org::apache::lucene::search::ConstantScoreQuery,
             j_constantscorequery_init);

/* ConstantScoreRangeQuery */

class j_constantscorerangequery {
public:
    PyObject_HEAD
    org::apache::lucene::search::ConstantScoreRangeQuery *object;
};

static int j_constantscorerangequery_init(j_constantscorerangequery *self,
                                          PyObject *args, PyObject *kwds);
static PyObject *j_constantscorerangequery_getField(j_constantscorerangequery *self);
static PyObject *j_constantscorerangequery_getLowerVal(j_constantscorerangequery *self);
static PyObject *j_constantscorerangequery_getUpperVal(j_constantscorerangequery *self);
static PyObject *j_constantscorerangequery_includesLower(j_constantscorerangequery *self);
static PyObject *j_constantscorerangequery_includesUpper(j_constantscorerangequery *self);

static PyMethodDef j_constantscorerangequery_methods[] = {
    DECLARE_METHOD(j_constantscorerangequery, getField, METH_NOARGS),
    DECLARE_METHOD(j_constantscorerangequery, getLowerVal, METH_NOARGS),
    DECLARE_METHOD(j_constantscorerangequery, getUpperVal, METH_NOARGS),
    DECLARE_METHOD(j_constantscorerangequery, includesLower, METH_NOARGS),
    DECLARE_METHOD(j_constantscorerangequery, includesUpper, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(ConstantScoreRangeQuery, j_constantscorerangequery, Query,
             org::apache::lucene::search::ConstantScoreRangeQuery,
             j_constantscorerangequery_init);

/* QueryIterator */

class j_queryiterator {
public:
    PyObject_HEAD
    java::util::Iterator *object;
};

static PyObject *j_queryiterator_next(j_queryiterator *self);

static PyMethodDef j_queryiterator_methods[] = {
    DECLARE_METHOD(j_queryiterator, next, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryIterator, j_queryiterator, Iterator,
             java::util::Iterator, abstract_init);

/* DisjunctionMaxQuery */

class j_disjunctionmaxquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::DisjunctionMaxQuery *object;
};

static int j_disjunctionmaxquery_init(j_disjunctionmaxquery *self,
                                      PyObject *args, PyObject *kwds);
static PyObject *j_disjunctionmaxquery_add(j_disjunctionmaxquery *self, PyObject *arg);
static PyObject *j_disjunctionmaxquery_iterator(j_disjunctionmaxquery *self);

static PyMethodDef j_disjunctionmaxquery_methods[] = {
    DECLARE_METHOD(j_disjunctionmaxquery, add, METH_O),
    DECLARE_METHOD(j_disjunctionmaxquery, iterator, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(DisjunctionMaxQuery, j_disjunctionmaxquery, Query,
             org::apache::lucene::search::DisjunctionMaxQuery,
             j_disjunctionmaxquery_init);

/* FuzzyQuery */

class j_fuzzyquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::FuzzyQuery *object;
};

static int j_fuzzyquery_init(j_fuzzyquery *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_fuzzyquery_getMinSimilarity(j_fuzzyquery *self);
static PyObject *j_fuzzyquery_getPrefixLength(j_fuzzyquery *self);

static PyMethodDef j_fuzzyquery_methods[] = {
    DECLARE_METHOD(j_fuzzyquery, getMinSimilarity, METH_NOARGS),
    DECLARE_METHOD(j_fuzzyquery, getPrefixLength, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FuzzyQuery, j_fuzzyquery, MultiTermQuery,
             org::apache::lucene::search::FuzzyQuery, j_fuzzyquery_init);

/* WildcardQuery */

class j_wildcardquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::WildcardQuery *object;
};

static int j_wildcardquery_init(j_wildcardquery *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_wildcardquery_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(WildcardQuery, j_wildcardquery, MultiTermQuery,
             org::apache::lucene::search::WildcardQuery, j_wildcardquery_init);

/* Spans */

class j_spans {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::Spans *object;
};

static PyObject *j_spans_doc(j_spans *self);
static PyObject *j_spans_start(j_spans *self);
static PyObject *j_spans_end(j_spans *self);
static PyObject *j_spans_next(j_spans *self);
static PyObject *j_spans_skipTo(j_spans *self, PyObject *arg);

static PyMethodDef j_spans_methods[] = {
    DECLARE_METHOD(j_spans, doc, METH_NOARGS),
    DECLARE_METHOD(j_spans, start, METH_NOARGS),
    DECLARE_METHOD(j_spans, end, METH_NOARGS),
    DECLARE_METHOD(j_spans, next, METH_NOARGS),
    DECLARE_METHOD(j_spans, skipTo, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Spans, j_spans, Query, org::apache::lucene::search::spans::Spans,
             abstract_init);

/* SpanQuery */

class j_spanquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanQuery *object;
};

static PyObject *j_spanquery_getField(j_spanquery *self);
static PyObject *j_spanquery_getTerms(j_spanquery *self);
static PyObject *j_spanquery_getSpans(j_spanquery *self, PyObject *arg);

static PyMethodDef j_spanquery_methods[] = {
    DECLARE_METHOD(j_spanquery, getField, METH_NOARGS),
    DECLARE_METHOD(j_spanquery, getTerms, METH_NOARGS),
    DECLARE_METHOD(j_spanquery, getSpans, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanQuery, j_spanquery, Query,
             org::apache::lucene::search::spans::SpanQuery, abstract_init);

/* SpanFirstQuery */

class j_spanfirstquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanFirstQuery *object;
};

static int j_spanfirstquery_init(j_spanfirstquery *self,
                                 PyObject *args, PyObject *kwds);
static PyObject *j_spanfirstquery_getEnd(j_spanfirstquery *self);
static PyObject *j_spanfirstquery_getMatch(j_spanfirstquery *self);

static PyMethodDef j_spanfirstquery_methods[] = {
    DECLARE_METHOD(j_spanfirstquery, getEnd, METH_NOARGS),
    DECLARE_METHOD(j_spanfirstquery, getMatch, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanFirstQuery, j_spanfirstquery, SpanQuery,
             org::apache::lucene::search::spans::SpanFirstQuery,
             j_spanfirstquery_init);

/* SpanNearQuery */

class j_spannearquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanNearQuery *object;
};

static int j_spannearquery_init(j_spannearquery *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_spannearquery_getClauses(j_spannearquery *self);
static PyObject *j_spannearquery_getSlop(j_spannearquery *self);
static PyObject *j_spannearquery_isInOrder(j_spannearquery *self);

static PyMethodDef j_spannearquery_methods[] = {
    DECLARE_METHOD(j_spannearquery, getClauses, METH_NOARGS),
    DECLARE_METHOD(j_spannearquery, getSlop, METH_NOARGS),
    DECLARE_METHOD(j_spannearquery, isInOrder, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanNearQuery, j_spannearquery, SpanQuery,
             org::apache::lucene::search::spans::SpanNearQuery,
             j_spannearquery_init);

/* SpanNotQuery */

class j_spannotquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanNotQuery *object;
};

static int j_spannotquery_init(j_spannotquery *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_spannotquery_getExclude(j_spannotquery *self);
static PyObject *j_spannotquery_getInclude(j_spannotquery *self);

static PyMethodDef j_spannotquery_methods[] = {
    DECLARE_METHOD(j_spannotquery, getExclude, METH_NOARGS),
    DECLARE_METHOD(j_spannotquery, getInclude, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanNotQuery, j_spannotquery, SpanQuery,
             org::apache::lucene::search::spans::SpanNotQuery,
             j_spannotquery_init);

/* SpanOrQuery */

class j_spanorquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanOrQuery *object;
};

static int j_spanorquery_init(j_spanorquery *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_spanorquery_getClauses(j_spanorquery *self);

static PyMethodDef j_spanorquery_methods[] = {
    DECLARE_METHOD(j_spanorquery, getClauses, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanOrQuery, j_spanorquery, SpanQuery,
             org::apache::lucene::search::spans::SpanOrQuery,
             j_spanorquery_init);

/* SpanTermQuery */

class j_spantermquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::spans::SpanTermQuery *object;
};

static int j_spantermquery_init(j_spantermquery *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_spantermquery_getTerm(j_spantermquery *self);

static PyMethodDef j_spantermquery_methods[] = {
    DECLARE_METHOD(j_spantermquery, getTerm, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanTermQuery, j_spantermquery, SpanQuery,
             org::apache::lucene::search::spans::SpanTermQuery,
             j_spantermquery_init);

/* RegexCapabilities */

class j_regexcapabilities {
public:
    PyObject_HEAD
    org::apache::lucene::search::regex::RegexCapabilities *object;
};

static PyObject *j_regexcapabilities_compile(j_regexcapabilities *self,
                                             PyObject *arg);
static PyObject *j_regexcapabilities_match(j_regexcapabilities *self,
                                           PyObject *arg);
static PyObject *j_regexcapabilities_prefix(j_regexcapabilities *self);

static PyMethodDef j_regexcapabilities_methods[] = {
    DECLARE_METHOD(j_regexcapabilities, compile, METH_O),
    DECLARE_METHOD(j_regexcapabilities, match, METH_O),
    DECLARE_METHOD(j_regexcapabilities, prefix, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RegexCapabilities, j_regexcapabilities, Object,
             org::apache::lucene::search::regex::RegexCapabilities,
             abstract_init);

/* PythonRegexCapabilities */

class j_pythonregexcapabilities {
public:
    PyObject_HEAD
    org::apache::lucene::search::regex::PythonRegexCapabilities *object;
};

static int j_pythonregexcapabilities_init(j_pythonregexcapabilities *self,
                                          PyObject *args, PyObject *kwds);

static PyMethodDef j_pythonregexcapabilities_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(PythonRegexCapabilities, j_pythonregexcapabilities,
             RegexCapabilities,
             org::apache::lucene::search::regex::PythonRegexCapabilities,
             j_pythonregexcapabilities_init);

/* RegexQuery */

class j_regexquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::regex::RegexQuery *object;
};

static int j_regexquery_init(j_regexquery *self,
                             PyObject *args, PyObject *kwds);
static PyObject * j_regexquery_getRegexImplementation(j_regexquery *self);

static PyMethodDef j_regexquery_methods[] = {
    DECLARE_METHOD(j_regexquery, getRegexImplementation, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(RegexQuery, j_regexquery, MultiTermQuery,
             org::apache::lucene::search::regex::RegexQuery, j_regexquery_init);

/* SpanRegexQuery */

class j_spanregexquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::regex::SpanRegexQuery *object;
};

static int j_spanregexquery_init(j_spanregexquery *self,
                                 PyObject *args, PyObject *kwds);
static PyObject *j_spanregexquery_getRegexImplementation(j_spanregexquery *self);
static PyObject *j_spanregexquery_getTerm(j_spanregexquery *self);

static PyMethodDef j_spanregexquery_methods[] = {
    DECLARE_METHOD(j_spanregexquery, getRegexImplementation, METH_NOARGS),
    DECLARE_METHOD(j_spanregexquery, getTerm, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanRegexQuery, j_spanregexquery, SpanQuery,
             org::apache::lucene::search::regex::SpanRegexQuery,
             j_spanregexquery_init);

/* MoreLikeThis */

class j_morelikethis {
public:
    PyObject_HEAD
    org::apache::lucene::search::similar::MoreLikeThis *object;
};

static int j_morelikethis_init(j_morelikethis *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_morelikethis_getAnalyzer(j_morelikethis *self);
static PyObject *j_morelikethis_setAnalyzer(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMinTermFreq(j_morelikethis *self);
static PyObject *j_morelikethis_setMinTermFreq(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMinDocFreq(j_morelikethis *self);
static PyObject *j_morelikethis_setMinDocFreq(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_isBoost(j_morelikethis *self);
static PyObject *j_morelikethis_setBoost(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getFieldNames(j_morelikethis *self);
static PyObject *j_morelikethis_setFieldNames(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMinWordLen(j_morelikethis *self);
static PyObject *j_morelikethis_setMinWordLen(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMaxWordLen(j_morelikethis *self);
static PyObject *j_morelikethis_setMaxWordLen(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMaxQueryTerms(j_morelikethis *self);
static PyObject *j_morelikethis_setMaxQueryTerms(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_getMaxNumTokensParsed(j_morelikethis *self);
static PyObject *j_morelikethis_setMaxNumTokensParsed(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_like(j_morelikethis *self, PyObject *arg);
static PyObject *j_morelikethis_describeParams(j_morelikethis *self);

static PyMethodDef j_morelikethis_methods[] = {
    DECLARE_METHOD(j_morelikethis, getAnalyzer, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setAnalyzer, METH_O),
    DECLARE_METHOD(j_morelikethis, getMinTermFreq, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMinTermFreq, METH_O),
    DECLARE_METHOD(j_morelikethis, getMinDocFreq, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMinDocFreq, METH_O),
    DECLARE_METHOD(j_morelikethis, isBoost, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setBoost, METH_O),
    DECLARE_METHOD(j_morelikethis, getFieldNames, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setFieldNames, METH_O),
    DECLARE_METHOD(j_morelikethis, getMinWordLen, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMinWordLen, METH_O),
    DECLARE_METHOD(j_morelikethis, getMaxWordLen, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMaxWordLen, METH_O),
    DECLARE_METHOD(j_morelikethis, getMaxQueryTerms, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMaxQueryTerms, METH_O),
    DECLARE_METHOD(j_morelikethis, getMaxNumTokensParsed, METH_NOARGS),
    DECLARE_METHOD(j_morelikethis, setMaxNumTokensParsed, METH_O),
    DECLARE_METHOD(j_morelikethis, like, METH_O),
    DECLARE_METHOD(j_morelikethis, describeParams, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MoreLikeThis, j_morelikethis, Object,
             org::apache::lucene::search::similar::MoreLikeThis, j_morelikethis_init);

/* MoreLikeThisQuery */

class j_morelikethisquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::similar::MoreLikeThisQuery *object;
};

static int j_morelikethisquery_init(j_morelikethisquery *self,
                                    PyObject *args, PyObject *kwds);
static PyObject *j_morelikethisquery_getPercentTermsToMatch(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setPercentTermsToMatch(j_morelikethisquery *self, PyObject *arg);
static PyObject *j_morelikethisquery_getAnalyzer(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setAnalyzer(j_morelikethisquery *self, PyObject *arg);
static PyObject *j_morelikethisquery_getLikeText(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setLikeText(j_morelikethisquery *self, PyObject *arg);
static PyObject *j_morelikethisquery_getMaxQueryTerms(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setMaxQueryTerms(j_morelikethisquery *self, PyObject *arg);
static PyObject *j_morelikethisquery_getMinTermFrequency(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setMinTermFrequency(j_morelikethisquery *self, PyObject *arg);
static PyObject *j_morelikethisquery_getMoreLikeFields(j_morelikethisquery *self);
static PyObject *j_morelikethisquery_setMoreLikeFields(j_morelikethisquery *self, PyObject *arg);

static PyMethodDef j_morelikethisquery_methods[] = {
    DECLARE_METHOD(j_morelikethisquery, getPercentTermsToMatch, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setPercentTermsToMatch, METH_O),
    DECLARE_METHOD(j_morelikethisquery, getAnalyzer, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setAnalyzer, METH_O),
    DECLARE_METHOD(j_morelikethisquery, getLikeText, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setLikeText, METH_O),
    DECLARE_METHOD(j_morelikethisquery, getMaxQueryTerms, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setMaxQueryTerms, METH_O),
    DECLARE_METHOD(j_morelikethisquery, getMinTermFrequency, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setMinTermFrequency, METH_O),
    DECLARE_METHOD(j_morelikethisquery, getMoreLikeFields, METH_NOARGS),
    DECLARE_METHOD(j_morelikethisquery, setMoreLikeFields, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MoreLikeThisQuery, j_morelikethisquery, Query,
             org::apache::lucene::search::similar::MoreLikeThisQuery, j_morelikethisquery_init);

/* FuzzyLikeThisQuery */

class j_fuzzylikethisquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::FuzzyLikeThisQuery *object;
};

static int j_fuzzylikethisquery_init(j_fuzzylikethisquery *self,
                                     PyObject *args, PyObject *kwds);
static PyObject *j_fuzzylikethisquery_addTerms(j_fuzzylikethisquery *self, PyObject *args);
static PyObject *j_fuzzylikethisquery_isIgnoreTF(j_fuzzylikethisquery *self);
static PyObject *j_fuzzylikethisquery_setIgnoreTF(j_fuzzylikethisquery *self, PyObject *arg);

static PyMethodDef j_fuzzylikethisquery_methods[] = {
    DECLARE_METHOD(j_fuzzylikethisquery, addTerms, METH_VARARGS),
    DECLARE_METHOD(j_fuzzylikethisquery, isIgnoreTF, METH_NOARGS),
    DECLARE_METHOD(j_fuzzylikethisquery, setIgnoreTF, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FuzzyLikeThisQuery, j_fuzzylikethisquery, Query,
             org::apache::lucene::search::FuzzyLikeThisQuery, j_fuzzylikethisquery_init);

/* BooleanFilter */

class j_booleanfilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::BooleanFilter *object;
};

static int j_booleanfilter_init(j_booleanfilter *self,
                                PyObject *args, PyObject *kwds);
static PyObject *j_booleanfilter_add(j_booleanfilter *self, PyObject *arg);

static PyMethodDef j_booleanfilter_methods[] = {
    DECLARE_METHOD(j_booleanfilter, add, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BooleanFilter, j_booleanfilter, Filter,
             org::apache::lucene::search::BooleanFilter, j_booleanfilter_init);

/* FilterClause */

class j_filterclause {
public:
    PyObject_HEAD
    org::apache::lucene::search::FilterClause *object;
};

static int j_filterclause_init(j_filterclause *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_filterclause_getFilter(j_filterclause *self);
static PyObject *j_filterclause_getOccur(j_filterclause *self);

static PyMethodDef j_filterclause_methods[] = {
    DECLARE_METHOD(j_filterclause, getFilter, METH_O),
    DECLARE_METHOD(j_filterclause, getOccur, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(FilterClause, j_filterclause, Object,
             org::apache::lucene::search::FilterClause, j_filterclause_init);

/* TermsFilter */

class j_termsfilter {
public:
    PyObject_HEAD
    org::apache::lucene::search::TermsFilter *object;
};

static int j_termsfilter_init(j_termsfilter *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_termsfilter_addTerm(j_termsfilter *self, PyObject *arg);

static PyMethodDef j_termsfilter_methods[] = {
    DECLARE_METHOD(j_termsfilter, addTerm, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TermsFilter, j_termsfilter, Filter,
             org::apache::lucene::search::TermsFilter, j_termsfilter_init);

/* BoostingQuery */

class j_boostingquery {
public:
    PyObject_HEAD
    org::apache::lucene::search::BoostingQuery *object;
};

static int j_boostingquery_init(j_boostingquery *self,
                                PyObject *args, PyObject *kwds);

static PyMethodDef j_boostingquery_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(BoostingQuery, j_boostingquery, Query,
             org::apache::lucene::search::BoostingQuery, j_boostingquery_init);

/* TokenGroup */

class j_tokengroup {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::TokenGroup *object;
};

static int j_tokengroup_init(j_tokengroup *self,
                             PyObject *args, PyObject *kwds);
static PyObject *j_tokengroup_getToken(j_tokengroup *self, PyObject *arg);
static PyObject *j_tokengroup_getScore(j_tokengroup *self, PyObject *arg);
static PyObject *j_tokengroup_getStartOffset(j_tokengroup *self);
static PyObject *j_tokengroup_getEndOffset(j_tokengroup *self);
static PyObject *j_tokengroup_getNumTokens(j_tokengroup *self);
static PyObject *j_tokengroup_getTotalScore(j_tokengroup *self);

static PyMethodDef j_tokengroup_methods[] = {
    DECLARE_METHOD(j_tokengroup, getToken, METH_O),
    DECLARE_METHOD(j_tokengroup, getScore, METH_O),
    DECLARE_METHOD(j_tokengroup, getStartOffset, METH_NOARGS),
    DECLARE_METHOD(j_tokengroup, getEndOffset, METH_NOARGS),
    DECLARE_METHOD(j_tokengroup, getNumTokens, METH_NOARGS),
    DECLARE_METHOD(j_tokengroup, getTotalScore, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TokenGroup, j_tokengroup, Object,
             org::apache::lucene::search::highlight::TokenGroup,
             j_tokengroup_init);

/* TextFragment */

class j_textfragment {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::TextFragment *object;
};

static int j_textfragment_init(j_textfragment *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_textfragment_getScore(j_textfragment *self);
static PyObject *j_textfragment_merge(j_textfragment *self, PyObject *arg);
static PyObject *j_textfragment_follows(j_textfragment *self, PyObject *arg);
static PyObject *j_textfragment_getFragNum(j_textfragment *self);

static PyMethodDef j_textfragment_methods[] = {
    DECLARE_METHOD(j_textfragment, getScore, METH_NOARGS),
    DECLARE_METHOD(j_textfragment, merge, METH_O),
    DECLARE_METHOD(j_textfragment, follows, METH_O),
    DECLARE_METHOD(j_textfragment, getFragNum, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(TextFragment, j_textfragment, Object,
             org::apache::lucene::search::highlight::TextFragment,
             j_textfragment_init);

/* WeightedTerm */

class j_weightedterm {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::WeightedTerm *object;
};

static int j_weightedterm_init(j_weightedterm *self,
                               PyObject *args, PyObject *kwds);
static PyObject *j_weightedterm_getTerm(j_weightedterm *self);
static PyObject *j_weightedterm_setTerm(j_weightedterm *self, PyObject *arg);
static PyObject *j_weightedterm_getWeight(j_weightedterm *self);
static PyObject *j_weightedterm_setWeight(j_weightedterm *self, PyObject *arg);

static PyMethodDef j_weightedterm_methods[] = {
    DECLARE_METHOD(j_weightedterm, getTerm, METH_NOARGS),
    DECLARE_METHOD(j_weightedterm, setTerm, METH_O),
    DECLARE_METHOD(j_weightedterm, getWeight, METH_NOARGS),
    DECLARE_METHOD(j_weightedterm, setWeight, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(WeightedTerm, j_weightedterm, Object,
             org::apache::lucene::search::highlight::WeightedTerm,
             j_weightedterm_init);

/* Formatter */

class j_formatter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::Formatter *object;
};

static int j_formatter_init(j_formatter *self, PyObject *args, PyObject *kwds);
static PyObject *j_formatter_highlightTerm(j_formatter *self, PyObject *args);

static PyMethodDef j_formatter_methods[] = {
    DECLARE_METHOD(j_formatter, highlightTerm, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Formatter, j_formatter, Object,
             org::apache::lucene::search::highlight::Formatter, abstract_init);

static int check_Formatter(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "highlightTerm");
}

static org::apache::lucene::search::highlight::Formatter *make_Formatter(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::highlight::Formatter *)
        new org::osafoundation::search::highlight::PythonFormatter(ptr);
}

/* Fragmenter */

class j_fragmenter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::Fragmenter *object;
};

static PyObject *j_fragmenter_start(j_fragmenter *self, PyObject *arg);
static PyObject *j_fragmenter_isNewFragment(j_fragmenter *self, PyObject *arg);

static PyMethodDef j_fragmenter_methods[] = {
    DECLARE_METHOD(j_fragmenter, start, METH_O),
    DECLARE_METHOD(j_fragmenter, isNewFragment, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Fragmenter, j_fragmenter, Object,
             org::apache::lucene::search::highlight::Fragmenter, abstract_init);

static int check_Fragmenter(PyObject *arg)
{
    return PyObject_HasAttrString(arg, "isNewFragment");
}

static org::apache::lucene::search::highlight::Fragmenter *make_Fragmenter(PyObject *arg)
{
    jlong ptr; *(PyObject **) &ptr = arg;

    return (org::apache::lucene::search::highlight::Fragmenter *)
        new org::osafoundation::search::highlight::PythonFragmenter(ptr);
}

/* HighlightScorer */

class j_highlightscorer {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::Scorer *object;
};

static PyObject *j_highlightscorer_getFragmentScore(j_highlightscorer *self);
static PyObject *j_highlightscorer_getTokenScore(j_highlightscorer *self, PyObject *arg);
static PyObject *j_highlightscorer_startFragment(j_highlightscorer *self, PyObject *arg);

static PyMethodDef j_highlightscorer_methods[] = {
    DECLARE_METHOD(j_highlightscorer, getFragmentScore, METH_NOARGS),
    DECLARE_METHOD(j_highlightscorer, getTokenScore, METH_O),
    DECLARE_METHOD(j_highlightscorer, startFragment, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(HighlightScorer, j_highlightscorer, Object,
             org::apache::lucene::search::highlight::Scorer, abstract_init);

/* QueryTermExtractor */

class j_querytermextractor {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::QueryTermExtractor *object;
};

static PyObject *j_querytermextractor_getTerms(PyTypeObject *type,
                                               PyObject *args);
static PyObject *j_querytermextractor_getIdfWeightedTerms(PyTypeObject *type,
                                                          PyObject *args);

static PyMethodDef j_querytermextractor_methods[] = {
    DECLARE_METHOD(j_querytermextractor, getTerms, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_querytermextractor, getIdfWeightedTerms, METH_VARARGS | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryTermExtractor, j_querytermextractor, Object,
             org::apache::lucene::search::highlight::QueryTermExtractor,
             abstract_init);


/* SimpleHTMLFormatter */

class j_simplehtmlformatter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::SimpleHTMLFormatter *object;
};

static int j_simplehtmlformatter_init(j_simplehtmlformatter *self,
                                      PyObject *args, PyObject *kwds);

static PyMethodDef j_simplehtmlformatter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SimpleHTMLFormatter, j_simplehtmlformatter, Formatter,
             org::apache::lucene::search::highlight::SimpleHTMLFormatter,
             j_simplehtmlformatter_init);

/* GradientFormatter */

class j_gradientformatter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::GradientFormatter *object;
};

static int j_gradientformatter_init(j_gradientformatter *self,
                                    PyObject *args, PyObject *kwds);
static PyObject *j_gradientformatter_hexToInt(PyTypeObject *type,
                                              PyObject *arg);

static PyMethodDef j_gradientformatter_methods[] = {
    DECLARE_METHOD(j_gradientformatter, hexToInt, METH_O | METH_CLASS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(GradientFormatter, j_gradientformatter, Formatter,
             org::apache::lucene::search::highlight::GradientFormatter,
             j_gradientformatter_init);

/* SpanGradientFormatter */

class j_spangradientformatter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::SpanGradientFormatter *object;
};

static int j_spangradientformatter_init(j_spangradientformatter *self,
                                        PyObject *args, PyObject *kwds);

static PyMethodDef j_spangradientformatter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SpanGradientFormatter, j_spangradientformatter, GradientFormatter,
             org::apache::lucene::search::highlight::SpanGradientFormatter,
             j_spangradientformatter_init);

/* SimpleFragmenter */

class j_simplefragmenter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::SimpleFragmenter *object;
};

static int j_simplefragmenter_init(j_simplefragmenter *self,
                                   PyObject *args, PyObject *kwds);
static PyObject *j_simplefragmenter_getFragmentSize(j_simplefragmenter *self);
static PyObject *j_simplefragmenter_setFragmentSize(j_simplefragmenter *self,
                                                    PyObject *arg);

static PyMethodDef j_simplefragmenter_methods[] = {
    DECLARE_METHOD(j_simplefragmenter, getFragmentSize, METH_NOARGS),
    DECLARE_METHOD(j_simplefragmenter, setFragmentSize, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(SimpleFragmenter, j_simplefragmenter, Fragmenter,
             org::apache::lucene::search::highlight::SimpleFragmenter,
             j_simplefragmenter_init);

/* NullFragmenter */

class j_nullfragmenter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::NullFragmenter *object;
};

static int j_nullfragmenter_init(j_nullfragmenter *self,
                                 PyObject *args, PyObject *kwds);

static PyMethodDef j_nullfragmenter_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(NullFragmenter, j_nullfragmenter, Fragmenter,
             org::apache::lucene::search::highlight::NullFragmenter,
             j_nullfragmenter_init);

/* QueryScorer */

class j_queryscorer {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::QueryScorer *object;
};

static int j_queryscorer_init(j_queryscorer *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_queryscorer_allFragmentsProcessed(j_queryscorer *self);
static PyObject *j_queryscorer_getMaxTermWeight(j_queryscorer *self);

static PyMethodDef j_queryscorer_methods[] = {
    DECLARE_METHOD(j_queryscorer, allFragmentsProcessed, METH_NOARGS),
    DECLARE_METHOD(j_queryscorer, getMaxTermWeight, METH_NOARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryScorer, j_queryscorer, HighlightScorer,
             org::apache::lucene::search::highlight::QueryScorer,
             j_queryscorer_init);

/* Highlighter */

class j_highlighter {
public:
    PyObject_HEAD
    org::apache::lucene::search::highlight::Highlighter *object;
};

static int j_highlighter_init(j_highlighter *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_highlighter_getBestFragment(j_highlighter *self,
                                               PyObject *args);
static PyObject *j_highlighter_getBestFragments(j_highlighter *self,
                                                PyObject *args);
static PyObject *j_highlighter_getBestTextFragments(j_highlighter *self,
                                                    PyObject *args);
static PyObject *j_highlighter_getMaxDocBytesToAnalyze(j_highlighter *self);
static PyObject *j_highlighter_setMaxDocBytesToAnalyze(j_highlighter *self,
                                                       PyObject *arg);
static PyObject *j_highlighter_getTextFragmenter(j_highlighter *self);
static PyObject *j_highlighter_setTextFragmenter(j_highlighter *self,
                                                 PyObject *arg);
static PyObject *j_highlighter_getFragmentScorer(j_highlighter *self);
static PyObject *j_highlighter_setFragmentScorer(j_highlighter *self,
                                                 PyObject *arg);

static PyMethodDef j_highlighter_methods[] = {
    DECLARE_METHOD(j_highlighter, getBestFragment, METH_VARARGS),
    DECLARE_METHOD(j_highlighter, getBestFragments, METH_VARARGS),
    DECLARE_METHOD(j_highlighter, getBestTextFragments, METH_VARARGS),
    DECLARE_METHOD(j_highlighter, getMaxDocBytesToAnalyze, METH_NOARGS),
    DECLARE_METHOD(j_highlighter, setMaxDocBytesToAnalyze, METH_O),
    DECLARE_METHOD(j_highlighter, getTextFragmenter, METH_NOARGS),
    DECLARE_METHOD(j_highlighter, setTextFragmenter, METH_O),
    DECLARE_METHOD(j_highlighter, getFragmentScorer, METH_NOARGS),
    DECLARE_METHOD(j_highlighter, setFragmentScorer, METH_O),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(Highlighter, j_highlighter, Object,
             org::apache::lucene::search::highlight::Highlighter,
             j_highlighter_init);

/* QueryParser.Operator */

class j_queryparser_operator {
public:
    PyObject_HEAD
    org::apache::lucene::queryParser::QueryParser$Operator *object;
};

static PyMethodDef j_queryparser_operator_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryParser_Operator, j_queryparser_operator, Parameter,
             org::apache::lucene::queryParser::QueryParser$Operator,
             abstract_init);

/* QueryParser */

class j_queryparser {
public:
    PyObject_HEAD
    org::apache::lucene::queryParser::QueryParser *object;
};

static int j_queryparser_init(j_queryparser *self,
                              PyObject *args, PyObject *kwds);
static PyObject *j_queryparser_escape(PyTypeObject *type, PyObject *arg);
static PyObject *j_queryparser_main(PyTypeObject *type, PyObject *arg);
static PyObject *j_queryparser_parse(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_Clause(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_Query(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_Term(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_Modifiers(j_queryparser *self);
static PyObject *j_queryparser_Conjunction(j_queryparser *self);
static PyObject *j_queryparser_getAnalyzer(j_queryparser *self);
static PyObject *j_queryparser_getField(j_queryparser *self);
static PyObject *j_queryparser_getFuzzyMinSim(j_queryparser *self);
static PyObject *j_queryparser_setFuzzyMinSim(j_queryparser *self,
                                              PyObject *arg);
static PyObject *j_queryparser_getLocale(j_queryparser *self);
static PyObject *j_queryparser_setLocale(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_getLowercaseExpandedTerms(j_queryparser *self);
static PyObject *j_queryparser_setLowercaseExpandedTerms(j_queryparser *self,
                                                         PyObject *arg);
static PyObject *j_queryparser_getUseOldRangeQuery(j_queryparser *self);
static PyObject *j_queryparser_setUseOldRangeQuery(j_queryparser *self,
                                                   PyObject *arg);
static PyObject *j_queryparser_getDefaultOperator(j_queryparser *self);
static PyObject *j_queryparser_setDefaultOperator(j_queryparser *self,
                                                  PyObject *arg);
static PyObject *j_queryparser_getNextToken(j_queryparser *self);
static PyObject *j_queryparser_getToken(j_queryparser *self, PyObject *arg);
static PyObject *j_queryparser_getPhraseSlop(j_queryparser *self);
static PyObject *j_queryparser_setPhraseSlop(j_queryparser *self,
                                             PyObject *arg);
static PyObject *j_queryparser_getBooleanQuery(j_queryparser *self,
                                               PyObject *arg);
static PyObject *j_queryparser_getFieldQuery(j_queryparser *self,
                                             PyObject *args);
static PyObject *j_queryparser_getFuzzyQuery(j_queryparser *self,
                                             PyObject *args);
static PyObject *j_queryparser_getPrefixQuery(j_queryparser *self,
                                              PyObject *args);
static PyObject *j_queryparser_getRangeQuery(j_queryparser *self,
                                             PyObject *args);
static PyObject *j_queryparser_getWildcardQuery(j_queryparser *self,
                                                PyObject *args);

static PyMethodDef j_queryparser_methods[] = {
    DECLARE_METHOD(j_queryparser, escape, METH_O | METH_CLASS),
    DECLARE_METHOD(j_queryparser, main, METH_O | METH_CLASS),
    DECLARE_METHOD(j_queryparser, parse, METH_O),
    DECLARE_METHOD(j_queryparser, Clause, METH_O),
    DECLARE_METHOD(j_queryparser, Query, METH_O),
    DECLARE_METHOD(j_queryparser, Term, METH_O),
    DECLARE_METHOD(j_queryparser, Modifiers, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, Conjunction, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, getAnalyzer, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, getField, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, getFuzzyMinSim, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setFuzzyMinSim, METH_O),
    DECLARE_METHOD(j_queryparser, getLocale, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setLocale, METH_O),
    DECLARE_METHOD(j_queryparser, getLowercaseExpandedTerms, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setLowercaseExpandedTerms, METH_O),
    DECLARE_METHOD(j_queryparser, getUseOldRangeQuery, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setUseOldRangeQuery, METH_O),
    DECLARE_METHOD(j_queryparser, getDefaultOperator, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setDefaultOperator, METH_O),
    DECLARE_METHOD(j_queryparser, getNextToken, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, getToken, METH_O),
    DECLARE_METHOD(j_queryparser, getPhraseSlop, METH_NOARGS),
    DECLARE_METHOD(j_queryparser, setPhraseSlop, METH_O),
    DECLARE_METHOD(j_queryparser, getBooleanQuery, METH_O),
    DECLARE_METHOD(j_queryparser, getFieldQuery, METH_VARARGS),
    DECLARE_METHOD(j_queryparser, getFuzzyQuery, METH_VARARGS),
    DECLARE_METHOD(j_queryparser, getPrefixQuery, METH_VARARGS),
    DECLARE_METHOD(j_queryparser, getRangeQuery, METH_VARARGS),
    DECLARE_METHOD(j_queryparser, getWildcardQuery, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryParser, j_queryparser, Object,
             org::apache::lucene::queryParser::QueryParser,
             j_queryparser_init);

static int check_QueryParser(PyObject *arg)
{
    return 1;
}

/* QueryParserToken */

class j_queryparsertoken {
public:
    PyObject_HEAD
    org::apache::lucene::queryParser::Token *object;
};

static PyMethodDef j_queryparsertoken_methods[] = {
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(QueryParserToken, j_queryparsertoken, Object,
             org::apache::lucene::queryParser::Token, abstract_init);

/* MultiFieldQueryParser */

class j_multifieldqueryparser {
public:
    PyObject_HEAD
    org::apache::lucene::queryParser::MultiFieldQueryParser *object;
};

static int j_multifieldqueryparser_init(j_multifieldqueryparser *self,
                                        PyObject *args, PyObject *kwds);
static PyObject *j_multifieldqueryparser_parseQueries(PyTypeObject *type,
                                                      PyObject *args);
static PyObject *j_multifieldqueryparser_getBooleanQuery(j_multifieldqueryparser *self, PyObject *arg);
static PyObject *j_multifieldqueryparser_getFieldQuery(j_multifieldqueryparser *self, PyObject *args);
static PyObject *j_multifieldqueryparser_getFuzzyQuery(j_multifieldqueryparser *self, PyObject *args);
static PyObject *j_multifieldqueryparser_getPrefixQuery(j_multifieldqueryparser *self, PyObject *args);
static PyObject *j_multifieldqueryparser_getRangeQuery(j_multifieldqueryparser *self, PyObject *args);
static PyObject *j_multifieldqueryparser_getWildcardQuery(j_multifieldqueryparser *self, PyObject *args);

static PyMethodDef j_multifieldqueryparser_methods[] = {
    DECLARE_METHOD(j_multifieldqueryparser, parseQueries, METH_VARARGS | METH_CLASS),
    DECLARE_METHOD(j_multifieldqueryparser, getBooleanQuery, METH_O),
    DECLARE_METHOD(j_multifieldqueryparser, getFieldQuery, METH_VARARGS),
    DECLARE_METHOD(j_multifieldqueryparser, getFuzzyQuery, METH_VARARGS),
    DECLARE_METHOD(j_multifieldqueryparser, getPrefixQuery, METH_VARARGS),
    DECLARE_METHOD(j_multifieldqueryparser, getRangeQuery, METH_VARARGS),
    DECLARE_METHOD(j_multifieldqueryparser, getWildcardQuery, METH_VARARGS),
    { NULL, NULL, 0, NULL }
};

DECLARE_TYPE(MultiFieldQueryParser, j_multifieldqueryparser, QueryParser,
             org::apache::lucene::queryParser::MultiFieldQueryParser,
             j_multifieldqueryparser_init);

static int check_MultiFieldQueryParser(PyObject *arg)
{
    return 1;
}


/* LucenePackage */

static PyObject *j_lucenepackage_get(PyTypeObject *type)
{
    java::lang::Package *package;

    OBJ_CALL(package = org::apache::lucene::LucenePackage::get());
    return wrap_Package(package);
}


/* IndexInput */

static int j_indexinput_init(j_indexinput *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::IndexInput *input;

    if (!parseArgs(args, "P", &org::apache::lucene::store::IndexInput::class$,
                   check_IndexInput, &input, make_IndexInput))
    {
        if (input)
        {
            self->object = input;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_indexinput_close(j_indexinput *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_indexinput_getFilePointer(j_indexinput *self)
{
    jlong pointer;

    OBJ_CALL(pointer = self->object->getFilePointer());
    return PyLong_FromLongLong(pointer);
}

static PyObject *j_indexinput_length(j_indexinput *self)
{
    jlong length;

    OBJ_CALL(length = self->object->length());
    return PyLong_FromLongLong(length);
}

static PyObject *j_indexinput_readByte(j_indexinput *self)
{
    jbyte b;

    OBJ_CALL(b = self->object->readByte());
    return PyString_FromStringAndSize((char *) &b, 1);
}

static PyObject *j_indexinput_readInt(j_indexinput *self)
{
    jint n;

    OBJ_CALL(n = self->object->readInt());
    return PyInt_FromLong(n);
}

static PyObject *j_indexinput_readLong(j_indexinput *self)
{
    jlong l;

    OBJ_CALL(l = self->object->readLong());
    return PyLong_FromLongLong(l);
}

static PyObject *j_indexinput_readString(j_indexinput *self)
{
    jstring s;

    OBJ_CALL(s = self->object->readString());
    return j2p(s);
}

static PyObject *j_indexinput_readVInt(j_indexinput *self)
{
    jint n;

    OBJ_CALL(n = self->object->readVInt());
    return PyInt_FromLong(n);
}

static PyObject *j_indexinput_readVLong(j_indexinput *self)
{
    jlong l;

    OBJ_CALL(l = self->object->readVLong());
    return PyLong_FromLongLong(l);
}

static PyObject *j_indexinput_seek(j_indexinput *self, PyObject *arg)
{
    jlong position;

    if (!parseArg(arg, "L", &position))
    {
        OBJ_CALL(self->object->seek(position));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "seek", arg);
}


/* IndexOutput */

static int j_indexoutput_init(j_indexoutput *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::IndexOutput *output;

    if (!parseArgs(args, "P", &org::apache::lucene::store::IndexOutput::class$,
                   check_IndexOutput, &output, make_IndexOutput))
    {
        if (output)
        {
            self->object = output;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_indexoutput_close(j_indexoutput *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_indexoutput_flush(j_indexoutput *self)
{
    OBJ_CALL(self->object->flush());
    Py_RETURN_NONE;
}

static PyObject *j_indexoutput_getFilePointer(j_indexoutput *self)
{
    jlong pointer;

    OBJ_CALL(pointer = self->object->getFilePointer());
    return PyLong_FromLongLong(pointer);
}

static PyObject *j_indexoutput_length(j_indexoutput *self)
{
    jlong length;

    OBJ_CALL(length = self->object->length());
    return PyLong_FromLongLong(length);
}

static PyObject *j_indexoutput_seek(j_indexoutput *self, PyObject *arg)
{
    jlong position;

    if (!parseArg(arg, "L", &position))
    {
        OBJ_CALL(self->object->seek(position));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "seek", arg);
}

static PyObject *j_indexoutput_writeByte(j_indexoutput *self, PyObject *arg)
{
    jbyte b;

    if (!parseArg(arg, "a", &b))
    {
        OBJ_CALL(self->object->writeByte(b));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeByte", arg);
}

static PyObject *j_indexoutput_writeBytes(j_indexoutput *self, PyObject *args)
{
    jbyteArray b;
    jint length;

    if (!parseArgs(args, "Ai", &b, &length))
    {
        OBJ_CALL(self->object->writeBytes(b, length));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeBytes", args);
}

static PyObject *j_indexoutput_writeChars(j_indexoutput *self, PyObject *args)
{
    jstring string;
    jint start, length;

    if (!parseArgs(args, "sii", &string, &start, &length))
    {
        OBJ_CALL(self->object->writeChars(string, start, length));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeChars", args);
}

static PyObject *j_indexoutput_writeInt(j_indexoutput *self, PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(self->object->writeInt(n));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeInt", arg);
}

static PyObject *j_indexoutput_writeLong(j_indexoutput *self, PyObject *arg)
{
    jlong l;

    if (!parseArg(arg, "L", &l))
    {
        OBJ_CALL(self->object->writeLong(l));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeLong", arg);
}

static PyObject *j_indexoutput_writeString(j_indexoutput *self, PyObject *arg)
{
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(self->object->writeString(s));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeString", arg);
}

static PyObject *j_indexoutput_writeVInt(j_indexoutput *self, PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(self->object->writeVInt(n));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeVInt", arg);
}

static PyObject *j_indexoutput_writeVLong(j_indexoutput *self, PyObject *arg)
{
    jlong l;

    if (!parseArg(arg, "L", &l))
    {
        OBJ_CALL(self->object->writeVLong(l));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeVLong", arg);
}


/* Lock */

static int j_lock_init(j_lock *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::Lock *lock;

    if (!parseArgs(args, "P", &org::apache::lucene::store::Lock::class$,
                   check_Lock, &lock, make_Lock))
    {
        if (lock)
        {
            self->object = lock;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_lock_isLocked(j_lock *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->isLocked());
    Py_RETURN_BOOL(b);
}

static PyObject *j_lock_obtain(j_lock *self, PyObject *args)
{
    switch (PyTuple_GET_SIZE(args)) {
      case 0:
      {
          OBJ_CALL(self->object->obtain());
          Py_RETURN_NONE;
      }
      case 1:
      {
          long long timeout;

          if (PyArg_ParseTuple(args, "L", &timeout))
          {
              OBJ_CALL(self->object->obtain(timeout));
              Py_RETURN_NONE;
          }
          return NULL;
      }
    }

    return PyErr_SetArgsError((PyObject *) self, "obtain", args);
}

static PyObject *j_lock_release(j_lock *self)
{
    OBJ_CALL(self->object->release());
    Py_RETURN_NONE;
}


/* Directory */

static int j_directory_init(j_directory *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::Directory *directory;

    if (!parseArgs(args, "P", &org::apache::lucene::store::Directory::class$,
                   check_Directory, &directory, make_Directory))
    {
        if (directory)
        {
            self->object = directory;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_directory_close(j_directory *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_directory_createOutput(j_directory *self, PyObject *arg)
{
    org::apache::lucene::store::IndexOutput *output;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(output = self->object->createOutput(name));
        return wrap_IndexOutput(output);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "createOutput", arg);
}

static PyObject *j_directory_openInput(j_directory *self, PyObject *arg)
{
    org::apache::lucene::store::IndexInput *input;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(input = self->object->openInput(name));
        return wrap_IndexInput(input);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "createInput", arg);
}

static PyObject *j_directory_deleteFile(j_directory *self, PyObject *arg)
{
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(self->object->deleteFile(name));
        Py_RETURN_NONE;
    }
    
    return PyErr_SetArgsError((PyObject *) self, "deleteFile", arg);
}

static PyObject *j_directory_renameFile(j_directory *self, PyObject *args)
{
    jstring from, to;

    if (!parseArgs(args, "ss", &from, &to))
    {
        OBJ_CALL(self->object->renameFile(from, to));
        Py_RETURN_NONE;
    }
    
    return PyErr_SetArgsError((PyObject *) self, "renameFile", args);
}

static PyObject *j_directory_touchFile(j_directory *self, PyObject *arg)
{
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(self->object->touchFile(name));
        Py_RETURN_NONE;
    }
    
    return PyErr_SetArgsError((PyObject *) self, "touchFile", arg);
}

static PyObject *j_directory_fileExists(j_directory *self, PyObject *arg)
{
    jstring name;
    jboolean b;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(b = self->object->fileExists(name));
        Py_RETURN_BOOL(b);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "fileExists", arg);
}

static PyObject *j_directory_fileLength(j_directory *self, PyObject *arg)
{
    jstring name;
    jlong length;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(length = self->object->fileExists(name));
        return PyLong_FromLongLong(length);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "fileLength", arg);
}

static PyObject *j_directory_fileModified(j_directory *self, PyObject *arg)
{
    jstring name;
    jboolean b;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(b = self->object->fileModified(name));
        Py_RETURN_BOOL(b);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "fileExists", arg);
}

static PyObject *j_directory_list(j_directory *self)
{
    jstringArray names;

    OBJ_CALL(names = self->object->list());
    return jsa2psl(names);
}

static PyObject *j_directory_makeLock(j_directory *self, PyObject *arg)
{
    org::apache::lucene::store::Lock *lock;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(lock = self->object->makeLock(name));
        return wrap_Lock(lock);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "makeLock", arg);
}


/* FSDirectory */

static PyObject *j_fsdirectory_getDirectory(PyTypeObject *type, PyObject *args)
{
    org::apache::lucene::store::FSDirectory *dir;
    jstring path;
    jboolean create;

    if (!parseArgs(args, "sb", &path, &create))
    {
        OBJ_CALL(dir = org::apache::lucene::store::FSDirectory::getDirectory(path, create));
        return wrap_FSDirectory(dir);
    }

    return PyErr_SetArgsError(type, "getDirectory", args);
}

static PyObject *j_fsdirectory_getDisableLocks(PyTypeObject *type)
{
    jboolean b;

    OBJ_CALL(b = org::apache::lucene::store::FSDirectory::getDisableLocks());
    Py_RETURN_BOOL(b);
}

static PyObject *j_fsdirectory_setDisableLocks(PyTypeObject *type,
                                               PyObject *arg)
{
    jboolean b;

    if (!parseArg(arg, "b", &b))
    {
        OBJ_CALL(org::apache::lucene::store::FSDirectory::setDisableLocks(b));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "setDisableLocks", arg);
}

static PyObject *j_fsdirectory_getFile(j_fsdirectory *self)
{
    java::io::File *file;

    OBJ_CALL(file = self->object->getFile());
    return j2p(file->getCanonicalPath());
}


/* MMapDirectory */

static PyObject *j_mmapdirectory_getDirectory(PyTypeObject *type,
                                              PyObject *args)
{
    org::apache::lucene::store::FSDirectory *dir;
    jstring path;
    jboolean create;

    if (!parseArgs(args, "sb", &path, &create))
    {
        OBJ_CALL(dir = org::apache::lucene::store::MMapDirectory::getDirectory(path, create));
        return wrap_FSDirectory(dir);
    }

    return PyErr_SetArgsError(type, "getDirectory", args);
}


#ifdef _WITH_DB_DIRECTORY

/* DbDirectory */

static int j_dbdirectory_init(j_dbdirectory *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::db::DbDirectory *dir;
    com::sleepycat::db::internal::DbTxn *txn;
    com::sleepycat::db::internal::Db *files, *blocks;
    PyObject *txnObj, *filesObj, *blocksObj;
    int flags;

    if (PyArg_ParseTuple(args, "OOOi", &txnObj, &filesObj, &blocksObj, &flags))
    {
        if (txnObj == Py_None)
            txn = NULL;
        else
        {
            jlong ptr; *(DB_TXN **) &ptr = ((DBTxnObject *) txnObj)->txn;
            txn = new com::sleepycat::db::internal::DbTxn(ptr, 0);
        }
    
        if (filesObj == Py_None)
            files = NULL;
        else
        {
            jlong ptr; *(DB **) &ptr = ((DBObject *) filesObj)->db;
            files = new com::sleepycat::db::internal::Db(ptr, 0);
        }

        if (blocksObj == Py_None)
            blocks = NULL;
        else
        {
            jlong ptr; *(DB **) &ptr = ((DBObject *) blocksObj)->db;
            blocks = new com::sleepycat::db::internal::Db(ptr, 0);
        }

        INT_CALL(dir = new org::apache::lucene::store::db::DbDirectory(txn, files, blocks, flags));
        self->object = dir;

        if (self->object)
        {
            refObject(self->object);
            return 0;
        }

        return -1;
    }
    
    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

#endif


/* RAMDirectory */

static int j_ramdirectory_init(j_ramdirectory *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::store::RAMDirectory *dir;
    org::apache::lucene::store::Directory *d;
    jstring s;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(dir = new org::apache::lucene::store::RAMDirectory());
        self->object = dir;
        break;
      case 1:
        if (!parseArgs(args, "s", &s))
        {
            INT_CALL(dir = new org::apache::lucene::store::RAMDirectory(s));
            self->object = dir;
            break;
        }
        if (!parseArgs(args, "P",
                       &org::apache::lucene::store::Directory::class$,
                       check_Directory, &d, make_Directory))
        {
            INT_CALL(dir = new org::apache::lucene::store::RAMDirectory(d));
            self->object = dir;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* RAMOutputStream */

DEFINE_0_INIT(j_ramoutputstream, org::apache::lucene::store::RAMOutputStream);

static PyObject *j_ramoutputstream_reset(j_ramoutputstream *self)
{
    OBJ_CALL(self->object->reset());
    Py_RETURN_NONE;
}

static PyObject *j_ramoutputstream_writeTo(j_ramoutputstream *self,
                                           PyObject *arg)
{
    org::apache::lucene::store::IndexOutput *output;

    if (!parseArg(arg, "P",
                  &org::apache::lucene::store::IndexOutput::class$,
                  check_IndexOutput, &output, make_IndexOutput))
    {
        OBJ_CALL(self->object->writeTo(output));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "writeTo", arg);
}


/* Token */

static int j_token_init(j_token *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::Token *token;
    jstring text, type;
    jint start, end;

    switch (PyTuple_GET_SIZE(args)) {
      case 3:
        if (!parseArgs(args, "sii", &text, &start, &end))
        {
            INT_CALL(token = new org::apache::lucene::analysis::Token(text, start, end));
            self->object = token;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 4:
        if (!parseArgs(args, "siis", &text, &start, &end, &type))
        {
            INT_CALL(token = new org::apache::lucene::analysis::Token(text, start, end, type));
            self->object = token;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_token_startOffset(j_token *self)
{
    jint offset;

    OBJ_CALL(offset = self->object->startOffset());
    return PyInt_FromLong(offset);
}

static PyObject *j_token_endOffset(j_token *self)
{
    jint offset;

    OBJ_CALL(offset = self->object->endOffset());
    return PyInt_FromLong(offset);
}

DEFINE_INT_GETSET(PositionIncrement, j_token);

static PyObject *j_token_termText(j_token *self)
{
    jstring text;

    OBJ_CALL(text = self->object->termText());
    return j2p(text);
}

static PyObject *j_token_type(j_token *self)
{
    jstring type;

    OBJ_CALL(type = self->object->type());
    return j2p(type);
}


/* TokenStream */

static int j_tokenstream_init(j_tokenstream *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        if (stream)
        {
            self->object = stream;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_tokenstream_close(j_tokenstream *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_tokenstream_next(j_tokenstream *self)
{
    org::apache::lucene::analysis::Token *token;

    OBJ_CALL(token = self->object->next());
    return wrap_Token(token);
}

static PyObject *j_tokenstream_charTokenizer(j_tokenstream *self,
                                             PyObject *args)
{
    org::apache::lucene::analysis::CharTokenizer *tokenizer;
    jlong ptr;
    java::io::Reader *reader;
    
    if (!parseArgs(args, "EP", check_CharTokenizer,
                   &java::io::Reader::class$, check_Reader,
                   &ptr, &reader, make_Reader))
    {
        OBJ_CALL(tokenizer = (org::apache::lucene::analysis::CharTokenizer *) new org::osafoundation::analysis::PythonCharTokenizer(ptr, reader));
        return wrap_CharTokenizer(tokenizer);
    }

    return PyErr_SetArgsError((PyObject *) self, "charTokenizer", args);
}

static PyObject *j_tokenstream_tokenFilter(j_tokenstream *self, PyObject *arg)
{
    org::apache::lucene::analysis::TokenFilter *filter;
    jlong ptr;

    if (!parseArg(arg, "E", check_TokenFilter, &ptr))
    {
        OBJ_CALL(filter = (org::apache::lucene::analysis::TokenFilter *) new org::osafoundation::analysis::PythonTokenFilter(ptr, self->object));
        return wrap_TokenFilter(filter);
    }

    return PyErr_SetArgsError((PyObject *) self, "tokenFilter", arg);
}

static PyObject *j_tokenstream_iter(j_tokenstream *self)
{
    org::osafoundation::util::TokenEnumeration *e;

    OBJ_CALL(e = new org::osafoundation::util::TokenEnumeration(self->object));
    return wrap_TokenEnumeration(e);
}


/* TokenEnumeration */

static PyObject *j_tokenenumeration_nextElement(j_tokenenumeration *self)
{
    jobject obj;

    EXC_OBJ_CALL(obj = self->object->nextElement(),
                 java::util::NoSuchElementException,
                 PyErr_SetNone(PyExc_StopIteration); return NULL);

    return wrap_Token((org::apache::lucene::analysis::Token *) obj);
}


/* Analyzer */

static int j_analyzer_init(j_analyzer *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "P", &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &analyzer, make_Analyzer))
    {
        if (analyzer)
        {
            self->object = analyzer;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_analyzer_tokenStream(j_analyzer *self, PyObject *args)
{
    org::apache::lucene::analysis::TokenStream *stream;
    jstring fieldName;
    java::io::Reader *reader;

    if (!parseArgs(args, "sP", &java::io::Reader::class$,
                   check_Reader, &fieldName, &reader, make_Reader))
    {
        OBJ_CALL(stream = self->object->tokenStream(fieldName, reader));
        return wrap_TokenStream(stream);
    }

    return PyErr_SetArgsError((PyObject *) self, "tokenStream", args);
}

static PyObject *j_analyzer_getPositionIncrementGap(j_analyzer *self,
                                                    PyObject *arg)
{
    jint increment;
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(increment = self->object->getPositionIncrementGap(string));
        return PyInt_FromLong(increment);
    }

    return PyErr_SetArgsError((PyObject *) self, "getPositionIncrementGap", arg);
}

DEFINE_DOWNCAST(j_analyzer, GermanAnalyzer,
                org::apache::lucene::analysis::de::GermanAnalyzer);
DEFINE_DOWNCAST(j_analyzer, PerFieldAnalyzerWrapper,
                org::apache::lucene::analysis::PerFieldAnalyzerWrapper);
DEFINE_DOWNCAST(j_analyzer, RussianAnalyzer,
                org::apache::lucene::analysis::ru::RussianAnalyzer);
DEFINE_DOWNCAST(j_analyzer, SimpleAnalyzer,
                org::apache::lucene::analysis::SimpleAnalyzer);
DEFINE_DOWNCAST(j_analyzer, StandardAnalyzer,
                org::apache::lucene::analysis::standard::StandardAnalyzer);
DEFINE_DOWNCAST(j_analyzer, StopAnalyzer,
                org::apache::lucene::analysis::StopAnalyzer);
DEFINE_DOWNCAST(j_analyzer, WhitespaceAnalyzer,
                org::apache::lucene::analysis::WhitespaceAnalyzer);

static PyObject *j_analyzer_queryParser(j_analyzer *self, PyObject *args)
{
    org::apache::lucene::queryParser::QueryParser *parser;
    jlong ptr;
    jstring field;

    if (!parseArgs(args, "Es", check_QueryParser, &ptr, &field))
    {
        OBJ_CALL(parser = (org::apache::lucene::queryParser::QueryParser *) new org::osafoundation::queryParser::PythonQueryParser(ptr, field, self->object));
        return wrap_QueryParser(parser);
    }

    return PyErr_SetArgsError((PyObject *) self, "queryParser", args);
}

static PyObject *j_analyzer_multiFieldQueryParser(j_analyzer *self,
                                                  PyObject *args)
{
    org::apache::lucene::queryParser::MultiFieldQueryParser *parser;
    jlong ptr;
    jstringArray fields;

    if (!parseArgs(args, "ES", check_MultiFieldQueryParser, &ptr, &fields))
    {
        OBJ_CALL(parser = (org::apache::lucene::queryParser::MultiFieldQueryParser *) new org::osafoundation::queryParser::PythonMultiFieldQueryParser(ptr, fields, self->object));
        return wrap_MultiFieldQueryParser(parser);
    }

    return PyErr_SetArgsError((PyObject *) self, "multiFieldQueryParser", args);
}


/* LetterTokenizer */

static int j_lettertokenizer_init(j_lettertokenizer *self,
                                  PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::LetterTokenizer *tokenizer;
    java::io::Reader *reader;

    if (!parseArgs(args, "P", &java::io::Reader::class$,
                   check_Reader, &reader, make_Reader))
    {
        INT_CALL(tokenizer = new org::apache::lucene::analysis::LetterTokenizer(reader));
        if (tokenizer)
        {
            self->object = tokenizer;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* LowerCaseTokenizer */

static int j_lowercasetokenizer_init(j_lowercasetokenizer *self,
                                     PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::LowerCaseTokenizer *tokenizer;
    java::io::Reader *reader;

    if (!parseArgs(args, "P", &java::io::Reader::class$,
                   check_Reader, &reader, make_Reader))
    {
        INT_CALL(tokenizer = new org::apache::lucene::analysis::LowerCaseTokenizer(reader));
        if (tokenizer)
        {
            self->object = tokenizer;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

/* LowerCaseFilter */

static int j_lowercasefilter_init(j_lowercasefilter *self,
                                     PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::LowerCaseFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::LowerCaseFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

/* ISOLatin1AccentFilter */

static int j_isolatin1accentfilter_init(j_isolatin1accentfilter *self,
                                        PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::ISOLatin1AccentFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::ISOLatin1AccentFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_isolatin1accentfilter_removeAccents(PyTypeObject *type,
                                                       PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = org::apache::lucene::analysis::ISOLatin1AccentFilter::removeAccents(string));
        return j2p(string);
    }

    return PyErr_SetArgsError(type, "removeAccents", arg);
}


/* KeywordAnalyzer */

DEFINE_0_INIT(j_keywordanalyzer,
              org::apache::lucene::analysis::KeywordAnalyzer);


/* KeywordTokenizer */

static int j_keywordtokenizer_init(j_keywordtokenizer *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::KeywordTokenizer *tokenizer;
    java::io::Reader *reader;
    jint size;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::KeywordTokenizer(reader));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "Pi", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader, &size))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::KeywordTokenizer(reader, size));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* LengthFilter */

static int j_lengthfilter_init(j_lengthfilter *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::LengthFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jint m, M;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "Pii",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream,
                       &m, &M))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::LengthFilter(stream, m, M));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* PorterStemFilter */

static int j_porterstemfilter_init(j_porterstemfilter *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::PorterStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::PorterStemFilter(stream));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* StopFilter */

static int j_stopfilter_init(j_stopfilter *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::StopFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jstringArray words;
    jboolean b;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "PS",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream, &words))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::StopFilter(stream, words));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "PSb",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream,
                       &words, &b))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::StopFilter(stream, words, b));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* SimpleAnalyzer */

DEFINE_0_INIT(j_simpleanalyzer, org::apache::lucene::analysis::SimpleAnalyzer);


/* StopAnalyzer */

static int j_stopanalyzer_init(j_stopanalyzer *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::StopAnalyzer *analyzer;
    java::io::Reader *reader;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::StopAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::StopAnalyzer(words));
            self->object = analyzer;
            break;
        }
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::StopAnalyzer(reader));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* WhitespaceAnalyzer */

DEFINE_0_INIT(j_whitespaceanalyzer,
              org::apache::lucene::analysis::WhitespaceAnalyzer);


/* WhitespaceTokenizer */

static int j_whitespacetokenizer_init(j_whitespacetokenizer *self,
                                      PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::WhitespaceTokenizer *tokenizer;
    java::io::Reader *reader;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::WhitespaceTokenizer(reader));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* PerFieldAnalyzerWrapper */

static int j_perfieldanalyzerwrapper_init(j_perfieldanalyzerwrapper *self,
                                          PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::PerFieldAnalyzerWrapper *wrapper;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &analyzer, make_Analyzer))
    {
        INT_CALL(wrapper = new org::apache::lucene::analysis::PerFieldAnalyzerWrapper(analyzer));
        self->object = wrapper;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_perfieldanalyzerwrapper_addAnalyzer(j_perfieldanalyzerwrapper *self, PyObject *args)
{
    jstring fieldName;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "sP",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &fieldName, &analyzer, make_Analyzer))
    {
        OBJ_CALL(self->object->addAnalyzer(fieldName, analyzer));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "addAnalyzer", args);
}


/* StandardAnalyzer */

static int j_standardanalyzer_init(j_standardanalyzer *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::standard::StandardAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::standard::StandardAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::standard::StandardAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* StandardFilter */

static int j_standardfilter_init(j_standardfilter *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::standard::StandardFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::standard::StandardFilter(stream));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* StandardTokenizer */

static int j_standardtokenizer_init(j_standardtokenizer *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::standard::StandardTokenizer *tokenizer;
    java::io::Reader *reader;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::standard::StandardTokenizer(reader));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* BrazilianAnalyzer */

static int j_braziliananalyzer_init(j_braziliananalyzer *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::br::BrazilianAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::br::BrazilianAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::br::BrazilianAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_braziliananalyzer_setStemExclusionTable(j_braziliananalyzer *self, PyObject *arg)
{
    jstringArray table;
    
    if (!parseArg(arg, "S", &table))
    {
        OBJ_CALL(self->object->setStemExclusionTable(table));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setStemExclusionTable", arg);
}

/* BrazilianStemmer */

DEFINE_0_INIT(j_brazilianstemmer,
              org::apache::lucene::analysis::br::BrazilianStemmer);

static PyObject *j_brazilianstemmer_stem(j_brazilianstemmer *self,
                                         PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->stem(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "stem", arg);
}


/* BrazilianStemFilter */

static int j_brazilianstemfilter_init(j_brazilianstemfilter *self,
                                      PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::br::BrazilianStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::br::BrazilianStemFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

/* CJKAnalyzer */

static int j_cjkanalyzer_init(j_cjkanalyzer *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::cjk::CJKAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::cjk::CJKAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::cjk::CJKAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* CJKTokenizer */

static int j_cjktokenizer_init(j_cjktokenizer *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::cjk::CJKTokenizer *tokenizer;
    java::io::Reader *reader;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::cjk::CJKTokenizer(reader));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* ChineseAnalyzer */

DEFINE_0_INIT(j_chineseanalyzer,
              org::apache::lucene::analysis::cn::ChineseAnalyzer);


/* ChineseFilter */

static int j_chinesefilter_init(j_chinesefilter *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::cn::ChineseFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::cn::ChineseFilter(stream));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* ChineseTokenizer */

static int j_chinesetokenizer_init(j_chinesetokenizer *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::cn::ChineseTokenizer *tokenizer;
    java::io::Reader *reader;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "P", &java::io::Reader::class$,
                       check_Reader, &reader, make_Reader))
        {
            INT_CALL(tokenizer = new org::apache::lucene::analysis::cn::ChineseTokenizer(reader));
            self->object = tokenizer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* CzechAnalyzer */

static int j_czechanalyzer_init(j_czechanalyzer *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::cz::CzechAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::cz::CzechAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::cz::CzechAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* GermanAnalyzer */

static int j_germananalyzer_init(j_germananalyzer *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::de::GermanAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::de::GermanAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::de::GermanAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_germananalyzer_setStemExclusionTable(j_germananalyzer *self, PyObject *arg)
{
    jstringArray table;
    
    if (!parseArg(arg, "S", &table))
    {
        OBJ_CALL(self->object->setStemExclusionTable(table));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setStemExclusionTable", arg);
}

/* GermanStemmer */

DEFINE_0_INIT(j_germanstemmer,
              org::apache::lucene::analysis::de::GermanStemmer);

static PyObject *j_germanstemmer_stem(j_germanstemmer *self, PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->stem(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "stem", arg);
}


/* GermanStemFilter */

static int j_germanstemfilter_init(j_germanstemfilter *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::de::GermanStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::de::GermanStemFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* GreekAnalyzer */

static int j_greekanalyzer_init(j_greekanalyzer *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::el::GreekAnalyzer *analyzer;
    jcharArray charset;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::el::GreekAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "P", &JArray<jchar>::class$,
                       check_Charset, &charset, make_Charset))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::el::GreekAnalyzer(charset));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "PS", &JArray<jchar>::class$,
                       check_Charset, &charset, make_Charset, &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::el::GreekAnalyzer(charset, words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* GreekLowerCaseFilter */

static int j_greeklowercasefilter_init(j_greeklowercasefilter *self,
                                       PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::el::GreekLowerCaseFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jcharArray charset;

    if (!parseArgs(args, "PP",
                   &org::apache::lucene::analysis::TokenStream::class$, check_TokenStream,
                   &JArray<jchar>::class$, check_Charset,
                   &stream, make_TokenStream, &charset, make_Charset))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::el::GreekLowerCaseFilter(stream, charset));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* GreekCharsets */

static PyObject *j_greekcharsets_toLowerCase(PyTypeObject *type, PyObject *args)
{
    jchar c;
    jcharArray charset;

    if (!parseArgs(args, "cP", &JArray<jchar>::class$, check_Charset,
                   &c, &charset, make_Charset))
    {
        OBJ_CALL(c = org::apache::lucene::analysis::el::GreekCharsets::toLowerCase(c, charset));
        Py_UNICODE u = (Py_UNICODE) c;
        return PyUnicode_FromUnicode(&u, 1);
    }

    return PyErr_SetArgsError(type, "toLowerCase", args);
}


/* FrenchAnalyzer */

static int j_frenchanalyzer_init(j_frenchanalyzer *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::fr::FrenchAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::fr::FrenchAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::fr::FrenchAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_frenchanalyzer_setStemExclusionTable(j_frenchanalyzer *self,
                                                        PyObject *arg)
{
    jstringArray table;
    
    if (!parseArg(arg, "S", &table))
    {
        OBJ_CALL(self->object->setStemExclusionTable(table));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setStemExclusionTable", arg);
}

/* FrenchStemmer */

DEFINE_0_INIT(j_frenchstemmer,
              org::apache::lucene::analysis::fr::FrenchStemmer);

static PyObject *j_frenchstemmer_stem(j_frenchstemmer *self, PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->stem(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "stem", arg);
}


/* FrenchStemFilter */

static int j_frenchstemfilter_init(j_frenchstemfilter *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::fr::FrenchStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::fr::FrenchStemFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* DutchAnalyzer */

static int j_dutchanalyzer_init(j_dutchanalyzer *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::nl::DutchAnalyzer *analyzer;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::nl::DutchAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "S", &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::nl::DutchAnalyzer(words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_dutchanalyzer_setStemExclusionTable(j_dutchanalyzer *self,
                                                       PyObject *arg)
{
    jstringArray table;
    
    if (!parseArg(arg, "S", &table))
    {
        OBJ_CALL(self->object->setStemExclusionTable(table));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setStemExclusionTable", arg);
}

/* DutchStemmer */

DEFINE_0_INIT(j_dutchstemmer,
              org::apache::lucene::analysis::nl::DutchStemmer);

static PyObject *j_dutchstemmer_stem(j_dutchstemmer *self, PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->stem(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "stem", arg);
}


/* DutchStemFilter */

static int j_dutchstemfilter_init(j_dutchstemfilter *self,
                                  PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::nl::DutchStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::nl::DutchStemFilter(stream));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* RussianAnalyzer */

static int j_russiananalyzer_init(j_russiananalyzer *self,
                                  PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::ru::RussianAnalyzer *analyzer;
    jcharArray charset;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(analyzer = new org::apache::lucene::analysis::ru::RussianAnalyzer());
        self->object = analyzer;
        break;
      case 1:
        if (!parseArgs(args, "P", &JArray<jchar>::class$,
                       check_Charset, &charset, make_Charset))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::ru::RussianAnalyzer(charset));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "PS", &JArray<jchar>::class$,
                       check_Charset, &charset, make_Charset, &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::ru::RussianAnalyzer(charset, words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* RussianStemmer */

DEFINE_0_INIT(j_russianstemmer,
              org::apache::lucene::analysis::ru::RussianStemmer);

static PyObject *j_russianstemmer_stem(j_russianstemmer *self, PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->stem(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "stem", arg);
}


/* RussianStemFilter */

static int j_russianstemfilter_init(j_russianstemfilter *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::ru::RussianStemFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jcharArray charset;

    if (!parseArgs(args, "PP",
                   &org::apache::lucene::analysis::TokenStream::class$, check_TokenStream, 
                   &JArray<jchar>::class$,
                   &stream, make_TokenStream,
                   check_Charset, &charset, make_Charset))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::ru::RussianStemFilter(stream, charset));

        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* RussianLowerCaseFilter */

static int j_russianlowercasefilter_init(j_russianlowercasefilter *self,
                                         PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::ru::RussianLowerCaseFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jcharArray charset;

    if (!parseArgs(args, "PP",
                   &org::apache::lucene::analysis::TokenStream::class$, check_TokenStream,
                   &JArray<jchar>::class$, check_Charset,
                   &stream, make_TokenStream, &charset, make_Charset))
    {
        INT_CALL(filter = new org::apache::lucene::analysis::ru::RussianLowerCaseFilter(stream, charset));
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}


/* RussianCharsets */

static PyObject *j_russiancharsets_toLowerCase(PyTypeObject *type,
                                               PyObject *args)
{
    jchar c;
    jcharArray charset;

    if (!parseArgs(args, "cP", &JArray<jchar>::class$, check_Charset,
                   &c, &charset, make_Charset))
    {
        OBJ_CALL(c = org::apache::lucene::analysis::ru::RussianCharsets::toLowerCase(c, charset));
        Py_UNICODE u = (Py_UNICODE) c;
        return PyUnicode_FromUnicode(&u, 1);
    }

    return PyErr_SetArgsError(type, "toLowerCase", args);
}


/* SnowballAnalyzer */

static int j_snowballanalyzer_init(j_snowballanalyzer *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::snowball::SnowballAnalyzer *analyzer;
    jstring name;
    jstringArray words;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "s", &name))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::snowball::SnowballAnalyzer(name));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "sS", &name, &words))
        {
            INT_CALL(analyzer = new org::apache::lucene::analysis::snowball::SnowballAnalyzer(name, words));
            self->object = analyzer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* SnowballFilter */

static int j_snowballfilter_init(j_snowballfilter *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::analysis::snowball::SnowballFilter *filter;
    org::apache::lucene::analysis::TokenStream *stream;
    jstring name;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "Ps",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream,
                       &name))
        {
            INT_CALL(filter = new org::apache::lucene::analysis::snowball::SnowballFilter(stream, name));
            self->object = filter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* Field */

static int j_field_init(j_field *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::document::Field *field;
    jstring name, value;
    java::io::Reader *reader;
    jbyteArray bytes;
    org::apache::lucene::document::Field$Store *store;
    org::apache::lucene::document::Field$Index *index;
    org::apache::lucene::document::Field$TermVector *termVector;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "sP",
                       &java::io::Reader::class$, check_Reader, 
                       &name, &reader, make_Reader))
        {
            INT_CALL(field = new org::apache::lucene::document::Field(name, reader));
            self->object = field;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "sPJ",
                       &java::io::Reader::class$, check_Reader,
                       &org::apache::lucene::document::Field$TermVector::class$,
                       &name, &reader, make_Reader, &termVector))
        {
            INT_CALL(field = new org::apache::lucene::document::Field(name, reader, termVector));
            self->object = field;
            break;
        }
        if (!parseArgs(args, "sAJ",
                       &org::apache::lucene::document::Field$Store::class$,
                       &name, &bytes, &store))
        {
            INT_CALL(field = new org::apache::lucene::document::Field(name, bytes, store));
            self->object = field;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 4:
        if (!parseArgs(args, "ssJJ",
                       &org::apache::lucene::document::Field$Store::class$,
                       &org::apache::lucene::document::Field$Index::class$,
                       &name, &value, &store, &index))
        {
            INT_CALL(field = new org::apache::lucene::document::Field(name, value, store, index));
            self->object = field;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 5:
        if (!parseArgs(args, "ssJJJ",
                       &org::apache::lucene::document::Field$Store::class$,
                       &org::apache::lucene::document::Field$Index::class$,
                       &org::apache::lucene::document::Field$TermVector::class$,
                       &name, &value, &store, &index, &termVector))
        {
            INT_CALL(field = new org::apache::lucene::document::Field(name, value, store, index, termVector));
            self->object = field;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_BOOL_GETTER(Indexed, j_field);
DEFINE_BOOL_GETTER(Stored, j_field);
DEFINE_BOOL_GETTER(Tokenized, j_field);
DEFINE_BOOL_GETTER(Compressed, j_field);
DEFINE_BOOL_GETTER(Binary, j_field);
DEFINE_BOOL_GETTER(TermVectorStored, j_field);
DEFINE_BOOL_GETTER(StoreOffsetWithTermVector, j_field);
DEFINE_BOOL_GETTER(StorePositionWithTermVector, j_field);

static PyObject *j_field_name(j_field *self)
{
    jstring name;

    OBJ_CALL(name = self->object->name());
    return j2p(name);
}

static PyObject *j_field_stringValue(j_field *self)
{
    jstring value;

    OBJ_CALL(value = self->object->stringValue());
    return j2p(value);
}

static PyObject *j_field_readerValue(j_field *self)
{
    java::io::Reader *reader;

    OBJ_CALL(reader = self->object->readerValue());
    return wrap_Reader(reader);
}

static PyObject *j_field_binaryValue(j_field *self)
{
    jbyteArray bytes;

    OBJ_CALL(bytes = self->object->binaryValue());
    if (bytes)
        return PyString_FromStringAndSize((char *) elements(bytes),
                                          JvGetArrayLength(bytes));
    Py_RETURN_NONE;
}

static PyObject *j_field_getBoost(j_field *self)
{
    jfloat boost;

    OBJ_CALL(boost = self->object->getBoost());
    return PyFloat_FromDouble((double) boost);
}

static PyObject *j_field_setBoost(j_field *self, PyObject *arg)
{
    jdouble boost;

    if (!parseArg(arg, "d", &boost))
    {
        OBJ_CALL(self->object->setBoost((jfloat) boost));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setBoost", arg);
}

DEFINE_BOOL_GETSET(OmitNorms, j_field);


/* DateField */

static PyObject *j_datefield_dateToString(PyTypeObject *type, PyObject *arg)
{
    java::util::Date *date;
    jstring string;

    if (!parseArg(arg, "J", &java::util::Date::class$, &date))
    {
        OBJ_CALL(string = org::apache::lucene::document::DateField::dateToString(date));
        return j2p(string);
    }

    return PyErr_SetArgsError(type, "dateToString", arg);
}

static PyObject *j_datefield_stringToDate(PyTypeObject *type, PyObject *arg)
{
    java::util::Date *date;
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(date = org::apache::lucene::document::DateField::stringToDate(string));
        return wrap_Date(date);
    }

    return PyErr_SetArgsError(type, "stringToDate", arg);
}

static PyObject *j_datefield_MAX_DATE_STRING(PyTypeObject *type)
{
    jstring string;

    OBJ_CALL(string = org::apache::lucene::document::DateField::MAX_DATE_STRING());
    return j2p(string);
}

static PyObject *j_datefield_MIN_DATE_STRING(PyTypeObject *type)
{
    jstring string;

    OBJ_CALL(string = org::apache::lucene::document::DateField::MIN_DATE_STRING());
    return j2p(string);
}

static PyObject *j_datefield_timeToString(PyTypeObject *type,
                                          PyObject *arg)
{
    jlong time;
    jstring string;

    if (!parseArg(arg, "L", &time))
    {
        OBJ_CALL(string = org::apache::lucene::document::DateField::timeToString(time));
        return j2p(string);
    }

    return PyErr_SetArgsError(type, "timeToString", arg);
}

static PyObject *j_datefield_stringToTime(PyTypeObject *type, PyObject *arg)
{
    jlong time;
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(time = org::apache::lucene::document::DateField::stringToTime(string));
        return PyLong_FromLongLong(time);
    }

    return PyErr_SetArgsError(type, "stringToTime", arg);
}


/* DateTools */

static PyObject *j_datetools_dateToString(PyTypeObject *type, PyObject *args)
{
    java::util::Date *date;
    org::apache::lucene::document::DateTools$Resolution *resolution;
    jstring string;

    if (!parseArgs(args, "JJ", &java::util::Date::class$,
                   &org::apache::lucene::document::DateTools$Resolution::class$,
                   &date, &resolution))
    {
        OBJ_CALL(string = org::apache::lucene::document::DateTools::dateToString(date, resolution));
        return j2p(string);
    }

    return PyErr_SetArgsError(type, "dateToString", args);
}

static PyObject *j_datetools_stringToDate(PyTypeObject *type, PyObject *arg)
{
    java::util::Date *date;
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(date = org::apache::lucene::document::DateTools::stringToDate(string));
        return wrap_Date(date);
    }

    return PyErr_SetArgsError(type, "stringToDate", arg);
}

static PyObject *j_datetools_timeToString(PyTypeObject *type, PyObject *args)
{
    jlong time;
    org::apache::lucene::document::DateTools$Resolution *resolution;
    jstring string;

    if (!parseArgs(args, "LJ",
                   &org::apache::lucene::document::DateTools$Resolution::class$,
                   &time, &resolution))
    {
        OBJ_CALL(string = org::apache::lucene::document::DateTools::timeToString(time, resolution));
        return j2p(string);
    }

    return PyErr_SetArgsError(type, "timeToString", args);
}
static PyObject *j_datetools_stringToTime(PyTypeObject *type, PyObject *arg)
{
    jlong time;
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(time = org::apache::lucene::document::DateTools::stringToTime(string));
        return PyLong_FromLongLong(time);
    }

    return PyErr_SetArgsError(type, "stringToTime", arg);
}

static PyObject *j_datetools_round(PyTypeObject *type, PyObject *args)
{
    java::util::Date *date;
    jlong time;
    org::apache::lucene::document::DateTools$Resolution *resolution;
    
    if (!parseArgs(args, "JJ", &java::util::Date::class$,
                   &org::apache::lucene::document::DateTools$Resolution::class$,
                   &date, &resolution))
    {
        OBJ_CALL(date = org::apache::lucene::document::DateTools::round(date, resolution));
        return wrap_Date(date);
    }
    if (!parseArgs(args, "LJ",
                   &org::apache::lucene::document::DateTools$Resolution::class$,
                   &time, &resolution))
    {
        OBJ_CALL(time = org::apache::lucene::document::DateTools::round(time, resolution));
        return PyLong_FromLongLong(time);
    }

    return PyErr_SetArgsError(type, "round", args);
}


/* NumberTools */

static PyObject *j_numbertools_longToString(PyTypeObject *type, PyObject *arg)
{
    jlong l;
    jstring s;

    if (!parseArg(arg, "L", &l))
    {
        OBJ_CALL(s = org::apache::lucene::document::NumberTools::longToString(l));
        return j2p(s);
    }

    return PyErr_SetArgsError(type, "longToString", arg);
}

static PyObject *j_numbertools_stringToLong(PyTypeObject *type, PyObject *arg)
{
    jlong l;
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(l = org::apache::lucene::document::NumberTools::stringToLong(s));
        return PyLong_FromLongLong(l);
    }

    return PyErr_SetArgsError(type, "stringToLong", arg);
}


/* FieldEnumeration */

static PyObject *j_fieldenumeration_nextElement(j_fieldenumeration *self)
{
    jobject obj;

    EXC_OBJ_CALL(obj = self->object->nextElement(),
                 java::util::NoSuchElementException,
                 PyErr_SetNone(PyExc_StopIteration); return NULL);

    return wrap_Field((org::apache::lucene::document::Field *) obj);
}


/* Document */

DEFINE_0_INIT(j_document, org::apache::lucene::document::Document);

static PyObject *j_document_add(j_document *self, PyObject *arg)
{
    org::apache::lucene::document::Fieldable *field;

    if (!parseArg(arg, "J", &org::apache::lucene::document::Fieldable::class$,
                  &field))
    {
        OBJ_CALL(self->object->add(field));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", arg);
}

static PyObject *j_document_get(j_document *self, PyObject *arg)
{
    jstring string;

    if (!parseArg(arg, "s", &string))
    {
        OBJ_CALL(string = self->object->get(string));
        return j2p(string);
    }

    return PyErr_SetArgsError((PyObject *) self, "get", arg);
}

static PyObject *j_document_getField(j_document *self, PyObject *arg)
{
    org::apache::lucene::document::Field *field;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(field = self->object->getField(name));
        return wrap_Field(field);
    }

    return PyErr_SetArgsError((PyObject *) self, "getField", arg);
}

static PyObject *j_document_getFields(j_document *self, PyObject *arg)
{
    JArray<org::apache::lucene::document::Field *> *fields;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(fields = self->object->getFields(name));
        return ja2pl((jobjectArray) fields,
                     (PyObject *(*)(jobject)) wrap_Field);
    }

    return PyErr_SetArgsError((PyObject *) self, "getFields", arg);
}

static PyObject *j_document_getValues(j_document *self, PyObject *arg)
{
    jstringArray values;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(values = self->object->getValues(name));
        return jsa2psl(values);
    }

    return PyErr_SetArgsError((PyObject *) self, "getValues", arg);
}

static PyObject *j_document_getBinaryValue(j_document *self, PyObject *arg)
{
    jbyteArray bytes;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(bytes = self->object->getBinaryValue(name));
        if (bytes)
            return PyString_FromStringAndSize((char *) elements(bytes),
                                              JvGetArrayLength(bytes));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "getBinaryValue", arg);
}

static PyObject *j_document_getBinaryValues(j_document *self, PyObject *arg)
{
    JArray<jbyteArray> *array;
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(array = self->object->getBinaryValues(name));
        if (array)
        {
            int len = JvGetArrayLength(array);
            jbyteArray *bytes = elements(array);
            PyObject *list = PyList_New(len);

            for (int i = 0; i < len; i++) {
                PyObject *string =
                    PyString_FromStringAndSize((char *) elements(bytes[i]),
                                               JvGetArrayLength(bytes[i]));
                PyList_SET_ITEM(list, i, string);
            }
                              
            return list;
        }

        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "getBinaryValues", arg);
}

static PyObject *j_document_fields(j_document *self)
{
    java::util::Enumeration *fields;

    OBJ_CALL(fields = self->object->fields());
    return wrap_FieldEnumeration(fields);
}

DEFINE_FLOAT_GETSET(Boost, j_document);

static PyObject *j_document_removeField(j_document *self, PyObject *arg)
{
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(self->object->removeField(name));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "removeField", arg);
}

static PyObject *j_document_removeFields(j_document *self, PyObject *arg)
{
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(self->object->removeFields(name));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "removeFields", arg);
}

static PyObject *j_document___getattr__(j_document *self, PyObject *arg)
{
    org::apache::lucene::document::Field *field;    
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(field = self->object->getField(name));
        if (field)
            return wrap_Field(field);

        PyErr_SetObject(PyExc_AttributeError, arg);
        return NULL;
    }

    return PyErr_SetArgsError((PyObject *) self, "__getattr__", arg);
}

static PyObject *j_document___delattr__(j_document *self, PyObject *arg)
{
    jstring name;

    if (!parseArg(arg, "s", &name))
    {
        OBJ_CALL(self->object->removeField(name));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "__delattr__", arg);
}

static int j_document_dict_length(j_document *self)
{
    jint len;

    INT_CALL(len = self->object->fields__->size());
    return len;
}

static PyObject *j_document_dict_get(j_document *self, PyObject *key)
{
    jstring strKey, value = NULL;

    if (!parseArg(key, "s", &strKey))
    {
        OBJ_CALL(value = self->object->get(strKey));
        if (value)
            return j2p(value);
        
        PyErr_SetObject(PyExc_KeyError, key);
        return NULL;
    }

    return PyErr_SetArgsError((PyObject *) self, "__getitem__", key);
}


/* IndexWriter */

static int j_indexwriter_init(j_indexwriter *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::IndexWriter *writer;
    org::apache::lucene::store::Directory *dir;
    org::apache::lucene::analysis::Analyzer *analyzer;
    jstring path;
    jboolean create;

    if (!parseArgs(args, "sPb",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &path, &analyzer, make_Analyzer,
                   &create))
    {
        INT_CALL(writer = new org::apache::lucene::index::IndexWriter(path, analyzer, create));
        self->object = writer;
    }
    else if (!parseArgs(args, "PPb",
                        &org::apache::lucene::store::Directory::class$,
                        check_Directory,
                        &org::apache::lucene::analysis::Analyzer::class$,
                        check_Analyzer,
                        &dir, make_Directory, &analyzer, make_Analyzer,
                        &create))
    {
        INT_CALL(writer = new org::apache::lucene::index::IndexWriter(dir, analyzer, create));
        self->object = writer;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_indexwriter_close(j_indexwriter *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_indexwriter_docCount(j_indexwriter *self)
{
    jint docCount;

    OBJ_CALL(docCount = self->object->docCount());
    return PyInt_FromLong(docCount);
}

DEFINE_OBJ_GETTER(Analyzer, j_indexwriter, Analyzer,
                  org::apache::lucene::analysis::Analyzer);
DEFINE_OBJ_GETTER(Directory, j_indexwriter, Directory,
                  org::apache::lucene::store::Directory);
DEFINE_BOOL_GETSET(UseCompoundFile, j_indexwriter);
DEFINE_INT_GETSET(MaxFieldLength, j_indexwriter);
DEFINE_INT_GETSET(MaxMergeDocs, j_indexwriter);
DEFINE_INT_GETSET(MaxBufferedDocs, j_indexwriter);
DEFINE_INT_GETSET(MergeFactor, j_indexwriter);
DEFINE_OBJ_GETSET(InfoStream, j_indexwriter, PrintStream,
                  java::io::PrintStream);
DEFINE_POBJ_GETSET(Similarity, j_indexwriter, Similarity,
                   org::apache::lucene::search::Similarity);
DEFINE_INT_GETSET(TermIndexInterval, j_indexwriter);
DEFINE_LONG_GETSET(WriteLockTimeout, j_indexwriter);

static PyObject *j_indexwriter_optimize(j_indexwriter *self)
{
    OBJ_CALL(self->object->optimize());
    Py_RETURN_NONE;
}

static PyObject *j_indexwriter_addIndexes(j_indexwriter *self, PyObject *arg)
{
    JArray<org::apache::lucene::index::IndexReader *> *readers;
    JArray<org::apache::lucene::store::Directory *> *dirs;

    if (!parseArg(arg, "K", &org::apache::lucene::index::IndexReader::class$,
                  &readers, &org::apache::lucene::index::IndexReader::class$))
    {
        OBJ_CALL(self->object->addIndexes(readers));
        Py_RETURN_NONE;
    }

    if (!parseArg(arg, "Q", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dirs, 
                  &org::apache::lucene::store::Directory::class$,
                  check_Directory, make_Directory))
    {
        OBJ_CALL(self->object->addIndexes(dirs));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "addIndexes", arg);
}

static PyObject *j_indexwriter_addDocument(j_indexwriter *self, PyObject *args)
{
    org::apache::lucene::document::Document *doc;
    org::apache::lucene::analysis::Analyzer *analyzer;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
      {
          if (!parseArgs(args, "J",
                         &org::apache::lucene::document::Document::class$,
                         &doc))
          {
              OBJ_CALL(self->object->addDocument(doc));
              Py_RETURN_NONE;
          }
          break;
      }
      case 2:
      {
          if (!parseArgs(args, "JP",
                         &org::apache::lucene::document::Document::class$,
                         &org::apache::lucene::analysis::Analyzer::class$,
                         check_Analyzer, &doc, &analyzer, make_Analyzer))
          {
              OBJ_CALL(self->object->addDocument(doc, analyzer));
              Py_RETURN_NONE;
          }
          return NULL;
      }
    }

    return PyErr_SetArgsError((PyObject *) self, "addDocument", args);
}


/* Term */

static int j_term_init(j_term *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::Term *term;
    jstring fieldName, text;

    if (!parseArgs(args, "ss", &fieldName, &text))
    {
        INT_CALL(term = new org::apache::lucene::index::Term(fieldName,
                                                             text));
        self->object = term;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_term_field(j_term *self)
{
    jstring fieldName;

    OBJ_CALL(fieldName = self->object->field());
    return j2p(fieldName);
}

static PyObject *j_term_text(j_term *self)
{
    jstring text;

    OBJ_CALL(text = self->object->text());
    return j2p(text);
}

static PyObject *j_term_createTerm(j_term *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;
    jstring text;

    if (!parseArg(arg, "s", &text))
    {
        OBJ_CALL(term = self->object->createTerm(text));
        return wrap_Term(term);
    }

    return PyErr_SetArgsError((PyObject *) self, "createTerm", arg);
}


/* TermEnum */

static PyObject *j_termenum_next(j_termenum *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->next());
    Py_RETURN_BOOL(b);
}

static PyObject *j_termenum_term(j_termenum *self)
{
    org::apache::lucene::index::Term *term;

    OBJ_CALL(term = self->object->term());
    return wrap_Term(term);
}

static PyObject *j_termenum_docFreq(j_termenum *self)
{
    jint freq;

    OBJ_CALL(freq = self->object->docFreq());
    return PyInt_FromLong(freq);
}

static PyObject *j_termenum_close(j_termenum *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_termenum_skipTo(j_termenum *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;
    jboolean b;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        OBJ_CALL(b = self->object->skipTo(term));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "skipTo", arg);
}


/* TermDocs */

static PyObject *j_termdocs_seek(j_termdocs *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;
    org::apache::lucene::index::TermEnum *e;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        OBJ_CALL(self->object->seek(term));
        Py_RETURN_NONE;
    }
    if (!parseArg(arg, "J", &org::apache::lucene::index::TermEnum::class$, &e))
    {
        OBJ_CALL(self->object->seek(e));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "seek", arg);
    
}

static PyObject *j_termdocs_doc(j_termdocs *self)
{
    jint doc;

    OBJ_CALL(doc = self->object->doc());
    return PyInt_FromLong(doc);
}

static PyObject *j_termdocs_freq(j_termdocs *self)
{
    jint freq;

    OBJ_CALL(freq = self->object->freq());
    return PyInt_FromLong(freq);
}

static PyObject *j_termdocs_next(j_termdocs *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->next());
    Py_RETURN_BOOL(b);
}

static PyObject *j_termdocs_skipTo(j_termdocs *self, PyObject *arg)
{
    jint doc;
    jboolean b;

    if (!parseArg(arg, "i", &doc))
    {
        OBJ_CALL(b = self->object->skipTo(doc));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "skipTo", arg);
}

static PyObject *j_termdocs_close(j_termdocs *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_termdocs_read(j_termdocs *self, PyObject *arg)
{
    jint count;

    if (!parseArg(arg, "i", &count))
    {
        jintArray docs;
        jintArray freqs;

        OBJ_CALL(
            {
                docs = JvNewIntArray(count);
                freqs = JvNewIntArray(count);
                count = self->object->read(docs, freqs);
            });

        PyObject *pyDocs = jia2pil(docs, count);
        PyObject *pyFreqs = jia2pil(freqs, count);
        PyObject *pyTuple = PyTuple_New(2);

        PyTuple_SET_ITEM(pyTuple, 0, pyDocs);
        PyTuple_SET_ITEM(pyTuple, 1, pyFreqs);

        return pyTuple;
    }

    return PyErr_SetArgsError((PyObject *) self, "read", arg);
}


/* TermPositions */

static PyObject *j_termpositions_nextPosition(j_termpositions *self)
{
    jint n;

    OBJ_CALL(n = self->object->nextPosition());
    return PyInt_FromLong(n);
}



/* MultipleTermPositions */

static int j_multipletermpositions_init(j_multipletermpositions *self,
                                        PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::MultipleTermPositions *mtp;
    org::apache::lucene::index::IndexReader *reader;
    JArray<org::apache::lucene::index::Term *> *terms;

    if (!parseArgs(args, "JK", &org::apache::lucene::index::IndexReader::class$,
                   &org::apache::lucene::index::Term::class$, &reader,
                   &terms, &org::apache::lucene::index::Term::class$))
    {
        INT_CALL(mtp = new org::apache::lucene::index::MultipleTermPositions(reader, terms));
        self->object = mtp;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* TermFreqVector */

static PyObject *j_termfreqvector_getField(j_termfreqvector *self)
{
    jstring field;

    OBJ_CALL(field = self->object->getField());
    return j2p(field);
}

static PyObject *j_termfreqvector_size(j_termfreqvector *self)
{
    jint size;

    OBJ_CALL(size = self->object->size());
    return PyInt_FromLong(size);
}

static PyObject *j_termfreqvector_getTerms(j_termfreqvector *self)
{
    jstringArray terms;

    OBJ_CALL(terms = self->object->getTerms());
    return jsa2psl(terms);
}

static PyObject *j_termfreqvector_getTermFrequencies(j_termfreqvector *self)
{
    jintArray freqs;

    OBJ_CALL(freqs = self->object->getTermFrequencies());
    return jia2pil(freqs);
}

static PyObject *j_termfreqvector_indexOf(j_termfreqvector *self,
                                          PyObject *arg)
{
    jstring term;
    jint i;

    if (!parseArg(arg, "s", &term))
    {
        OBJ_CALL(i = self->object->indexOf(term));
        return PyInt_FromLong(i);
    }

    return PyErr_SetArgsError((PyObject *) self, "indexOf", arg);
}

static PyObject *j_termfreqvector_indexesOf(j_termfreqvector *self,
                                            PyObject *args)
{
    jintArray indexes;
    jstringArray terms;
    jint start, end;

    if (!parseArgs(args, "Sii", &terms, &start, &end))
    {
        OBJ_CALL(indexes = self->object->indexesOf(terms, start, end));
        return jia2pil(indexes);
    }

    return PyErr_SetArgsError((PyObject *) self, "indexesOf", args);
}


/* TermPositionVector */

static PyObject *j_termpositionvector_getTermPositions(j_termpositionvector *self, PyObject *arg)
{
    jintArray positions;
    jint index;

    if (!parseArg(arg, "i", &index))
    {
        OBJ_CALL(positions = self->object->getTermPositions(index));
        return jia2pil(positions);
    }

    return PyErr_SetArgsError((PyObject *) self, "getTermPositions", arg);
}

static PyObject *j_termpositionvector_getOffsets(j_termpositionvector *self,
                                                 PyObject *arg)
{
    JArray<org::apache::lucene::index::TermVectorOffsetInfo *> *offsets;
    jint index;

    if (!parseArg(arg, "i", &index))
    {
        OBJ_CALL(offsets = self->object->getOffsets(index));
        return ja2pl((jobjectArray) offsets,
                     (PyObject *(*)(jobject)) wrap_TermVectorOffsetInfo);
    }

    return PyErr_SetArgsError((PyObject *) self, "getOffsets", arg);
}


/* TermVectorOffsetInfo */

static int j_termvectoroffsetinfo_init(j_termvectoroffsetinfo *self,
                                       PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::TermVectorOffsetInfo *tvoi;
    jint start, end;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(tvoi = new org::apache::lucene::index::TermVectorOffsetInfo());
        self->object = tvoi;
        break;
      case 2:
        if (!parseArgs(args, "ii", &start, &end))
        {
            INT_CALL(tvoi = new org::apache::lucene::index::TermVectorOffsetInfo(start, end));
            self->object = tvoi;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_INT_GETSET(StartOffset, j_termvectoroffsetinfo);
DEFINE_INT_GETSET(EndOffset, j_termvectoroffsetinfo);


/* IndexReader */

static PyObject *j_indexreader_open(PyTypeObject *type, PyObject *arg)
{
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::store::Directory *dir;
    jstring path;

    if (!parseArg(arg, "s", &path))
    {
        OBJ_CALL(reader = org::apache::lucene::index::IndexReader::open(path));
        return wrap_IndexReader(reader);
    }
    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(reader = org::apache::lucene::index::IndexReader::open(dir));
        return wrap_IndexReader(reader);
    }

    return PyErr_SetArgsError(type, "open", arg);
}

static PyObject *j_indexreader_main(PyTypeObject *type, PyObject *arg)
{
    jstringArray args;

    if (!parseArg(arg, "S", &args))
    {
        OBJ_CALL(org::apache::lucene::index::IndexReader::main(args));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "open", arg);
}

static PyObject *j_indexreader_lastModified(PyTypeObject *type, PyObject *arg)
{
    jlong time;
    org::apache::lucene::store::Directory *dir;
    jstring path;

    if (!parseArg(arg, "s", &path))
    {
        OBJ_CALL(time = org::apache::lucene::index::IndexReader::lastModified(path));
        return PyLong_FromLongLong(time);
    }
    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(time = org::apache::lucene::index::IndexReader::lastModified(dir));
        return PyLong_FromLongLong(time);
    }
    
    return PyErr_SetArgsError(type, "lastModified", arg);
}

static PyObject *j_indexreader_getCurrentVersion(PyTypeObject *type,
                                                 PyObject *arg)
{
    jlong version;
    org::apache::lucene::store::Directory *dir;
    jstring path;

    if (!parseArg(arg, "s", &path))
    {
        OBJ_CALL(version = org::apache::lucene::index::IndexReader::getCurrentVersion(path));
        return PyLong_FromLongLong(version);
    }
    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(version = org::apache::lucene::index::IndexReader::getCurrentVersion(dir));
        return PyLong_FromLongLong(version);
    }
    
    return PyErr_SetArgsError(type, "getCurrentVersion", arg);
}

static PyObject *j_indexreader_isLocked(PyTypeObject *type, PyObject *arg)
{
    jboolean b;
    org::apache::lucene::store::Directory *dir;
    jstring path;

    if (!parseArg(arg, "s", &path))
    {
        OBJ_CALL(b = org::apache::lucene::index::IndexReader::isLocked(path));
        Py_RETURN_BOOL(b);
    }
    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(b = org::apache::lucene::index::IndexReader::isLocked(dir));
        Py_RETURN_BOOL(b);
    }
    
    return PyErr_SetArgsError(type, "isLocked", arg);
}

static PyObject *j_indexreader_unlock(PyTypeObject *type, PyObject *arg)
{
    org::apache::lucene::store::Directory *dir;

    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(org::apache::lucene::index::IndexReader::unlock(dir));
        Py_RETURN_NONE;
    }
    
    return PyErr_SetArgsError(type, "unlock", arg);
}

static PyObject *j_indexreader_indexExists(PyTypeObject *type, PyObject *arg)
{
    jboolean b;
    org::apache::lucene::store::Directory *dir;
    jstring path;

    if (!parseArg(arg, "s", &path))
    {
        OBJ_CALL(b = org::apache::lucene::index::IndexReader::indexExists(path));
        Py_RETURN_BOOL(b);
    }
    if (!parseArg(arg, "P", &org::apache::lucene::store::Directory::class$,
                  check_Directory, &dir, make_Directory))
    {
        OBJ_CALL(b = org::apache::lucene::index::IndexReader::indexExists(dir));
        Py_RETURN_BOOL(b);
    }
    
    return PyErr_SetArgsError(type, "indexExists", arg);
}

static PyObject *j_indexreader_getTermFreqVector(j_indexreader *self,
                                                 PyObject *args)
{
    org::apache::lucene::index::TermFreqVector *tfv;
    jint n;
    jstring field;

    if (!parseArgs(args, "is", &n, &field))
    {
        OBJ_CALL(tfv = self->object->getTermFreqVector(n, field));
        return wrap_TermFreqVector(tfv);
    }

    return PyErr_SetArgsError((PyObject *) self, "getTermFreqVector", args);
}

static PyObject *j_indexreader_getTermFreqVectors(j_indexreader *self,
                                                  PyObject *arg)
{
    JArray<org::apache::lucene::index::TermFreqVector *> *tfvs;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(tfvs = self->object->getTermFreqVectors(n));
        return ja2pl((jobjectArray) tfvs,
                     (PyObject *(*)(jobject)) wrap_TermFreqVector);
    }

    return PyErr_SetArgsError((PyObject *) self, "getTermFreqVectors", arg);
}

static PyObject *j_indexreader_numDocs(j_indexreader *self)
{
    jint n;

    OBJ_CALL(n = self->object->numDocs());
    return PyInt_FromLong(n);
}

static PyObject *j_indexreader_maxDoc(j_indexreader *self)
{
    jint n;

    OBJ_CALL(n = self->object->maxDoc());
    return PyInt_FromLong(n);
}

static PyObject *j_indexreader_document(j_indexreader *self, PyObject *arg)
{
    org::apache::lucene::document::Document *doc;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(doc = self->object->document(n));
        return wrap_Document(doc);
    }

    return PyErr_SetArgsError((PyObject *) self, "document", arg);
}

static PyObject *j_indexreader_isDeleted(j_indexreader *self, PyObject *arg)
{
    jboolean b;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(b = self->object->isDeleted(n));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "isDeleted", arg);
}

static PyObject *j_indexreader_hasDeletions(j_indexreader *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->hasDeletions());
    Py_RETURN_BOOL(b);
}

static PyObject *j_indexreader_setNorm(j_indexreader *self, PyObject *args)
{
    jint n;
    jstring field;
    jbyte b;
    jdouble d;

    if (!parseArgs(args, "isa", &n, &field, &b))
    {
        OBJ_CALL(self->object->setNorm(n, field, b));
        Py_RETURN_NONE;
    }
    if (!parseArgs(args, "isd", &n, &field, &d))
    {
        OBJ_CALL(self->object->setNorm(n, field, (jfloat) d));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setNorm", args);
}

static PyObject *j_indexreader_hasNorms(j_indexreader *self, PyObject *arg)
{
    jboolean b;
    jstring field;

    if (!parseArg(arg, "s", &field))
    {
        OBJ_CALL(b = self->object->hasNorms(field));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "hasNorms", arg);
}

static PyObject *j_indexreader_norms(j_indexreader *self, PyObject *arg)
{
    jbyteArray norms;
    jstring field;

    if (!parseArg(arg, "s", &field))
    {
        OBJ_CALL(norms = self->object->norms(field));
        if (norms)
            return PyString_FromStringAndSize((char *) elements(norms),
                                              JvGetArrayLength(norms));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "norms", arg);
}

static PyObject *j_indexreader_termDocs(j_indexreader *self, PyObject *args)
{
    org::apache::lucene::index::TermDocs *td;
    org::apache::lucene::index::Term *term;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        OBJ_CALL(td = self->object->termDocs());
        return wrap_TermDocs(td);
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::index::Term::class$,
                       &term))
        {
            OBJ_CALL(td = self->object->termDocs(term));
            return wrap_TermDocs(td);
        }
    }

    return PyErr_SetArgsError((PyObject *) self, "termDocs", args);
}

static PyObject *j_indexreader_terms(j_indexreader *self, PyObject *args)
{
    org::apache::lucene::index::TermEnum *te;
    org::apache::lucene::index::Term *term;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        OBJ_CALL(te = self->object->terms());
        return wrap_TermEnum(te);
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::index::Term::class$,
                       &term))
        {
            OBJ_CALL(te = self->object->terms(term));
            return wrap_TermEnum(te);
        }
    }

    return PyErr_SetArgsError((PyObject *) self, "terms", args);
}

static PyObject *j_indexreader_termPositions(j_indexreader *self,
                                             PyObject *args)
{
    org::apache::lucene::index::TermPositions *tp;
    org::apache::lucene::index::Term *term;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        OBJ_CALL(tp = self->object->termPositions());
        return wrap_TermPositions(tp);
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::index::Term::class$,
                       &term))
        {
            OBJ_CALL(tp = self->object->termPositions(term));
            return wrap_TermPositions(tp);
        }
    }

    return PyErr_SetArgsError((PyObject *) self, "termPositions", args);
}

static PyObject *j_indexreader_docFreq(j_indexreader *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;
    jint freq;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        OBJ_CALL(freq = self->object->docFreq(term));
        return PyInt_FromLong(freq);
    }

    return PyErr_SetArgsError((PyObject *) self, "docFreq", arg);
}

static PyObject *j_indexreader_directory(j_indexreader *self)
{
    org::apache::lucene::store::Directory *dir;

    OBJ_CALL(dir = self->object->directory());
    return wrap_Directory(dir);
}

static PyObject *j_indexreader_getVersion(j_indexreader *self)
{
    jlong version;

    OBJ_CALL(version = self->object->getVersion());
    return PyLong_FromLongLong(version);
}

static PyObject *j_indexreader_isCurrent(j_indexreader *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->isCurrent());
    Py_RETURN_BOOL(b);
}

static PyObject *j_indexreader_deleteDocument(j_indexreader *self,
                                              PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(self->object->deleteDocument(n));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "deleteDocument", arg);
}

static PyObject *j_indexreader_deleteDocuments(j_indexreader *self,
                                               PyObject *arg)
{
    org::apache::lucene::index::Term *term;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        jint docCount;

        OBJ_CALL(docCount = self->object->deleteDocuments(term));
        return PyInt_FromLong(docCount);
    }

    return PyErr_SetArgsError((PyObject *) self, "deleteDocuments", arg);
}

static PyObject *j_indexreader_undeleteAll(j_indexreader *self)
{
    OBJ_CALL(self->object->undeleteAll());
    Py_RETURN_NONE;
}

static PyObject *j_indexreader_close(j_indexreader *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_indexreader_getFieldNames(j_indexreader *self,
                                             PyObject *arg)
{
    org::apache::lucene::index::IndexReader$FieldOption *option;
    java::util::Collection *names;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::index::IndexReader$FieldOption::class$,
                  &option))
    {
        OBJ_CALL(names = self->object->getFieldNames(option));
        return jsc2psl(names);
    }

    return PyErr_SetArgsError((PyObject *) self, "getFieldNames", arg);
}

static PyObject *j_indexreader_iter(j_indexreader *self)
{
    org::osafoundation::util::IndexReaderEnumeration *e;

    OBJ_CALL(e = new org::osafoundation::util::IndexReaderEnumeration(self->object));
    return wrap_IndexReaderEnumeration(e);
}


/* IndexReaderEnumeration */

static PyObject *j_indexreaderenumeration_nextElement(j_indexreaderenumeration *self)
{
    jobject obj;

    EXC_OBJ_CALL(obj = self->object->nextElement(),
                 java::util::NoSuchElementException,
                 PyErr_SetNone(PyExc_StopIteration); return NULL);

    return wrap_Document((org::apache::lucene::document::Document *) obj);
}

static PyObject *j_indexreaderenumeration_next(j_indexreaderenumeration *self)
{
    jobject obj;
    jint id;

    EXC_OBJ_CALL(
        {
            id = self->object->current;
            obj = self->object->nextElement();
        },
        java::util::NoSuchElementException,
        {
            PyErr_SetNone(PyExc_StopIteration);
            return NULL;
        });

    PyObject *pyTuple = PyTuple_New(2);
    PyObject *pyId = PyInt_FromLong(id);
    PyObject *pyDoc =
        wrap_Document((org::apache::lucene::document::Document *) obj);

    PyTuple_SET_ITEM(pyTuple, 0, pyId);
    PyTuple_SET_ITEM(pyTuple, 1, pyDoc);

    return pyTuple;
}


/* FilterIndexReader */

static int j_filterindexreader_init(j_filterindexreader *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::FilterIndexReader *filterReader;
    org::apache::lucene::index::IndexReader *indexReader;

    if (!parseArgs(args, "J", &org::apache::lucene::index::IndexReader::class$,
                   &indexReader))
    {
        INT_CALL(filterReader = new org::apache::lucene::index::FilterIndexReader(indexReader));
        self->object = filterReader;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

/* ParallelReader */

static int j_parallelreader_init(j_parallelreader *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::ParallelReader *reader;

    INT_CALL(reader = new org::apache::lucene::index::ParallelReader());
    self->object = reader;

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_parallelreader_add(j_parallelreader *self, PyObject *args)
{
    org::apache::lucene::index::IndexReader *indexReader;
    jboolean b;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::index::IndexReader::class$,
                       &indexReader))
        {
            OBJ_CALL(self->object->add(indexReader));
            Py_RETURN_NONE;
        }
        break;
      case 2:
        if (!parseArgs(args, "Jb",
                       &org::apache::lucene::index::IndexReader::class$,
                       &indexReader, &b))
        {
            OBJ_CALL(self->object->add(indexReader, b));
            Py_RETURN_NONE;
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", args);
}


/* IndexModifier */


static int j_indexmodifier_init(j_indexmodifier *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::IndexModifier *modifier;
    org::apache::lucene::store::Directory *dir;
    org::apache::lucene::analysis::Analyzer *analyzer;
    jstring path;
    jboolean create;

    if (!parseArgs(args, "sPb",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &path, &analyzer, make_Analyzer, &create))
    {
        INT_CALL(modifier = new org::apache::lucene::index::IndexModifier(path, analyzer, create));
        self->object = modifier;
    }
    else if (!parseArgs(args, "PPb",
                        &org::apache::lucene::store::Directory::class$,
                        check_Directory,
                        &org::apache::lucene::analysis::Analyzer::class$,
                        check_Analyzer,
                        &dir, make_Directory,
                        &analyzer, make_Analyzer, &create))
    {
        INT_CALL(modifier = new org::apache::lucene::index::IndexModifier(dir, analyzer, create));
        self->object = modifier;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
    
}

static PyObject *j_indexmodifier_optimize(j_indexmodifier *self)
{
    OBJ_CALL(self->object->optimize());
    Py_RETURN_NONE;
}

static PyObject *j_indexmodifier_flush(j_indexmodifier *self)
{
    OBJ_CALL(self->object->flush());
    Py_RETURN_NONE;
}

static PyObject *j_indexmodifier_close(j_indexmodifier *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_indexmodifier_addDocument(j_indexmodifier *self,
                                             PyObject *args)
{
    org::apache::lucene::document::Document *doc;
    org::apache::lucene::analysis::Analyzer *analyzer;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
      {
          if (!parseArgs(args, "J",
                         &org::apache::lucene::document::Document::class$,
                         &doc))
          {
              OBJ_CALL(self->object->addDocument(doc));
              Py_RETURN_NONE;
          }
          break;
      }
      case 2:
      {
          if (!parseArgs(args, "JP",
                         &org::apache::lucene::document::Document::class$,
                         &org::apache::lucene::analysis::Analyzer::class$,
                         check_Analyzer, &doc, &analyzer, make_Analyzer))
          {
              OBJ_CALL(self->object->addDocument(doc, analyzer));
              Py_RETURN_NONE;
          }
          return NULL;
      }
    }

    return PyErr_SetArgsError((PyObject *) self, "addDocument", args);
}

static PyObject *j_indexmodifier_deleteDocument(j_indexmodifier *self,
                                                PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(self->object->deleteDocument(n));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "deleteDocument", arg);
}

static PyObject *j_indexmodifier_deleteDocuments(j_indexmodifier *self,
                                                 PyObject *arg)
{
    org::apache::lucene::index::Term *term;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        jint docCount;

        OBJ_CALL(docCount = self->object->deleteDocuments(term));
        return PyInt_FromLong(docCount);
    }

    return PyErr_SetArgsError((PyObject *) self, "deleteDocuments", arg);
}

static PyObject *j_indexmodifier_docCount(j_indexmodifier *self)
{
    jint docCount;

    OBJ_CALL(docCount = self->object->docCount());
    return PyInt_FromLong(docCount);
}

DEFINE_OBJ_GETSET(InfoStream, j_indexmodifier, PrintStream,
                  java::io::PrintStream);
DEFINE_BOOL_GETSET(UseCompoundFile, j_indexmodifier);
DEFINE_INT_GETSET(MaxFieldLength, j_indexmodifier);
DEFINE_INT_GETSET(MaxBufferedDocs, j_indexmodifier);
DEFINE_INT_GETSET(MergeFactor, j_indexmodifier);


/* MultiReader */

static int j_multireader_init(j_multireader *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::index::MultiReader *reader;
    JArray<org::apache::lucene::index::IndexReader *> *readers;

    if (!parseArgs(args, "K", &org::apache::lucene::index::IndexReader::class$,
                   &readers, &org::apache::lucene::index::IndexReader::class$))
    {
        INT_CALL(reader = new org::apache::lucene::index::MultiReader(readers));
        self->object = reader;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* Query */

static PyObject *j_query_mergeBooleanQueries(PyTypeObject *type, PyObject *arg)
{
    JArray<org::apache::lucene::search::Query *> *queries;
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "K", &org::apache::lucene::search::Query::class$,
                  &queries, &org::apache::lucene::search::Query::class$))
    {
        OBJ_CALL(query = org::apache::lucene::search::Query::mergeBooleanQueries(queries));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError(type, "mergeBooleanQueries", arg);
}

DEFINE_FLOAT_GETSET(Boost, j_query);

static PyObject *j_query_rewrite(j_query *self, PyObject *arg)
{
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::index::IndexReader::class$,
                  &reader))
    {
        OBJ_CALL(query = self->object->rewrite(reader));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "rewrite", arg);
}

static PyObject *j_query_combine(j_query *self, PyObject *arg)
{
    JArray<org::apache::lucene::search::Query *> *queries;
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "K", &org::apache::lucene::search::Query::class$,
                  &queries, &org::apache::lucene::search::Query::class$))
    {
        OBJ_CALL(query = self->object->combine(queries));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "combine", arg);
}

static PyObject *j_query_weight(j_query *self, PyObject *arg)
{
    org::apache::lucene::search::Weight *weight;
    org::apache::lucene::search::Searcher *searcher;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::Searcher::class$,
                  &searcher))
    {
        OBJ_CALL(weight = self->object->weight(searcher));
        return wrap_Weight(weight);
    }

    return PyErr_SetArgsError((PyObject *) self, "weight", arg);
}

static PyObject *j_query_getSimilarity(j_query *self, PyObject *arg)
{
    org::apache::lucene::search::Similarity *similarity;
    org::apache::lucene::search::Searcher *searcher;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::Searcher::class$,
                  &searcher))
    {
        OBJ_CALL(similarity = self->object->getSimilarity(searcher));
        return wrap_Similarity(similarity);
    }

    return PyErr_SetArgsError((PyObject *) self, "getSimilarity", arg);
}

static PyObject *j_query_toString(j_query *self, PyObject *args)
{
    jstring s, field;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        OBJ_CALL(s = self->object->toString());
        return j2p(s);
      case 1:
        if (!parseArgs(args, "s", &field))
        {
            OBJ_CALL(s = self->object->toString(field));
            return j2p(s);
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "toString", args);
}


DEFINE_DOWNCAST(j_query, BooleanQuery,
                org::apache::lucene::search::BooleanQuery);
DEFINE_DOWNCAST(j_query, PrefixQuery,
                org::apache::lucene::search::PrefixQuery);
DEFINE_DOWNCAST(j_query, TermQuery,
                org::apache::lucene::search::TermQuery);
DEFINE_DOWNCAST(j_query, PhraseQuery,
                org::apache::lucene::search::PhraseQuery);
DEFINE_DOWNCAST(j_query, MultiPhraseQuery,
                org::apache::lucene::search::MultiPhraseQuery);
DEFINE_DOWNCAST(j_query, FilteredQuery,
                org::apache::lucene::search::FilteredQuery);
DEFINE_DOWNCAST(j_query, RangeQuery,
                org::apache::lucene::search::RangeQuery);
DEFINE_DOWNCAST(j_query, MultiTermQuery,
                org::apache::lucene::search::MultiTermQuery);
DEFINE_DOWNCAST(j_query, FuzzyQuery,
                org::apache::lucene::search::FuzzyQuery);
DEFINE_DOWNCAST(j_query, WildcardQuery,
                org::apache::lucene::search::WildcardQuery);
DEFINE_DOWNCAST(j_query, SpanQuery,
                org::apache::lucene::search::spans::SpanQuery);
DEFINE_DOWNCAST(j_query, SpanFirstQuery,
                org::apache::lucene::search::spans::SpanFirstQuery);
DEFINE_DOWNCAST(j_query, SpanNearQuery,
                org::apache::lucene::search::spans::SpanNearQuery);
DEFINE_DOWNCAST(j_query, SpanNotQuery,
                org::apache::lucene::search::spans::SpanNotQuery);
DEFINE_DOWNCAST(j_query, SpanOrQuery,
                org::apache::lucene::search::spans::SpanOrQuery);
DEFINE_DOWNCAST(j_query, SpanTermQuery,
                org::apache::lucene::search::spans::SpanTermQuery);
DEFINE_DOWNCAST(j_query, MatchAllDocsQuery,
                org::apache::lucene::search::MatchAllDocsQuery);
DEFINE_DOWNCAST(j_query, ConstantScoreQuery,
                org::apache::lucene::search::ConstantScoreQuery);
DEFINE_DOWNCAST(j_query, ConstantScoreRangeQuery,
                org::apache::lucene::search::ConstantScoreRangeQuery);
DEFINE_DOWNCAST(j_query, DisjunctionMaxQuery,
                org::apache::lucene::search::DisjunctionMaxQuery);
DEFINE_DOWNCAST(j_query, RegexQuery,
                org::apache::lucene::search::regex::RegexQuery);
DEFINE_DOWNCAST(j_query, SpanRegexQuery,
                org::apache::lucene::search::regex::SpanRegexQuery);


/* MultiTermQuery */

DEFINE_OBJ_GETTER(Term, j_multitermquery, Term,
                  org::apache::lucene::index::Term);


/* Hits */

static PyObject *j_hits_length(j_hits *self)
{
    jint length;

    OBJ_CALL(length = self->object->length());
    return PyInt_FromLong(length);
}

static PyObject *j_hits_doc(j_hits *self, PyObject *arg)
{
    org::apache::lucene::document::Document *doc;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(doc = self->object->doc(n));
        return wrap_Document(doc);
    }

    return PyErr_SetArgsError((PyObject *) self, "doc", arg);
}

static PyObject *j_hits_score(j_hits *self, PyObject *arg)
{
    jfloat score;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(score = self->object->score(n));
        return PyFloat_FromDouble((double) score);
    }

    return PyErr_SetArgsError((PyObject *) self, "score", arg);
}

static PyObject *j_hits_id(j_hits *self, PyObject *arg)
{
    jint id;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(id = self->object->id(n));
        return PyInt_FromLong(id);
    }

    return PyErr_SetArgsError((PyObject *) self, "id", arg);
}

static PyObject *j_hits_iter(j_hits *self)
{
    j_hititerator *hi = (j_hititerator *) wrap_HitIterator(self->object);

    hi->i = 0;
    hi->len = self->object->length();

    return (PyObject *) hi;
}

static int j_hits_getlength(j_hits *self)
{
    jint length;

    INT_CALL(length = self->object->length());
    return length;
}

static PyObject *j_hits_getitem(j_hits *self, int i)
{
    int len = self->object->length();

    if (i < 0)
        i += len;

    if (i >= 0 && i < len)
    {
        org::apache::lucene::document::Document *doc;

        OBJ_CALL(doc = self->object->doc(i));
        return wrap_Document(doc);
    }
    else
    {
        PyObject *index = PyInt_FromLong(i);

        PyErr_SetObject(PyExc_IndexError, index);
        Py_DECREF(index);
        return NULL;
    }
}


/* HitIterator */

static int j_hititerator_init(j_hititerator *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::Hits *hits;

    if (!parseArgs(args, "J", &org::apache::lucene::search::Hits::class$,
                   &hits))
    {
        self->object = hits;
        self->i = 0;
        self->len = hits->length();
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

PyObject *j_hititerator_iter(j_hititerator *self)
{
    Py_INCREF(self);
    return (PyObject *) self;
}

static PyObject *j_hititerator_next(j_hititerator *self)
{
    if (self->i >= self->len)
    {
        PyErr_SetNone(PyExc_StopIteration);
        return NULL;
    }

    j_hit *hit = (j_hit *) HitType.tp_alloc(&HitType, 0);

    if (hit)
    {
        org::apache::lucene::search::Hit *object;
        OBJ_CALL(object = new org::apache::lucene::search::Hit(self->object,
                                                               self->i));
        hit->object = object;
        refObject(hit->object);
        hit->hitNumber = self->i++;
    }

    return (PyObject *) hit;
}


/* Hit */

DEFINE_OBJ_GETTER(Document, j_hit, Document,
                  org::apache::lucene::document::Document);
DEFINE_FLOAT_GETTER(Score, j_hit);
DEFINE_INT_GETTER(Id, j_hit);
DEFINE_FLOAT_GETTER(Boost, j_hit);

static PyObject *j_hit_get(j_hit *self, PyObject *arg)
{
    jstring field;
    
    if (!parseArg(arg, "s", &field))
    {
        OBJ_CALL(field = self->object->get(field));
        return j2p(field);
    }

    return PyErr_SetArgsError((PyObject *) self, "get", arg);
}

static int j_hit_getlength(j_hit *self)
{
    return 2;
}

static PyObject *j_hit_getitem(j_hit *self, int n)
{
    if (n < 0)
        n = 2 + n;

    switch (n) {
      case 0:
        return PyInt_FromLong(self->hitNumber);
      case 1:
        return j_hit_getDocument(self);
    }

    PyErr_SetNone(PyExc_IndexError);
    return NULL;
}


/* HitCollector */

static int j_hitcollector_init(j_hitcollector *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::HitCollector *collector;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::HitCollector::class$,
                   check_HitCollector, &collector, make_HitCollector))
    {
        if (collector)
        {
            self->object = collector;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_hitcollector_collect(j_hitcollector *self, PyObject *args)
{
    jint doc;
    jdouble score;

    if (!parseArgs(args, "id", &doc, &score))
    {
        OBJ_CALL(self->object->collect(doc, (jfloat) score));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "collect", args);
}


/* Scorer */

DEFINE_OBJ_GETTER(Similarity, j_scorer, Similarity,
                  org::apache::lucene::search::Similarity);

static PyObject *j_scorer_score(j_scorer *self, PyObject *args)
{
    org::apache::lucene::search::HitCollector *collector;
    jdouble score;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        OBJ_CALL(score = self->object->score());
        return PyFloat_FromDouble((double) score);
      case 1:
        if (!parseArgs(args, "P",
                       &org::apache::lucene::search::HitCollector::class$,
                       check_HitCollector, &collector, make_HitCollector))
        {
            OBJ_CALL(self->object->score(collector));
            Py_RETURN_NONE;
        }
    }

    return PyErr_SetArgsError((PyObject *) self, "score", args);
}

static PyObject *j_scorer_next(j_scorer *self)
{
    jboolean b;
    
    OBJ_CALL(b = self->object->next());
    Py_RETURN_BOOL(b);
}

static PyObject *j_scorer_doc(j_scorer *self)
{
    jint doc;

    OBJ_CALL(doc = self->object->doc());
    return PyInt_FromLong(doc);
}

static PyObject *j_scorer_skipTo(j_scorer *self, PyObject *arg)
{
    jint doc;
    jboolean b;

    if (!parseArg(arg, "i", &doc))
    {
        OBJ_CALL(b = self->object->skipTo(doc));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "skipTo", arg);
}

static PyObject *j_scorer_explain(j_scorer *self, PyObject *arg)
{
    jint doc;
    org::apache::lucene::search::Explanation *explanation;

    if (!parseArg(arg, "i", &doc))
    {
        OBJ_CALL(explanation = self->object->explain(doc));
        return wrap_Explanation(explanation);
    }

    return PyErr_SetArgsError((PyObject *) self, "explain", arg);
}


/* Weight */

static PyObject *j_weight_getQuery(j_weight *self);

DEFINE_OBJ_GETTER(Query, j_weight, Query, org::apache::lucene::search::Query);
DEFINE_FLOAT_GETTER(Value, j_weight);

static PyObject *j_weight_sumOfSquaredWeights(j_weight *self)
{
    jfloat sum;

    OBJ_CALL(sum = self->object->sumOfSquaredWeights());
    return PyFloat_FromDouble((double) sum);
}

static PyObject *j_weight_normalize(j_weight *self, PyObject *arg)
{
    jdouble d;

    if (!parseArg(arg, "d", &d))
    {
        OBJ_CALL(self->object->normalize((jfloat) d));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "normalize", arg);
}

static PyObject *j_weight_scorer(j_weight *self, PyObject *arg)
{
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::search::Scorer *scorer;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::index::IndexReader::class$,
                  &reader))
    {
        OBJ_CALL(scorer = self->object->scorer(reader));
        return wrap_Scorer(scorer);
    }

    return PyErr_SetArgsError((PyObject *) self, "scorer", arg);
}

static PyObject *j_weight_explain(j_weight *self, PyObject *args)
{
    org::apache::lucene::search::Explanation *explanation;
    org::apache::lucene::index::IndexReader *reader;
    jint doc;

    if (!parseArgs(args, "Ji",
                   &org::apache::lucene::index::IndexReader::class$,
                   &reader, &doc))
    {
        OBJ_CALL(explanation = self->object->explain(reader, doc));
        return wrap_Explanation(explanation);
    }

    return PyErr_SetArgsError((PyObject *) self, "explain", args);
}


/* Similarity */

static PyObject *j_similarity_getDefault(PyTypeObject *type)
{
    org::apache::lucene::search::Similarity *similarity;
    
    OBJ_CALL(similarity = org::apache::lucene::search::Similarity::getDefault());
    return wrap_Similarity(similarity);
}

static PyObject *j_similarity_setDefault(PyTypeObject *type, PyObject *arg)
{
    org::apache::lucene::search::Similarity *similarity;

    if (!parseArg(arg, "P", &org::apache::lucene::search::Similarity::class$,
                  check_Similarity, &similarity, make_Similarity))
    {
        OBJ_CALL(org::apache::lucene::search::Similarity::setDefault(similarity));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "setDefault", arg);
}

static PyObject *j_similarity_encodeNorm(PyTypeObject *type, PyObject *arg)
{
    jdouble d;
    jbyte b;

    if (!parseArg(arg, "d", &d))
    {
        OBJ_CALL(b = org::apache::lucene::search::Similarity::encodeNorm((jfloat) d));
        return PyString_FromStringAndSize((char *) &b, 1);
    }

    return PyErr_SetArgsError(type, "encodeNorm", arg);
}

static PyObject *j_similarity_decodeNorm(PyTypeObject *type, PyObject *arg)
{
    jfloat f;
    jbyte b;

    if (!parseArg(arg, "a", &b))
    {
        OBJ_CALL(f = org::apache::lucene::search::Similarity::decodeNorm(b));
        return PyFloat_FromDouble((double) f);
    }

    return PyErr_SetArgsError(type, "decodeNorm", arg);
}

static PyObject *j_similarity_lengthNorm(j_similarity *self, PyObject *args)
{
    jstring fieldName;
    jint numTokens;
    jfloat f;

    if (!parseArgs(args, "si", &fieldName, &numTokens))
    {
        OBJ_CALL(f = self->object->lengthNorm(fieldName, numTokens));
        return PyFloat_FromDouble((double) f);
    }

    return PyErr_SetArgsError((PyObject *) self, "lengthNorm", args);
}

static PyObject *j_similarity_queryNorm(j_similarity *self, PyObject *arg)
{
    jdouble sum;
    jfloat f;

    if (!parseArg(arg, "d", &sum))
    {
        OBJ_CALL(f = self->object->queryNorm((jfloat) sum));
        return PyFloat_FromDouble((double) f);
    }

    return PyErr_SetArgsError((PyObject *) self, "queryNorm", arg);
}

static PyObject *j_similarity_tf(j_similarity *self, PyObject *arg)
{
    jdouble d;
    jint n;
    jfloat f;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(f = self->object->tf(n));
        return PyFloat_FromDouble((double) f);
    }
    if (!parseArg(arg, "d", &d))
    {
        OBJ_CALL(f = self->object->tf((jfloat) d));
        return PyFloat_FromDouble((double) f);
    }
        
    return PyErr_SetArgsError((PyObject *) self, "tf", arg);
}

static PyObject *j_similarity_idf(j_similarity *self, PyObject *args)
{
    org::apache::lucene::index::Term *term;
    JArray<org::apache::lucene::index::Term *> *terms;
    org::apache::lucene::search::Searcher *searcher;
    jint docFreq, numDocs;
    jfloat f;

    if (!parseArgs(args, "ii", &docFreq, &numDocs))
    {
        OBJ_CALL(f = self->object->idf(docFreq, numDocs));
        return PyFloat_FromDouble((double) f);
    }
    if (!parseArgs(args, "JJ", &org::apache::lucene::index::Term::class$,
                   &org::apache::lucene::search::Searcher::class$,
                   &term, &searcher))
    {
        OBJ_CALL(f = self->object->idf(term, searcher));
        return PyFloat_FromDouble((double) f);
    }
    if (!parseArgs(args, "KJ", &org::apache::lucene::index::Term::class$,
                   &org::apache::lucene::search::Searcher::class$,
                   &terms, &org::apache::lucene::index::Term::class$,
                   &searcher))
    {
        OBJ_CALL(f = self->object->idf((java::util::Collection *) java::util::Arrays::asList((jobjectArray) terms), searcher));
        return PyFloat_FromDouble((double) f);
    }
        
    return PyErr_SetArgsError((PyObject *) self, "idf", args);
}

static PyObject *j_similarity_coord(j_similarity *self, PyObject *args)
{
    jint overlap, maxOverlap;
    jfloat f;

    if (!parseArgs(args, "ii", &overlap, &maxOverlap))
    {
        OBJ_CALL(f = self->object->coord(overlap, maxOverlap));
        return PyFloat_FromDouble((double) f);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "coord", args);
}

static PyObject *j_similarity_sloppyFreq(j_similarity *self, PyObject *arg)
{
    jint distance;
    jfloat f;

    if (!parseArg(arg, "i", &distance))
    {
        OBJ_CALL(f = self->object->sloppyFreq(distance));
        return PyFloat_FromDouble((double) f);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "sloppyFreq", arg);
}


/* ScoreDoc */

static int j_scoredoc_init(j_scoredoc *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::ScoreDoc *sd;
    jint doc;
    jdouble score;

    if (!parseArgs(args, "id", &doc, &score))
    {
        INT_CALL(sd = new org::apache::lucene::search::ScoreDoc(doc, (jfloat) score));
        self->object = sd;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_DOWNCAST(j_scoredoc, FieldDoc,
                org::apache::lucene::search::FieldDoc);

static PyObject *j_scoredoc_get_score(j_scoredoc *self, void *data)
{
    return PyFloat_FromDouble((double) self->object->score);
}

static int j_scoredoc_set_score(j_scoredoc *self, PyObject *arg, void *data)
{
    jdouble score;

    if (!parseArg(arg, "d", &score))
    {
        self->object->score = (jfloat) score;
        return 0;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "score", arg);
        return -1;
    }
}

static PyObject *j_scoredoc_get_doc(j_scoredoc *self, void *data)
{
    return PyInt_FromLong(self->object->doc);
}

static int j_scoredoc_set_doc(j_scoredoc *self, PyObject *arg, void *data)
{
    jint doc;

    if (!parseArg(arg, "i", &doc))
    {
        self->object->doc = doc;
        return 0;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "doc", arg);
        return -1;
    }
}


/* FieldDoc */

static int j_fielddoc_init(j_fielddoc *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FieldDoc *fd;
    jint doc;
    jdouble score;
    JArray<java::lang::Comparable *> *comparables;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "id", &doc, &score))
        {
            INT_CALL(fd = new org::apache::lucene::search::FieldDoc(doc, (jfloat) score));
            self->object = fd;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "idQ", &java::lang::Comparable::class$,
                       check_Comparable, &doc, &score,
                       &comparables, &java::lang::Comparable::class$,
                       make_Comparable))
        {
            INT_CALL(fd = new org::apache::lucene::search::FieldDoc(doc, (jfloat) score, comparables));
            self->object = fd;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_fielddoc_get_fields(j_fielddoc *self, void *data)
{
    JArray<java::lang::Comparable *> *comparables = self->object->fields;
    return ja2pl((jobjectArray) comparables, (PyObject *(*)(jobject)) jc2pc);
}

static int j_fielddoc_set_fields(j_fielddoc *self, PyObject *arg, void *data)
{
    JArray<java::lang::Comparable *> *comparables;

    if (!parseArg(arg, "Q", &java::lang::Comparable::class$, check_Comparable,
                  &comparables, &java::lang::Comparable::class$,
                  check_Comparable, make_Comparable))
    {
        INT_CALL(self->object->fields = comparables);
        return 0;
    }

    PyErr_SetArgsError((PyObject *) self, "fields", arg);
    return -1;
}


/* TopDocs */

static int j_topdocs_init(j_topdocs *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::TopDocs *td;
    jint totalHits;
    JArray<org::apache::lucene::search::ScoreDoc *> *sds;
    jdouble maxScore;

    if (!parseArgs(args, "iKd", &org::apache::lucene::search::ScoreDoc::class$,
                   &totalHits,
                   &sds, &org::apache::lucene::search::ScoreDoc::class$,
                   &maxScore))
    {
        INT_CALL(td = new org::apache::lucene::search::TopDocs(totalHits, sds, (jfloat) maxScore));
        self->object = td;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_FLOAT_GETSET(MaxScore, j_topdocs);

static PyObject *j_topdocs_get_scoreDocs(j_topdocs *self, void *data)
{
    return ja2pl((jobjectArray) self->object->scoreDocs,
                 (PyObject *(*)(jobject)) wrap_ScoreDoc);
}

static int j_topdocs_set_scoreDocs(j_topdocs *self, PyObject *arg, void *data)
{
    JArray<org::apache::lucene::search::ScoreDoc *> *sds;

    if (!parseArg(arg, "K", &org::apache::lucene::search::ScoreDoc::class$,
                  &sds, &org::apache::lucene::search::ScoreDoc::class$))
    {
        self->object->scoreDocs = sds;
        return 0;
    }

    PyErr_SetArgsError((PyObject *) self, "scoreDocs", arg);
    return -1;
}

static PyObject *j_topdocs_get_totalHits(j_topdocs *self, void *data)
{
    return PyInt_FromLong(self->object->totalHits);
}

static int j_topdocs_set_totalHits(j_topdocs *self, PyObject *arg, void *data)
{
    jint totalHits;

    if (!parseArg(arg, "i", &totalHits))
    {
        self->object->totalHits = totalHits;
        return 0;
    }

    PyErr_SetArgsError((PyObject *) self, "totalHits", arg);
    return -1;
}


/* TopFieldDocs */

static int j_topfielddocs_init(j_topfielddocs *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::TopFieldDocs *tfd;
    jint totalHits;
    JArray<org::apache::lucene::search::ScoreDoc *> *sds;
    JArray<org::apache::lucene::search::SortField *> *sfs;
    jdouble maxScore;
    
    if (!parseArgs(args, "iKKd",
                   &org::apache::lucene::search::ScoreDoc::class$,
                   &org::apache::lucene::search::SortField::class$,
                   &totalHits,
                   &sds, &org::apache::lucene::search::ScoreDoc::class$,
                   &sfs, &org::apache::lucene::search::SortField::class$,
                   &maxScore))
    {
        INT_CALL(tfd = new org::apache::lucene::search::TopFieldDocs(totalHits, sds, sfs, (jfloat) maxScore));
        self->object = tfd;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_topfielddocs_get_fields(j_topfielddocs *self, void *data)
{
    return ja2pl((jobjectArray) self->object->fields,
                 (PyObject *(*)(jobject)) wrap_SortField);
}

static int j_topfielddocs_set_fields(j_topfielddocs *self,
                                     PyObject *arg, void *data)
{
    JArray<org::apache::lucene::search::SortField *> *sfs;

    if (!parseArg(arg, "K", &org::apache::lucene::search::SortField::class$,
                  &sfs, &org::apache::lucene::search::SortField::class$))
    {
        self->object->fields = sfs;
        return 0;
    }

    PyErr_SetArgsError((PyObject *) self, "fields", arg);
    return -1;
}


/* ScoreDocComparator */

static PyObject *j_scoredoccomparator_compare(j_scoredoccomparator *self,
                                              PyObject *args)
{
    org::apache::lucene::search::ScoreDoc *i, *j;
    jint value;

    if (!parseArgs(args, "JJ",
                   &org::apache::lucene::search::ScoreDoc::class$,
                   &org::apache::lucene::search::ScoreDoc::class$,
                   &i, &j))
    {
        OBJ_CALL(value = self->object->compare(i, j));
        return PyInt_FromLong(value);
    }

    return PyErr_SetArgsError((PyObject *) self, "compare", args);
}

static PyObject *j_scoredoccomparator_sortValue(j_scoredoccomparator *self,
                                                PyObject *arg)
{
    org::apache::lucene::search::ScoreDoc *i;
    java::lang::Comparable *comparable;

    if (!parseArg(arg, "J", &org::apache::lucene::search::ScoreDoc::class$, &i))
    {
        OBJ_CALL(comparable = self->object->sortValue(i));
        return jc2pc(comparable);
    }

    return PyErr_SetArgsError((PyObject *) self, "sortValue", arg);
}

static PyObject *j_scoredoccomparator_sortType(j_scoredoccomparator *self)
{
    jint type;

    OBJ_CALL(type = self->object->sortType());
    return PyInt_FromLong(type);
}


/* SortComparatorSource */

static int j_sortcomparatorsource_init(j_sortcomparatorsource *self,
                                       PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::SortComparatorSource *src;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::SortComparatorSource::class$,
                   check_SortComparatorSource, &src, make_SortComparatorSource))
    {
        if (src)
        {
            self->object = src;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_sortcomparatorsource_newComparator(j_sortcomparatorsource *self, PyObject *args)
{
    org::apache::lucene::search::ScoreDocComparator *comparator;    
    org::apache::lucene::index::IndexReader *reader;
    jstring fieldName;

    if (!parseArgs(args, "Js",
                   &org::apache::lucene::index::IndexReader::class$, &reader,
                   &fieldName))
    {
        OBJ_CALL(comparator = self->object->newComparator(reader, fieldName));
        return wrap_ScoreDocComparator(comparator);
    }

    return PyErr_SetArgsError((PyObject *) self, "newComparator", args);
}

/* SortField */

static int j_sortfield_init(j_sortfield *self,
                            PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::SortField *sf;
    jstring field;
    jboolean reverse;
    jint type;
    java::util::Locale *locale;
    org::apache::lucene::search::SortComparatorSource *src;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "s", &field))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field));
            self->object = sf;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "sB", &field, &reverse))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, reverse));
            self->object = sf;
            break;
        }
        if (!parseArgs(args, "si", &field, &type))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, type));
            self->object = sf;
            break;
        }
        if (!parseArgs(args, "sJ", &java::util::Locale::class$,
                       &field, &locale))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, locale));
            self->object = sf;
            break;
        }
        if (!parseArgs(args, "sP", &org::apache::lucene::search::SortComparatorSource::class$,
                       check_SortComparatorSource, 
                       &field, &src, &make_SortComparatorSource))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, src));
            self->object = sf;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "sib", &field, &type, &reverse))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, type, reverse));
            self->object = sf;
            break;
        }
        if (!parseArgs(args, "sJb", &java::util::Locale::class$,
                       &field, &locale, &reverse))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, locale, reverse));
            self->object = sf;
            break;
        }
        if (!parseArgs(args, "sPb", &org::apache::lucene::search::SortComparatorSource::class$,
                       check_SortComparatorSource, 
                       &field, &src, &make_SortComparatorSource, &reverse))
        {
            INT_CALL(sf = new org::apache::lucene::search::SortField(field, src, reverse));
            self->object = sf;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Factory, j_sortfield, SortComparatorSource,
                  org::apache::lucene::search::SortComparatorSource);
DEFINE_STRING_GETTER(Field, j_sortfield);
DEFINE_INT_GETTER(Type, j_sortfield);
DEFINE_OBJ_GETTER(Locale, j_sortfield, Locale, java::util::Locale);

static PyObject *j_sortfield_getReverse(j_sortfield *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->getReverse());
    Py_RETURN_BOOL(b);
}


/* Sort */

static int j_sort_init(j_sort *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::Sort *sort;
    org::apache::lucene::search::SortField *sf;
    JArray<org::apache::lucene::search::SortField *> *sfs;
    jstring field;
    jstringArray fields;
    jboolean reverse;
    jint type;
    java::util::Locale *locale;
    org::apache::lucene::search::SortComparatorSource *src;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(sort = new org::apache::lucene::search::Sort());
        self->object = sort;
        break;
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::search::SortField::class$, &sf))
        {
            INT_CALL(sort = new org::apache::lucene::search::Sort(sf));
            self->object = sort;
            break;
        }
        if (!parseArgs(args, "K",
                       &org::apache::lucene::search::SortField::class$, &sfs,
                       &org::apache::lucene::search::SortField::class$))
        {
            INT_CALL(sort = new org::apache::lucene::search::Sort(sfs));
            self->object = sort;
            break;
        }
        if (!parseArgs(args, "s", &field))
        {
            INT_CALL(sort = new org::apache::lucene::search::Sort(field));
            self->object = sort;
            break;
        }
        if (!parseArgs(args, "S", &fields))
        {
            INT_CALL(sort = new org::apache::lucene::search::Sort(fields));
            self->object = sort;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "sb", &field, &reverse))
        {
            INT_CALL(sort = new org::apache::lucene::search::Sort(field, reverse));
            self->object = sort;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_sort_setSort(j_sort *self, PyObject *args)
{
    org::apache::lucene::search::Sort *sort;
    org::apache::lucene::search::SortField *sf;
    JArray<org::apache::lucene::search::SortField *> *sfs;
    jstring field;
    jstringArray fields;
    jboolean reverse;
    jint type;
    java::util::Locale *locale;
    org::apache::lucene::search::SortComparatorSource *src;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::search::SortField::class$, &sf))
        {
            OBJ_CALL(self->object->setSort(sf));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "K",
                       &org::apache::lucene::search::SortField::class$, &sfs,
                       &org::apache::lucene::search::SortField::class$))
        {
            OBJ_CALL(self->object->setSort(sfs));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "s", &field))
        {
            OBJ_CALL(self->object->setSort(field));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "S", &fields))
        {
            OBJ_CALL(self->object->setSort(fields));
            Py_RETURN_NONE;
        }
        break;
      case 2:
        if (!parseArgs(args, "sb", &field, &reverse))
        {
            OBJ_CALL(self->object->setSort(field, reverse));
            Py_RETURN_NONE;
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "setSort", args);
}


/* TopDocCollector */

static int j_topdoccollector_init(j_topdoccollector *self,
                                  PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::TopDocCollector *tdc;
    jint numHits;

    if (!parseArgs(args, "i", &numHits))
    {
        INT_CALL(tdc = new org::apache::lucene::search::TopDocCollector(numHits));
        self->object = tdc;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_INT_GETTER(TotalHits, j_topdoccollector);

static PyObject *j_topdoccollector_topDocs(j_topdoccollector *self)
{
    org::apache::lucene::search::TopDocs *docs;

    OBJ_CALL(docs = self->object->topDocs());
    return wrap_TopDocs(docs);
}


/* TopFieldDocCollector */

static int j_topfielddoccollector_init(j_topfielddoccollector *self,
                                       PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::TopFieldDocCollector *tfdc;
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::search::Sort *sort;
    jint numHits;

    if (!parseArgs(args, "JJi",
                   &org::apache::lucene::index::IndexReader::class$,
                   &org::apache::lucene::search::Sort::class$,
                   &reader, &sort, &numHits))
    {
        INT_CALL(tfdc = new org::apache::lucene::search::TopFieldDocCollector(reader, sort, numHits));
        self->object = tfdc;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* Filter */

static int j_filter_init(j_filter *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::Filter *filter;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::Filter::class$,
                   check_Filter, &filter, make_Filter))
    {
        if (filter)
        {
            self->object = filter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_filter_bits(j_filter *self, PyObject *arg)
{
    java::util::BitSet *bits;
    org::apache::lucene::index::IndexReader *reader;

    if (!parseArg(arg, "J", &org::apache::lucene::index::IndexReader::class$,
                  &reader))
    {
        OBJ_CALL(bits = self->object->bits(reader));
        return wrap_BitSet(bits);
    }

    return PyErr_SetArgsError((PyObject *) self, "bits", arg);
}


/* Searchable */

static int j_searchable_init(j_searchable *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::Searchable *searchable;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::Searchable::class$,
                   check_Searchable, &searchable, make_Searchable))
    {
        if (searchable)
        {
            self->object = searchable;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_searchable_close(j_searchable *self)
{
    OBJ_CALL(self->object->close());
    Py_RETURN_NONE;
}

static PyObject *j_searchable_doc(j_searchable *self, PyObject *arg)
{
    org::apache::lucene::document::Document *doc;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(doc = self->object->doc(n));
        return wrap_Document(doc);
    }

    return PyErr_SetArgsError((PyObject *) self, "doc", arg);
}

static PyObject *j_searchable_docFreq(j_searchable *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;
    jint freq;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$, &term))
    {
        OBJ_CALL(freq = self->object->docFreq(term));
        return PyInt_FromLong(freq);
    }

    return PyErr_SetArgsError((PyObject *) self, "docFreq", arg);
}

static PyObject *j_searchable_docFreqs(j_searchable *self, PyObject *arg)
{
    JArray<org::apache::lucene::index::Term *> *terms;
    jintArray freqs;

    if (!parseArg(arg, "K",
                  &org::apache::lucene::index::Term::class$,
                  &terms, &org::apache::lucene::index::Term::class$))
    {
        OBJ_CALL(freqs = self->object->docFreqs(terms));
        return jia2pil(freqs);
    }

    return PyErr_SetArgsError((PyObject *) self, "docFreqs", arg);
}

static PyObject *j_searchable_explain(j_searchable *self, PyObject *args)
{
    org::apache::lucene::search::Weight *weight;
    jint doc;
    org::apache::lucene::search::Explanation *explanation;

    if (!parseArgs(args, "Ji", &org::apache::lucene::search::Weight::class$,
                   &weight, &doc))
    {
        OBJ_CALL(explanation = self->object->explain(weight, doc));
        return wrap_Explanation(explanation);
    }

    return PyErr_SetArgsError((PyObject *) self, "explain", args);
}

static PyObject *j_searchable_maxDoc(j_searchable *self)
{
    jint n;

    OBJ_CALL(n = self->object->maxDoc());
    return PyInt_FromLong(n);
}

static PyObject *j_searchable_rewrite(j_searchable *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::Query::class$,
                  &query))
    {
        OBJ_CALL(query = self->object->rewrite(query));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "rewrite", arg);
}

static PyObject *j_searchable_search(j_searchable *self, PyObject *args)
{
    org::apache::lucene::search::TopDocs *td;
    org::apache::lucene::search::TopFieldDocs *tfd;
    org::apache::lucene::search::Weight *weight;
    org::apache::lucene::search::Filter *filter;
    org::apache::lucene::search::Sort *sort;
    org::apache::lucene::search::HitCollector *collector;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 3:
        if (!parseArgs(args, "JPi",
                       &org::apache::lucene::search::Weight::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter, &weight, &filter, make_Filter, &n))
        {
            OBJ_CALL(td = self->object->search(weight, filter, n));
            return wrap_TopDocs(td);
        }
        if (!parseArgs(args, "JPP",
                       &org::apache::lucene::search::Weight::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &org::apache::lucene::search::HitCollector::class$,
                       check_HitCollector, &weight, &filter, make_Filter,
                       &collector, make_HitCollector))
        {
            OBJ_CALL(self->object->search(weight, filter, collector));
            Py_RETURN_NONE;
        }
        break;
      case 4:
        if (!parseArgs(args, "JPiJ",
                       &org::apache::lucene::search::Weight::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &org::apache::lucene::search::Sort::class$,
                       &weight, &filter, make_Filter, &n, &sort))
        {
            OBJ_CALL(tfd = self->object->search(weight, filter, n, sort));
            return wrap_TopFieldDocs(tfd);
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "search", args);
}

DEFINE_DOWNCAST(j_searchable, Searcher,
                org::apache::lucene::search::Searcher);


/* Searcher */

static PyObject *j_searcher_search(j_searcher *self, PyObject *args)
{
    org::apache::lucene::search::TopDocs *docs;
    org::apache::lucene::search::TopFieldDocs *fieldDocs;
    org::apache::lucene::search::Query *query;
    org::apache::lucene::search::Filter *filter;
    org::apache::lucene::search::Sort *sort;
    org::apache::lucene::search::Hits *hits;
    org::apache::lucene::search::HitCollector *collector;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::search::Query::class$,
                       &query))
        {
            OBJ_CALL(hits = self->object->search(query));
            return wrap_Hits(hits);
        }
        break;
      case 2:
        if (!parseArgs(args, "JP",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::HitCollector::class$,
                       check_HitCollector,
                       &query, &collector, &make_HitCollector))
        {
            OBJ_CALL(self->object->search(query, collector));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "JP",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::HitCollector::class$,
                       check_HitCollector,
                       &query, &collector, &make_HitCollector))
        {
            OBJ_CALL(self->object->search(query, collector));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "JP",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &query, &filter, &make_Filter))
        {
            OBJ_CALL(hits = self->object->search(query, filter));
            return wrap_Hits(hits);
        }
        if (!parseArgs(args, "JJ",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Sort::class$,
                       &query, &sort))
        {
            OBJ_CALL(hits = self->object->search(query, sort));
            return wrap_Hits(hits);
        }
        break;
      case 3:
        if (!parseArgs(args, "JPP",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &org::apache::lucene::search::HitCollector::class$,
                       check_HitCollector,
                       &query, &filter, make_Filter,
                       &collector, &make_HitCollector))
        {
            OBJ_CALL(self->object->search(query, filter, collector));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "JPJ",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &org::apache::lucene::search::Sort::class$,
                       &query, &filter, make_Filter, &sort))
        {
            OBJ_CALL(hits = self->object->search(query, filter, sort));
            return wrap_Hits(hits);
        }
        if (!parseArgs(args, "JPi",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &query, &filter, make_Filter, &n))
        {
            OBJ_CALL(docs = self->object->search(query, filter, n));
            return wrap_TopDocs(docs);
        }
        break;
      case 4:
        if (!parseArgs(args, "JPiJ",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::Filter::class$,
                       check_Filter,
                       &org::apache::lucene::search::Sort::class$,
                       &query, &filter, make_Filter, &n, &sort))
        {
            OBJ_CALL(fieldDocs = self->object->search(query, filter, n, sort));
            return wrap_TopFieldDocs(fieldDocs);
        }
    }

    return j_searchable_search((j_searchable *) self, args);
}

static PyObject *j_searcher_explain(j_searcher *self, PyObject *args)
{
    org::apache::lucene::search::Query *query;
    jint doc;
    org::apache::lucene::search::Explanation *explanation;

    if (!parseArgs(args, "Ji", &org::apache::lucene::search::Query::class$,
                   &query, &doc))
    {
        OBJ_CALL(explanation = self->object->explain(query, doc));
        return wrap_Explanation(explanation);
    }

    return j_searchable_explain((j_searchable *) self, args);
}

DEFINE_POBJ_GETSET(Similarity, j_searcher, Similarity,
                   org::apache::lucene::search::Similarity);

DEFINE_DOWNCAST(j_searcher, IndexSearcher,
                org::apache::lucene::search::IndexSearcher);
DEFINE_DOWNCAST(j_searcher, MultiSearcher,
                org::apache::lucene::search::MultiSearcher);
DEFINE_DOWNCAST(j_searcher, ParallelMultiSearcher,
                org::apache::lucene::search::ParallelMultiSearcher);


/* IndexSearcher */

static int j_indexsearcher_init(j_indexsearcher *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::IndexSearcher *searcher;
    org::apache::lucene::store::Directory *dir;
    org::apache::lucene::index::IndexReader *reader;
    jstring path;

    if (!parseArgs(args, "s", &path))
    {
        INT_CALL(searcher = new org::apache::lucene::search::IndexSearcher(path));
        self->object = searcher;
    }
    else if (!parseArgs(args, "P",
                        &org::apache::lucene::store::Directory::class$,
                        check_Directory, &dir, make_Directory))
    {
        INT_CALL(searcher = new org::apache::lucene::search::IndexSearcher(dir));
        self->object = searcher;
    }
    else if (!parseArgs(args, "J",
                        &org::apache::lucene::index::IndexReader::class$,
                        &reader))
    {
        INT_CALL(searcher = new org::apache::lucene::search::IndexSearcher(reader));
        self->object = searcher;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(IndexReader, j_indexsearcher, IndexReader,
                  org::apache::lucene::index::IndexReader);


/* MultiSearcher */

static int j_multisearcher_init(j_multisearcher *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::MultiSearcher *searcher;
    JArray<org::apache::lucene::search::Searchable *> *searchables;

    if (!parseArgs(args, "Q",
                   &org::apache::lucene::search::Searchable::class$,
                   check_Searchable, &searchables,
                   &org::apache::lucene::search::Searchable::class$,
                   check_Searchable, make_Searchable))
    {
        INT_CALL(searcher = new org::apache::lucene::search::MultiSearcher(searchables));
        self->object = searcher;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
        
}

static PyObject *j_multisearcher_subDoc(j_multisearcher *self, PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(n = self->object->subDoc(n));
        return PyInt_FromLong(n);
    }

    return PyErr_SetArgsError((PyObject *) self, "subDoc", arg);
}

static PyObject *j_multisearcher_subSearcher(j_multisearcher *self,
                                             PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(n = self->object->subSearcher(n));
        return PyInt_FromLong(n);
    }

    return PyErr_SetArgsError((PyObject *) self, "subDoc", arg);
}

static PyObject *j_multisearcher_getSearchables(j_multisearcher *self)
{
    JArray<org::apache::lucene::search::Searchable *> *searchables;

    OBJ_CALL(searchables = self->object->getSearchables());
    return ja2pl((jobjectArray) searchables,
                 (PyObject *(*)(jobject)) wrap_Searchable);
}


/* ParallelMultiSearcher */

static int j_parallelmultisearcher_init(j_parallelmultisearcher *self,
                                        PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::ParallelMultiSearcher *searcher;
    JArray<org::apache::lucene::search::Searchable *> *searchables;

    if (!parseArgs(args, "Q",
                   &org::apache::lucene::search::Searchable::class$,
                   check_Searchable, &searchables,
                   &org::apache::lucene::search::Searchable::class$,
                   check_Searchable, make_Searchable))
    {
        INT_CALL(searcher = new org::apache::lucene::search::ParallelMultiSearcher(searchables));
        self->object = searcher;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* Explanation */

static int j_explanation_init(j_explanation *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::Explanation *explanation;
    jdouble d;
    jstring s;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(explanation = new org::apache::lucene::search::Explanation());
        self->object = explanation;
        break;
      case 2:
        if (!parseArgs(args, "ds", &d, &s))
        {
            INT_CALL(explanation = new org::apache::lucene::search::Explanation((jfloat) d, s));
            self->object = explanation;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_explanation_addDetail(j_explanation *self, PyObject *arg)
{
    org::apache::lucene::search::Explanation *explanation;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::Explanation::class$,
                  &explanation))
    {
        OBJ_CALL(self->object->addDetail(explanation));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "addDetail", arg);
}

static PyObject *j_explanation_getDetails(j_explanation *self)
{
    JArray<org::apache::lucene::search::Explanation *> *explanations;

    OBJ_CALL(explanations = self->object->getDetails());
    return ja2pl((jobjectArray) explanations,
                 (PyObject *(*)(jobject)) wrap_Explanation);
}

DEFINE_STRING_GETSET(Description, j_explanation);
DEFINE_FLOAT_GETSET(Value, j_explanation);

static PyObject *j_explanation_toHtml(j_explanation *self)
{
    jstring html;

    OBJ_CALL(html = self->object->toHtml());
    return j2p(html);
}


/* MatchAllDocsQuery */

DEFINE_0_INIT(j_matchalldocsquery,
              org::apache::lucene::search::MatchAllDocsQuery);


/* BooleanClause */

static int j_booleanclause_init(j_booleanclause *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::BooleanClause *clause;
    org::apache::lucene::search::Query *query;
    org::apache::lucene::search::BooleanClause$Occur *occur;

    if (!parseArgs(args, "JJ",
                   &org::apache::lucene::search::Query::class$,
                   &org::apache::lucene::search::BooleanClause$Occur::class$,
                   &query, &occur))
    {
        INT_CALL(clause = new org::apache::lucene::search::BooleanClause(query, occur));
        self->object = clause;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETSET(Query, j_booleanclause, Query,
                  org::apache::lucene::search::Query);
DEFINE_OBJ_GETSET(Occur, j_booleanclause, BooleanClause_Occur,
                  org::apache::lucene::search::BooleanClause$Occur);
DEFINE_BOOL_GETTER(Prohibited, j_booleanclause);
DEFINE_BOOL_GETTER(Required, j_booleanclause);


/* BooleanQuery */

static int j_booleanquery_init(j_booleanquery *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::BooleanQuery *query;
    jboolean b;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(query = new org::apache::lucene::search::BooleanQuery());
        self->object = query;
        break;
      case 1:
        if (!parseArgs(args, "b", &b))
        {
            INT_CALL(query = new org::apache::lucene::search::BooleanQuery(b));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_booleanquery_getUseScorer14(PyTypeObject *type)
{
    jboolean b;

    OBJ_CALL(b = org::apache::lucene::search::BooleanQuery::getUseScorer14());
    Py_RETURN_BOOL(b);
}

static PyObject *j_booleanquery_setUseScorer14(PyTypeObject *type, PyObject *arg)
{
    jboolean b;

    if (!parseArg(arg, "b", &b))
    {
        OBJ_CALL(org::apache::lucene::search::BooleanQuery::setUseScorer14(b));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "setUseScorer14", arg);
}

static PyObject *j_booleanquery_getMaxClauseCount(PyTypeObject *type)
{
    jint n;

    OBJ_CALL(n = org::apache::lucene::search::BooleanQuery::getMaxClauseCount());
    return PyInt_FromLong(n);
}

static PyObject *j_booleanquery_setMaxClauseCount(PyTypeObject *type,
                                                  PyObject *arg)
{
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(org::apache::lucene::search::BooleanQuery::setMaxClauseCount(n));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "setMaxClauseCount", arg);
}

DEFINE_BOOL_GETTER(CoordDisabled, j_booleanquery);

static PyObject *j_booleanquery_getClauses(j_booleanquery *self)
{
    JArray<org::apache::lucene::search::BooleanClause *> *clauses;
    
    OBJ_CALL(clauses = self->object->getClauses());
    return ja2pl((jobjectArray) clauses,
                 (PyObject *(*)(jobject)) wrap_BooleanClause);
}

static PyObject *j_booleanquery_add(j_booleanquery *self, PyObject *args)
{
    org::apache::lucene::search::Query *query;
    org::apache::lucene::search::BooleanClause *clause;
    org::apache::lucene::search::BooleanClause$Occur *occur;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J", 
                   &org::apache::lucene::search::BooleanClause::class$,
                   &clause))
        {
            OBJ_CALL(self->object->add(clause));
            Py_RETURN_NONE;
        }
        break;
      case 2:
        if (!parseArgs(args, "JJ",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::search::BooleanClause$Occur::class$,
                       &query, &occur))
        {
            OBJ_CALL(self->object->add(query, occur));
            Py_RETURN_NONE;
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", args);
}

DEFINE_INT_GETSET(MinimumNumberShouldMatch, j_booleanquery);


/* TermQuery */

static int j_termquery_init(j_termquery *self,
                            PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::TermQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(query = new org::apache::lucene::search::TermQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Term, j_termquery, Term, org::apache::lucene::index::Term);

/* PrefixQuery */

static int j_prefixquery_init(j_prefixquery *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::PrefixQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(query = new org::apache::lucene::search::PrefixQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Prefix, j_prefixquery, Term,
                  org::apache::lucene::index::Term);


/* PhraseQuery */

DEFINE_0_INIT(j_phrasequery, org::apache::lucene::search::PhraseQuery);
DEFINE_INT_GETSET(Slop, j_phrasequery);

static PyObject *j_phrasequery_add(j_phrasequery *self, PyObject *args)
{
    org::apache::lucene::index::Term *term;
    jint position;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::index::Term::class$, &term))
        {
            OBJ_CALL(self->object->add(term));
            Py_RETURN_NONE;
        }
        break;
      case 2:
        if (!parseArgs(args, "Ji",
                       &org::apache::lucene::index::Term::class$,
                       &term, &position))
        {
            OBJ_CALL(self->object->add(term, position));
            Py_RETURN_NONE;
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", args);
}

static PyObject *j_phrasequery_getTerms(j_phrasequery *self)
{
    JArray<org::apache::lucene::index::Term *> *terms;

    OBJ_CALL(terms = self->object->getTerms());
    return ja2pl((jobjectArray) terms,
                 (PyObject *(*)(jobject)) wrap_Term);
}

static PyObject *j_phrasequery_getPositions(j_phrasequery *self)
{
    jintArray positions;

    OBJ_CALL(positions = self->object->getPositions());
    return jia2pil(positions);
}

/* MultiPhraseQuery */

DEFINE_0_INIT(j_multiphrasequery,
              org::apache::lucene::search::MultiPhraseQuery);
DEFINE_INT_GETSET(Slop, j_multiphrasequery);

static PyObject *j_multiphrasequery_add(j_multiphrasequery *self,
                                        PyObject *args)
{
    org::apache::lucene::index::Term *term;
    JArray<org::apache::lucene::index::Term *> *terms;
    jint position;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::index::Term::class$, &term))
        {
            OBJ_CALL(self->object->add(term));
            Py_RETURN_NONE;
        }
        if (!parseArgs(args, "K",
                       &org::apache::lucene::index::Term::class$,
                       &terms, &org::apache::lucene::index::Term::class$))

        {
            OBJ_CALL(self->object->add(terms));
            Py_RETURN_NONE;
        }
        break;
      case 2:
        if (!parseArgs(args, "Ki",
                       &org::apache::lucene::index::Term::class$,
                       &terms, &org::apache::lucene::index::Term::class$,
                       &position))
        {
            OBJ_CALL(self->object->add(terms, position));
            Py_RETURN_NONE;
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", args);
}

static PyObject *j_multiphrasequery_getPositions(j_multiphrasequery *self)
{
    jintArray positions;

    OBJ_CALL(positions = self->object->getPositions());
    return jia2pil(positions);
}


/* FilteredTermEnum */

static PyObject *j_filteredtermenum_difference(j_filteredtermenum *self)
{
    jfloat f;

    OBJ_CALL(f = self->object->difference());
    return PyFloat_FromDouble((double) f);
}


/* DefaultSimilarity */

DEFINE_0_INIT(j_defaultsimilarity,
              org::apache::lucene::search::DefaultSimilarity);


/* CachingWrapperFilter */

static int j_cachingwrapperfilter_init(j_cachingwrapperfilter *self,
                                       PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::CachingWrapperFilter *cwf;
    org::apache::lucene::search::Filter *filter;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::Filter::class$,
                   check_Filter, &filter, make_Filter))
    {
        INT_CALL(cwf = new org::apache::lucene::search::CachingWrapperFilter(filter));
        self->object = cwf;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* QueryFilter */

static int j_queryfilter_init(j_queryfilter *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::QueryFilter *filter;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::search::Query::class$, &query))
    {
        INT_CALL(filter = new org::apache::lucene::search::QueryFilter(query));
        self->object = filter;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* RangeFilter */

static int j_rangefilter_init(j_rangefilter *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::RangeFilter *filter;
    jstring fieldName, lowerTerm, upperTerm;
    jboolean includeLower, includeUpper;

    if (!parseArgs(args, "sssbb", &fieldName, &lowerTerm, &upperTerm,
                   &includeLower, &includeUpper))
    {
        INT_CALL(filter = new org::apache::lucene::search::RangeFilter(fieldName, lowerTerm, upperTerm, includeLower, includeUpper));
        self->object = filter;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_rangefilter_Less(PyTypeObject *type, PyObject *args)
{
    org::apache::lucene::search::RangeFilter *filter;
    jstring fieldName, upperTerm;

    if (!parseArgs(args, "ss", &fieldName, &upperTerm))
    {
        OBJ_CALL(filter = org::apache::lucene::search::RangeFilter::Less(fieldName, upperTerm));
        return wrap_RangeFilter(filter);
    }

    return PyErr_SetArgsError(type, "Less", args);
}

static PyObject *j_rangefilter_More(PyTypeObject *type, PyObject *args)
{
    org::apache::lucene::search::RangeFilter *filter;
    jstring fieldName, lowerTerm;

    if (!parseArgs(args, "ss", &fieldName, &lowerTerm))
    {
        OBJ_CALL(filter = org::apache::lucene::search::RangeFilter::More(fieldName, lowerTerm));
        return wrap_RangeFilter(filter);
    }

    return PyErr_SetArgsError(type, "More", args);
}


/* PrefixFilter */

static int j_prefixfilter_init(j_prefixfilter *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::PrefixFilter *filter;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(filter = new org::apache::lucene::search::PrefixFilter(term));
        self->object = filter;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* FuzzyTermEnum */

static int j_fuzzytermenum_init(j_fuzzytermenum *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FuzzyTermEnum *fte;
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::index::Term *term;
    jdouble d;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "JJ",
                       &org::apache::lucene::index::IndexReader::class$,
                       &org::apache::lucene::index::Term::class$,
                       &reader, &term))
        {
            INT_CALL(fte = new org::apache::lucene::search::FuzzyTermEnum(reader, term));
            self->object = fte;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "JJd",
                       &org::apache::lucene::index::IndexReader::class$,
                       &org::apache::lucene::index::Term::class$,
                       &reader, &term, &d))
        {
            INT_CALL(fte = new org::apache::lucene::search::FuzzyTermEnum(reader, term, (jfloat) d));
            self->object = fte;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 4:
        if (!parseArgs(args, "JJdi",
                       &org::apache::lucene::index::IndexReader::class$,
                       &org::apache::lucene::index::Term::class$,
                       &reader, &term, &d, &n))
        {
            INT_CALL(fte = new org::apache::lucene::search::FuzzyTermEnum(reader, term, (jfloat) d, n));
            self->object = fte;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }

    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* WildcardTermEnum */

static int j_wildcardtermenum_init(j_wildcardtermenum *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::WildcardTermEnum *wte;
    org::apache::lucene::index::IndexReader *reader;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "JJ",
                   &org::apache::lucene::index::IndexReader::class$,
                   &org::apache::lucene::index::Term::class$,
                   &reader, &term))
    {
        INT_CALL(wte = new org::apache::lucene::search::WildcardTermEnum(reader, term));
        self->object = wte;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* FilteredQuery */

static int j_filteredquery_init(j_filteredquery *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FilteredQuery *fq;
    org::apache::lucene::search::Query *query;
    org::apache::lucene::search::Filter *filter;

    if (!parseArgs(args, "JP",
                   &org::apache::lucene::search::Query::class$,
                   &org::apache::lucene::search::Filter::class$, check_Filter,
                   &query, &filter, make_Filter))
    {
        INT_CALL(fq = new org::apache::lucene::search::FilteredQuery(query, filter));
        self->object = fq;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Query, j_filteredquery, Query,
                  org::apache::lucene::search::Query);


/* RangeQuery */

static int j_rangequery_init(j_rangequery *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::RangeQuery *query;
    org::apache::lucene::index::Term *lowerTerm, *upperTerm;
    jboolean b;

    if (!parseArgs(args, "JJb",
                   &org::apache::lucene::index::Term::class$,
                   &org::apache::lucene::index::Term::class$,
                   &lowerTerm, &upperTerm, &b))
    {
        INT_CALL(query = new org::apache::lucene::search::RangeQuery(lowerTerm, upperTerm, b));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_STRING_GETTER(Field, j_rangequery);
DEFINE_OBJ_GETTER(LowerTerm, j_rangequery, Term,
                  org::apache::lucene::index::Term);
DEFINE_OBJ_GETTER(UpperTerm, j_rangequery, Term,
                  org::apache::lucene::index::Term);
DEFINE_BOOL_GETTER(Inclusive, j_rangequery);


/* ConstantScoreQuery */

static int j_constantscorequery_init(j_constantscorequery *self,
                                     PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::ConstantScoreQuery *query;
    org::apache::lucene::search::Filter *filter;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::search::Filter::class$, &filter))
    {
        INT_CALL(query = new org::apache::lucene::search::ConstantScoreQuery(filter));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* ConstantScoreRangeQuery */

static int j_constantscorerangequery_init(j_constantscorerangequery *self,
                                          PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::ConstantScoreRangeQuery *query;
    jstring field, lowerVal, upperVal;
    jboolean includeLower, includeUpper;

    if (!parseArgs(args, "sssbb", &field, &lowerVal, &upperVal,
                   &includeLower, &includeUpper))
    {
        INT_CALL(query = new org::apache::lucene::search::ConstantScoreRangeQuery(field, lowerVal, upperVal, includeLower, includeUpper));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_STRING_GETTER(Field, j_constantscorerangequery);
DEFINE_STRING_GETTER(LowerVal, j_constantscorerangequery);
DEFINE_STRING_GETTER(UpperVal, j_constantscorerangequery);

static PyObject *j_constantscorerangequery_includesLower(j_constantscorerangequery *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->includesLower());
    Py_RETURN_BOOL(b);
}

static PyObject *j_constantscorerangequery_includesUpper(j_constantscorerangequery *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->includesUpper());
    Py_RETURN_BOOL(b);
}


/* QueryIterator */

static PyObject *j_queryiterator_next(j_queryiterator *self)
{
    org::apache::lucene::search::Query *query;

    EXC_OBJ_CALL(
        {
            query = (org::apache::lucene::search::Query *) self->object->next();
        },
        java::util::NoSuchElementException,
        {
            PyErr_SetNone(PyExc_StopIteration);
            return NULL;
        });

    return wrap_Query(query);
}


/* DisjunctionMaxQuery */

static int j_disjunctionmaxquery_init(j_disjunctionmaxquery *self,
                                      PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::DisjunctionMaxQuery *query;
    JArray<org::apache::lucene::search::Query *> *queries;
    jfloat tie;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "d", &tie))
        {
            INT_CALL(query = new org::apache::lucene::search::DisjunctionMaxQuery(tie));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "Kd",
                       &org::apache::lucene::search::Query::class$,
                       &queries, &org::apache::lucene::search::Query::class$,
                       &tie))
        {
            INT_CALL(query = new org::apache::lucene::search::DisjunctionMaxQuery((java::util::Collection *) java::util::Arrays::asList((jobjectArray) queries), tie));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_disjunctionmaxquery_add(j_disjunctionmaxquery *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    JArray<org::apache::lucene::search::Query *> *queries;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::Query::class$, &query))
    {
        OBJ_CALL(self->object->add(query));
        Py_RETURN_NONE;
    }
    if (!parseArg(arg, "K",
                  &org::apache::lucene::search::Query::class$, &queries,
                  &org::apache::lucene::search::Query::class$))
    {
        OBJ_CALL(self->object->add((java::util::Collection *) java::util::Arrays::asList((jobjectArray) queries)));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", arg);
}

static PyObject *j_disjunctionmaxquery_iterator(j_disjunctionmaxquery *self)
{
    java::util::Iterator *iterator;

    OBJ_CALL(iterator = self->object->iterator());
    return wrap_QueryIterator(iterator);
}


/* FuzzyQuery */

static int j_fuzzyquery_init(j_fuzzyquery *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FuzzyQuery *query;
    org::apache::lucene::index::Term *term;
    jdouble d;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::index::Term::class$, &term))
        {
            INT_CALL(query = new org::apache::lucene::search::FuzzyQuery(term));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "Jd",
                       &org::apache::lucene::index::Term::class$, &term, &d))
        {
            INT_CALL(query = new org::apache::lucene::search::FuzzyQuery(term, (jfloat) d));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "Jdi",
                       &org::apache::lucene::index::Term::class$,
                       &term, &d, &n))
        {
            INT_CALL(query = new org::apache::lucene::search::FuzzyQuery(term, (jfloat) d, n));
            self->object = query;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_FLOAT_GETTER(MinSimilarity, j_fuzzyquery);
DEFINE_INT_GETTER(PrefixLength, j_fuzzyquery);


/* WildcardQuery */

static int j_wildcardquery_init(j_wildcardquery *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::WildcardQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$,
                   &term))
    {
        INT_CALL(query = new org::apache::lucene::search::WildcardQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* Spans */

static PyObject *j_spans_doc(j_spans *self)
{
    jint doc;

    OBJ_CALL(doc = self->object->doc());
    return PyInt_FromLong(doc);
}

static PyObject *j_spans_start(j_spans *self)
{
    jint start;

    OBJ_CALL(start = self->object->start());
    return PyInt_FromLong(start);
}

static PyObject *j_spans_end(j_spans *self)
{
    jint end;

    OBJ_CALL(end = self->object->end());
    return PyInt_FromLong(end);
}

static PyObject *j_spans_next(j_spans *self)
{
    jboolean b;

    OBJ_CALL(b = self->object->next());
    Py_RETURN_BOOL(b);
}

static PyObject *j_spans_skipTo(j_spans *self, PyObject *arg)
{
    jint target;
    jboolean b;

    if (!parseArg(arg, "i", &target))
    {
        OBJ_CALL(b = self->object->skipTo(target));
        return PyInt_FromLong(target);
    }

    return PyErr_SetArgsError((PyObject *) self, "skipTo", arg);
}


/* SpanQuery */

DEFINE_STRING_GETTER(Field, j_spanquery);

static PyObject *j_spanquery_getTerms(j_spanquery *self)
{
    java::util::Collection *terms;

    OBJ_CALL(terms = self->object->getTerms());
    return jc2pl(terms, (PyObject *(*)(jobject)) wrap_Term);
}

static PyObject *j_spanquery_getSpans(j_spanquery *self, PyObject *arg)
{
    org::apache::lucene::search::spans::Spans *spans;
    org::apache::lucene::index::IndexReader *reader;

    if (!parseArg(arg, "J", &org::apache::lucene::index::IndexReader::class$,
                  &reader))
    {
        OBJ_CALL(spans = self->object->getSpans(reader));
        return wrap_Spans(spans);
    }

    return PyErr_SetArgsError((PyObject *) self, "getSpans", arg);
}


/* SpanFirstQuery */

static int j_spanfirstquery_init(j_spanfirstquery *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::spans::SpanFirstQuery *query;
    org::apache::lucene::search::spans::SpanQuery *sq;
    jint n;

    if (!parseArgs(args, "Ji",
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &sq, &n))
    {
        INT_CALL(query = new org::apache::lucene::search::spans::SpanFirstQuery(sq, n));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_INT_GETTER(End, j_spanfirstquery);
DEFINE_OBJ_GETTER(Match, j_spanfirstquery, SpanQuery,
                  org::apache::lucene::search::spans::SpanQuery);


/* SpanNearQuery */

static int j_spannearquery_init(j_spannearquery *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::spans::SpanNearQuery *query;
    JArray<org::apache::lucene::search::spans::SpanQuery *> *queries;
    jint slop;
    jboolean inOrder;

    if (!parseArgs(args, "Kib",
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &queries,
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &slop, &inOrder))
    {
        INT_CALL(query = new org::apache::lucene::search::spans::SpanNearQuery(queries, slop, inOrder));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_spannearquery_getClauses(j_spannearquery *self)
{
    JArray<org::apache::lucene::search::spans::SpanQuery *> *queries;

    OBJ_CALL(queries = self->object->getClauses());
    return ja2pl((jobjectArray) queries,
                 (PyObject *(*)(jobject)) wrap_SpanQuery);
}

DEFINE_INT_GETTER(Slop, j_spannearquery);
DEFINE_BOOL_GETTER(InOrder, j_spannearquery);


/* SpanNotQuery */

static int j_spannotquery_init(j_spannotquery *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::spans::SpanNotQuery *query;
    org::apache::lucene::search::spans::SpanQuery *include, *exclude;

    if (!parseArgs(args, "JJ",
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &include, &exclude))
    {
        INT_CALL(query = new org::apache::lucene::search::spans::SpanNotQuery(include, exclude));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Include, j_spannotquery, SpanQuery,
                  org::apache::lucene::search::spans::SpanQuery);
DEFINE_OBJ_GETTER(Exclude, j_spannotquery, SpanQuery,
                  org::apache::lucene::search::spans::SpanQuery);


/* SpanOrQuery */

static int j_spanorquery_init(j_spanorquery *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::spans::SpanOrQuery *query;
    JArray<org::apache::lucene::search::spans::SpanQuery *> *queries;

    if (!parseArgs(args, "K",
                   &org::apache::lucene::search::spans::SpanQuery::class$,
                   &queries,
                   &org::apache::lucene::search::spans::SpanQuery::class$))
    {
        INT_CALL(query = new org::apache::lucene::search::spans::SpanOrQuery(queries));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_spanorquery_getClauses(j_spanorquery *self)
{
    JArray<org::apache::lucene::search::spans::SpanQuery *> *queries;

    OBJ_CALL(queries = self->object->getClauses());
    return ja2pl((jobjectArray) queries,
                 (PyObject *(*)(jobject)) wrap_SpanQuery);
}


/* SpanTermQuery */

static int j_spantermquery_init(j_spantermquery *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::spans::SpanTermQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(query = new org::apache::lucene::search::spans::SpanTermQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Term, j_spantermquery, Term,
                  org::apache::lucene::index::Term);


/* RegexCapabilities */

static PyObject *j_regexcapabilities_compile(j_regexcapabilities *self,
                                             PyObject *arg)
{
    jstring s;
    
    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(self->object->compile(s));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "compile", arg);
}

static PyObject *j_regexcapabilities_match(j_regexcapabilities *self,
                                           PyObject *arg)
{
    jstring s;
    jboolean b;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(self->object->match(s));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "match", arg);
}

static PyObject *j_regexcapabilities_prefix(j_regexcapabilities *self)
{
    jstring s;

    OBJ_CALL(s = self->object->prefix());
    return j2p(s);
}


/* PythonRegexCapabilities */

DEFINE_0_INIT(j_pythonregexcapabilities,
              org::apache::lucene::search::regex::PythonRegexCapabilities);


/* RegexQuery */

static int j_regexquery_init(j_regexquery *self,
                             PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::regex::RegexQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(query = new org::apache::lucene::search::regex::RegexQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(RegexImplementation, j_regexquery, RegexCapabilities,
                  org::apache::lucene::search::regex::RegexCapabilities);


/* SpanRegexQuery */

static int j_spanregexquery_init(j_spanregexquery *self,
                                 PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::regex::SpanRegexQuery *query;
    org::apache::lucene::index::Term *term;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::Term::class$, &term))
    {
        INT_CALL(query = new org::apache::lucene::search::regex::SpanRegexQuery(term));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(RegexImplementation, j_spanregexquery, RegexCapabilities,
                  org::apache::lucene::search::regex::RegexCapabilities);
DEFINE_OBJ_GETTER(Term, j_spanregexquery, Term,
                  org::apache::lucene::index::Term);

/* MoreLikeThis */

static int j_morelikethis_init(j_morelikethis *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::similar::MoreLikeThis *mlt;
    org::apache::lucene::index::IndexReader *reader;

    if (!parseArgs(args, "J",
                   &org::apache::lucene::index::IndexReader::class$,
                   &reader))
    {
        INT_CALL(mlt = new org::apache::lucene::search::similar::MoreLikeThis(reader));
        self->object = mlt;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETSET(Analyzer, j_morelikethis, Analyzer,
                  org::apache::lucene::analysis::Analyzer);
DEFINE_INT_GETSET(MinTermFreq, j_morelikethis);
DEFINE_INT_GETSET(MinDocFreq, j_morelikethis);
DEFINE_BOOL_ISSET(Boost, j_morelikethis);
DEFINE_INT_GETSET(MinWordLen, j_morelikethis);
DEFINE_INT_GETSET(MaxWordLen, j_morelikethis);
DEFINE_INT_GETSET(MaxQueryTerms, j_morelikethis);
DEFINE_INT_GETSET(MaxNumTokensParsed, j_morelikethis);

static PyObject *j_morelikethis_getFieldNames(j_morelikethis *self)
{
    jstringArray strings;    

    OBJ_CALL(strings = self->object->getFieldNames());
    return jsa2psl(strings);
}

static PyObject *j_morelikethis_setFieldNames(j_morelikethis *self,
                                              PyObject *arg)
{
    jstringArray strings;

    if (!parseArg(arg, "S", &strings))
    {
        OBJ_CALL(self->object->setFieldNames(strings));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setFieldNames", arg);
}

static PyObject *j_morelikethis_like(j_morelikethis *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    java::io::Reader *reader;
    jint docNum;

    if (!parseArg(arg, "i", &docNum))
    {
        OBJ_CALL(query = self->object->like(docNum));
        return wrap_Query(query);
    }
    if (!parseArg(arg, "P", &java::io::Reader::class$,
                  check_Reader, &reader, make_Reader))
    {
        OBJ_CALL(query = self->object->like(reader));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "like", arg);
}

static PyObject *j_morelikethis_describeParams(j_morelikethis *self)
{
    jstring text;

    OBJ_CALL(text = self->object->describeParams());
    return j2p(text);
}


/* MoreLikeThisQuery */

static int j_morelikethisquery_init(j_morelikethisquery *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::similar::MoreLikeThisQuery *query;
    jstring likeText;
    jstringArray moreLikeFields;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "sSJ",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   &likeText, &moreLikeFields, &analyzer))
    {
        INT_CALL(query = new org::apache::lucene::search::similar::MoreLikeThisQuery(likeText, moreLikeFields, analyzer));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_morelikethisquery_getMoreLikeFields(j_morelikethisquery *self)
{
    jstringArray fields;

    OBJ_CALL(fields = self->object->getMoreLikeFields());
    return jsa2psl(fields);
}

static PyObject *j_morelikethisquery_setMoreLikeFields(j_morelikethisquery *self, PyObject *arg)
{
    jstringArray fields;

    if (!parseArg(arg, "S", &fields))
    {
        OBJ_CALL(self->object->setMoreLikeFields(fields));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "setMoreLikeFields", arg);
}

DEFINE_FLOAT_GETSET(PercentTermsToMatch, j_morelikethisquery);
DEFINE_OBJ_GETSET(Analyzer, j_morelikethisquery, Analyzer,
                  org::apache::lucene::analysis::Analyzer);
DEFINE_STRING_GETSET(LikeText, j_morelikethisquery);
DEFINE_INT_GETSET(MaxQueryTerms, j_morelikethisquery);
DEFINE_INT_GETSET(MinTermFrequency, j_morelikethisquery);


/* FuzzyLikeThisQuery */

static int j_fuzzylikethisquery_init(j_fuzzylikethisquery *self,
                                     PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FuzzyLikeThisQuery *query;
    jint maxNumTerms;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "iJ", &org::apache::lucene::analysis::Analyzer::class$,
                   &maxNumTerms, &analyzer))
    {
        INT_CALL(query = new org::apache::lucene::search::FuzzyLikeThisQuery(maxNumTerms, analyzer));
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_fuzzylikethisquery_addTerms(j_fuzzylikethisquery *self, PyObject *args)
{
    jstring queryString, fieldName;
    jdouble minSimilarity;
    jint prefixLength;

    if (!parseArgs(args, "ssdi", &queryString, &fieldName, &minSimilarity,
                   &prefixLength))
    {
        OBJ_CALL(self->object->addTerms(queryString, fieldName, minSimilarity,
                                        prefixLength));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "addTerms", args);    
}

DEFINE_BOOL_ISSET(IgnoreTF, j_fuzzylikethisquery);


/* BooleanFilter */

DEFINE_0_INIT(j_booleanfilter, org::apache::lucene::search::BooleanFilter);

static PyObject *j_booleanfilter_add(j_booleanfilter *self, PyObject *arg)
{
    org::apache::lucene::search::FilterClause *clause;

    if (!parseArg(arg, "J", &org::apache::lucene::search::FilterClause::class$,
                  &clause))
    {
        OBJ_CALL(self->object->add(clause));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "add", arg);
}


/* FilterClause */

static int j_filterclause_init(j_filterclause *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::FilterClause *clause;
    org::apache::lucene::search::Filter *filter;
    org::apache::lucene::search::BooleanClause$Occur *occur;

    if (!parseArgs(args, "PJ",
                   &org::apache::lucene::search::Filter::class$,
                   &org::apache::lucene::search::BooleanClause$Occur::class$,
                   check_Filter, &filter, make_Filter, &occur))
    {
        INT_CALL(clause = new org::apache::lucene::search::FilterClause(filter, occur))
        self->object = clause;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_OBJ_GETTER(Filter, j_filterclause, Filter,
                  org::apache::lucene::search::Filter);
DEFINE_OBJ_GETTER(Occur, j_filterclause, BooleanClause_Occur,
                  org::apache::lucene::search::BooleanClause$Occur);


/* TermsFilter */

DEFINE_0_INIT(j_termsfilter, org::apache::lucene::search::TermsFilter);

static PyObject *j_termsfilter_addTerm(j_termsfilter *self, PyObject *arg)
{
    org::apache::lucene::index::Term *term;

    if (!parseArg(arg, "J", &org::apache::lucene::index::Term::class$,
                  &term))
    {
        OBJ_CALL(self->object->addTerm(term));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "addTerm", arg);
}


/* BoostingQuery */

static int j_boostingquery_init(j_boostingquery *self,
                                PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::BoostingQuery *query;
    org::apache::lucene::search::Query *match, *context;
    jdouble boost;

    if (!parseArgs(args, "JJd",
                   &org::apache::lucene::search::Query::class$,
                   &org::apache::lucene::search::Query::class$,
                   &match, &context, &boost))
    {
        INT_CALL(query = new org::apache::lucene::search::BoostingQuery(match, context, boost))
        self->object = query;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* TokenGroup */

DEFINE_0_INIT(j_tokengroup, org::apache::lucene::search::highlight::TokenGroup);

static PyObject *j_tokengroup_getToken(j_tokengroup *self, PyObject *arg)
{
    org::apache::lucene::analysis::Token *token;
    jint index;

    if (!parseArg(arg, "i", &index))
    {
        OBJ_CALL(token = self->object->getToken(index));
        return wrap_Token(token);
    }

    return PyErr_SetArgsError((PyObject *) self, "getToken", arg);
}

static PyObject *j_tokengroup_getScore(j_tokengroup *self, PyObject *arg)
{
    jfloat score;
    jint index;

    if (!parseArg(arg, "i", &index))
    {
        OBJ_CALL(score = self->object->getScore(index));
        return PyFloat_FromDouble((double) score);
    }

    return PyErr_SetArgsError((PyObject *) self, "getScore", arg);
}

DEFINE_INT_GETTER(StartOffset, j_tokengroup);
DEFINE_INT_GETTER(EndOffset, j_tokengroup);
DEFINE_FLOAT_GETTER(TotalScore, j_tokengroup);
DEFINE_INT_GETTER(NumTokens, j_tokengroup);


/* TextFragment */

static int j_textfragment_init(j_textfragment *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::TextFragment *tf;
    jstring text;
    jint startPos, fragNum;

    if (!parseArgs(args, "sii", &text, &startPos, &fragNum))
    {
        INT_CALL(tf = new org::apache::lucene::search::highlight::TextFragment(new java::lang::StringBuffer(text), startPos, fragNum));
        self->object = tf;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_FLOAT_GETTER(Score, j_textfragment);

static PyObject *j_textfragment_merge(j_textfragment *self, PyObject *arg)
{
    org::apache::lucene::search::highlight::TextFragment *tf;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::highlight::TextFragment::class$,
                  &tf))
    {
        OBJ_CALL(self->object->merge(tf));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "merge", arg);
}

static PyObject *j_textfragment_follows(j_textfragment *self, PyObject *arg)
{
    org::apache::lucene::search::highlight::TextFragment *tf;
    jboolean b;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::highlight::TextFragment::class$,
                  &tf))
    {
        OBJ_CALL(b = self->object->follows(tf));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "follows", arg);
}

DEFINE_INT_GETTER(FragNum, j_textfragment);


/* WeightedTerm */

static int j_weightedterm_init(j_weightedterm *self,
                               PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::WeightedTerm *wt;
    jdouble weight;
    jstring term;

    if (!parseArgs(args, "ds", &weight, &term))
    {
        INT_CALL(wt = new org::apache::lucene::search::highlight::WeightedTerm((jfloat) weight, term));
        self->object = wt;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_STRING_GETSET(Term, j_weightedterm);
DEFINE_FLOAT_GETSET(Weight, j_weightedterm);


/* Formatter */

static int j_formatter_init(j_formatter *self, PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::Formatter *formatter;

    if (!parseArgs(args, "P",
                   &org::apache::lucene::search::highlight::Formatter::class$,
                   check_Formatter, &formatter, make_Formatter))
    {
        if (formatter)
        {
            self->object = formatter;
            refObject(self->object);
            return 0;
        }
    }

    PyErr_SetArgsError((PyObject *) self, "__init__", args);
    return -1;
}

static PyObject *j_formatter_highlightTerm(j_formatter *self, PyObject *args)
{
    jstring text;
    org::apache::lucene::search::highlight::TokenGroup *tokens;

    if (!parseArgs(args, "sJ",
                   &org::apache::lucene::search::highlight::TokenGroup::class$,
                   &text, &tokens))
    {
        OBJ_CALL(text = self->object->highlightTerm(text, tokens));
        return j2p(text);
    }

    return PyErr_SetArgsError((PyObject *) self, "highlightTerm", args);
}


/* Fragmenter */

static PyObject *j_fragmenter_start(j_fragmenter *self, PyObject *arg)
{
    jstring text;

    if (!parseArg(arg, "s", &text))
    {
        OBJ_CALL(self->object->start(text));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "start", arg);
}

static PyObject *j_fragmenter_isNewFragment(j_fragmenter *self, PyObject *arg)
{
    org::apache::lucene::analysis::Token *token;
    jboolean b;

    if (!parseArg(arg, "J", &org::apache::lucene::analysis::Token::class$,
                  &token))
    {
        OBJ_CALL(b = self->object->isNewFragment(token));
        Py_RETURN_BOOL(b);
    }

    return PyErr_SetArgsError((PyObject *) self, "isNewFragment", arg);
}


/* HighlightScorer */

DEFINE_FLOAT_GETTER(FragmentScore, j_highlightscorer);

static PyObject *j_highlightscorer_getTokenScore(j_highlightscorer *self,
                                                 PyObject *arg)
{
    org::apache::lucene::analysis::Token *token;
    jfloat score;

    if (!parseArg(arg, "J", &org::apache::lucene::analysis::Token::class$,
                  &token))
    {
        OBJ_CALL(score = self->object->getTokenScore(token));
        return PyFloat_FromDouble((double) score);
    }

    return PyErr_SetArgsError((PyObject *) self, "getTokenScore", arg);
}

static PyObject *j_highlightscorer_startFragment(j_highlightscorer *self,
                                                 PyObject *arg)
{
    org::apache::lucene::search::highlight::TextFragment *fragment;
    jfloat score;

    if (!parseArg(arg, "J",
                  &org::apache::lucene::search::highlight::TextFragment::class$,
                  &fragment))
    {
        OBJ_CALL(self->object->startFragment(fragment));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError((PyObject *) self, "startFragment", arg);
}


/* QueryTermExtractor */

static PyObject *j_querytermextractor_getTerms(PyTypeObject *type,
                                               PyObject *args)
{
    JArray<org::apache::lucene::search::highlight::WeightedTerm *> *terms;
    org::apache::lucene::search::Query *query;
    jboolean b;
    jstring s;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::search::Query::class$,
                       &query))
        {
            OBJ_CALL(terms = org::apache::lucene::search::highlight::QueryTermExtractor::getTerms(query));
            return ja2pl((jobjectArray) terms,
                         (PyObject *(*)(jobject)) wrap_WeightedTerm);
        }
        break;
      case 2:
        if (!parseArgs(args, "Jb", &org::apache::lucene::search::Query::class$,
                       &query, &b))
        {
            OBJ_CALL(terms = org::apache::lucene::search::highlight::QueryTermExtractor::getTerms(query, b));
            return ja2pl((jobjectArray) terms,
                         (PyObject *(*)(jobject)) wrap_WeightedTerm);
        }
        break;
      case 3:
        if (!parseArgs(args, "Jbs",
                       &org::apache::lucene::search::Query::class$,
                       &query, &b, &s))
        {
            OBJ_CALL(terms = org::apache::lucene::search::highlight::QueryTermExtractor::getTerms(query, b, s));
            return ja2pl((jobjectArray) terms,
                         (PyObject *(*)(jobject)) wrap_WeightedTerm);
        }
        break;
    }

    return PyErr_SetArgsError(type, "getTerms", args);
}

static PyObject *j_querytermextractor_getIdfWeightedTerms(PyTypeObject *type,
                                                          PyObject *args)
{
    JArray<org::apache::lucene::search::highlight::WeightedTerm *> *terms;
    org::apache::lucene::search::Query *query;
    org::apache::lucene::index::IndexReader *reader;
    jstring s;

    if (!parseArgs(args, "JJs",
                   &org::apache::lucene::search::Query::class$,
                   &org::apache::lucene::index::IndexReader::class$,
                   &query, &reader, &s))
    {
        OBJ_CALL(terms = org::apache::lucene::search::highlight::QueryTermExtractor::getIdfWeightedTerms(query, reader, s));
        return ja2pl((jobjectArray) terms,
                     (PyObject *(*)(jobject)) wrap_WeightedTerm);
    }

    return PyErr_SetArgsError(type, "getIdfWeightedTerms", args);
}


/* SimpleHTMLFormatter */

static int j_simplehtmlformatter_init(j_simplehtmlformatter *self,
                                      PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::SimpleHTMLFormatter *formatter;
    jstring preTag, postTag;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(formatter = new org::apache::lucene::search::highlight::SimpleHTMLFormatter());
        self->object = formatter;
        break;
      case 2:
        if (!parseArgs(args, "ss", &preTag, &postTag))
        {
            INT_CALL(formatter = new org::apache::lucene::search::highlight::SimpleHTMLFormatter(preTag, postTag));
            self->object = formatter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* GradientFormatter */

static int j_gradientformatter_init(j_gradientformatter *self,
                                    PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::GradientFormatter *formatter;
    jdouble maxScore;
    jstring minForegroundColor, maxForegroundColor;
    jstring minBackgroundColor, maxBackgroundColor;

    if (!parseArgs(args, "dssss", &maxScore,
                   &minForegroundColor, &maxForegroundColor,
                   &minBackgroundColor, &maxBackgroundColor))
    {
        INT_CALL(formatter = new org::apache::lucene::search::highlight::GradientFormatter(maxScore, minForegroundColor, maxForegroundColor, minBackgroundColor, maxBackgroundColor));
        self->object = formatter;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_gradientformatter_hexToInt(PyTypeObject *type, PyObject *arg)
{
    jstring hex;
    jint n;

    if (!parseArg(arg, "s", &hex))
    {
        OBJ_CALL(n = org::apache::lucene::search::highlight::GradientFormatter::hexToInt(hex));
        return PyInt_FromLong(n);
    }

    return PyErr_SetArgsError(type, "hexToInt", arg);
}


/* SpanGradientFormatter */

static int j_spangradientformatter_init(j_spangradientformatter *self,
                                        PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::SpanGradientFormatter *formatter;
    jdouble maxScore;
    jstring minForegroundColor, maxForegroundColor;
    jstring minBackgroundColor, maxBackgroundColor;

    if (!parseArgs(args, "dssss", &maxScore,
                   &minForegroundColor, &maxForegroundColor,
                   &minBackgroundColor, &maxBackgroundColor))
    {
        INT_CALL(formatter = new org::apache::lucene::search::highlight::SpanGradientFormatter(maxScore, minForegroundColor, maxForegroundColor, minBackgroundColor, maxBackgroundColor));
        self->object = formatter;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}


/* SimpleFragmenter */

static int j_simplefragmenter_init(j_simplefragmenter *self,
                                   PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::SimpleFragmenter *fragmenter;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 0:
        INT_CALL(fragmenter = new org::apache::lucene::search::highlight::SimpleFragmenter());
        self->object = fragmenter;
        break;
      case 1:
        if (!parseArgs(args, "i", &n))
        {
            INT_CALL(fragmenter = new org::apache::lucene::search::highlight::SimpleFragmenter(n));
            self->object = fragmenter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

DEFINE_INT_GETSET(FragmentSize, j_simplefragmenter);


/* NullFragmenter */

DEFINE_0_INIT(j_nullfragmenter,
              org::apache::lucene::search::highlight::NullFragmenter);


/* QueryScorer */

static int j_queryscorer_init(j_queryscorer *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::QueryScorer *scorer;
    org::apache::lucene::search::Query *query;
    org::apache::lucene::index::IndexReader *reader;
    jstring s;
    JArray<org::apache::lucene::search::highlight::WeightedTerm *> *terms;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J", &org::apache::lucene::search::Query::class$,
                       &query))
        {
            INT_CALL(scorer = new org::apache::lucene::search::highlight::QueryScorer(query));
            self->object = scorer;
            break;
        }
        if (!parseArgs(args, "K",
                       &org::apache::lucene::search::highlight::WeightedTerm::class$,
                       &terms, 
                       &org::apache::lucene::search::highlight::WeightedTerm::class$))
        {
            INT_CALL(scorer = new org::apache::lucene::search::highlight::QueryScorer(terms));
            self->object = scorer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 3:
        if (!parseArgs(args, "JJs",
                       &org::apache::lucene::search::Query::class$,
                       &org::apache::lucene::index::IndexReader::class$,
                       &query, &reader, &s))
        {
            INT_CALL(scorer = new org::apache::lucene::search::highlight::QueryScorer(query, reader, s));
            self->object = scorer;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_queryscorer_allFragmentsProcessed(j_queryscorer *self)
{
    OBJ_CALL(self->object->allFragmentsProcessed());
    Py_RETURN_NONE;
}

DEFINE_FLOAT_GETTER(MaxTermWeight, j_queryscorer);


/* Highlighter */

static int j_highlighter_init(j_highlighter *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::search::highlight::Highlighter *highlighter;
    org::apache::lucene::search::highlight::Scorer *scorer;
    org::apache::lucene::search::highlight::Formatter *formatter;

    switch (PyTuple_GET_SIZE(args)) {
      case 1:
        if (!parseArgs(args, "J",
                       &org::apache::lucene::search::highlight::Scorer::class$,
                       &scorer))
        {
            INT_CALL(highlighter = new org::apache::lucene::search::highlight::Highlighter(scorer));
            self->object = highlighter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      case 2:
        if (!parseArgs(args, "PJ",
                       &org::apache::lucene::search::highlight::Formatter::class$, check_Formatter,
                       &org::apache::lucene::search::highlight::Scorer::class$,
                       &formatter, make_Formatter, &scorer))

        {
            INT_CALL(highlighter = new org::apache::lucene::search::highlight::Highlighter(formatter, scorer));
            self->object = highlighter;
            break;
        }
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
      default:
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_highlighter_getBestFragment(j_highlighter *self,
                                               PyObject *args)
{
    org::apache::lucene::analysis::TokenStream *stream;
    jstring text;

    if (!parseArgs(args, "Ps",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream, &text))
    {
        OBJ_CALL(text = self->object->getBestFragment(stream, text));
        return j2p(text);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "getBestFragment", args);
}

static PyObject *j_highlighter_getBestFragments(j_highlighter *self,
                                                PyObject *args)
{
    org::apache::lucene::analysis::TokenStream *stream;
    org::apache::lucene::analysis::Analyzer *analyzer;
    jstringArray strings;
    jstring text, separator;
    jint n;

    switch (PyTuple_GET_SIZE(args)) {
      case 3:
        if (!parseArgs(args, "Psi",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream,
                       &text, &n))
        {
            OBJ_CALL(strings = self->object->getBestFragments(stream, text, n));
            return jsa2psl(strings);
        }
        if (!parseArgs(args, "Psi",
                       &org::apache::lucene::analysis::Analyzer::class$,
                       check_Analyzer, &stream, make_Analyzer,
                       &text, &n))
        {
            OBJ_CALL(strings = self->object->getBestFragments(analyzer, text, n));
            return jsa2psl(strings);
        }
        break;
      case 4:
        if (!parseArgs(args, "Psis",
                       &org::apache::lucene::analysis::TokenStream::class$,
                       check_TokenStream, &stream, make_TokenStream,
                       &text, &n, &separator))
        {
            OBJ_CALL(text = self->object->getBestFragments(stream, text, n, separator));
            return j2p(text);
        }
        break;
    }
    
    return PyErr_SetArgsError((PyObject *) self, "getBestFragments", args);
}

static PyObject *j_highlighter_getBestTextFragments(j_highlighter *self,
                                                    PyObject *args)
{
    org::apache::lucene::analysis::TokenStream *stream;
    JArray<org::apache::lucene::search::highlight::TextFragment *> *fragments;
    jstring text;
    jboolean b;
    jint n;

    if (!parseArgs(args, "Psbi",
                   &org::apache::lucene::analysis::TokenStream::class$,
                   check_TokenStream, &stream, make_TokenStream,
                   &text, &b, &n))
    {
        OBJ_CALL(fragments = self->object->getBestTextFragments(stream, text, n, n));
        return ja2pl((jobjectArray) fragments,
                     (PyObject *(*)(jobject)) wrap_TextFragment);
    }
    
    return PyErr_SetArgsError((PyObject *) self, "getBestTextFragments", args);
}

DEFINE_INT_GETSET(MaxDocBytesToAnalyze, j_highlighter);
DEFINE_POBJ_GETSET(TextFragmenter, j_highlighter, Fragmenter,
                   org::apache::lucene::search::highlight::Fragmenter);
DEFINE_OBJ_GETSET(FragmentScorer, j_highlighter, HighlightScorer,
                  org::apache::lucene::search::highlight::Scorer);


/* QueryParser */

static int j_queryparser_init(j_queryparser *self,
                              PyObject *args, PyObject *kwds)
{
    org::apache::lucene::queryParser::QueryParser *parser;
    jstring field;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "sP",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &field, &analyzer, make_Analyzer))
    {
        INT_CALL(parser = new org::apache::lucene::queryParser::QueryParser(field, analyzer));
        self->object = parser;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_queryparser_escape(PyTypeObject *type, PyObject *arg)
{
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(s = org::apache::lucene::queryParser::QueryParser::escape(s));
        return j2p(s);
    }

    return PyErr_SetArgsError(type, "escape", arg);
}

static PyObject *j_queryparser_main(PyTypeObject *type, PyObject *arg)
{
    jstringArray args;

    if (!parseArg(arg, "S", &args))
    {
        OBJ_CALL(org::apache::lucene::queryParser::QueryParser::main(args));
        Py_RETURN_NONE;
    }

    return PyErr_SetArgsError(type, "main", arg);
}

static PyObject *j_queryparser_parse(j_queryparser *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(query = self->object->parse(s));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "parse", arg);
}

static PyObject *j_queryparser_Clause(j_queryparser *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(query = self->object->Clause(s));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "Clause", arg);
}

static PyObject *j_queryparser_Query(j_queryparser *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(query = self->object->Query(s));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "Query", arg);
}

static PyObject *j_queryparser_Term(j_queryparser *self, PyObject *arg)
{
    org::apache::lucene::search::Query *query;
    jstring s;

    if (!parseArg(arg, "s", &s))
    {
        OBJ_CALL(query = self->object->Term(s));
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "Term", arg);
}

static PyObject *j_queryparser_Modifiers(j_queryparser *self)
{
    jint n;

    OBJ_CALL(n = self->object->Modifiers());
    return PyInt_FromLong(n);
}

static PyObject *j_queryparser_Conjunction(j_queryparser *self)
{
    jint n;

    OBJ_CALL(n = self->object->Conjunction());
    return PyInt_FromLong(n);
}

DEFINE_OBJ_GETTER(Analyzer, j_queryparser, Analyzer,
                  org::apache::lucene::analysis::Analyzer);
DEFINE_STRING_GETTER(Field, j_queryparser);
DEFINE_FLOAT_GETSET(FuzzyMinSim, j_queryparser);
DEFINE_OBJ_GETSET(Locale, j_queryparser, Locale, java::util::Locale);
DEFINE_BOOL_GETSET(LowercaseExpandedTerms, j_queryparser);
DEFINE_BOOL_GETSET(UseOldRangeQuery, j_queryparser);
DEFINE_OBJ_GETSET(DefaultOperator, j_queryparser, QueryParser_Operator,
                  org::apache::lucene::queryParser::QueryParser$Operator);
DEFINE_OBJ_GETTER(NextToken, j_queryparser, QueryParserToken,
                  org::apache::lucene::queryParser::Token);

static PyObject *j_queryparser_getToken(j_queryparser *self, PyObject *arg)
{
    org::apache::lucene::queryParser::Token *token;
    jint n;

    if (!parseArg(arg, "i", &n))
    {
        OBJ_CALL(token = self->object->getToken(n));
        return wrap_QueryParserToken(token);
    }

    return PyErr_SetArgsError((PyObject *) self, "getToken", arg);
}

DEFINE_INT_GETSET(PhraseSlop, j_queryparser);

static PyObject *j_queryparser_getBooleanQuery(j_queryparser *self,
                                               PyObject *arg)
{
    JArray<org::apache::lucene::search::BooleanClause *> *clauses;
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "K",
                  &org::apache::lucene::search::BooleanClause::class$,
                  &clauses,
                  &org::apache::lucene::search::BooleanClause::class$))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::QueryParser::getBooleanQuery(new java::util::Vector((java::util::Collection *) java::util::Arrays::asList((jobjectArray) clauses)));
                else
                    query = self->object->getBooleanQuery(new java::util::Vector((java::util::Collection *) java::util::Arrays::asList((jobjectArray) clauses)));
            });

        return wrap_Query(query);
    }
                  
    return PyErr_SetArgsError((PyObject *) self, "getBooleanQuery", arg);
}

static PyObject *j_queryparser_getFieldQuery(j_queryparser *self,
                                             PyObject *args)
{
    jstring field, text;
    jint slop;
    org::apache::lucene::search::Query *query;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "ss", &field, &text))
        {
            OBJ_CALL(
                {
                    if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                        query = self->object->org::apache::lucene::queryParser::QueryParser::getFieldQuery(field, text);
                    else
                        query = self->object->getFieldQuery(field, text);
                });
            return wrap_Query(query);
        }
        break;
      case 3:
        if (!parseArgs(args, "ssi", &field, &text, &slop))
        {
            OBJ_CALL(
                {
                    if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                        query = self->object->org::apache::lucene::queryParser::QueryParser::getFieldQuery(field, text, slop);
                    else
                        query = self->object->getFieldQuery(field, text, slop);
                });
            return wrap_Query(query);
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "getFieldQuery", args);
}

static PyObject *j_queryparser_getFuzzyQuery(j_queryparser *self,
                                             PyObject *args)
{
    jstring field, text;
    jdouble minSim;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ssd", &field, &text, &minSim))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::QueryParser::getFuzzyQuery(field, text, (jfloat) minSim);
                else
                    query = self->object->getFuzzyQuery(field, text, minSim);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getFuzzyQuery", args);
}

static PyObject *j_queryparser_getPrefixQuery(j_queryparser *self,
                                              PyObject *args)
{
    jstring field, text;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ss", &field, &text))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::QueryParser::getPrefixQuery(field, text);
                else
                    query = self->object->getPrefixQuery(field, text);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getPrefixQuery", args);
}

static PyObject *j_queryparser_getRangeQuery(j_queryparser *self,
                                             PyObject *args)
{
    jstring field, part1, part2;
    jboolean inclusive;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "sssb", &field, &part1, &part2, &inclusive))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::QueryParser::getRangeQuery(field, part1, part2, inclusive);
                else
                    query = self->object->getRangeQuery(field, part1, part2, inclusive);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getRangeQuery", args);
}

static PyObject *j_queryparser_getWildcardQuery(j_queryparser *self,
                                                PyObject *args)
{
    jstring field, text;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ss", &field, &text))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::QueryParser::getWildcardQuery(field, text);
                else
                    query = self->object->getWildcardQuery(field, text);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getWildcardQuery", args);
}


/* MultiFieldQueryParser */

static int j_multifieldqueryparser_init(j_multifieldqueryparser *self,
                                        PyObject *args, PyObject *kwds)
{
    org::apache::lucene::queryParser::MultiFieldQueryParser *parser;
    jstringArray fields;
    org::apache::lucene::analysis::Analyzer *analyzer;

    if (!parseArgs(args, "SP",
                   &org::apache::lucene::analysis::Analyzer::class$,
                   check_Analyzer, &fields, &analyzer, make_Analyzer))
    {
        INT_CALL(parser = new org::apache::lucene::queryParser::MultiFieldQueryParser(fields, analyzer));
        self->object = parser;
    }
    else
    {
        PyErr_SetArgsError((PyObject *) self, "__init__", args);
        return -1;
    }
    
    if (self->object)
    {
        refObject(self->object);
        return 0;
    }
    
    return -1;
}

static PyObject *j_multifieldqueryparser_parseQueries(PyTypeObject *type,
                                                      PyObject *args)
{
    org::apache::lucene::search::Query *query;
    JArray<org::apache::lucene::search::BooleanClause$Occur *> *flags;
    jstring s;
    jstringArray queries, fields;
    org::apache::lucene::analysis::Analyzer *analyzer;

    switch (PyTuple_GET_SIZE(args)) {
      case 3:
        if (!parseArgs(args, "SSP",
                       &org::apache::lucene::analysis::Analyzer::class$,
                       check_Analyzer, &queries, &fields,
                       &analyzer, make_Analyzer))
        {
            OBJ_CALL(query = org::apache::lucene::queryParser::MultiFieldQueryParser::parse(queries, fields, analyzer));
            return wrap_Query(query);
        }
        break;
      case 4:
        if (!parseArgs(args, "sSKP",
                       &org::apache::lucene::search::BooleanClause$Occur::class$,
                       &org::apache::lucene::analysis::Analyzer::class$, check_Analyzer, 
                       &s, &fields, &flags,
                       &org::apache::lucene::search::BooleanClause$Occur::class$,                       
                       &analyzer, make_Analyzer))
        {
            OBJ_CALL(query = org::apache::lucene::queryParser::MultiFieldQueryParser::parse(s, fields, flags, analyzer));
            return wrap_Query(query);
        }
        if (!parseArgs(args, "SSKP",
                       &org::apache::lucene::search::BooleanClause$Occur::class$,
                       &org::apache::lucene::analysis::Analyzer::class$, check_Analyzer, 
                       &queries, &fields, &flags,
                       &org::apache::lucene::search::BooleanClause$Occur::class$,                       
                       &analyzer, make_Analyzer))
        {
            OBJ_CALL(query = org::apache::lucene::queryParser::MultiFieldQueryParser::parse(queries, fields, flags, analyzer));
            return wrap_Query(query);
        }
        break;
    }

    return PyErr_SetArgsError(type, "parse", args);
}

static PyObject *j_multifieldqueryparser_getBooleanQuery(j_multifieldqueryparser *self, PyObject *arg)
{
    JArray<org::apache::lucene::search::BooleanClause *> *clauses;
    org::apache::lucene::search::Query *query;

    if (!parseArg(arg, "K",
                  &org::apache::lucene::search::BooleanClause::class$,
                  &clauses,
                  &org::apache::lucene::search::BooleanClause::class$))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getBooleanQuery(new java::util::Vector((java::util::Collection *) java::util::Arrays::asList((jobjectArray) clauses)));
                else
                    query = self->object->getBooleanQuery(new java::util::Vector((java::util::Collection *) java::util::Arrays::asList((jobjectArray) clauses)));
            });

        return wrap_Query(query);
    }
                  
    return PyErr_SetArgsError((PyObject *) self, "getBooleanQuery", arg);
}

static PyObject *j_multifieldqueryparser_getFieldQuery(j_multifieldqueryparser *self, PyObject *args)
{
    jstring field, text;
    jint slop;
    org::apache::lucene::search::Query *query;

    switch (PyTuple_GET_SIZE(args)) {
      case 2:
        if (!parseArgs(args, "ss", &field, &text))
        {
            OBJ_CALL(
                {
                    if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                        query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getFieldQuery(field, text);
                    else
                        query = self->object->getFieldQuery(field, text);
                });
            return wrap_Query(query);
        }
        break;
      case 3:
        if (!parseArgs(args, "ssi", &field, &text, &slop))
        {
            OBJ_CALL(
                {
                    if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                        query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getFieldQuery(field, text, slop);
                    else
                        query = self->object->getFieldQuery(field, text, slop);
                });
            return wrap_Query(query);
        }
        break;
    }

    return PyErr_SetArgsError((PyObject *) self, "getFieldQuery", args);
}

static PyObject *j_multifieldqueryparser_getFuzzyQuery(j_multifieldqueryparser *self, PyObject *args)
{
    jstring field, text;
    jdouble minSim;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ssd", &field, &text, &minSim))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getFuzzyQuery(field, text, (jfloat) minSim);
                else
                    query = self->object->getFuzzyQuery(field, text, minSim);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getFuzzyQuery", args);
}

static PyObject *j_multifieldqueryparser_getPrefixQuery(j_multifieldqueryparser *self, PyObject *args)
{
    jstring field, text;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ss", &field, &text))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getPrefixQuery(field, text);
                else
                    query = self->object->getPrefixQuery(field, text);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getPrefixQuery", args);
}

static PyObject *j_multifieldqueryparser_getRangeQuery(j_multifieldqueryparser *self, PyObject *args)
{
    jstring field, part1, part2;
    jboolean inclusive;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "sssb", &field, &part1, &part2, &inclusive))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getRangeQuery(field, part1, part2, inclusive);
                else
                    query = self->object->getRangeQuery(field, part1, part2, inclusive);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getRangeQuery", args);
}

static PyObject *j_multifieldqueryparser_getWildcardQuery(j_multifieldqueryparser *self, PyObject *args)
{
    jstring field, text;
    org::apache::lucene::search::Query *query;

    if (!parseArgs(args, "ss", &field, &text))
    {
        OBJ_CALL(
            {
                if (org::osafoundation::queryParser::PythonMultiFieldQueryParser::class$.isInstance(self->object))
                    query = self->object->org::apache::lucene::queryParser::MultiFieldQueryParser::getWildcardQuery(field, text);
                else
                    query = self->object->getWildcardQuery(field, text);
            });
        return wrap_Query(query);
    }

    return PyErr_SetArgsError((PyObject *) self, "getWildcardQuery", args);
}

static void initClasses()
{
    JvInitClass(&org::apache::lucene::LucenePackage::class$);
    JvInitClass(&org::apache::lucene::analysis::StopAnalyzer::class$);
    JvInitClass(&org::apache::lucene::analysis::standard::StandardAnalyzer::class$);
    JvInitClass(&org::apache::lucene::analysis::standard::StandardTokenizerConstants::class$);
    JvInitClass(&org::apache::lucene::analysis::standard::StandardTokenizer::class$);
    JvInitClass(&org::apache::lucene::analysis::standard::StandardTokenizerTokenManager::class$);
    JvInitClass(&org::apache::lucene::analysis::standard::StandardFilter::class$);
    JvInitClass(&org::apache::lucene::document::Field::class$);
    JvInitClass(&org::apache::lucene::document::Field$Store::class$);
    JvInitClass(&org::apache::lucene::document::Field$Index::class$);
    JvInitClass(&org::apache::lucene::document::Field$TermVector::class$);
    JvInitClass(&org::apache::lucene::document::DateField::class$);
    JvInitClass(&org::apache::lucene::document::DateTools$Resolution::class$);
    JvInitClass(&org::apache::lucene::document::NumberTools::class$);
    JvInitClass(&org::apache::lucene::document::FieldSelectorResult::class$);
    JvInitClass(&org::apache::lucene::queryParser::QueryParser::class$);
    JvInitClass(&org::apache::lucene::queryParser::QueryParser$Operator::class$);
    JvInitClass(&org::apache::lucene::queryParser::QueryParserConstants::class$);
    JvInitClass(&org::apache::lucene::queryParser::QueryParserTokenManager::class$);
    JvInitClass(&org::apache::lucene::queryParser::MultiFieldQueryParser::class$);
    JvInitClass(&org::apache::lucene::search::BooleanQuery::class$);
    JvInitClass(&org::apache::lucene::search::BooleanClause$Occur::class$);
    JvInitClass(&org::apache::lucene::search::ScoreDocComparator::class$);
    JvInitClass(&org::apache::lucene::search::SortField::class$);
    JvInitClass(&org::apache::lucene::search::Sort::class$);
    JvInitClass(&org::apache::lucene::search::Similarity::class$);
    JvInitClass(&org::apache::lucene::search::similar::MoreLikeThis::class$);
    JvInitClass(&org::apache::lucene::store::FSDirectory::class$);
    JvInitClass(&org::apache::lucene::index::IndexReader::class$);
    JvInitClass(&org::apache::lucene::index::IndexReader$FieldOption::class$);
    JvInitClass(&org::apache::lucene::index::IndexWriter::class$);
    JvInitClass(&org::apache::lucene::index::IndexFileNames::class$);
    JvInitClass(&org::apache::lucene::analysis::el::GreekCharsets::class$);
    JvInitClass(&org::apache::lucene::analysis::ru::RussianCharsets::class$);
}

void _init_lucene(PyObject *m)
{
    initClasses();

    TokenStreamType.tp_iter = (getiterfunc) j_tokenstream_iter;
    TokenEnumerationType.tp_iternext = (iternextfunc) j_tokenenumeration_nextElement;
    FieldEnumerationType.tp_iternext = (iternextfunc) j_fieldenumeration_nextElement;
    DocumentType.tp_as_mapping = &j_document_as_mapping;
    DocumentType.tp_iter = (getiterfunc) j_document_fields;
    IndexReaderType.tp_iter = (getiterfunc) j_indexreader_iter;
    IndexReaderEnumerationType.tp_iternext = (iternextfunc) j_indexreaderenumeration_next;
    HitsType.tp_iter = (getiterfunc) j_hits_iter;
    HitsType.tp_as_sequence = &j_hits_as_sequence;
    HitType.tp_as_sequence = &j_hit_as_sequence;
    HitIteratorType.tp_iter = (getiterfunc) j_hititerator_iter;
    HitIteratorType.tp_iternext = (iternextfunc) j_hititerator_next;
    ScoreDocType.tp_getset = j_scoredoc_properties;
    FieldDocType.tp_getset = j_fielddoc_properties;
    TopDocsType.tp_getset = j_topdocs_properties;
    TopFieldDocsType.tp_getset = j_topfielddocs_properties;
    QueryIteratorType.tp_iternext = (iternextfunc) j_queryiterator_next;

    INSTALL_TYPE(LucenePackage, m);
    INSTALL_TYPE(IndexInput, m);
    INSTALL_TYPE(BufferedIndexInput, m);
    INSTALL_TYPE(IndexOutput, m);
    INSTALL_TYPE(BufferedIndexOutput, m);
    INSTALL_TYPE(Lock, m);
    INSTALL_TYPE(Directory, m);
    INSTALL_TYPE(FSDirectory, m);
    INSTALL_TYPE(MMapDirectory, m);
#ifdef _WITH_DB_DIRECTORY
    INSTALL_TYPE(DbDirectory, m);
#endif
    INSTALL_TYPE(RAMDirectory, m);
    INSTALL_TYPE(RAMOutputStream, m);
    INSTALL_TYPE(Token, m);
    INSTALL_TYPE(TokenStream, m);
    INSTALL_TYPE(TokenEnumeration, m);
    INSTALL_TYPE(TokenFilter, m);
    INSTALL_TYPE(Tokenizer, m);
    INSTALL_TYPE(CharTokenizer, m);
    INSTALL_TYPE(Analyzer, m);
    INSTALL_TYPE(LetterTokenizer, m);
    INSTALL_TYPE(LowerCaseTokenizer, m);
    INSTALL_TYPE(LowerCaseFilter, m);
    INSTALL_TYPE(ISOLatin1AccentFilter, m);
    INSTALL_TYPE(KeywordAnalyzer, m);
    INSTALL_TYPE(KeywordTokenizer, m);
    INSTALL_TYPE(LengthFilter, m);
    INSTALL_TYPE(PorterStemFilter, m);
    INSTALL_TYPE(StopFilter, m);
    INSTALL_TYPE(SimpleAnalyzer, m);
    INSTALL_TYPE(StopAnalyzer, m);
    INSTALL_TYPE(WhitespaceAnalyzer, m);
    INSTALL_TYPE(WhitespaceTokenizer, m);
    INSTALL_TYPE(PerFieldAnalyzerWrapper, m);
    INSTALL_TYPE(StandardAnalyzer, m);
    INSTALL_TYPE(StandardFilter, m);
    INSTALL_TYPE(StandardTokenizer, m);
    INSTALL_TYPE(BrazilianAnalyzer, m);
    INSTALL_TYPE(BrazilianStemmer, m);
    INSTALL_TYPE(BrazilianStemFilter, m);
    INSTALL_TYPE(CJKAnalyzer, m);
    INSTALL_TYPE(CJKTokenizer, m);
    INSTALL_TYPE(ChineseAnalyzer, m);
    INSTALL_TYPE(ChineseFilter, m);
    INSTALL_TYPE(ChineseTokenizer, m);
    INSTALL_TYPE(CzechAnalyzer, m);
    INSTALL_TYPE(GermanAnalyzer, m);
    INSTALL_TYPE(GermanStemmer, m);
    INSTALL_TYPE(GermanStemFilter, m);
    INSTALL_TYPE(GreekAnalyzer, m);
    INSTALL_TYPE(GreekLowerCaseFilter, m);
    INSTALL_TYPE(GreekCharsets, m);
    INSTALL_TYPE(FrenchAnalyzer, m);
    INSTALL_TYPE(FrenchStemmer, m);
    INSTALL_TYPE(FrenchStemFilter, m);
    INSTALL_TYPE(DutchAnalyzer, m);
    INSTALL_TYPE(DutchStemmer, m);
    INSTALL_TYPE(DutchStemFilter, m);
    INSTALL_TYPE(RussianAnalyzer, m);
    INSTALL_TYPE(RussianStemmer, m);
    INSTALL_TYPE(RussianStemFilter, m);
    INSTALL_TYPE(RussianLowerCaseFilter, m);
    INSTALL_TYPE(RussianCharsets, m);
    INSTALL_TYPE(SnowballAnalyzer, m);
    INSTALL_TYPE(SnowballFilter, m);
    INSTALL_TYPE(Parameter, m);
    INSTALL_TYPE(Field, m);
    INSTALL_INNER_TYPE(Field, Store, Field_Store);
    INSTALL_INNER_TYPE(Field, Index, Field_Index);
    INSTALL_INNER_TYPE(Field, TermVector, Field_TermVector);
    INSTALL_TYPE(DateField, m);
    INSTALL_TYPE(DateTools, m);
    INSTALL_INNER_TYPE(DateTools, Resolution, DateTools_Resolution);
    INSTALL_TYPE(NumberTools, m);
    INSTALL_TYPE(FieldEnumeration, m);
    INSTALL_TYPE(Document, m);
    INSTALL_TYPE(IndexWriter, m);
    INSTALL_TYPE(Term, m);
    INSTALL_TYPE(TermEnum, m);
    INSTALL_TYPE(TermDocs, m);
    INSTALL_TYPE(TermVectorOffsetInfo, m);
    INSTALL_TYPE(TermPositions, m);
    INSTALL_TYPE(MultipleTermPositions, m);
    INSTALL_TYPE(TermFreqVector, m);
    INSTALL_TYPE(TermPositionVector, m);
    INSTALL_TYPE(IndexReader, m);
    INSTALL_INNER_TYPE(IndexReader, FieldOption, IndexReader_FieldOption);
    INSTALL_TYPE(IndexReaderEnumeration, m);
    INSTALL_TYPE(FilterIndexReader, m);
    INSTALL_TYPE(ParallelReader, m);
    INSTALL_TYPE(IndexModifier, m);
    INSTALL_TYPE(MultiReader, m);
    INSTALL_TYPE(Query, m);
    INSTALL_TYPE(MultiTermQuery, m);
    INSTALL_TYPE(Hits, m);
    INSTALL_TYPE(HitIterator, m);
    INSTALL_TYPE(Hit, m);
    INSTALL_TYPE(HitCollector, m);
    INSTALL_TYPE(Scorer, m);
    INSTALL_TYPE(Weight, m);
    INSTALL_TYPE(Similarity, m);
    INSTALL_TYPE(ScoreDoc, m);
    INSTALL_TYPE(FieldDoc, m);
    INSTALL_TYPE(TopDocs, m);
    INSTALL_TYPE(TopFieldDocs, m);
    INSTALL_TYPE(ScoreDocComparator, m);
    INSTALL_TYPE(SortComparatorSource, m);
    INSTALL_TYPE(SortComparator, m);
    INSTALL_TYPE(SortField, m);
    INSTALL_TYPE(Sort, m);
    INSTALL_TYPE(TopDocCollector, m);
    INSTALL_TYPE(TopFieldDocCollector, m);
    INSTALL_TYPE(Filter, m);
    INSTALL_TYPE(Searchable, m);
    INSTALL_TYPE(Searcher, m);
    INSTALL_TYPE(IndexSearcher, m);
    INSTALL_TYPE(MultiSearcher, m);
    INSTALL_TYPE(ParallelMultiSearcher, m);
    INSTALL_TYPE(Explanation, m);
    INSTALL_TYPE(MatchAllDocsQuery, m);
    INSTALL_TYPE(BooleanClause, m);
    INSTALL_INNER_TYPE(BooleanClause, Occur, BooleanClause_Occur);
    INSTALL_TYPE(BooleanQuery, m);
    INSTALL_TYPE(TermQuery, m);
    INSTALL_TYPE(PrefixQuery, m);
    INSTALL_TYPE(PhraseQuery, m);
    INSTALL_TYPE(MultiPhraseQuery, m);
    INSTALL_TYPE(FilteredTermEnum, m);
    INSTALL_TYPE(DefaultSimilarity, m);
    INSTALL_TYPE(CachingWrapperFilter, m);
    INSTALL_TYPE(QueryFilter, m);
    INSTALL_TYPE(RangeFilter, m);
    INSTALL_TYPE(PrefixFilter, m);
    INSTALL_TYPE(FuzzyTermEnum, m);
    INSTALL_TYPE(WildcardTermEnum, m);
    INSTALL_TYPE(FilteredQuery, m);
    INSTALL_TYPE(RangeQuery, m);
    INSTALL_TYPE(ConstantScoreQuery, m);
    INSTALL_TYPE(ConstantScoreRangeQuery, m);
    INSTALL_TYPE(QueryIterator, m);
    INSTALL_TYPE(DisjunctionMaxQuery, m);
    INSTALL_TYPE(FuzzyQuery, m);
    INSTALL_TYPE(WildcardQuery, m);
    INSTALL_TYPE(Spans, m);
    INSTALL_TYPE(SpanQuery, m);
    INSTALL_TYPE(SpanFirstQuery, m);
    INSTALL_TYPE(SpanNearQuery, m);
    INSTALL_TYPE(SpanNotQuery, m);
    INSTALL_TYPE(SpanOrQuery, m);
    INSTALL_TYPE(SpanTermQuery, m);
    INSTALL_TYPE(RegexCapabilities, m);
    INSTALL_TYPE(PythonRegexCapabilities, m);
    INSTALL_TYPE(RegexQuery, m);
    INSTALL_TYPE(SpanRegexQuery, m);
    INSTALL_TYPE(MoreLikeThis, m);
    INSTALL_TYPE(MoreLikeThisQuery, m);
    INSTALL_TYPE(FuzzyLikeThisQuery, m);
    INSTALL_TYPE(BooleanFilter, m);
    INSTALL_TYPE(FilterClause, m);
    INSTALL_TYPE(TermsFilter, m);
    INSTALL_TYPE(BoostingQuery, m);
    INSTALL_TYPE(TokenGroup, m);
    INSTALL_TYPE(TextFragment, m);
    INSTALL_TYPE(WeightedTerm, m);
    INSTALL_TYPE(Formatter, m);
    INSTALL_TYPE(Fragmenter, m);
    INSTALL_TYPE(HighlightScorer, m);
    INSTALL_TYPE(QueryTermExtractor, m);
    INSTALL_TYPE(SimpleHTMLFormatter, m);
    INSTALL_TYPE(GradientFormatter, m);
    INSTALL_TYPE(SpanGradientFormatter, m);
    INSTALL_TYPE(SimpleFragmenter, m);
    INSTALL_TYPE(NullFragmenter, m);
    INSTALL_TYPE(QueryScorer, m);
    INSTALL_TYPE(Highlighter, m);
    INSTALL_TYPE(QueryParser, m);
    INSTALL_TYPE(QueryParserToken, m);
    INSTALL_INNER_TYPE(QueryParser, Operator, QueryParser_Operator);
    INSTALL_TYPE(MultiFieldQueryParser, m);

    INSTALL_STATIC_STRING(FSDirectory, LOCK_DIR,
                          org::apache::lucene::store::FSDirectory);

    INSTALL_STATIC_STRINGS(StopAnalyzer, ENGLISH_STOP_WORDS,
                           org::apache::lucene::analysis::StopAnalyzer);

    INSTALL_STATIC_STRINGS(StandardAnalyzer, STOP_WORDS,
                           org::apache::lucene::analysis::standard::StandardAnalyzer);

    INSTALL_STATIC(GreekCharsets, UnicodeGreek, Charset,
                   org::apache::lucene::analysis::el::GreekCharsets);
    INSTALL_STATIC(GreekCharsets, ISO, Charset,
                   org::apache::lucene::analysis::el::GreekCharsets);
    INSTALL_STATIC(GreekCharsets, CP1253, Charset,
                   org::apache::lucene::analysis::el::GreekCharsets);

    INSTALL_STATIC(RussianCharsets, UnicodeRussian, Charset,
                   org::apache::lucene::analysis::ru::RussianCharsets);
    INSTALL_STATIC(RussianCharsets, KOI8, Charset,
                   org::apache::lucene::analysis::ru::RussianCharsets);
    INSTALL_STATIC(RussianCharsets, CP1251, Charset,
                   org::apache::lucene::analysis::ru::RussianCharsets);

    INSTALL_STATIC(Field_Store, COMPRESS, Field_Store,
                   org::apache::lucene::document::Field$Store);
    INSTALL_STATIC(Field_Store, YES, Field_Store,
                   org::apache::lucene::document::Field$Store);
    INSTALL_STATIC(Field_Store, NO, Field_Store,
                   org::apache::lucene::document::Field$Store);

    INSTALL_STATIC(Field_Index, NO, Field_Index,
                   org::apache::lucene::document::Field$Index);
    INSTALL_STATIC(Field_Index, TOKENIZED, Field_Index,
                   org::apache::lucene::document::Field$Index);
    INSTALL_STATIC(Field_Index, UN_TOKENIZED, Field_Index,
                   org::apache::lucene::document::Field$Index);
    INSTALL_STATIC(Field_Index, NO_NORMS, Field_Index,
                   org::apache::lucene::document::Field$Index);

    INSTALL_STATIC(Field_TermVector, NO, Field_TermVector,
                   org::apache::lucene::document::Field$TermVector);
    INSTALL_STATIC(Field_TermVector, YES, Field_TermVector,
                   org::apache::lucene::document::Field$TermVector);
    INSTALL_STATIC(Field_TermVector, WITH_POSITIONS, Field_TermVector,
                   org::apache::lucene::document::Field$TermVector);
    INSTALL_STATIC(Field_TermVector, WITH_OFFSETS, Field_TermVector,
                   org::apache::lucene::document::Field$TermVector);
    INSTALL_STATIC(Field_TermVector, WITH_POSITIONS_OFFSETS, Field_TermVector,
                   org::apache::lucene::document::Field$TermVector);

    INSTALL_STATIC(DateTools_Resolution, YEAR, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, MONTH, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, DAY, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, HOUR, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, MINUTE, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, SECOND, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);
    INSTALL_STATIC(DateTools_Resolution, MILLISECOND, DateTools_Resolution,
                   org::apache::lucene::document::DateTools$Resolution);

    INSTALL_STATIC_INT(NumberTools, STR_SIZE,
                       org::apache::lucene::document::NumberTools);

    INSTALL_STATIC_LONG_rename(IndexWriter,
                               WRITE_LOCK_TIMEOUT, DEFAULT_WRITE_LOCK_TIMEOUT,
                               org::apache::lucene::index::IndexWriter);

    INSTALL_STATIC_STRING(IndexWriter, WRITE_LOCK_NAME,
                          org::apache::lucene::index::IndexWriter);
    INSTALL_STATIC_INT(IndexWriter, DEFAULT_MERGE_FACTOR,
                       org::apache::lucene::index::IndexWriter);
    INSTALL_STATIC_INT(IndexWriter, DEFAULT_MAX_BUFFERED_DOCS,
                       org::apache::lucene::index::IndexWriter);
    INSTALL_STATIC_INT(IndexWriter, DEFAULT_MAX_MERGE_DOCS,
                       org::apache::lucene::index::IndexWriter);
    INSTALL_STATIC_INT(IndexWriter, DEFAULT_MAX_FIELD_LENGTH,
                       org::apache::lucene::index::IndexWriter);
    INSTALL_STATIC_INT(IndexWriter, DEFAULT_TERM_INDEX_INTERVAL,
                       org::apache::lucene::index::IndexWriter);

    INSTALL_STATIC(IndexReader_FieldOption, ALL, IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, INDEXED, IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, UNINDEXED, IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, INDEXED_WITH_TERMVECTOR,
                   IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, INDEXED_NO_TERMVECTOR,
                   IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, TERMVECTOR, IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, TERMVECTOR, IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, TERMVECTOR_WITH_POSITION,
                   IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, TERMVECTOR_WITH_OFFSET,
                   IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);
    INSTALL_STATIC(IndexReader_FieldOption, TERMVECTOR_WITH_POSITION_OFFSET,
                   IndexReader_FieldOption,
                   org::apache::lucene::index::IndexReader$FieldOption);

    INSTALL_STATIC(ScoreDocComparator, RELEVANCE, ScoreDocComparator,
                   org::apache::lucene::search::ScoreDocComparator);
    INSTALL_STATIC(ScoreDocComparator, INDEXORDER, ScoreDocComparator,
                   org::apache::lucene::search::ScoreDocComparator);

    INSTALL_STATIC_INT(SortField, SCORE,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, DOC,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, AUTO,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, STRING,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, INT,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, FLOAT,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC_INT(SortField, CUSTOM,
                       org::apache::lucene::search::SortField);
    INSTALL_STATIC(SortField, FIELD_SCORE, SortField,
                   org::apache::lucene::search::SortField);
    INSTALL_STATIC(SortField, FIELD_DOC, SortField,
                   org::apache::lucene::search::SortField);

    INSTALL_STATIC(Sort, RELEVANCE, Sort, org::apache::lucene::search::Sort);
    INSTALL_STATIC(Sort, INDEXORDER, Sort, org::apache::lucene::search::Sort);

    INSTALL_STATIC(BooleanClause_Occur, MUST, BooleanClause_Occur,
                   org::apache::lucene::search::BooleanClause$Occur);
    INSTALL_STATIC(BooleanClause_Occur, SHOULD, BooleanClause_Occur,
                   org::apache::lucene::search::BooleanClause$Occur);
    INSTALL_STATIC(BooleanClause_Occur, MUST_NOT, BooleanClause_Occur,
                   org::apache::lucene::search::BooleanClause$Occur);

    INSTALL_STATIC(QueryParser_Operator, OR, QueryParser_Operator,
                   org::apache::lucene::queryParser::QueryParser$Operator);
    INSTALL_STATIC(QueryParser_Operator, AND, QueryParser_Operator,
                   org::apache::lucene::queryParser::QueryParser$Operator);

    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MAX_NUM_TOKENS_PARSED,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MIN_TERM_FREQ,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MIN_DOC_FREQ,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MIN_WORD_LENGTH,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MAX_WORD_LENGTH,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_INT(MoreLikeThis, DEFAULT_MAX_QUERY_TERMS,
                       org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_BOOL(MoreLikeThis, DEFAULT_BOOST,
                        org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC_STRINGS(MoreLikeThis, DEFAULT_FIELD_NAMES,
                           org::apache::lucene::search::similar::MoreLikeThis);
    INSTALL_STATIC(MoreLikeThis, DEFAULT_ANALYZER, Analyzer,
                   org::apache::lucene::search::similar::MoreLikeThis);
}
