# ====================================================================
# Copyright (c) 2004-2005 Open Source Applications Foundation.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions: 
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software. 
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
# ====================================================================
#

from lia.common.LiaTestCase import LiaTestCase

from PyLucene import \
     SimpleAnalyzer, Document, TermQuery, QueryParser, IndexSearcher, Term


class BasicSearchingTest(LiaTestCase):

    def testTerm(self):

        searcher = IndexSearcher(self.directory)
        t = Term("subject", "ant")
        query = TermQuery(t)
        hits = searcher.search(query)
        self.assertEqual(1, hits.length(), "JDwA")

        t = Term("subject", "junit")
        hits = searcher.search(TermQuery(t))
        self.assertEqual(2, hits.length())

        searcher.close()

    def testKeyword(self):

        searcher = IndexSearcher(self.directory)
        t = Term("isbn", "1930110995")
        query = TermQuery(t)
        hits = searcher.search(query)
        self.assertEqual(1, hits.length(), "JUnit in Action")

    def testQueryParser(self):

        searcher = IndexSearcher(self.directory)

        query = QueryParser("contents",
                            SimpleAnalyzer()).parse("+JUNIT +ANT -MOCK")
        hits = searcher.search(query)
        self.assertEqual(1, hits.length())
        d = hits.doc(0)
        self.assertEqual("Java Development with Ant", d.get("title"))

        query = QueryParser("contents", SimpleAnalyzer()).parse("mock OR junit")
        hits = searcher.search(query)
        self.assertEqual(2, hits.length(), "JDwA and JIA")
