# ====================================================================
# Copyright (c) 2004-2005 Open Source Applications Foundation.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions: 
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software. 
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
# ====================================================================
#

import os, shutil
from unittest import TestCase, main
from PyLucene import *
from test_PyLucene import Test_PyLuceneBase


class Test_PyLuceneWithDbStore(TestCase, Test_PyLuceneBase):

    STORE_DIR = "testrepo"
    DB_FILES = "files.db"
    DB_BLOCKS = "blocks.db"

    def setUp(self):

        from bsddb import db
        
        if not os.path.exists(self.STORE_DIR):
            os.mkdir(self.STORE_DIR)

        self.flags = db.DB_DIRTY_READ

        self.env = db.DBEnv()
        self.env.open(self.STORE_DIR,
                      (db.DB_CREATE | db.DB_INIT_LOCK | db.DB_INIT_LOG |
                       db.DB_INIT_MPOOL | db.DB_INIT_TXN |
                       db.DB_THREAD | db.DB_RECOVER))

        self.files_db = db.DB(self.env)
        self.blocks_db = db.DB(self.env)
        
        self.txn = self.env.txn_begin()
        self.files_db.open(filename = self.DB_FILES,
                           dbtype = db.DB_BTREE,
                           flags = self.flags | db.DB_CREATE,
                           txn = self.txn)
        self.blocks_db.open(filename = self.DB_BLOCKS,
                            dbtype = db.DB_BTREE,
                            flags = self.flags | db.DB_CREATE,
                            txn = self.txn)
        self.txn.commit()

    def tearDown(self):
        
        self.files_db.close()
        self.blocks_db.close()        
        self.env.close()

        if os.path.exists(self.STORE_DIR):
            shutil.rmtree(self.STORE_DIR)
        
    def openStore(self):

        self.txn = self.env.txn_begin()
        return DbDirectory(self.txn, self.files_db, self.blocks_db, self.flags)

    def getWriter(self, store, analyzer, create=False):

        writer = super(Test_PyLuceneWithDbStore, self).getWriter(store,
                                                                 analyzer,
                                                                 create)
        writer.setUseCompoundFile(False)

        return writer

    def closeStore(self, store, *args):

        for arg in args:
            if arg is not None:
                arg.close()
        self.txn.commit()
        

if __name__ == "__main__":
    try:
        DbDirectory
    except NameError:
        pass
    else:
        import sys
        if '-loop' in sys.argv:
            sys.argv.remove('-loop')
            while True:
                try:
                    main()
                except:
                    pass
        else:
            main()
