/* ====================================================================
 * Copyright (c) 2004-2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#ifndef _converters_h
#define _converters_h

#include <Python.h>
#include <gcj/cni.h>
#include <java/lang/Throwable.h>
#include <java/util/Collection.h>

typedef JArray<jobject> *jobjectArray;
typedef JArray<jstring> *jstringArray;

jstring p2j(PyObject *object);
PyObject *j2p(jstring js);
java::lang::Comparable *pc2jc(PyObject *pc);
PyObject *jc2pc(java::lang::Comparable *jc);

jstringArray psl2jsa(PyObject *psl);
PyObject *jsa2psl(jstringArray jsa);
PyObject *jsc2psl(java::util::Collection *jsc);
PyObject *jia2pil(jintArray jia);
PyObject *jia2pil(jintArray jia, int count);

PyObject *jc2pl(java::util::Collection *jobjects, PyObject *(*wrapfn)(jobject));
PyObject *ja2pl(jobjectArray objects, PyObject *(*wrapfn)(jobject));
jobjectArray pl2ja(PyObject *pl, jclass cls);
jobjectArray pl2ja(PyObject *pl, jclass cls,
                   int (*check)(PyObject *), jobject (*make)(PyObject *));

#endif /* _converters_h */
