/* ====================================================================
 * Copyright (c) 2004-2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#ifndef _PyLucene_h
#define _PyLucene_h

#include <gcj/cni.h>
#undef EOF
#include <java/lang/Comparable.h>
#include <java/util/Collection.h>

#include <Python.h>

#include "../converters.h"
#include "../functions.h"

#include "../java.h"
#include "../lucene.h"


PyObject *callPython(PyObject *self, char *methodName, ...);

#define finalizeObject(object)                  \
    if (object)                                 \
    {                                           \
        PythonGIL gil;                          \
        Py_XDECREF(*(PyObject **) &(object));   \
        (object) = (jlong) 0;                   \
    }

class PythonGIL {
  private:
    PyGILState_STATE state;
  public:
    PythonGIL()
    {
        state = PyGILState_Ensure();
    }
    ~PythonGIL()
    {
        PyGILState_Release(state);
    }
};

class PythonThreadState {
  private:
    PyThreadState *state;
  public:
    PythonThreadState()
    {
        state = PyEval_SaveThread();
    }
    ~PythonThreadState()
    {
        PyEval_RestoreThread(state);
    }
};

#endif
