/* ====================================================================
 * Copyright (c) 2004-2005 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#include "PyLucene.h"
#include <java/util/Vector.h>

#include "org/apache/lucene/search/BooleanClause.h"
#include "org/apache/lucene/search/Query.h"
#include "org/apache/lucene/queryParser/QueryParser.h"
#include "org/osafoundation/queryParser/PythonQueryParser.h"
#include "org/osafoundation/queryParser/PythonMultiFieldQueryParser.h"
#include "org/osafoundation/util/PythonException.h"


/**
 * The native functions declared in:
 *     org.osafoundation.queryParser.PythonQueryParser
 * 
 * @author Andi Vajda
 */

static ::org::apache::lucene::search::Query *query(PyObject *pyQuery)
{
    if (pyQuery)
    {
        org::apache::lucene::search::Query *query;

        if (!parseArg(pyQuery, "J",
                      &org::apache::lucene::search::Query::class$, &query))
        {
            Py_DECREF(pyQuery);
            return query;
        }
        else
        {
            PyErr_SetObject(PyExc_TypeError, pyQuery);
            Py_DECREF(pyQuery);
        }            
    }

    throw new org::osafoundation::util::PythonException();
}


namespace org {
    namespace osafoundation {
        namespace queryParser {

            static PyObject *javaQP(PythonQueryParser *self)
            {
                return wrap_QueryParser((org::apache::lucene::queryParser::QueryParser *) self);
            }

            static PyObject *javaMFQP(PythonMultiFieldQueryParser *self)
            {
                return wrap_MultiFieldQueryParser((org::apache::lucene::queryParser::MultiFieldQueryParser *) self);
            }

            // org.osafoundation.queryParser.PythonQueryParser

            void PythonQueryParser::incRef(void)
            {
                PythonGIL gil;
                Py_INCREF(*(PyObject **) &pythonQueryParser);
            }

            void PythonQueryParser::decRef(void)
            {
                finalizeObject(pythonQueryParser);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getBooleanQuery(::java::util::Vector *clauses)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getBooleanQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyList =
                        ja2pl(clauses->toArray(),
                              (PyObject *(*)(jobject)) wrap_BooleanClause);
                    PyObject *pyQuery = callPython(pyQP, "getBooleanQuery", pySuper, pyList, NULL);
                    Py_DECREF(pySuper);
                    Py_DECREF(pyList);

                    return query(pyQuery);
                }
        
                return QueryParser::getBooleanQuery(clauses);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getFieldQuery(jstring field, jstring queryText)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getFieldQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyQueryText = j2p(queryText);
                    PyObject *pyQuery = callPython(pyQP, "getFieldQuery", pySuper, pyField, pyQueryText, Py_None, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyQueryText);

                    return query(pyQuery);
                }

                return QueryParser::getFieldQuery(field, queryText);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getFieldQuery(jstring field, jstring queryText, jint slop)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getFieldQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyQueryText = j2p(queryText);
                    PyObject *pySlop = PyInt_FromLong((int) slop);
                    PyObject *pyQuery = callPython(pyQP, "getFieldQuery", pySuper, pyField, pyQueryText, pySlop, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyQueryText);
                    Py_DECREF(pySlop);

                    return query(pyQuery);
                }

                return QueryParser::getFieldQuery(field, queryText, slop);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getFuzzyQuery(jstring field, jstring termText, jfloat minSim)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getFuzzyQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyMinSim = PyFloat_FromDouble(minSim);
                    PyObject *pyQuery = callPython(pyQP, "getFuzzyQuery", pySuper, pyField, pyTermText, pyMinSim, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);
                    Py_DECREF(pyMinSim);

                    return query(pyQuery);
                }

                return QueryParser::getFuzzyQuery(field, termText, minSim);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getPrefixQuery(jstring field, jstring termText)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getPrefixQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyQuery = callPython(pyQP, "getPrefixQuery", pySuper, pyField, pyTermText, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);

                    return query(pyQuery);
                }

                return QueryParser::getPrefixQuery(field, termText);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getRangeQuery(jstring field, jstring part1, jstring part2, jboolean inclusive)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getRangeQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyPart1 = j2p(part1);
                    PyObject *pyPart2 = j2p(part2);
                    PyObject *pyInclusive = PyBool_FromLong((long) inclusive);
                    PyObject *pyQuery = callPython(pyQP, "getRangeQuery", pySuper, pyField, pyPart1, pyPart2, pyInclusive, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyPart1);
                    Py_DECREF(pyPart2);
                    Py_DECREF(pyInclusive);

                    return query(pyQuery);
                }

                return QueryParser::getRangeQuery(field, part1, part2,
                                                  inclusive);
            }

            ::org::apache::lucene::search::Query *PythonQueryParser::getWildcardQuery(jstring field, jstring termText)
            {
                PythonGIL gil;
                PyObject *pyQP = *(PyObject **) &pythonQueryParser;

                if (PyObject_HasAttrString(pyQP, "getWildcardQuery"))
                {
                    PyObject *pySuper = javaQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyQuery = callPython(pyQP, "getWildcardQuery", pySuper, pyField, pyTermText, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);

                    return query(pyQuery);
                }

                return QueryParser::getWildcardQuery(field, termText);
            }


            // org.osafoundation.queryParser.MultiFieldPythonQueryParser

            void PythonMultiFieldQueryParser::incRef(void)
            {
                PythonGIL gil;
                Py_INCREF(*(PyObject **) &pythonMultiFieldQueryParser);
            }

            void PythonMultiFieldQueryParser::decRef(void)
            {
                finalizeObject(pythonMultiFieldQueryParser);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getBooleanQuery(::java::util::Vector *clauses)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getBooleanQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyList =
                        ja2pl(clauses->toArray(),
                              (PyObject *(*)(jobject)) wrap_BooleanClause);
                    PyObject *pyQuery = callPython(pyMFQP, "getBooleanQuery", pySuper, pyList, NULL);
                    Py_DECREF(pySuper);
                    Py_DECREF(pyList);

                    return query(pyQuery);
                }
        
                return MultiFieldQueryParser::getBooleanQuery(clauses);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getFieldQuery(jstring field, jstring queryText)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getFieldQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyQueryText = j2p(queryText);
                    PyObject *pyQuery = callPython(pyMFQP, "getFieldQuery", pySuper, pyField, pyQueryText, Py_None, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyQueryText);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getFieldQuery(field, queryText);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getFieldQuery(jstring field, jstring queryText, jint slop)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getFieldQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyQueryText = j2p(queryText);
                    PyObject *pySlop = PyInt_FromLong((int) slop);
                    PyObject *pyQuery = callPython(pyMFQP, "getFieldQuery", pySuper, pyField, pyQueryText, pySlop, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyQueryText);
                    Py_DECREF(pySlop);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getFieldQuery(field, queryText, slop);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getFuzzyQuery(jstring field, jstring termText, jfloat minSim)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getFuzzyQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyMinSim = PyFloat_FromDouble(minSim);
                    PyObject *pyQuery = callPython(pyMFQP, "getFuzzyQuery", pySuper, pyField, pyTermText, pyMinSim, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);
                    Py_DECREF(pyMinSim);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getFuzzyQuery(field, termText, minSim);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getPrefixQuery(jstring field, jstring termText)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getPrefixQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyQuery = callPython(pyMFQP, "getPrefixQuery", pySuper, pyField, pyTermText, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getPrefixQuery(field, termText);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getRangeQuery(jstring field, jstring part1, jstring part2, jboolean inclusive)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getRangeQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyPart1 = j2p(part1);
                    PyObject *pyPart2 = j2p(part2);
                    PyObject *pyInclusive = PyBool_FromLong((long) inclusive);
                    PyObject *pyQuery = callPython(pyMFQP, "getRangeQuery", pySuper, pyField, pyPart1, pyPart2, pyInclusive, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyPart1);
                    Py_DECREF(pyPart2);
                    Py_DECREF(pyInclusive);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getRangeQuery(field, part1, part2, inclusive);
            }

            ::org::apache::lucene::search::Query *PythonMultiFieldQueryParser::getWildcardQuery(jstring field, jstring termText)
            {
                PythonGIL gil;
                PyObject *pyMFQP = *(PyObject **) &pythonMultiFieldQueryParser;

                if (PyObject_HasAttrString(pyMFQP, "getWildcardQuery"))
                {
                    PyObject *pySuper = javaMFQP(this);
                    PyObject *pyField = j2p(field);
                    PyObject *pyTermText = j2p(termText);
                    PyObject *pyQuery = callPython(pyMFQP, "getWildcardQuery", pySuper, pyField, pyTermText, NULL);

                    Py_DECREF(pySuper);
                    Py_DECREF(pyField);
                    Py_DECREF(pyTermText);

                    return query(pyQuery);
                }

                return MultiFieldQueryParser::getWildcardQuery(field, termText);
            }
        }
    }
}
