/* ====================================================================
 * Copyright (c) 2004-2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#ifndef _java_h
#define _java_h

#include <java/lang/Object.h>
#include <java/lang/Throwable.h>
#include <java/lang/Package.h>
#include <java/lang/Comparable.h>
#include <java/io/Reader.h>
#include <java/io/PrintStream.h>
#include <java/util/Date.h>
#include <java/util/Enumeration.h>
#include <java/util/Iterator.h>
#include <java/util/NoSuchElementException.h>
#include <java/util/Locale.h>
#include <java/util/BitSet.h>

void _init_java(PyObject *m);

class j_object {
public:
    PyObject_HEAD
    jobject object;
};

extern PyTypeObject ObjectType;
extern PyTypeObject ThrowableType;
extern PyTypeObject PackageType;
extern PyTypeObject ReaderType;
extern PyTypeObject PrintStreamType;
extern PyTypeObject CharsetType;
extern PyTypeObject DateType;
extern PyTypeObject EnumerationType;
extern PyTypeObject IteratorType;
extern PyTypeObject ComparableType;
extern PyTypeObject BitSetType;

PyObject *wrap_Object(java::lang::Object *object);
PyObject *wrap_Throwable(java::lang::Throwable *object);
PyObject *wrap_Package(java::lang::Package *object);
PyObject *wrap_Reader(java::io::Reader *object);
PyObject *wrap_PrintStream(java::io::PrintStream *object);
PyObject *wrap_Charset(JArray<jchar> *object);
PyObject *wrap_Date(java::util::Date *object);
PyObject *wrap_Comparable(java::lang::Comparable *object);
PyObject *wrap_Locale(java::util::Locale *object);
PyObject *wrap_BitSet(java::util::BitSet *object);

int check_Reader(PyObject *arg);
java::io::Reader *make_Reader(PyObject *arg);

int check_Charset(PyObject *arg);
JArray<jchar> *make_Charset(PyObject *arg);

int check_Comparable(PyObject *arg);
java::lang::Comparable *make_Comparable(PyObject *arg);

#endif /* _java_h */
