/* ====================================================================
 * Copyright (c) 2004-2005 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

package org.osafoundation.store;

import org.apache.lucene.store.BufferedIndexInput;

/**
 * @author Andi Vajda
 */

public class PythonIndexInput extends BufferedIndexInput {

    protected long pythonIndexInput;
    protected boolean isClone = false;

    public PythonIndexInput(long pythonIndexInput)
    {
        this.pythonIndexInput = pythonIndexInput;
        incRef();
    }

    protected void finalize()
        throws Throwable
    {
        decRef();
    }

    public Object clone()
    {
        PythonIndexInput clone = (PythonIndexInput) super.clone();

        clone.isClone = true;
        clone.incRef();

        return clone;
    }

    protected native void incRef();
    protected native void decRef();

    public native void close();
    public native long length();
    protected native void readInternal(byte[] b, int offset, int length);
    protected native void seekInternal(long pos);
}
