/* ====================================================================
 * Copyright (c) 2004-2006 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

#ifndef _lucene_h
#define _lucene_h

#include "org/apache/lucene/index/Term.h"
#include "org/apache/lucene/index/TermEnum.h"
#include "org/apache/lucene/index/IndexReader.h"
#include "org/apache/lucene/search/Searcher.h"
#include "org/apache/lucene/search/ScoreDoc.h"
#include "org/apache/lucene/search/Weight.h"
#include "org/apache/lucene/search/Filter.h"
#include "org/apache/lucene/search/HitCollector.h"
#include "org/apache/lucene/search/Sort.h"
#include "org/apache/lucene/search/Query.h"
#include "org/apache/lucene/search/BooleanClause.h"
#include "org/apache/lucene/search/highlight/TokenGroup.h"
#include "org/apache/lucene/queryParser/QueryParser.h"
#include "org/apache/lucene/queryParser/MultiFieldQueryParser.h"

void _init_lucene(PyObject *m);

PyObject *wrap_Term(org::apache::lucene::index::Term *);
PyObject *wrap_TermEnum(org::apache::lucene::index::TermEnum *);
PyObject *wrap_IndexReader(org::apache::lucene::index::IndexReader *);
PyObject *wrap_Searcher(org::apache::lucene::search::Searcher *);
PyObject *wrap_ScoreDoc(org::apache::lucene::search::ScoreDoc *);
PyObject *wrap_Weight(org::apache::lucene::search::Weight *);
PyObject *wrap_Filter(org::apache::lucene::search::Filter *);
PyObject *wrap_HitCollector(org::apache::lucene::search::HitCollector *);
PyObject *wrap_Sort(org::apache::lucene::search::Sort *);
PyObject *wrap_Query(org::apache::lucene::search::Query *);
PyObject *wrap_BooleanClause(org::apache::lucene::search::BooleanClause *);
PyObject *wrap_TokenGroup(org::apache::lucene::search::highlight::TokenGroup *);
PyObject *wrap_QueryParser(org::apache::lucene::queryParser::QueryParser *);
PyObject *wrap_MultiFieldQueryParser(org::apache::lucene::queryParser::MultiFieldQueryParser *);
PyObject *wrap_Token(org::apache::lucene::analysis::Token *);

#endif /* _lucene_h */
