# ====================================================================
# Copyright (c) 2004-2005 Open Source Applications Foundation.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions: 
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software. 
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
# ====================================================================
#


class StringReader(object):

    def __init__(self, unicodeText):

        super(StringReader, self).__init__()
        self.unicodeText = unicode(unicodeText)

    def read(self, length = -1):

        text = self.unicodeText
        if text is None:
            return u''
        
        if length == -1 or length >= len(text):
            self.unicodeText = None
            return text

        text = text[0:length]
        self.unicodeText = self.unicodeText[length:]

        return text

    def close(self):
        pass


class InputStreamReader(object):

    def __init__(self, inputStream, encoding):

        super(InputStreamReader, self).__init__()
        self.inputStream = inputStream
        self.encoding = encoding

    def read(self, length = -1):

        text = self.inputStream.read(length)
        text = unicode(text, self.encoding)

        return text

    def readline(self):

        text = self.inputStream.readline()
        text = unicode(text, self.encoding)

        return text

    def close(self):

        self.inputStream.close()
