from pyprolog import Term

print """
What substitutions for variables A and B are needed to make 

    ['apple', A, 'grape']==[B, 'orange', 'grape'] 

true?  If A=='orange' and B=='apple', the two lists would be
equivalent.
"""

A = Term.new_variable()
B = Term.new_variable()

converter = Term.var_to_prolog()
m1 = converter(['apple', A, 'grape'])
m2 = converter([B, 'orange', 'grape'])

print "BEFORE> A=%s, B=%s, m1=%s, m2=%s" % (A, B, m1, m2)

m1.unify(m2)

print "AFTER> A=%s, B=%s, m1=%s, m2=%s" % (A, B, m1, m2)

print 'UNIFIED LIST>', Term.from_prolog()(m1)


print """


What substitutions for variable A is needed to make 

    ['apple', A, 'grape']==['banana', 'orange', 'grape'] 

true?  None. The literal apple can never equal the literal banana, so
the two list can't be unified.

"""
A = Term.new_variable()

converter = Term.var_to_prolog()
m1 = converter(['apple', A, 'grape'])
m2 = converter(['banana', 'orange', 'grape'])

print "BEFORE> A=%s, m1=%s, m2=%s" % (A, m1, m2)

if not m1.unify(m2):
	print 'As expected, these terms do not unify.'

print "SAME> A=%s, m1=%s, m2=%s" % (A, m1, m2)


print """


What substitutions for variables A, B are needed to make 

    ['apple', A, 'grape']==['apple', B, 'grape'] 

true?  After unification, A and B are aliases of the same variable.

"""
A = Term.new_variable()
B = Term.new_variable()

converter = Term.var_to_prolog()
m1 = converter(['apple', A, 'grape'])
m2 = converter(['apple', B, 'grape'])

print "BEFORE> A=%s, B=%s, m1=%s, m2=%s" % (A, B, m1, m2)

m1.unify(m2)

print "AFTER> A=%s, B=%s, m1=%s, m2=%s" % (A, B, m1, m2)

peach = Term.to_prolog()('peach')
B.unify(peach)

print "FINALLY> A=%s, B=%s, m1=%s, m2=%s" % (A, B, m1, m2)
