
# import sys; sys.path.insert(0, './_local/PythonLib')

from distutils.core import setup, Extension
import os

def get_atom(atom):
	query = "pl -f none -g 'current_prolog_flag(%s, V), write(V), nl.' -t 'halt'"
	f = os.popen(query % atom)
	r = f.read()[:-1]
	f.close()
	return r

# TDB: this code only need run during 'build'.
arch = get_atom('arch')
#swipl_version =  get_atom('version')
swipl_home =  get_atom('home')
#print 'P>', arch, swipl_version, swipl_home
swipl_include_path = os.path.join(swipl_home, 'include')
swipl_library_path = os.path.join(swipl_home, 'runtime', arch)
#print 'I>', swipl_include_path, swipl_library_path

setup(name="PyProlog",
	  version="0.1",
	  author="Glen Wilder",
	  author_email="gwilder@best.com",
	  url="http://pyprolog.sourceforge.net",
	  licence='LGPL',
	  description='SWI-Prolog extension module',
	  packages=["pyprolog"],
	  package_dir={"pyprolog":"Lib"},
	  #data_files=[   ('lib/python/pyprolog/test', ['Lib/test/calc.pl'])   ],
	  ext_modules=[Extension("pyprolog.swiplmodule", 
							 ["Modules/swiplmodule.c"],
							 include_dirs=[swipl_include_path],
							 library_dirs=[swipl_library_path],
							 libraries=['pl', 'termcap'])
				   ]   
	  )
