#! /usr/bin/env python

import sys, types
import unittest
from pyprolog import swipl

class test_PAtom(unittest.TestCase):
    
    def setUp(self):
        self.a = swipl.new_atom("abc")
        self.b = swipl.new_atom("the letter b")
        self.c = swipl.new_atom("a null\000 value.")
        self.big_string = 'ab\tc\nz\000\n'*100
        self.d = swipl.new_atom(self.big_string)
        return
    
    def test_repr(self): 
        msg = 'repr is wrong.'
        assert repr(self.a) == 'new_atom("abc")', msg
        assert repr(self.b) == 'new_atom("the letter b")', msg
        assert repr(self.c) == 'new_atom("a null\000 value.")', msg
        assert repr(self.d) == 'new_atom("%s")' % self.big_string, msg
    
    def test_atom_nchars(self): 
        msg = 'atom_nchars is wrong.'
        assert self.a.atom_nchars() == (3, 'abc'), msg
        assert self.b.atom_nchars() == (12, 'the letter b'), msg
        assert self.c.atom_nchars() == (14, 'a null\000 value.'), msg
        assert self.d.atom_nchars() == (800, self.big_string)
    
    def test_handle(self): 
        msg = "atom's handle is not an integer."
        assert type(self.a.handle) == types.IntType, msg
        assert type(self.b.handle) == types.IntType, msg
        assert type(self.c.handle) == types.IntType, msg
        assert type(self.d.handle) == types.IntType, msg

def make_suite():
    suite = unittest.TestSuite()
    suite.addTest(test_PAtom('test_repr'))
    suite.addTest(test_PAtom('test_atom_nchars'))
    suite.addTest(test_PAtom('test_handle'))
    return suite

def main():
    runner = unittest.TextTestRunner()
    suite = make_suite()
    runner.run(suite)

if __name__ == '__main__':
    main()
   
# Local Variables:          
# mode:python               
# indent-tabs-mode: nil     
# py-indent-offset: 4  
# py-smart-indentation: nil 
# End:                      
