#! /usr/bin/env python

import types
import unittest
from pyprolog import swipl

class test_PFunctor(unittest.TestCase):
    
    def setUp(self):
        self.f1 = swipl.new_functor(swipl.new_atom("f1"), 1)
        self.f2 = swipl.new_functor(swipl.new_atom("f2"), 2)
        self.fq = swipl.new_functor(swipl.new_atom("f\000q"), 3)
##         self.big_string = 'ab\tc\nz\000\n'*100
##         self.f4 = new_functor(swipl.new_atom(self.big_string), 1)
        self.f5 = swipl.new_functor(swipl.new_atom('F'), 2)
        return
    
    def test_repr(self): 
        msg = 'repr is wrong.'
        assert repr(self.f1) == "new_functor(f1, 1)"
        assert repr(self.f2) == "new_functor(f2, 2)"
        assert repr(self.fq) == 'new_functor(f\000q, 3)'
        assert repr(self.f5) == 'new_functor(F, 2)'
    
    def test_handle(self): 
        msg = "functor's handle is not an integer."
        assert type(self.f1.handle) == types.IntType, msg
        assert type(self.f2.handle) == types.IntType, msg
        assert type(self.fq.handle) == types.IntType, msg
        assert type(self.f5.handle) == types.IntType, msg
    
    def test_functor_name(self): 
        msg = "problem with functor's name."
        assert self.f1.functor_name() == 'f1' , msg
        assert self.f2.functor_name() == 'f2' , msg
        assert self.fq.functor_name() == 'f\000q' , msg
        assert self.f5.functor_name() == 'F' , msg
    
    def test_functor_arity(self): 
        msg = "problem with functor's arity."
        assert self.f1.functor_arity() == 1 , msg
        assert self.f2.functor_arity() == 2 , msg
        assert self.fq.functor_arity() == 3 , msg
        assert self.f5.functor_arity() == 2 , msg

def make_suite():
    suite = unittest.TestSuite()
    suite.addTest(test_PFunctor('test_repr'))
    suite.addTest(test_PFunctor('test_handle'))
    suite.addTest(test_PFunctor('test_functor_name'))
    suite.addTest(test_PFunctor('test_functor_arity'))
    return suite

def main():
    runner = unittest.TextTestRunner()
    suite = make_suite()
    runner.run(suite)

if __name__ == '__main__':
    main()
   
# Local Variables:          
# mode:python               
# indent-tabs-mode: nil     
# py-indent-offset: 4  
# py-smart-indentation: nil 
# End:                      
