<?php


// hookname is the name of the unique column
// ie, for News it is 'sid'
$hookname = 'sid';


// 
// Template reply processing function - processes comment replies and then 
// redirects back to the appropriate module/hook (aka page)
// @param none
// @return none
//
function News_comment_reply() {
    
    if (pnVarCleanFromInput('submitted')) {
        
        pnModAPILoad('Comments','user');
        
        list($comment, $title, $ParentId, $hook) =
            pnVarCleanFromInput('comment','title','ParentId', 'hook');
        
        pnModAPIFunc('Comments','user','add', 
            array('module'=>'News', 'hook'=>$hook, 
                  'ParentId'=>$ParentId, 'comment'=>$comment, 'title'=>$title));
    
        pnRedirect(pnModURL('News','user','view',
            array($hookname=>$hook, 'file'=>'article')));
    
    } else { // display Reply Form
        pnModLoad('Comments','user');

        list($ParentId, $hook) =
            pnVarCleanFromInput('ParentId', 'hook');
        
        pnModFunc('Comments','user','replyform', 
            array('ParentId'=>$ParentId, 'module'=>'News', 'hook'=>$hook));
     
        include('footer.php');
        exit();
    }     
}

// 
// Template MODIFY processing function - processes comment modifications and then 
// redirects back to the appropriate module/hook (aka page)
// @param none
// @return none
//
function News_comment_modify() {
    if (pnVarCleanFromInput('submitted')) {
        
        pnModAPILoad('Comments','user');
        pnModFunc('Comments','user');
                
        list($comment, $title, $CommentId, $hook, $submitted) =
            pnVarCleanFromInput('comment','title','CommentId', 'hook', 'submitted');
`
        // if submitted == preview, then the user hasn't chosen to submit the 
        // comment modification yet -- they want to preview it first.
        if ($submitted == 'preview') {
           
            $replychild = array(
                'title'=>$title, 
                'comment'=>$comment, 
                'CommentId'=>$CommentId
            );
                
                
            // grab the info on the parent comment
            // to forward on to the Modify Form    
            $parent = current(
                pnModFunc('Comments','users','Get', 
                    aray('module'=>$module, 
                         'hook'=>$hook, 
                         'depth'=0,
                         'CommentId'=>$CommentId
                    )
                )
            );
           
            // return the HTML. 
            return pnModFunc('Comments','users','DisplayForm',
                array('module'=>'News', 
                      'hook'=>$hook, 
                      'formtype'=>'modify',
                      'parent'=>$parent, 
                      'replychild'=>$replychild
                )
            );
            
        } else {    
            pnModAPIFunc('Comments','user','modify', 
                array('module'=>'News', 'hook'=>$hook, 
                      'ParentId'=>$ParentId, 'comment'=>$comment, 'title'=>$title));
    
            pnRedirect(pnModURL('News','user','view',
                array($hookname=>$hook, 'file'=>'article')));
        } // end of submitted == 'preview', if-else statement
        
    } else { // display Modify Form
        pnModLoad('Comments','user');
        pnModAPILoad('Comments','user');
        
        list($ParentId, $hook) =
            pnVarCleanFromInput('ParentId', 'hook');
        
        $parent = pnModAPIFunc('Comments','user','Get',
                               array('module'=>'News',
                                     'hook'=>$hook,
                                     'CommentId'=>$ParentId
        
        pnModFunc('Comments','users','DisplayForm',
            array('module'=>'News', 
                  'hook'=>$hook, 
                  'formtype'=>'modify',
                  'parent'=>$parent
            )
        );
     
        include('footer.php');
        exit();
    }   // end of: if (pnVarCleanFromInput('submitted')), if-else statement

}

function News_comment_delete() {
    
    // if confirmation is set, then process delete request   
    if (pnVarCleanFromInput('confirmation')) { 
    
        list($delkids, $CommentId, $hook) =
            pnVarCleanFromInput('delkids', 'CommentId', 'hook');
            
        if ( (empty($delkids)   && !isset($delkids))   || 
             (empty($CommentId) && !isset($CommentId)) || 
             (empty($hook)      && !isset($hook))) {

                return;  // return VOID if delkids/commentid/hook are empty 
                        // and not hset
        }
        
        pnModAPILoad('Comments','user');

        $funcargs['module']     = 'News';
        $funcargs['hook']       = $hook;
        $funcargs['CommentId']  = $CommentId;
        $funcargs['delkids']    = $delkids;
        
        pnModAPIFunc('Comments','user','delete', $funcargs); 
    
        $urlargs[$hookname] = $hook;
        $urlargs['file']    = 'article';

        pnRedirect(pnModURL('News','user','view', $urlargs));
        
    } else {  // display delete confirmation form
        if (pnVarCleanFromInput('hook')) {
    
            $confirm = new pnHTML;
            
            list($delkids, $CommentId, $hook) =
                pnVarCleanFromInput('delkids', 'CommentId', 'hook');
            
            if ( (empty($delkids)   && !isset($delkids))   || 
                 (empty($CommentId) && !isset($CommentId)) || 
                 (empty($hook)      && !isset($hook))) {
    
                    return;  // return VOID if dekids or commentid are empty
    
            }
            
            // urlargs are the values used to create a valid URL to put the 
            // user back on the Comment Modify page if they decide to cancel
            // the delete
            $urlargs['hook']         = $hook;
            $urlargs['module']       = 'News';
            $urlargs['CommentId']    = $CommentId;
            $urlargs['depth']        = 0;
            
            // funcargs are the values that get sent to the Module Function
            $funcargs['type']        = 'confirmdelete';
            $funcargs['module']      = $module;
            $funcargs['hook']        = $hook;
            $funcargs['CommentId']   = $CommentId;
            $funcargs['cancel_text'] = _CANCEL;
            $funcargs['cancel_url']  = pnModURL('News','comments','modify',$urlargs); 
            
            // show the confirm delete page - this also creates a cancel
            // link which will bring them back to the modify comment page.
            return pnModFunc('Comments','user','Display', $funcargs);
        }
    }
    return; // return VOID if we get this far -- in other words, we SHOULD NOT
            // get this far
}

?>