////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////


// ShadowMap.h: interface for the ShadowMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SHADOWMAP_H__50A1C655_51B8_4B47_982E_58C20CD21815__INCLUDED_)
#define AFX_SHADOWMAP_H__50A1C655_51B8_4B47_982E_58C20CD21815__INCLUDED_

#include <GLEXT/GLTexture.h>

class ShadowMap  
{
public:
	ShadowMap();
	virtual ~ShadowMap();

	void setTexture();
	void addSquare(float x, float y, float w, float opacity = 1.0f);
	void addCircle(float sx, float sy, float sw, float opacity = 1.0f);

protected:
	static ShadowMap *instance_;
	GLTexture shadowTexture_;
	GLubyte *shadowBytes_;
	GLint size_, sizeSq_;

};

#endif // !defined(AFX_SHADOWMAP_H__50A1C655_51B8_4B47_982E_58C20CD21815__INCLUDED_)
