// Description:
//   Controller
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BLockController_hpp__
#define __BLockController_hpp__

#include "EventWatcher.hpp"
#include "EventInjector.hpp"

#include "BlockModel.hpp"
#include "BlockViewBase.hpp"

class BlockController
{
public:
    BlockController( BlockModel &model, BlockViewBase &view);
    ~BlockController();

    bool update( void);

    void setEventWatcher( EventWatcher *ev)
    {
	_eventWatcher = ev;
    }

    void setEventInjector( EventInjector *inj)
    {
	_eventInjector = inj;
    }

private:
    bool hasEvent( SDL_Event &event);

    BlockModel &_model;
    BlockViewBase &_view;
    EventWatcher *_eventWatcher;
    EventInjector *_eventInjector;
};

#endif
