// Description:
//   Block View GL
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BlockViewGL_hpp__
#define __BlockViewGL_hpp__

#include "BlockViewSmooth.hpp"

class BlockViewGL: public BlockViewSmooth
{
public:
    BlockViewGL( BlockModel &model);
    virtual ~BlockViewGL();

    virtual bool init( void);
    virtual void close( void);

    virtual void draw( void) = 0;
    virtual void snapshot( void);

protected:
    bool _isFullscreen;
    int _bpp;
    int _width;
    int _height;
};

#endif
