// Description:
//   Block View smooth rotation
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BlockViewSmooth_hpp__
#define __BlockViewSmooth_hpp__

#include <Point.hpp>
#include <Quaternion.hpp>

#include "BlockViewBase.hpp"

class BlockViewSmooth: public BlockViewBase
{
public:
    BlockViewSmooth( BlockModel &model);
    virtual ~BlockViewSmooth();

    virtual void update( void);

    virtual void notifyNewBlock( void);
    virtual void notifyNewRotation( const Quaternion &q);

    //Get interpolated values based on the current game state frameFraction
    Point3D &getInterpolatedOffset( void);
    float getInterpolatedAngle( void);

    Point3D &getCurrentAxis( void) { return _currentAxis; }
    float getPrevAngle( void) { return _prevAngle; }
    Point3D &getPrevAxis( void) { return _prevAxis; }

private:
    void resetRotations( void);

    float _rotationSpeed;
    int _moveSteps;

    Point3D _interpOffset; 
    Point3Di _oldOffset;
    Point3D _delta;
    Point3D _targetOffset;
    Point3D _currentOffset;
    Point3D _prevOffset;
    int _numSteps;
    float _prev2Angle;

    Quaternion _prevQ;
    Point3D _prevAxis;
    float _prevAngle;

    Quaternion _targetQ;
    Point3D _currentAxis;
    float _currentAngle;
    float _targetAngle;
};

#endif
