// Description:
//   All kinds of constants (record)
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _Constants_hpp_
#define _Constants_hpp_

#include <string>
#include <defines.h>

#ifndef M_PI
# define M_PI           3.14159265358979323846  /* pi */
#endif

#if 0
template <typename TYPE>
inline TYPE MIN( const TYPE v1, const TYPE v2)
{
    return (v1<v2?v1:v2);
}

template <typename TYPE>
inline TYPE MAX( const TYPE v1, const TYPE v2)
{
    return (v1>v2?v1:v2);
}
#endif

const string GAMETITLE   = PACKAGE;
const string GAMEVERSION = VERSION;

const float GAME_STEP_SIZE = 1.0/50.0; //run logic 50 times per second
const int MAX_GAME_STEPS = 20; //max number of logic runs per frame

// All updates in out logic are based on a game step size of 1/50.
// In case we want to use a different GAME_STEP_SIZE in the future,
// multiply all update values by GAME_STEP_SCALE.
const float GAME_STEP_SCALE = 50.0*GAME_STEP_SIZE;

#endif
