// Description:
//   Creates SDL events from stream (playback)
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _EventInjector_hpp_
#define _EventInjector_hpp_

#include "SDL.h"

#include <iostream>
using namespace std;

#include <Trace.hpp>
#include <Tokenizer.hpp>
#include "GameState.hpp"

class EventInjector
{
public:
    EventInjector( istream &in):
	_inStream(in)
    {
    	getNextEvent();
    }

    void getNextEvent( void)
    {
	if( _inStream.eof())
	    _nextGameTick = (unsigned int)-1;
	else
	{
	    string line;
	    getline( _inStream, line);

	    Tokenizer token(line);
	    _nextGameTick = atoi( token.next().c_str());
	    _nextEvent.type = atoi( token.next().c_str());
//	    LOG_INFO << "Event type = " << (unsigned int)_nextEvent.type << "\n";

	    switch( _nextEvent.type)
	    {
		case SDL_KEYDOWN:
		case SDL_KEYUP:
		    _nextEvent.key.keysym.sym = (SDLKey)atoi( token.next().c_str());
//		    LOG_INFO << "Key = " << (unsigned int)_nextEvent.key.keysym.sym << "\n";
		    break;
	    }
	}

//	LOG_INFO << "Next tick = " << _nextGameTick << "\n";
    }

    bool getEvent( SDL_Event &event)
    {
	if( _nextGameTick <= GameState::gameTick)
	{
	    event = _nextEvent;
	    getNextEvent();
	    return true;
	}
	return false;
    }

private:
    istream &_inStream;
    unsigned int _nextGameTick; 
    SDL_Event _nextEvent;
};

#endif
