// Description:
//   Collection of game state variables.
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _GameState_hpp_
#define _GameState_hpp_

#include <PausableTimer.hpp>
#include <R250.hpp>

struct GameState
{
    static bool isDeveloper;
    static bool isAlive;
    static bool requestExit;

    static bool showFPS;

    static float startOfStep;
    static float frameFractionOther;
    static float startOfGameStep;
    static float frameFraction;
    static unsigned int gameTick;

    static PausableTimer stopwatch;
    static R250 r250;
};

#endif
