// Description:
//   Block View Base
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BlockViewBase_hpp__
#define __BlockViewBase_hpp__

#include <Quaternion.hpp>
#include "BlockModel.hpp"

class BlockViewBase
{
public:
    BlockViewBase( BlockModel &model);
    virtual ~BlockViewBase();

    virtual bool init( void) = 0;
    virtual void close( void) = 0;
    virtual void draw( void) = 0;

    // game step update
    virtual void update( void);

    //The model will call these when a new block or a new
    //rotation was applied.
    virtual void notifyNewBlock( void) {}
    virtual void notifyNewRotation( const Quaternion &) {}

    virtual void snapshot( void) {};

protected:
    BlockModel &_model;
};

#endif
