// Description:
//   Block View GL smooth rotation
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BlockViewGLSmooth_hpp__
#define __BlockViewGLSmooth_hpp__

#include <Point.hpp>
#include <Quaternion.hpp>
#include <GLBitmapFont.hpp>

#include "BlockViewGL.hpp"

class BlockViewGLSmooth: public BlockViewGL
{
public:
    BlockViewGLSmooth( BlockModel &model);
    virtual ~BlockViewGLSmooth();

    virtual bool init( void);
    virtual void close( void);

    virtual void draw( void);
    virtual void update( void);
private:
    void drawElement( Point3Di *p, bool isLocked);
    void drawShaft( void);
    void drawIndicator( void);

    void setColor( int p);

    float _squaresize;
    bool _useAALines;
    float _gameOverAngle;

    GLBitmapFont *_smallFont;
    GLTexture *_blockFace;
};

#endif
