// Description:
//   Converts SDL events to stream
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _EventWatcher_hpp_
#define _EventWatcher_hpp_

#include "SDL.h"

#include <iostream>
using namespace std;

#include "GameState.hpp"

class EventWatcher
{
public:
    EventWatcher( ostream &os):
	_outStream(os)
    {
    }

    void notify( SDL_Event &event)
    {
	switch( event.type)
	{
	    case SDL_KEYDOWN:
	    case SDL_KEYUP:
		_outStream << GameState::gameTick << " ";
		_outStream << (unsigned int)event.type << " ";
		_outStream << (unsigned int)event.key.keysym.sym << "\n";
		break;
	}
    }

private:
    ostream &_outStream;
};

#endif
