// Description:
//   Collection of game state variables.
//
// Copyright (C) 2003 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <GameState.hpp>

bool GameState::isDeveloper = false;
bool GameState::isAlive = true;
bool GameState::requestExit = false;

bool GameState::showFPS = false;

float GameState::startOfStep = 0;
float GameState::frameFractionOther = 0.0;
float GameState::startOfGameStep = 0;
float GameState::frameFraction = 0.0;
unsigned int GameState::gameTick = 0;

PausableTimer GameState::stopwatch;
R250 GameState::r250;
