use ExtUtils::MakeMaker;

sub chk_module {
    my($pkg) = @_;
    print "Checking for $pkg ..";
    eval { my $p; ($p = $pkg . ".pm") =~ s#::#/#g; require $p; };
    if ($@) {
	print " failed\n";
	$missing_modules++;
    } else {
	print " ok\n";
    }
}

if ($missing_modules) {
    print "One or more required modules is missing. Stop.\n";
    exit;
}

WriteMakefile(
    'NAME'		=> 'Shape',
    'VERSION_FROM'	=> 'Shape.pm',
    'LIBS'		=> ['-L/usr/local/lib -lshp'], # change if you have libshp somewhere else
    'DEFINE'		=> '-ggdb',
    'INC'		=> '-I/usr/local/include', # change if you have shapefil.h somewhere else
);

sub MY::postamble {
'
cvsupdate:
	cvs -d :pserver:anonymous@kampela.hut.fi:/var/cvsroot -z3 update

cvscommit:
	cvs -d :pserver:ajolma@kampela.hut.fi:/var/cvsroot -z3 commit

';
}
